/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.formplugin.promote;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.enums.PromotionEnum;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocdpm.business.promote.helper.PromotionHelper;

public class PromoteHomepageList
extends AbstractListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String operateKey = ((FormOperate)e.getSource()).getOperateKey();
        if ("new".equals(operateKey)) {
            e.setCancel(true);
            this.showNewDynamicPage();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        BillList billList;
        ListSelectedRowCollection listSelectedRow;
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if (e.getOperationResult() != null && e.getOperationResult().isSuccess() && (listSelectedRow = (billList = (BillList)this.getControl("billlistap")).getSelectedRows()) != null && listSelectedRow.size() > 0) {
            Object[] primaryKeyValues = listSelectedRow.getPrimaryKeyValues();
            DynamicObject[] promotes = BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ocdpm_promote"));
            switch (key) {
                case "audit": {
                    this.updatePromoteStatus(promotes);
                    break;
                }
                case "implement": {
                    StringBuilder msg = this.getErrorMsg(promotes, "B");
                    if (msg.length() > 0) {
                        this.getView().showTipNotification(msg.toString(), Integer.valueOf(3000));
                        break;
                    }
                    this.showConfirmView("B");
                    break;
                }
                case "termination": {
                    StringBuilder tip = this.getErrorMsg(promotes, "C");
                    if (tip.length() > 0) {
                        this.getView().showTipNotification(tip.toString(), Integer.valueOf(3000));
                        break;
                    }
                    this.showConfirmView("C");
                    break;
                }
            }
        }
    }

    private void showConfirmView(String promoteStatus) {
        HashMap<String, String> customsParams = new HashMap<String, String>(2);
        customsParams.put("promotestatus", promoteStatus);
        FormShowParameter param = FormShowUtils.openNewForm(null, (String)"ocdpm_promote_confirm", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.VIEW, customsParams);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "callbacktag"));
        this.getView().showForm(param);
    }

    private void updatePromoteStatus(DynamicObject[] promotes) {
        for (DynamicObject promote : promotes) {
            Date startdate = promote.getDate("startdate");
            Date auditdate = promote.getDate("auditdate");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            if (!dateFormat.format(startdate).equals(dateFormat.format(auditdate))) continue;
            promote.set("promotestatus", (Object)Character.valueOf('B'));
        }
        SaveServiceHelper.update((DynamicObject[])promotes);
        ((IListView)this.getView()).refresh();
    }

    private void showNewDynamicPage() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("ocdpm_promote_choose");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(formShowParameter);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
        long primaryKeyValue = (Long)selectedRow.getPrimaryKeyValue();
        String formId = PromotionHelper.gerformIdByPkId((long)primaryKeyValue);
        e.getParameter().setCaption(PromotionEnum.getSchemenameByDynamickey((String)formId));
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (e.getReturnData() == null) {
            return;
        }
        if ("callbacktag".equals(actionId) && e.getReturnData().equals("success")) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6267\u884c\u6210\u529f", (String)"PromoteHomepageList_0", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
            ((IListView)this.getView()).refresh();
        }
    }

    private StringBuilder getErrorMsg(DynamicObject[] promotes, String action) {
        StringBuilder msg = new StringBuilder();
        for (DynamicObject promote : promotes) {
            String billstatus = promote.getString("billstatus");
            String promotestatus = promote.getString("promotestatus");
            if (!"C".equals(billstatus)) {
                this.appendBreak(msg);
                msg.append(promote.get("billno"));
                msg.append(':');
                msg.append(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5ba1\u6838\u624d\u80fd\u6267\u884c\u4fc3\u9500\u64cd\u4f5c", (String)"PromoteHomepageList_1", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
                continue;
            }
            if ("C".equals(action)) {
                if (!"C".equals(promotestatus)) continue;
                this.appendBreak(msg);
                msg.append(promote.get("billno"));
                msg.append(':');
                msg.append(ResManager.loadKDString((String)"\u4fc3\u9500\u65b9\u6848\u5df2\u7ec8\u6b62,\u8bf7\u52ff\u91cd\u590d\u6267\u884c", (String)"PromoteHomepageList_2", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (!"B".equals(action)) continue;
            if ("C".equals(promotestatus)) {
                this.appendBreak(msg);
                msg.append(promote.get("billno"));
                msg.append(':');
                msg.append(ResManager.loadKDString((String)"\u4fc3\u9500\u65b9\u6848\u5df2\u7ec8\u6b62,\u4e0d\u652f\u6301\u518d\u6b21\u6267\u884c", (String)"PromoteHomepageList_3", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (!"B".equals(promotestatus)) continue;
            this.appendBreak(msg);
            msg.append(promote.get("billno"));
            msg.append(':');
            msg.append(ResManager.loadKDString((String)"\u4fc3\u9500\u65b9\u6848\u5df2\u6267\u884c,\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c", (String)"PromoteHomepageList_4", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
        }
        return msg;
    }

    private void appendBreak(StringBuilder msg) {
        if (msg.length() > 0) {
            msg.append('\u3001');
        }
    }
}

