/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.formplugin.promote.importentry;

import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.PosItemUtil;
import kd.occ.ocdpm.common.enums.PromoteItemEnum;

public class ImportItemEntryPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final int ENTRYFIELDSNUM_MAX = 9;
    private static final int ENTRYFIELDSNUM_MIN = 1;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"downloadtpl"});
        this.addClickListeners(new String[]{"btnok"});
        Button uploaddata = (Button)this.getControl("uploaddata");
        uploaddata.addUploadListener((UploadListener)this);
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        Control source = (Control)e.getSource();
        switch (key = source.getKey()) {
            case "downloadtpl": {
                this.downExcelTpl();
                break;
            }
            case "btnok": {
                this.handleButtonOKEvent();
                break;
            }
        }
    }

    public void afterUpload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls != null && urls.length > 0) {
            String fileUrl = urls[0].toString();
            this.loadXLSXFile(fileUrl);
        }
    }

    private void handleButtonOKEvent() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        ArrayList<JSONObject> importList = new ArrayList<JSONObject>();
        int index = 0;
        try {
            for (DynamicObject importInfo : entryEntity) {
                DynamicObject itemLabel;
                DynamicObject itemClass;
                DynamicObject itemBrand;
                ++index;
                String type = importInfo.getString("type");
                String value = PromoteItemEnum.getValueByDescription((String)type);
                String itemNumber = importInfo.getString("itemnumber");
                String itemClassNumber = importInfo.getString("itemclassnumber");
                String itemBrandNumber = importInfo.getString("itembrandnumber");
                String itemLabelNumber = importInfo.getString("itemlabelnumber");
                QFilter qFilter = new QFilter("number", "=", (Object)itemNumber);
                DynamicObject item = BusinessDataServiceHelper.loadSingle((String)"ocdbd_iteminfo", (String)"id,itembrands,material,baseunit,itemclassentity.classstandardid,retailprice,itemclassentity.goodsclasssid", (QFilter[])qFilter.toArray());
                JSONObject temp = new JSONObject();
                if ("1".equals(value) && item != null) {
                    itemBrand = item.getDynamicObject("itembrands");
                    itemClass = PosItemUtil.queryItemClass((DynamicObject)item);
                    itemLabel = this.getItemLabelByItem(item);
                    DynamicObject material = item.getDynamicObject("material");
                    DynamicObject barCode = this.getBarcodeByItem(item);
                    DynamicObject unit = item.getDynamicObject("baseunit");
                    temp.put("material", (Object)material);
                    temp.put("barCode", (Object)barCode);
                    temp.put("unit", (Object)unit);
                    temp.put("retailprice", (Object)item.getBigDecimal("retailprice"));
                } else {
                    qFilter = new QFilter("number", "=", (Object)itemClassNumber);
                    itemClass = BusinessDataServiceHelper.loadSingle((String)"mdr_item_class", (String)"id", (QFilter[])qFilter.toArray());
                    qFilter = new QFilter("number", "=", (Object)itemBrandNumber);
                    itemBrand = BusinessDataServiceHelper.loadSingle((String)"mdr_item_brand", (String)"id", (QFilter[])qFilter.toArray());
                    qFilter = new QFilter("number", "=", (Object)itemLabelNumber);
                    itemLabel = BusinessDataServiceHelper.loadSingle((String)"ocdbd_item_label", (String)"id", (QFilter[])qFilter.toArray());
                }
                temp.put("type", (Object)value);
                temp.put("item", (Object)item);
                temp.put("itemClass", (Object)itemClass);
                temp.put("itemBrand", (Object)itemBrand);
                temp.put("itemLabel", (Object)itemLabel);
                importList.add(temp);
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%sImportItemEntryPlugin_0", (String)"ImportItemEntryPlugin_3", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]), index));
        }
        this.getView().returnDataToParent(importList);
        this.getView().close();
    }

    private DynamicObject getItemLabelByItem(DynamicObject item) {
        QFilter filter = new QFilter("entryentity.item", "=", item.getPkValue());
        return BusinessDataServiceHelper.loadSingle((String)"ocdbd_item_label", (String)"id", (QFilter[])filter.toArray());
    }

    private DynamicObject getBarcodeByItem(DynamicObject item) {
        QFilter filter = new QFilter("item", "=", item.getPkValue());
        return BusinessDataServiceHelper.loadSingle((String)"ocdbd_item_barcode", (String)"id", (QFilter[])filter.toArray());
    }

    private void loadXLSXFile(String fileUrl) {
        ExcelReader reader = new ExcelReader();
        FileService service = FileServiceFactory.getAttachmentFileService();
        final ArrayList realData = new ArrayList();
        try {
            reader.read(service.getInputStream(fileUrl), new SheetHandler(){

                public void handleRow(SheetHandler.ParsedRow paramParsedRow) {
                    int rowNum = paramParsedRow.getRowNum() + 1;
                    if (rowNum == 1 || rowNum == 2 || rowNum == 3) {
                        return;
                    }
                    if (rowNum == 4) {
                        return;
                    }
                    Map mapData = paramParsedRow.getData();
                    String value = (String)mapData.get(0);
                    if (value.isEmpty()) {
                        return;
                    }
                    realData.add(mapData);
                }
            });
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        this.getModel().getDataEntity(true);
        this.getModel().beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("type", new Object[0]);
        vs.addField("itemnumber", new Object[0]);
        vs.addField("item", new Object[0]);
        vs.addField("itemclassnumber", new Object[0]);
        vs.addField("itemclass", new Object[0]);
        vs.addField("itembrandnumber", new Object[0]);
        vs.addField("itembrand", new Object[0]);
        vs.addField("itemlabelnumber", new Object[0]);
        vs.addField("itemlabel", new Object[0]);
        for (Map realDataMap : realData) {
            if (realDataMap.size() <= 9 && realDataMap.size() >= 1) {
                vs.addRow(new Object[]{realDataMap.get(0), realDataMap.get(1), realDataMap.get(2), realDataMap.get(3), realDataMap.get(4), realDataMap.get(5), realDataMap.get(6), realDataMap.get(7), realDataMap.get(8)});
                continue;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u683c\u5f0f\u4e0e\u6a21\u7248\u4e0d\u7b26\u5408\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u5bfc\u5165\u6570\u636e\u683c\u5f0f\u3002", (String)"ImportItemEntryPlugin_1", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
        }
        AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)this.getModel();
        abstractFormDataModel.batchCreateNewEntryRow("entryentity", vs);
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private void downExcelTpl() {
        String url;
        String billFormId = "ocdpm_promote_template";
        String extendData = null;
        String t = "1372345247064960000";
        LocalDate now = LocalDate.now();
        String ctxPath = RequestContext.get().getClientFullContextPath();
        DynamicObject templateData = BusinessDataServiceHelper.loadSingle((Object)t, (String)"bos_importtemplate");
        String fileName = String.format(ResManager.loadKDString((String)"\u9884\u7f6e_%s", (String)"ImportItemEntryPlugin_4", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]), templateData.get("name"));
        try {
            url = ctxPath + (ctxPath.endsWith("/") ? "" : "/") + "form/export.do?templateid=" + t + "&formid=" + billFormId + "&plugin=&filename=" + URLEncoder.encode(fileName + "_" + String.format("%02d", now.getMonthValue()) + String.format("%02d", now.getDayOfMonth()) + ".xlsx", StandardCharsets.UTF_8.name()) + "&extenddata=" + extendData + "&routeappid=" + this.getView().getFormShowParameter().getServiceAppId() + "&a=t";
        }
        catch (UnsupportedEncodingException e) {
            throw new KDBizException(e.getMessage());
        }
        this.getView().download(url);
        this.getView().sendFormAction(this.getView());
    }
}

