/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.formplugin.promtion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocbase.formplugin.base.OcbaseBillPlugin;
import kd.occ.ocdpm.common.enums.PromoteLinkEnum;
import org.apache.commons.collections.CollectionUtils;

public class PromotionRuleEditPlugin
extends OcbaseBillPlugin
implements BeforeF7SelectListener {
    private static final String KEY_SOURCEBILL = "sourcebill";
    private static final Long[] common_mustInputIds = new Long[]{1104405340751064069L, 1104405340751064070L, 1104405340751064077L, 1104405340751064079L, 1104405340751064080L, 1104405340751064083L};
    private static final Long[] SCM_mustInputIds = new Long[]{1104405340751064065L, 1104405340751064066L, 1104405340751064075L};
    private static final Long[] CHANNEL_mustInputIds = new Long[]{1104405340751064067L, 1104405340751064068L, 1104405340751064076L};
    private static final Long[] TOSCM_mustInputIds = new Long[]{1104405340751064065L, 1104405340751064068L, 1104405340751064076L};
    private static final String ctrl_filtergridap = "filtergridap";
    private static final String ctrl_entryfiltergridap = "entryfiltergridap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("combofield");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.bindDataBeforeCreate();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setDefaultPomotionMatchInParams();
        long pkValue = this.getCopyParentId();
        if (pkValue > 0L) {
            DynamicObject rule = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"ocdpm_pmt_rule");
            this.updateEntityValues(rule);
        } else {
            Object billEntity = this.getView().getFormShowParameter().getCustomParam(KEY_SOURCEBILL);
            if (billEntity == null) {
                billEntity = this.getModel().getValue("billentity");
            }
            this.getModel().setValue("billentity", billEntity);
            this.setBillColNameComboValues();
        }
        this.setFilterDetailValues("filterscheme", ctrl_filtergridap);
        this.setFilterDetailValues("entryfilter", ctrl_entryfiltergridap);
    }

    private long getCopyParentId() {
        Object pkValue = this.getView().getFormShowParameter().getCustomParam("parentId");
        if (pkValue == null) {
            return 0L;
        }
        return Long.parseLong(pkValue.toString());
    }

    private void updateEntityValues(DynamicObject copyRule) {
        this.getModel().setValue("promlink", (Object)copyRule.getString("promlink"));
        this.getModel().setValue("filterscheme", (Object)copyRule.getString("filterscheme"));
        this.getView().updateView("billentity");
        this.getView().updateView("promlink");
        this.getView().updateView("filterscheme");
        DynamicObjectCollection ruleSets = copyRule.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection detailValueList = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        detailValueList.clear();
        for (DynamicObject ruleValue : ruleSets) {
            DynamicObject newValue = detailValueList.addNew();
            newValue.set("combofield", (Object)ruleValue.getDynamicObject("combofield"));
            newValue.set("querycolname", (Object)ruleValue.getString("querycolname"));
            newValue.set("sourceentity", (Object)ruleValue.getString("sourceentity"));
            newValue.set("billcolname", (Object)ruleValue.getString("billcolname"));
        }
        this.getView().updateView("entryentity");
    }

    private void setFilterDetailValues(String ctrlName, String filterGrid) {
        FilterGrid filterGridCtrl = (FilterGrid)this.getView().getControl(filterGrid);
        FilterCondition filterCondition = this.loadFilter(ctrlName);
        if (filterCondition != null) {
            filterGridCtrl.SetValue(filterCondition);
            this.getView().updateView(filterGrid);
        }
    }

    private FilterCondition loadFilter(String ctrlName) {
        Object filter = this.getModel().getValue(ctrlName);
        if (StringUtils.isEmpty((Object)filter)) {
            return null;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter.toString(), FilterCondition.class);
        return filterCondition;
    }

    private void setDefaultPomotionMatchInParams() {
        boolean isNew;
        IBillModel billModel = (IBillModel)this.getModel();
        Object pkValue = billModel.getPKValue();
        boolean bl = isNew = pkValue == null || Long.parseLong(pkValue.toString()) == 0L;
        if (isNew) {
            this.setDefaultInParamEntry();
            return;
        }
        this.setDefaultInParamEnable();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (formOperate.getOperateKey()) {
            case "save": {
                String errorMsg = this.checkBeforeSaveOp();
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)errorMsg)) {
                    this.getView().showErrorNotification(errorMsg);
                    args.setCancel(true);
                    return;
                }
                this.dealWithFilterCondition();
                this.updateSourceEntityAndColname();
                break;
            }
        }
    }

    private void dealWithFilterCondition() {
        FilterCondition filterCondition = this.getFilter(ctrl_filtergridap);
        this.translateFilter("filterscheme", filterCondition);
        filterCondition = this.getFilter(ctrl_entryfiltergridap);
        this.translateFilter("entryfilter", filterCondition);
    }

    private String checkBeforeSaveOp() {
        String message;
        DynamicObjectCollection setParamsList = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        DynamicObjectCollection inParamsList = this.queryDefaultInParams();
        Map<Long, String> paramsMap = inParamsList.stream().collect(Collectors.toMap(a -> DynamicObjectUtils.getPkValue((DynamicObject)a), a -> a.getString("name"), (k1, k2) -> k1));
        String promLink = (String)this.getView().getModel().getValue("promlink");
        ArrayList<Long> mustInput = new ArrayList<Long>(Arrays.asList(common_mustInputIds));
        List<Long> otherInput = null;
        if (PromoteLinkEnum.SCM.getValue().equalsIgnoreCase(promLink)) {
            otherInput = Arrays.asList(SCM_mustInputIds);
        } else if (PromoteLinkEnum.CHANNELTOSCM.getValue().equalsIgnoreCase(promLink)) {
            otherInput = Arrays.asList(TOSCM_mustInputIds);
        } else if (PromoteLinkEnum.CHANNELTOCHANNEL.getValue().equalsIgnoreCase(promLink)) {
            otherInput = Arrays.asList(CHANNEL_mustInputIds);
        }
        if (CollectionUtils.isNotEmpty(otherInput)) {
            mustInput.addAll(otherInput);
        }
        long paramDetailId = 0L;
        StringBuilder errorMsg = new StringBuilder();
        boolean hasMaterial = false;
        boolean hasAuxpty = false;
        String materialDetailName = null;
        String auxptyName = null;
        for (DynamicObject setParam : setParamsList) {
            paramDetailId = DynamicObjectUtils.getPkValue((DynamicObject)setParam.getDynamicObject("combofield"));
            if (mustInput.contains(paramDetailId) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)setParam.getString("querycolname")) && paramsMap.containsKey(paramDetailId)) {
                errorMsg.append(paramsMap.get(paramDetailId)).append('\u3001');
            }
            if (paramDetailId == 1104405340751064078L) {
                hasAuxpty = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)setParam.getString("querycolname"));
                auxptyName = paramsMap.get(paramDetailId);
            }
            if (paramDetailId != 1104405340751064075L) continue;
            hasMaterial = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)setParam.getString("querycolname"));
            materialDetailName = paramsMap.get(paramDetailId);
        }
        if (hasAuxpty && !hasMaterial) {
            errorMsg.append(materialDetailName).append('\u3001');
        }
        if (hasMaterial && !hasAuxpty) {
            errorMsg.append(auxptyName).append('\u3001');
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(message = errorMsg.toString()))) {
            return String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u5339\u914d\u5165\u53c2\u5b57\u6bb5\u6620\u5c04\u5206\u5f55\u4ee5\u4e0b\u7684\u9002\u7528\u5355\u636e\u5b57\u6bb5\u5fc5\u586b\uff1a%s\uff0c\u8bf7\u68c0\u67e5\u5e76\u586b\u5199\u6570\u636e\u3002", (String)"PromotionRuleEditPlugin_0", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]), message.substring(0, message.length() - 1));
        }
        return null;
    }

    private void updateSourceEntityAndColname() {
        DynamicObjectCollection setParamsList = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (DynamicObject param : setParamsList) {
            String queryColName = param.getString("querycolname");
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)queryColName)) continue;
            String[] names = queryColName.split("\\.");
            if (names.length > 1) {
                param.set("billcolname", (Object)names[1]);
                param.set("sourceentity", (Object)names[0]);
                continue;
            }
            param.set("billcolname", (Object)queryColName);
            param.set("sourceentity", (Object)"");
        }
    }

    private void translateFilter(String colName, FilterCondition filterCondition) {
        String filter = "";
        if (filterCondition != null) {
            filter = SerializationUtils.toJsonString((Object)filterCondition);
            this.getModel().setValue(colName, (Object)filter);
        }
    }

    private FilterCondition getFilter(String ctrl) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(ctrl);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        return condition;
    }

    public void propertyChanged(PropertyChangedArgs e, String key) {
        super.propertyChanged(e, key);
        switch (key) {
            case "promlink": {
                DynamicObjectCollection setParamsList = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                setParamsList.clear();
                DynamicObjectCollection defaultParamsList = this.queryDefaultInParams();
                List<Object> enableList = new ArrayList(defaultParamsList.size());
                ChangeData[] data = e.getChangeSet();
                String newValue = (String)data[0].getNewValue();
                if ("B".equalsIgnoreCase(newValue)) {
                    enableList = defaultParamsList.stream().filter(a -> a.getLong("id") != 1104405340751064067L && a.getLong("id") != 1104405340751064068L && a.getLong("id") != 1104405340751064076L).collect(Collectors.toList());
                } else if ("A".equalsIgnoreCase(newValue)) {
                    enableList = defaultParamsList.stream().filter(a -> a.getLong("id") != 1104405340751064065L && a.getLong("id") != 1104405340751064066L).collect(Collectors.toList());
                } else if ("C".equalsIgnoreCase(newValue)) {
                    enableList = defaultParamsList.stream().filter(a -> a.getLong("id") != 1104405340751064067L && a.getLong("id") != 1104405340751064066L).collect(Collectors.toList());
                }
                int rowIndex = 0;
                for (DynamicObject enableDetail : enableList) {
                    DynamicObject newValueDetail = setParamsList.addNew();
                    newValueDetail.set("combofield", (Object)enableDetail);
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"combofield"});
                    ++rowIndex;
                }
                this.getView().updateView("entryentity");
                break;
            }
        }
    }

    private DynamicObjectCollection queryDefaultInParams() {
        QFilter filter = new QFilter("paramenable", "=", (Object)"1");
        return ORM.create().query("ocdpm_pparamdetail", filter.toArray());
    }

    private void setBillColNameComboValues() {
        Object billFormId = this.getView().getFormShowParameter().getCustomParam(KEY_SOURCEBILL);
        if (billFormId == null) {
            DynamicObject billEntity = (DynamicObject)this.getModel().getValue("billentity");
            billFormId = billEntity == null ? "" : billEntity.getPkValue();
        }
        this.setComboValuesByBill(billFormId);
    }

    private void setComboValuesByBill(Object billFormId) {
        ComboEdit comboEdit = (ComboEdit)this.getControl("querycolname");
        List<ComboItem> comboItemList = this.getBillColNameComboItemList(billFormId.toString());
        comboEdit.setComboItems(comboItemList);
    }

    private List<ComboItem> getBillColNameComboItemList(String billEntity) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)billEntity)) {
            return new ArrayList<ComboItem>(0);
        }
        MainEntityType srcMainType = EntityMetadataCache.getDataEntityType((String)billEntity);
        Map allEntities = srcMainType.getAllEntities();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        for (Map.Entry entityType : allEntities.entrySet()) {
            LocaleString entityTypeName = ((EntityType)entityType.getValue()).getDisplayName();
            Map fieldsList = ((EntityType)entityType.getValue()).getFields();
            for (Map.Entry entry : fieldsList.entrySet()) {
                IDataEntityProperty dDataEntityProperty = (IDataEntityProperty)entry.getValue();
                IDataEntityType iDataEntityType = dDataEntityProperty.getParent();
                String parentName = "";
                if (!iDataEntityType.getName().equalsIgnoreCase(srcMainType.getName())) {
                    parentName = iDataEntityType.getName();
                }
                ComboItem item = new ComboItem();
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)parentName)) {
                    item.setId(dDataEntityProperty.getName());
                    item.setValue(dDataEntityProperty.getName());
                } else {
                    item.setId(parentName + "." + dDataEntityProperty.getName());
                    item.setValue(parentName + "." + dDataEntityProperty.getName());
                }
                item.setCaption(new LocaleString(entityTypeName + "." + dDataEntityProperty.getDisplayName()));
                comboItems.add(item);
            }
        }
        return comboItems;
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String key = arg.getProperty().getName();
        QFilter qFilter = null;
        switch (key) {
            case "combofield": {
                DynamicObjectCollection paramsList = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                List paramIdList = paramsList.stream().map(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("combofield"))).collect(Collectors.toList());
                qFilter = new QFilter("id", "not in", paramIdList);
                qFilter.and(new QFilter("paramenable", "=", (Object)"1"));
                break;
            }
        }
        ListShowParameter showParameter = (ListShowParameter)arg.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        int[] rowIndexs = e.getRowIndexs();
        DynamicObjectCollection paramsList = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)paramsList)) {
            return;
        }
        ArrayList<String> rowList = new ArrayList<String>(0);
        for (int rowIndex : rowIndexs) {
            DynamicObject combofield;
            if (paramsList.size() < rowIndex || (combofield = ((DynamicObject)paramsList.get(rowIndex)).getDynamicObject("combofield")) == null || !combofield.getBoolean("issyspreset")) continue;
            rowList.add(String.valueOf(rowIndex + 1));
        }
        if (CollectionUtils.isEmpty(rowList)) {
            return;
        }
        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u3010\u5165\u53c2\u5b57\u6bb5\u3011\u7b2c%s\u884c\u4e3a\u7cfb\u7edf\u9884\u7f6e\u5165\u53c2\u5b57\u6bb5\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PromotionRuleEditPlugin_1", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\uff0c", rowList)));
        e.setCancel(true);
    }

    private void bindDataBeforeCreate() {
        long pkValue = this.getCopyParentId();
        if (pkValue > 0L) {
            this.bindDataBeforeCopy(pkValue);
            return;
        }
        this.bindDataBeforeAddNew();
    }

    private void bindDataBeforeAddNew() {
        String formId = this.getFormId();
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(ctrl_filtergridap);
        FilterGrid entryGrid = (FilterGrid)this.getView().getControl(ctrl_entryfiltergridap);
        filterGrid.setEntityNumber(formId);
        entryGrid.setEntityNumber(formId);
    }

    private String getFormId() {
        DynamicObject billEntity;
        Object formId = this.getView().getFormShowParameter().getCustomParam(KEY_SOURCEBILL);
        if (formId == null && (billEntity = (DynamicObject)this.getModel().getValue("billentity")) != null) {
            formId = billEntity.getPkValue();
        }
        return formId == null ? "" : formId.toString();
    }

    private void bindDataBeforeCopy(long pkValue) {
        FilterGrid filterGridControl = (FilterGrid)this.getView().getControl(ctrl_filtergridap);
        DynamicObject rule = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"ocdpm_pmt_rule");
        filterGridControl.setEntityNumber(String.valueOf(rule.getDynamicObject("billentity").getPkValue()));
        String billEntity = rule.getString("billentity.number");
        this.getModel().setValue("billentity", (Object)billEntity);
        this.getView().updateView("billentity");
        this.setComboValuesByBill(billEntity);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String event = afterDoOperationEventArgs.getOperateKey();
        if ("save".equalsIgnoreCase(event) || "submit".equalsIgnoreCase(event) || "audit".equalsIgnoreCase(event)) {
            this.setDefaultInParamEnable();
        }
    }

    private void setDefaultInParamEnable() {
        DynamicObjectCollection setParamsList = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        int rowIndex = 0;
        for (DynamicObject paramsObj : setParamsList) {
            rowIndex = paramsObj.getInt("seq") - 1;
            DynamicObject combofield = paramsObj.getDynamicObject("combofield");
            if (combofield == null) continue;
            this.getView().setEnable(Boolean.valueOf(!combofield.getBoolean("issyspreset")), rowIndex, new String[]{"combofield"});
        }
    }

    private void setDefaultInParamEntry() {
        DynamicObjectCollection setParamsList = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        DynamicObjectCollection enableList = this.queryDefaultInParams();
        setParamsList.clear();
        int rowIndex = 0;
        for (DynamicObject paramsObj : enableList) {
            DynamicObject newParam = setParamsList.addNew();
            newParam.set("combofield", (Object)paramsObj);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"combofield"});
            ++rowIndex;
        }
        this.getView().updateView("entryentity");
    }
}

