/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.formplugin.promtion;

import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.occ.ocbase.formplugin.base.OcbaseBillPlugin;

public class SelectSourceBillEditPlugin
extends OcbaseBillPlugin {
    private static final String KEY_OK = "btnok";
    private static final String KEY_CANCEL = "btncancel";
    private static final String KEY_SOURCEBILL = "sourcebill";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_OK, KEY_CANCEL});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            this.getPageCache().put("createOrg", pageCache.get("createOrg"));
        } else {
            this.getPageCache().put("createOrg", Long.toString(RequestContext.getOrCreate().getOrgId()));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "btnok": {
                DynamicObject sourceBill = (DynamicObject)this.getModel().getValue(KEY_SOURCEBILL);
                if (sourceBill == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9002\u7528\u5355\u636e", (String)"SelectSourceBillEditPlugin_0", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
                    return;
                }
                BillShowParameter ShowParameter = new BillShowParameter();
                ShowParameter.setFormId("ocdpm_pmt_rule");
                ShowParameter.setCustomParam(KEY_SOURCEBILL, sourceBill.getPkValue());
                ShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)ShowParameter);
                this.getView().close();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
        }
    }
}

