/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.formplugin.retailprice;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocdpm.common.util.CommonUtil;

public class RetailItemPriceListPlugin
extends AbstractListPlugin {
    private static final String OP_NEW = "new";
    private static final String OP_DISABLE = "disable";
    private static final String OP_ENABLE = "enable";
    private static final String TABNAME_HEADQUARTERS = ResManager.loadKDString((String)"\u603b\u90e8\u5546\u54c1\u96f6\u552e\u4ef7\u76ee\u8868", (String)"RetailItemPriceListPlugin_0", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]);
    private static final String TABNAME_BRANCHES = ResManager.loadKDString((String)"\u95e8\u5e97\u5546\u54c1\u96f6\u552e\u4ef7\u76ee\u8868", (String)"RetailItemPriceListPlugin_1", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]);
    private static final String OP_AUDIT = "audit";
    private static final String OP_UNAUDIT = "unaudit";
    private static final String LIST = "billlistap";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain", "tblnew", OP_NEW});
    }

    public void setFilter(SetFilterEvent e) {
        String billTypeId = this.getBillTypeId();
        List filters = e.getCustomQFilters();
        filters.add(new QFilter("billtype", "=", (Object)Long.parseLong(billTypeId)));
        e.setCustomQFilters(filters);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        switch (opKey = op.getOperateKey()) {
            case "new": {
                args.setCancel(true);
                this.openAddFormByBillType();
                break;
            }
        }
    }

    private void openAddFormByBillType() {
        String billType = this.getBillTypeId();
        BillShowParameter param = new BillShowParameter();
        param.setFormId("ocdpm_retailpricelist");
        param.setCustomParam("billtype", (Object)billType);
        param.setCustomParam("org", ((IListView)this.getView()).getSelectedMainOrgIds().get(0));
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if ("1041388752234404864".equalsIgnoreCase(billType)) {
            param.setCaption(TABNAME_BRANCHES);
        } else {
            param.setCaption(TABNAME_HEADQUARTERS);
        }
        this.getView().showForm((FormShowParameter)param);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        if ("1041388752234404864".equalsIgnoreCase(this.getBillTypeId())) {
            e.getParameter().setCaption(TABNAME_BRANCHES);
        } else {
            e.getParameter().setCaption(TABNAME_HEADQUARTERS);
            this.getView().setVisible(Boolean.FALSE, new String[]{"channel"});
        }
    }

    private String getBillTypeId() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        return (String)parameter.getCustomParam("billtype");
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String opKey = eventArgs.getOperateKey();
        Object[] primaryKeyValues = ((IListView)this.getView()).getSelectedRows().getPrimaryKeyValues();
        IDataEntityType dataEntityType = BusinessDataServiceHelper.newDynamicObject((String)"ocdpm_retailpricelist").getDataEntityType();
        DynamicObject[] entities = (DynamicObject[])BusinessDataServiceHelper.load((Object[])primaryKeyValues, (IDataEntityType)dataEntityType);
        String customParam = this.getView().getFormShowParameter().getCustomParam("billtype").toString();
        boolean isBranch = "1041388752234404864".equals(customParam);
        if (OP_ENABLE.equalsIgnoreCase(opKey) || OP_DISABLE.equalsIgnoreCase(opKey)) {
            this.setDataEnable(entities, OP_DISABLE.equalsIgnoreCase(opKey));
        } else if ((OP_AUDIT.equals(opKey) || OP_UNAUDIT.equals(opKey)) && isBranch) {
            this.setDataExecute(entities, OP_AUDIT.equals(opKey));
        }
        SaveServiceHelper.update((DynamicObject[])entities);
        BillList list = (BillList)this.getControl(LIST);
        list.refreshData();
    }

    private void setDataExecute(DynamicObject[] entities, boolean flag) {
        String billtype = this.getView().getFormShowParameter().getCustomParam("billtype").toString();
        if ("1041385340746914816".equals(billtype)) {
            return;
        }
        boolean isDistributed = false;
        ArrayList<Object> sourceBillIds = new ArrayList<Object>(entities.length);
        HashMap<DynamicObject, Object> map = new HashMap<DynamicObject, Object>(entities.length);
        Object sourceBillId = null;
        for (DynamicObject entity : entities) {
            isDistributed = entity.getBoolean("isdistributed");
            if (isDistributed) {
                sourceBillId = entity.get("sourcebillid");
                sourceBillIds.add(entity.get("sourcebillid"));
                map.put(entity, sourceBillId);
            }
            DynamicObjectCollection useRanges = entity.getDynamicObjectCollection("treeentryentity");
            DynamicObject useRange = (DynamicObject)useRanges.get(0);
            useRange.set("priceenable", (Object)(flag && "A".equals(entity.getString(OP_ENABLE)) ? Boolean.TRUE : Boolean.FALSE));
        }
        if (sourceBillIds.size() == 0) {
            return;
        }
        HashSet<DynamicObject> sourceObjs = new HashSet<DynamicObject>(sourceBillIds.size());
        Map objectMap = BusinessDataServiceHelper.loadFromCache((Object[])sourceBillIds.toArray(), (String)"ocdpm_retailpricelist");
        for (Map.Entry entry : map.entrySet()) {
            DynamicObject sourceObj = (DynamicObject)objectMap.get(entry.getValue());
            DynamicObjectCollection useRanges = sourceObj.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject useRange : useRanges) {
                if (!((DynamicObject)entry.getKey()).getDynamicObject("channel").getPkValue().equals(useRange.getDynamicObject("branch").getPkValue())) continue;
                useRange.set("priceenable", (Object)(flag && "A".equals(((DynamicObject)entry.getKey()).getString(OP_ENABLE)) ? Boolean.TRUE : Boolean.FALSE));
                break;
            }
            sourceObjs.add(sourceObj);
        }
        SaveServiceHelper.update((DynamicObject[])sourceObjs.toArray(new DynamicObject[sourceObjs.size()]));
    }

    private void setDataEnable(DynamicObject[] entities, boolean flag) {
        DynamicObjectCollection entries = null;
        HashMap<DynamicObject, Object> map = new HashMap<DynamicObject, Object>(entities.length);
        HashSet<Object> set = new HashSet<Object>(entities.length);
        Object sourceBillId = null;
        DynamicObjectCollection useRanges = null;
        for (DynamicObject entity : entities) {
            entries = entity.getDynamicObjectCollection("pricedetailentity");
            entity.set(OP_ENABLE, (Object)(flag ? "B" : "A"));
            entity.set("disabler", flag ? CommonUtil.getLoginUser() : null);
            entity.set("disabletime", (Object)(flag ? TimeServiceHelper.now() : null));
            for (DynamicObject entry : entries) {
                if (entry.getBoolean("priceisinvalid")) continue;
                entry.set("priceisinvalid", (Object)(flag ? Boolean.TRUE : Boolean.FALSE));
                entry.set("disableopdate", (Object)(flag ? TimeServiceHelper.now() : null));
                entry.set("disabloper", flag ? CommonUtil.getLoginUser() : null);
            }
            if (entity.getBoolean("isdistributed")) {
                sourceBillId = entity.get("sourcebillid");
                map.put(entity, entity.get("sourcebillid"));
                set.add(sourceBillId);
                continue;
            }
            useRanges = entity.getDynamicObjectCollection("treeentryentity");
            DynamicObject useRange = (DynamicObject)useRanges.get(0);
            useRange.set("priceenable", (Object)(flag ? Boolean.FALSE : Boolean.TRUE));
        }
        if (set.size() == 0) {
            return;
        }
        Map sourceObjMap = BusinessDataServiceHelper.loadFromCache((Object[])set.toArray(), (String)"ocdpm_retailpricelist");
        HashMap sourceUseRanges = new HashMap(set.size());
        HashSet sourceObjs = new HashSet(set.size());
        for (Map.Entry entry : sourceObjMap.entrySet()) {
            HashMap<Object, DynamicObject> useRangeMap = new HashMap<Object, DynamicObject>(sourceObjMap.size());
            DynamicObjectCollection useRangeCollection = ((DynamicObject)entry.getValue()).getDynamicObjectCollection("treeentryentity");
            for (DynamicObject obj : useRangeCollection) {
                useRangeMap.put(obj.getDynamicObject("branch").getPkValue(), obj);
            }
            sourceUseRanges.put(entry.getKey(), useRangeMap);
            sourceObjs.add(entry.getValue());
        }
        for (Map.Entry entry : map.entrySet()) {
            DynamicObject useRange = (DynamicObject)((Map)sourceUseRanges.get(entry.getValue())).get(((DynamicObject)entry.getKey()).getDynamicObject("channel").getPkValue());
            useRange.set("priceenable", (Object)(flag ? Boolean.FALSE : Boolean.TRUE));
        }
        SaveServiceHelper.update((DynamicObject[])sourceObjs.toArray(new DynamicObject[sourceObjs.size()]));
    }
}

