/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.formplugin.retailprice;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.business.handle.SetBranchRangeHelper;
import kd.occ.ocbase.business.helper.changemodel.CurrencyHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocdpm.business.retailprice.RetailItemPriceHelper;
import kd.occ.ocdpm.common.retailprice.vo.DistributeOpResult;
import kd.occ.ocdpm.common.userperm.UserPermUtils;
import kd.occ.ocdpm.common.util.CommonUtil;
import kd.occ.ocdpm.common.util.PriceTypeUtil;

public class RetailPriceBasePlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String OP_DISTRIBUTE = "distribute";
    private static final String OP_CANCELDISTRIBUTE = "canceldistribute";
    private static final String CALLBACK_DISTRIBUTE = "distributecallback";
    private static final String CALLBACK_CANCELDISTRIBUTE = "canceldistributecallback";
    private static final String OP_ROWDISABLE = "rowdisable";
    private static final String OP_ROWENABLE = "rowenable";
    public static final String USERANGEPANEL = "userangepanel";
    public static final String OP_ADD = "new";
    private static final String BAR_MORE = "bar_more";
    private static final String OPERATION = "operation";
    private static final String UNAUDIT = "bar_unaudit";
    private static final String AUDIT = "bar_audit";
    private static final String[][] PRICE_TYPE = new String[][]{{"retailprice", "retailvalue"}, {"factoryprice", "factoryvalue"}, {"uniqueprice", "uniquevalue"}, {"memberprice", "membervalue"}, {"specialprice", "specialvalue"}, {"price1", "value1"}, {"price2", "value2"}, {"price3", "value3"}, {"price4", "value4"}, {"price5", "value5"}};
    private static final Log LOG = LogFactory.getLog(RetailPriceBasePlugin.class, (String)"ocdpm");

    public void beforeF7Select(BeforeF7SelectEvent paramBeforeF7SelectEvent) {
    }

    public void registerListener(EventObject e) {
        this.addF7Listener(this, "barcode", "item");
        this.addItemClickListeners(new String[]{"advcontoolbarap", "tbmain", "advcontoolbarap1"});
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String parentFormId = this.getView().getEntityId();
        LOG.info("isFromImport" + this.isFromImport());
        LOG.info("parentFormId" + parentFormId);
        if (!this.isFromImport() && "ocdpm_retailpricelist".equals(parentFormId)) {
            Object billType = this.getView().getModel().getValue("billtype");
            LOG.info("price billType" + billType);
            if (billType == null) {
                Object customParam = this.getView().getFormShowParameter().getCustomParam("org");
                this.getView().getModel().setValue("org", customParam);
                long billTypeId = this.getBillTypeId();
                LOG.info("billTypeId" + billTypeId);
                this.getModel().setValue("billtype", (Object)billTypeId);
                if (billTypeId == 1041385340746914816L) {
                    Object orgPKValue = ((DynamicObject)this.getView().getModel().getValue("org")).getPkValue();
                    DynamicObject currency = CurrencyHelper.getCurrency((Long)((Long)orgPKValue));
                    this.getView().getModel().setValue("currency", currency.getPkValue());
                }
            }
        }
    }

    public void beforeBindData(EventObject e) {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        this.getView().setEnable(Boolean.FALSE, new String[]{"billtype"});
        DynamicObjectCollection entryEntity = model.getEntryEntity("pricedetailentity");
        DynamicObjectCollection detailEntity = model.getEntryEntity("pricedetail");
        long billTypeId = this.getBillTypeId();
        if (billTypeId == 1041388752234404864L) {
            this.setPriceEnable(entryEntity, detailEntity);
            view.setVisible(Boolean.FALSE, new String[]{USERANGEPANEL});
            view.setVisible(Boolean.FALSE, new String[]{BAR_MORE});
            ((FieldEdit)this.getView().getControl("channel")).setMustInput(true);
            view.setEnable(Boolean.FALSE, new String[]{"currency"});
            view.setEnable(Boolean.TRUE, new String[]{"pricerecord"});
            Object isdistributed = model.getValue("isdistributed");
            if (Boolean.parseBoolean(isdistributed.toString())) {
                view.setVisible(Boolean.FALSE, new String[]{"pricedetaillist"});
                view.setVisible(Boolean.TRUE, new String[]{"pricedetaillocal"});
                view.setEnable(Boolean.FALSE, new String[]{"choosepricetype"});
                view.setVisible(Boolean.TRUE, new String[]{"sourcebillno"});
            } else {
                view.setVisible(Boolean.TRUE, new String[]{"pricedetaillist"});
                view.setVisible(Boolean.FALSE, new String[]{"pricedetaillocal"});
                view.setEnable(Boolean.TRUE, new String[]{"choosepricetype"});
                view.setVisible(Boolean.FALSE, new String[]{"sourcebillno"});
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"channel"});
            view.setVisible(Boolean.FALSE, new String[]{"isdistributed"});
            view.setVisible(Boolean.FALSE, new String[]{"pricerecord"});
            view.setEnable(Boolean.TRUE, new String[]{"currency"});
            view.setVisible(Boolean.TRUE, new String[]{USERANGEPANEL});
            view.setVisible(Boolean.TRUE, new String[]{BAR_MORE});
            view.setVisible(Boolean.FALSE, new String[]{"pricedetaillocal"});
            view.setVisible(Boolean.FALSE, new String[]{"sourcebillno"});
        }
        DynamicObjectCollection priceRecord = this.getView().getModel().getEntryEntity("pricerecord");
        String status = this.getView().getFormShowParameter().getStatus().toString();
        if (StringUtils.equals((CharSequence)status, (CharSequence)"ADDNEW") && priceRecord != null && priceRecord.size() > 0) {
            this.getView().getModel().deleteEntryData("pricerecord");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getChangeSet() == null || e.getChangeSet().length <= 0) {
            return;
        }
        String key = e.getProperty().getName();
        Object changeValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "controltype": {
                this.setBranchRange();
                break;
            }
            case "orgrange": {
                DynamicObjectCollection range = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
                this.updateBranchRange("channelgroup", range);
                break;
            }
            case "channelgroup": {
                DynamicObjectCollection group = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
                this.updateBranchRange("orgrange", group);
                break;
            }
            case "isstore": 
            case "isonlinestore": 
            case "isonlinemarket": {
                if (this.isAllFalse()) {
                    this.getView().getModel().deleteEntryData("treeentryentity");
                    this.getView().getModel().setValue("orgrange", null);
                    this.getView().getModel().setValue("channelgroup", null);
                    this.getView().updateView("treeentryentity");
                    return;
                }
                this.updateUseRange();
                break;
            }
            case "enable": {
                boolean disable = changeValue != null && "B".equalsIgnoreCase((String)changeValue);
                this.updatePriceDetailEffect(disable);
                break;
            }
            case "effectdate": {
                this.updateEntryDate("effectdate", changeValue);
                break;
            }
            case "invaliddate": {
                this.updateEntryDate("invaliddate", changeValue);
                break;
            }
        }
    }

    private boolean isAllFalse() {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        boolean isStore = dataEntity.getBoolean("isstore");
        boolean isOnlineStore = dataEntity.getBoolean("isonlinestore");
        boolean isOnlineMarket = dataEntity.getBoolean("isonlinemarket");
        return !isStore && !isOnlineMarket && !isOnlineStore;
    }

    private void updateUseRange() {
        Object controltype = this.getView().getModel().getValue("controltype");
        if ("A".equals(controltype.toString())) {
            this.setBranchRange();
        } else {
            this.getView().getModel().setValue("orgrange", null);
            this.getView().getModel().setValue("channelgroup", null);
            this.getView().getModel().deleteEntryData("treeentryentity");
            this.getView().updateView("treeentryentity");
        }
    }

    private void updateEntryDate(String dateName, Object newDateTime) {
        if (newDateTime == null) {
            return;
        }
        DynamicObjectCollection detailList = this.getView().getModel().getDataEntity().getDynamicObjectCollection("pricedetailentity");
        String updateName = "effectdate".equalsIgnoreCase(dateName) ? "priceeffectdate" : "priceinvaliddate";
        for (DynamicObject detail : detailList) {
            detail.set(updateName, newDateTime);
        }
        this.getView().updateView("pricedetailentity");
    }

    private void updatePriceDetailEffect(boolean disable) {
        DynamicObjectCollection detailList = this.getView().getModel().getDataEntity().getDynamicObjectCollection("pricedetailentity");
        if (detailList.size() > 0) {
            for (DynamicObject detail : detailList) {
                detail.set("priceisinvalid", (Object)disable);
                if (disable) {
                    detail.set("disabloper", (Object)CommonUtil.getLoginUser());
                    detail.set("disableopdate", (Object)TimeServiceHelper.now());
                    continue;
                }
                detail.set("disabloper", null);
                detail.set("disableopdate", null);
            }
            this.getView().updateView("pricedetailentity");
        }
    }

    private void updateRangeView() {
        this.getView().updateView("treeentryentity");
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        grid.setCollapse(false);
        grid.selectRows(-1);
    }

    private void setBranchRange() {
        Object controlType = this.getView().getModel().getValue("controltype");
        if ("A".equals(controlType.toString())) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>(3);
            map.put("isstore", this.getView().getModel().getDataEntity(true).getBoolean("isstore"));
            map.put("isonlinestore", this.getView().getModel().getDataEntity(true).getBoolean("isonlinestore"));
            map.put("isonlinemarket", this.getView().getModel().getDataEntity(true).getBoolean("isonlinemarket"));
            SetBranchRangeHelper.setBranchRange((IDataModel)this.getModel(), (String)"treeentryentity", (String)"applyorg", (String)"branch", map);
            this.updateRangeView();
        } else {
            this.getView().getModel().deleteEntryData("treeentryentity");
            this.getView().updateView("treeentryentity");
        }
    }

    private void updateBranchRange(String clearRange, DynamicObjectCollection newValue) {
        this.getView().getModel().deleteEntryData("treeentryentity");
        this.getView().updateView("treeentryentity");
        boolean isOrgRange = "channelgroup".equalsIgnoreCase(clearRange);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(3);
        map.put("isstore", this.getView().getModel().getDataEntity(true).getBoolean("isstore"));
        map.put("isonlinestore", this.getView().getModel().getDataEntity(true).getBoolean("isonlinestore"));
        map.put("isonlinemarket", this.getView().getModel().getDataEntity(true).getBoolean("isonlinemarket"));
        DynamicObjectCollection clearList = (DynamicObjectCollection)this.getModel().getValue(clearRange);
        if (!CommonUtil.listIsEmpty((List)clearList)) {
            this.getView().getModel().beginInit();
            this.getView().getModel().setValue(clearRange, null);
            this.getView().updateView(clearRange);
            this.getView().getModel().endInit();
        }
        SetBranchRangeHelper.setBranchRange((IDataModel)this.getModel(), (DynamicObjectCollection)newValue, (boolean)isOrgRange, (String)"treeentryentity", (String)"applyorg", (String)"branch", map);
        this.updateRangeView();
    }

    public void itemClick(ItemClickEvent evt) {
        IDataModel model = this.getView().getModel();
        IFormView view = this.getView();
        String itemKey = evt.getItemKey();
        Object pkValue = model.getDataEntity().getPkValue();
        EntryGrid entryGrid = null;
        switch (itemKey) {
            case "distribute": {
                if (!this.checkRetailPricePerm("0VN0B56L7GJW")) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u53f7\u65e0\u201c\u5206\u914d\u4ef7\u76ee\u8868\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743\u3002", (String)"RetailPriceBasePlugin_0", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
                    return;
                }
                List notDistributedBranchList = RetailItemPriceHelper.getNotDistributedBranchList((Object)pkValue);
                if (notDistributedBranchList == null || notDistributedBranchList.size() == 0) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0b\u65e0\u53ef\u5206\u914d\u6e20\u9053\uff0c\u4e0d\u53ef\u5206\u914d\u3002", (String)"RetailPriceBasePlugin_1", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.openWindow("ocdpm_pricedistributebranch", CALLBACK_DISTRIBUTE, ResManager.loadKDString((String)"\u5206\u914d\u6e20\u9053", (String)"RetailPriceBasePlugin_2", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]), OP_DISTRIBUTE);
                break;
            }
            case "canceldistribute": {
                if (!this.checkRetailPricePerm("0VN0B56L7GJW")) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u53f7\u65e0\u201c\u53d6\u6d88\u5206\u914d\u4ef7\u76ee\u8868\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743\u3002", (String)"RetailPriceBasePlugin_3", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
                    return;
                }
                List distributedBranchList = RetailItemPriceHelper.getDistributedBranchList((Object)pkValue);
                if (distributedBranchList == null || distributedBranchList.size() == 0) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0b\u65e0\u5df2\u5206\u914d\u6e20\u9053\uff0c\u4e0d\u53ef\u53d6\u6d88\u5206\u914d\u3002", (String)"RetailPriceBasePlugin_4", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.openWindow("ocdpm_pricedistributebranch", CALLBACK_CANCELDISTRIBUTE, ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u6e20\u9053", (String)"RetailPriceBasePlugin_5", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]), OP_CANCELDISTRIBUTE);
                break;
            }
            case "rowdisable": {
                entryGrid = (EntryGrid)view.getControl("pricedetailentity");
                int[] disableRow = entryGrid.getSelectRows();
                if (disableRow.length == 0) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u4ef7\u683c\u660e\u7ec6\u3002", (String)"RetailPriceBasePlugin_6", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.updateEntryInvalidProperties(disableRow);
                break;
            }
            case "rowenable": {
                entryGrid = (EntryGrid)view.getControl("pricedetailentity");
                int[] enableRow = entryGrid.getSelectRows();
                if (enableRow.length == 0) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u4ef7\u683c\u660e\u7ec6\u3002", (String)"RetailPriceBasePlugin_6", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.clearEntryInvalidProperties(enableRow);
                break;
            }
            case "bar_audit": {
                this.setPriceIsEnable(AUDIT);
                break;
            }
            case "bar_unaudit": {
                this.setPriceIsEnable(UNAUDIT);
                model.setValue("isunaudit", (Object)Boolean.TRUE);
                break;
            }
        }
    }

    private void setPriceIsEnable(String operation) {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        String billtype = dataEntity.getDynamicObject("billtype").getPkValue().toString();
        if ("1041385340746914816".equals(billtype)) {
            return;
        }
        boolean isdistributed = dataEntity.getBoolean("isdistributed");
        if (isdistributed) {
            DynamicObject sourceObj = BusinessDataServiceHelper.loadSingleFromCache((Object)dataEntity.get("sourcebillid"), (String)"ocdpm_retailpricelist");
            DynamicObjectCollection useRanges = sourceObj.getDynamicObjectCollection("treeentryentity");
            List targetRange = useRanges.stream().filter(p -> p.getDynamicObject("branch").getPkValue().equals(dataEntity.getDynamicObject("channel").getPkValue())).collect(Collectors.toList());
            ((DynamicObject)targetRange.get(0)).set("priceenable", (Object)(AUDIT.equals(operation) ? 1 : 0));
            SaveServiceHelper.update((DynamicObject)sourceObj);
        }
        DynamicObjectCollection useRange = dataEntity.getDynamicObjectCollection("treeentryentity");
        ((DynamicObject)useRange.get(0)).set("priceenable", (Object)(AUDIT.equals(operation) ? 1 : 0));
        SaveServiceHelper.update((DynamicObject)dataEntity);
    }

    private boolean isFromImport() {
        IDataModel model = this.getModel();
        if (model instanceof IBillModel) {
            return ((IBillModel)model).isFromImport();
        }
        return false;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String name = e.getEntryProp().getName();
        DynamicObject billType = (DynamicObject)this.getView().getModel().getValue("billtype");
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)billType);
        int index = 0;
        RowDataEntity[] rowEntities = e.getRowDataEntities();
        switch (name) {
            case "pricedetailentity": {
                Object enable = this.getView().getModel().getValue("enable");
                boolean isinvalid = true;
                if (enable != null && "A".equalsIgnoreCase(enable.toString())) {
                    isinvalid = false;
                }
                for (RowDataEntity rowEntry : rowEntities) {
                    index = rowEntry.getRowIndex();
                    this.getView().getModel().setValue("priceeffectdate", this.getView().getModel().getValue("effectdate"), index);
                    this.getView().getModel().setValue("priceinvaliddate", this.getView().getModel().getValue("invaliddate"), index);
                    this.getView().getModel().setValue("priceisinvalid", (Object)isinvalid, index);
                }
                if (billTypeId != 1041388752234404864L) break;
                this.setPriceEnable(index, "pricedetailentity");
                break;
            }
            case "pricedetail": {
                if (billTypeId != 1041388752234404864L) break;
                for (RowDataEntity rowEntry : rowEntities) {
                    index = rowEntry.getRowIndex();
                    this.setPriceEnable(index, "pricedetail");
                }
                break;
            }
        }
    }

    private void setPriceEnable(int index, String rowEntity) {
        DynamicObject priceTypeObj = null;
        Map priceMap = PriceTypeUtil.getPriceMap();
        if ("pricedetailentity".equals(rowEntity)) {
            for (String[] priceType : PRICE_TYPE) {
                priceTypeObj = (DynamicObject)priceMap.get(priceType[0]);
                if (priceTypeObj == null) continue;
                if (priceTypeObj.getBoolean("isallowadjust")) {
                    this.getView().setEnable(Boolean.TRUE, index, new String[]{priceType[0]});
                    continue;
                }
                this.getView().setEnable(Boolean.FALSE, index, new String[]{priceType[0]});
            }
        } else {
            for (String[] priceType : PRICE_TYPE) {
                priceTypeObj = (DynamicObject)priceMap.get(priceType[0]);
                if (priceTypeObj == null) continue;
                if (priceTypeObj.getBoolean("isallowadjust")) {
                    this.getView().setEnable(Boolean.TRUE, index, new String[]{priceType[1]});
                    continue;
                }
                this.getView().setEnable(Boolean.FALSE, index, new String[]{priceType[1]});
            }
        }
    }

    private void setPriceEnable(DynamicObjectCollection entry, DynamicObjectCollection detail) {
        DynamicObject billType = (DynamicObject)this.getView().getModel().getValue("billtype");
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)billType);
        List currentPriceType = PriceTypeUtil.getCurrentPriceType((DynamicObject)this.getView().getModel().getDataEntity());
        Map priceMap = PriceTypeUtil.getPriceMap();
        if (billTypeId == 1041388752234404864L) {
            int i;
            DynamicObject priceTypeObj = null;
            for (i = 0; i < entry.size(); ++i) {
                for (String priceType : currentPriceType) {
                    priceTypeObj = (DynamicObject)priceMap.get(priceType);
                    if (priceTypeObj == null) continue;
                    if (priceTypeObj.getBoolean("isallowadjust")) {
                        this.getView().setEnable(Boolean.TRUE, i, new String[]{priceType});
                        continue;
                    }
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{priceType});
                }
            }
            for (i = 0; i < detail.size(); ++i) {
                for (String[] priceType : PRICE_TYPE) {
                    priceTypeObj = (DynamicObject)priceMap.get(priceType[0]);
                    if (priceTypeObj == null) continue;
                    if (priceTypeObj.getBoolean("isallowadjust")) {
                        this.getView().setEnable(Boolean.TRUE, i, new String[]{priceType[1]});
                        continue;
                    }
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{priceType[1]});
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String callBackId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null || ((List)returnData).size() == 0) {
            return;
        }
        List distributeOpResults = (List)returnData;
        switch (callBackId) {
            case "distributecallback": 
            case "canceldistributecallback": {
                this.getView().showMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u7ed3\u679c", (String)"RetailPriceBasePlugin_7", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]), this.formataResult(distributeOpResults), null);
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private String formataResult(List<DistributeOpResult> distributeOpResults) {
        StringBuilder sb = new StringBuilder();
        for (DistributeOpResult result : distributeOpResults) {
            sb.append(result.getOpMessage()).append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    private boolean checkRetailPricePerm(String permKey) {
        return UserPermUtils.checkUserPerm((String)"ocdpm_retailpricelist", (String)permKey);
    }

    private void openWindow(String formId, String callBackSign, String title, String operation) {
        Object pkValue = this.getView().getModel().getValue("id");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.setCaption(title);
        formShowParameter.setCustomParam("id", pkValue);
        formShowParameter.setCustomParam(OPERATION, (Object)operation);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackSign));
        this.getView().showForm(formShowParameter);
    }

    private void clearEntryInvalidProperties(int[] enableRow) {
        int i;
        IDataModel model = this.getView().getModel();
        IFormView view = this.getView();
        model.beginInit();
        Boolean priceIsInvalid = null;
        DynamicObjectCollection details = model.getDataEntity(true).getDynamicObjectCollection("pricedetailentity");
        DynamicObject detail = null;
        for (i = 0; i < enableRow.length; ++i) {
            detail = (DynamicObject)details.get(enableRow[i]);
            priceIsInvalid = detail.getBoolean("priceisinvalid");
            if (!priceIsInvalid.booleanValue()) continue;
            detail.set("disabloper", null);
            detail.set("disableopdate", null);
            detail.set("priceisinvalid", (Object)Boolean.FALSE);
        }
        view.updateView("pricedetailentity");
        i = 0;
        DynamicObjectCollection entryEntity = model.getEntryEntity("pricedetailentity");
        for (DynamicObject entry : entryEntity) {
            if (entry.getBoolean("priceisinvalid")) continue;
            ++i;
            break;
        }
        if (i != 0) {
            model.setValue("enable", (Object)"A");
            model.setValue("disabler", null);
            model.setValue("disabletime", null);
        }
        SaveServiceHelper.update((DynamicObject)model.getDataEntity());
        model.setDataChanged(false);
        view.updateView();
        model.endInit();
    }

    private void updateEntryInvalidProperties(int[] disableRow) {
        int i;
        IDataModel model = this.getView().getModel();
        IFormView view = this.getView();
        model.beginInit();
        Boolean priceIsInvalid = null;
        DynamicObjectCollection details = model.getDataEntity(true).getDynamicObjectCollection("pricedetailentity");
        DynamicObject detail = null;
        for (i = 0; i < disableRow.length; ++i) {
            detail = (DynamicObject)details.get(disableRow[i]);
            priceIsInvalid = detail.getBoolean("priceisinvalid");
            if (priceIsInvalid.booleanValue()) continue;
            detail.set("disabloper", (Object)CommonUtil.getLoginUser());
            detail.set("disableopdate", (Object)TimeServiceHelper.now());
            detail.set("priceisinvalid", (Object)Boolean.TRUE);
        }
        i = 0;
        for (DynamicObject entry : details) {
            if (!entry.getBoolean("priceisinvalid")) continue;
            ++i;
        }
        if (i == details.size()) {
            model.setValue("enable", (Object)"B");
            model.setValue("disabler", (Object)CommonUtil.getLoginUser());
            model.setValue("disabletime", (Object)TimeServiceHelper.now());
        }
        SaveServiceHelper.update((DynamicObject)model.getDataEntity());
        model.setDataChanged(false);
        view.updateView();
        model.endInit();
    }

    public long getBillTypeId() {
        String billType;
        long billTypeId = 0L;
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && StringUtils.isNotBlank((CharSequence)(billType = (String)parentView.getFormShowParameter().getCustomParam("billtype")))) {
            billTypeId = Long.parseLong(billType);
        }
        return billTypeId;
    }
}

