/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.opplugin.promote;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.occ.ocbase.common.enums.PromotionEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocdpm.business.promote.handler.AmtItemHandler;
import kd.occ.ocdpm.business.promote.handler.AmtTicketHandler;
import kd.occ.ocdpm.business.promote.handler.AutoBindHandler;
import kd.occ.ocdpm.business.promote.handler.BindPriceHandler;
import kd.occ.ocdpm.business.promote.handler.FamtTicketHandler;
import kd.occ.ocdpm.business.promote.handler.FamtitemHandler;
import kd.occ.ocdpm.business.promote.handler.FamtpointHandler;
import kd.occ.ocdpm.business.promote.handler.FqtyItemHandler;
import kd.occ.ocdpm.business.promote.handler.FqtypointHandler;
import kd.occ.ocdpm.business.promote.handler.FullAmtHandler;
import kd.occ.ocdpm.business.promote.handler.FullCountHandler;
import kd.occ.ocdpm.business.promote.handler.FullPointHandler;
import kd.occ.ocdpm.business.promote.handler.FullTicketHandler;
import kd.occ.ocdpm.business.promote.handler.LadAmtHandler;
import kd.occ.ocdpm.business.promote.handler.LadCountHandler;
import kd.occ.ocdpm.business.promote.handler.PointDiscoHandler;
import kd.occ.ocdpm.business.promote.handler.PointPriceHandler;
import kd.occ.ocdpm.business.promote.handler.SchemeHandler;
import kd.occ.ocdpm.business.promote.helper.PromotionHelper;
import kd.occ.ocdpm.opplugin.promote.validator.PromoteValidatorFactory;

public class PromotionOp
extends AbstractOperationServicePlugIn {
    private String actbillid;
    private static final Map<String, SchemeHandler> SaveMap = new HashMap<String, SchemeHandler>();

    public void onAddValidators(AddValidatorsEventArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (null == dataEntities) {
            return;
        }
        this.actbillid = dataEntities[0].getString("dynamicbill");
        AbstractValidator validator = PromoteValidatorFactory.getValidator(this.actbillid);
        if (validator != null) {
            e.addValidator(PromoteValidatorFactory.getValidator(this.actbillid));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String operationKey;
        switch (operationKey = e.getOperationKey()) {
            case "save": 
            case "submit": {
                DynamicObject[] dataEntities;
                for (DynamicObject promote : dataEntities = e.getDataEntities()) {
                    long promoteid = DynamicObjectUtils.getPkValue((DynamicObject)promote);
                    boolean isExists = PromotionHelper.isExistsPromoteRule((long)promoteid);
                    if (isExists) continue;
                    this.saveRulesInfo(promoteid);
                }
                break;
            }
        }
    }

    private void saveRulesInfo(long promoteid) {
        String pageId = SessionManager.getCurrent().get(this.actbillid);
        IFormView parameterView = SessionManager.getCurrent().getView(pageId);
        if (parameterView == null) {
            return;
        }
        IDataModel dataModel = (IDataModel)parameterView.getService(IDataModel.class);
        SchemeHandler handler = SaveMap.get(this.actbillid);
        handler.save(dataModel, this.actbillid, promoteid);
    }

    static {
        SaveMap.put(PromotionEnum.PIECES_GIFT.getDynamickey(), (SchemeHandler)new FamtpointHandler());
        SaveMap.put(PromotionEnum.FULL_TICKET.getDynamickey(), (SchemeHandler)new FullTicketHandler());
        SaveMap.put(PromotionEnum.FAMT_TICKET.getDynamickey(), (SchemeHandler)new FamtTicketHandler());
        SaveMap.put(PromotionEnum.AMT_TICKET.getDynamickey(), (SchemeHandler)new AmtTicketHandler());
        SaveMap.put(PromotionEnum.FULL_POINT.getDynamickey(), (SchemeHandler)new FullPointHandler());
        SaveMap.put(PromotionEnum.FQTY_GIFT.getDynamickey(), (SchemeHandler)new FqtypointHandler());
        SaveMap.put(PromotionEnum.FULL_AMT.getDynamickey(), (SchemeHandler)new FullAmtHandler());
        SaveMap.put(PromotionEnum.FULL_COUNT.getDynamickey(), (SchemeHandler)new FullCountHandler());
        SaveMap.put(PromotionEnum.LAD_AMT.getDynamickey(), (SchemeHandler)new LadAmtHandler());
        SaveMap.put(PromotionEnum.LAD_COUNT.getDynamickey(), (SchemeHandler)new LadCountHandler());
        SaveMap.put(PromotionEnum.POINT_AMT.getDynamickey(), (SchemeHandler)new PointPriceHandler());
        SaveMap.put(PromotionEnum.POINT_DISC.getDynamickey(), (SchemeHandler)new PointDiscoHandler());
        SaveMap.put(PromotionEnum.BINDPRICE.getDynamickey(), (SchemeHandler)new BindPriceHandler());
        SaveMap.put(PromotionEnum.AUTOBIND.getDynamickey(), (SchemeHandler)new AutoBindHandler());
        SaveMap.put(PromotionEnum.FQTY_ITEM.getDynamickey(), (SchemeHandler)new FqtyItemHandler());
        SaveMap.put(PromotionEnum.FAMT_ITEM.getDynamickey(), (SchemeHandler)new FamtitemHandler());
        SaveMap.put(PromotionEnum.AMT_ITEM.getDynamickey(), (SchemeHandler)new AmtItemHandler());
    }
}

