/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.opplugin.promote.validator;

import java.math.BigDecimal;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.ocdpm.opplugin.promote.validator.AbstractPromoteValidator;

public class BindPriceValidator
extends AbstractPromoteValidator {
    @Override
    public void checkPromoteScheme(IDataModel dataModel) {
        BigDecimal totalprice;
        DynamicObject bindPrice = dataModel.getDataEntity(true);
        int pickQty = bindPrice.getInt("bindpickqty");
        if (pickQty == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6346\u7ed1\u6570\u91cf\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u91cd\u65b0\u7f16\u8f91", (String)"BindPriceValidator_0", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]));
        }
        String itemType = bindPrice.getString("itemgroup");
        if ("3".equals(itemType)) {
            DynamicObjectCollection rules = bindPrice.getDynamicObjectCollection("ruleentry");
            if (CollectionUtils.isEmpty((Collection)rules)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f18\u60e0\u89c4\u5219\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u91cd\u65b0\u7f16\u8f91", (String)"BindPriceValidator_1", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]));
            }
            for (DynamicObject rule : rules) {
                int groupsqno = rule.getInt("groupseqno");
                int pickqty = rule.getInt("pickqty");
                if (pickqty == 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f18\u60e0\u89c4\u5219\u5206\u7ec4%socc-ocdpm-opplugin_2", (String)"BindPriceValidator_5", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), groupsqno));
                }
                DynamicObjectCollection items = rule.getDynamicObjectCollection("groupitementry");
                if (CollectionUtils.isEmpty((Collection)items)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f18\u60e0\u89c4\u5219\u5206\u7ec4%socc-ocdpm-opplugin_2", (String)"BindPriceValidator_5", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), groupsqno));
                }
                boolean isSaleqtyZero = items.stream().anyMatch(a -> a.getInt("saleqty") == 0);
                if (isSaleqtyZero) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f18\u60e0\u89c4\u5219\u5206\u7ec4%socc-ocdpm-opplugin_2", (String)"BindPriceValidator_5", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), groupsqno));
                }
                boolean isPriceZero = items.stream().anyMatch(a -> a.getBigDecimal("promotionprice").compareTo(BigDecimal.ZERO) == 0);
                if (!isPriceZero) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f18\u60e0\u89c4\u5219\u5206\u7ec4%socc-ocdpm-opplugin_2", (String)"BindPriceValidator_5", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), groupsqno));
            }
        } else {
            DynamicObjectCollection itementry = bindPrice.getDynamicObjectCollection("itementry");
            if (CollectionUtils.isEmpty((Collection)itementry)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u6e05\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u91cd\u65b0\u7f16\u8f91", (String)"BindPriceValidator_3", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]));
            }
        }
        if ((totalprice = bindPrice.getBigDecimal("bindtotalamount")).compareTo(BigDecimal.ZERO) == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6346\u7ed1\u7ec4\u5408\u603b\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u91cd\u65b0\u7f16\u8f91", (String)"BindPriceValidator_4", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void checkFormView(DynamicObject promote) {
    }
}

