/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.opplugin.promotepolicy.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocdpm.business.promotion.OcdpmPromotePolicyHelper;
import kd.occ.ocdpm.common.enums.PromoteLadderType;
import kd.occ.ocdpm.common.enums.PromoteLinkEnum;
import kd.occ.ocdpm.common.enums.PromotionRowTypeEnum;

public class PromotePolicySaveValidator
extends AbstractValidator {
    protected static final String[] GiftControlBaseFields = new String[]{"promotiongroupno", "ladderno", "rowtype", "pggroupno", "typeingroup", "isthatcycleaccount", "typebetgroup"};
    protected static final String[] GiftControlDigitalFields = new String[]{"thatgiftqty", "thatgiftexcprice"};
    protected static final String[] ProductControlBaseFields = new String[]{"promotiongroupno", "ladderno", "rowtype", "pggroupno", "auxpty", "procondition", "prostrategy", "prostarttime", "proendtime", "remark", "item", "itemclass", "material", "materialgroup", "unit"};
    protected static final String[] ProductControlDigitalFields = new String[]{"buyqty", "buyamount", "buymutiple", "minlimitqty", "minlimitamount", "minbuypiece", "ladderminamount", "ladderminbase", "ladderminqty", "laddermaxamount", "laddermaxbase", "laddermaxqty"};
    protected static final String[] ProductControlFieldsTotal = new String[]{"item", "itemclass", "material", "materialgroup", "unit"};
    protected static final String[] ProductControlFieldsTopLadder = new String[]{"laddermaxamount", "laddermaxbase", "laddermaxqty"};
    protected static final String[] structureCompareFields = new String[]{"pggroupno", "itemclass", "item", "material", "materialgroup", "unit", "auxpty"};
    private static final String TOPLADDER = PromoteLadderType.TOPLADDER.getValue();
    private static final String SIMPLELADDER = PromoteLadderType.LADDER.getValue();
    private static final String NOLADDER = PromoteLadderType.NOLADDER.getValue();
    private static final String MAIN_ROW = PromotionRowTypeEnum.mainRow.getValue();
    private static final String GIFT_ROW = PromotionRowTypeEnum.giftRow.getValue();
    private static final String CHANNELTOCHANNEL = PromoteLinkEnum.CHANNELTOCHANNEL.getValue();
    private static final String SCM = PromoteLinkEnum.SCM.getValue();
    private static final String CHANNELTOSCM = PromoteLinkEnum.CHANNELTOSCM.getValue();
    private static final String BPZS_STRATEGY = "CXCL0001";
    private static final String ZDPZS_STRATEGY = "CXCL0002";
    private static final String ZKL_STRATEGY = "CXCL0003";
    private static final String ZDZKE_STRATEGY = "CXCL0004";
    private static final String DJZKE_STRATEGY = "CXCL0005";
    private static final String ZDZKL_STRATEGY = "CXCL0006";
    private static final String CXDJ_STRATEGY = "CXCL0007";
    private static final String ZDCPZH_OBJECT = "CXDX0002";
    private static final String ZD_OBJECT = "CXDX0004";

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length <= 0) {
            return;
        }
        String key = this.getOperateKey();
        if (key.equalsIgnoreCase("save") || key.equalsIgnoreCase("submit") || key.equalsIgnoreCase("audit")) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject promotePolicy = dataEntity.getDataEntity();
                DynamicObject promoteType = promotePolicy.getDynamicObject("promotetype");
                if (null != promoteType) {
                    String status = promoteType.getString("status");
                    String enable = promoteType.getString("enable");
                    if (!status.isEmpty() && !status.equalsIgnoreCase("C") || !enable.isEmpty() && !enable.equalsIgnoreCase("1")) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4fc3\u9500\u7c7b\u578b%s\u4e0d\u662f\u5df2\u914d\u7f6e+\u5df2\u5ba1\u6838+\u53ef\u7528\u72b6\u6001\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"PromotePolicySaveValidator_0", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promoteType.getString("number")));
                        continue;
                    }
                }
                this.checkPromotePolicyHeadInfo(dataEntity, promotePolicy);
                this.checkPromotePolicySaleEntity(dataEntity, promotePolicy);
                this.checkPromotePolicyOrderEntity(dataEntity, promotePolicy);
                this.checkPromotePolicyRuleDetailEntityNew(dataEntity, promotePolicy);
                this.checkExcGiftEntity(dataEntity, promotePolicy);
            }
        }
    }

    private void checkExcGiftEntity(ExtendedDataEntity dataEntity, DynamicObject promotePolicy) {
        DynamicObjectCollection giftEntrys = promotePolicy.getDynamicObjectCollection("exceptionentry");
        if (!this.checkExcItem(dataEntity, giftEntrys)) {
            return;
        }
        if (!this.checkExcAuxpty(dataEntity, giftEntrys)) {
            return;
        }
    }

    private boolean checkExcItem(ExtendedDataEntity dataEntity, DynamicObjectCollection giftEntrys) {
        boolean check = true;
        for (DynamicObject obj : giftEntrys) {
            int seq = obj.getInt("seq");
            Object item = obj.get("exceptionitem");
            Object material = obj.get("exceptionmaterial");
            if (item != null || material != null) continue;
            check = false;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4f8b\u5916\u5546\u54c1\u5206\u5f55\u7b2c%d\u884c\u7684\u4f8b\u5916\u5546\u54c1/\u4f8b\u5916\u7269\u6599\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_1", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq));
        }
        return check;
    }

    private boolean checkExcAuxpty(ExtendedDataEntity dataEntity, DynamicObjectCollection giftEntrys) {
        boolean check = true;
        for (DynamicObject row : giftEntrys) {
            DynamicObject material = row.getDynamicObject("exceptionmaterial");
            Object auxpty = row.get("exceptionauxpty");
            if (material == null || !material.getBoolean("isuseauxpty") || auxpty != null) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4f8b\u5916\u5546\u54c1\u7b2c%d\u884c\u4f8b\u5916\u8f85\u52a9\u5c5e\u6027\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_2", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), row.getInt("seq")));
        }
        return check;
    }

    private void checkPromotePolicyRuleDetailEntityNew(ExtendedDataEntity dataEntity, DynamicObject promotePolicy) {
        DynamicObject promoteType = promotePolicy.getDynamicObject("promotetype");
        if (promoteType == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8868\u5934\u4fc3\u9500\u653f\u7b56\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_3", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]));
            return;
        }
        String promoteCondition = DynamicObjectUtils.getString((DynamicObject)promoteType, (String)"promrequire");
        Object promotelink = promoteType.get("promlink");
        DynamicObject promoteObject = promoteType.getDynamicObject("promobject");
        String ladderType = promoteType.getString("laddertype");
        long promobjectId = DynamicObjectUtils.getPkValue((DynamicObject)promoteType.getDynamicObject("promobject"));
        ArrayList<String> giftKeys = new ArrayList<String>(Arrays.asList(GiftControlBaseFields));
        ArrayList<String> giftDigitalKeys = new ArrayList<String>(Arrays.asList(GiftControlDigitalFields));
        ArrayList<String> productKeys = new ArrayList<String>(Arrays.asList(ProductControlBaseFields));
        ArrayList<String> productDigitalKeys = new ArrayList<String>(Arrays.asList(ProductControlDigitalFields));
        ArrayList<String> productTotalkeys = new ArrayList<String>(Arrays.asList(ProductControlFieldsTotal));
        ArrayList<String> productTopKeys = new ArrayList<String>(Arrays.asList(ProductControlFieldsTopLadder));
        DynamicObjectCollection entrys = OcdpmPromotePolicyHelper.queryFilterRulesSetting((long)promoteType.getLong("id"));
        if (promoteCondition == null || promotelink == null || promoteObject == null || ladderType == null || entrys == null || entrys.size() == 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fc3\u9500\u653f\u7b56\u4e2d\u6240\u9009\u7684\u4fc3\u9500\u7c7b\u578b\u975e\u6cd5\u3002", (String)"PromotePolicySaveValidator_4", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection ruleDetailList = promotePolicy.getDynamicObjectCollection("entryentity");
        if (ruleDetailList == null || ruleDetailList.size() == 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u5206\u5f55\u81f3\u5c11\u6709\u4e00\u6761\u6570\u636e\u3002", (String)"PromotePolicySaveValidator_5", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.checckPromotionGroupAndLadderno(dataEntity, ruleDetailList, ladderType)) {
            return;
        }
        if (this.onlyHaveGiftRow(dataEntity, ruleDetailList)) {
            return;
        }
        if (!this.checkSycTimeAndRemark(dataEntity, ruleDetailList)) {
            return;
        }
        if (!this.checkStartAndEndTime(dataEntity, ruleDetailList, promotePolicy)) {
            return;
        }
        if (!this.checkAuxpty(dataEntity, ruleDetailList, promoteObject, promotelink)) {
            return;
        }
        if (ladderType.equalsIgnoreCase(NOLADDER)) {
            this.checkNoLadderCycle(dataEntity, ruleDetailList);
        }
        if (!this.checkSameFieldsInGroup(dataEntity, ruleDetailList, ladderType, promotelink)) {
            return;
        }
        if (!this.checkProstrategies(dataEntity, ruleDetailList, ladderType)) {
            return;
        }
        if (!NOLADDER.equalsIgnoreCase(ladderType) && !this.checkLadderNoConsistentInGroup(dataEntity, ruleDetailList)) {
            return;
        }
        if ((ladderType.equalsIgnoreCase(TOPLADDER) || ladderType.equalsIgnoreCase(SIMPLELADDER)) && !this.checkSameLadderFields(ruleDetailList, dataEntity)) {
            return;
        }
        for (DynamicObject ruleDetail : ruleDetailList) {
            String name;
            String key;
            int seq = ruleDetail.getInt("seq");
            String rowtype = ruleDetail.getString("rowtype");
            DynamicObject pgroupno = ruleDetail.getDynamicObject("pggroupno");
            DynamicObject promotionno = ruleDetail.getDynamicObject("promotiongroupno");
            DynamicObject ladderno = ruleDetail.getDynamicObject("ladderno");
            DynamicObject prioritydetail = ruleDetail.getDynamicObject("prioritydetail");
            if (rowtype == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u7b2c%d\u884c\u4e2d\u884c\u7c7b\u578b\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_6", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq));
                return;
            }
            if (promotionno == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u7b2c%d\u884c\u4e2d\u4fc3\u9500\u7ec4\u53f7\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_7", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq));
                return;
            }
            if (prioritydetail == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u7b2c%d\u884c\uff1a\u4fc3\u9500\u7ec4\u4f18\u5148\u7ea7\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_8", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq));
            } else {
                String num = prioritydetail.getString("number");
                for (char c : num.toCharArray()) {
                    if (c <= '9' && c >= '0') continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u7b2c%d\u884c\uff1a\u4fc3\u9500\u89c4\u5219\u4f18\u5148\u7ea7\u975e\u6cd5\u3002", (String)"PromotePolicySaveValidator_9", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq));
                    return;
                }
            }
            Object item = ruleDetail.get("item");
            Object material = ruleDetail.get("material");
            Object unit = ruleDetail.get("unit");
            if (unit == null && item != null && material != null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u7b2c%d\u884c\u4e2d:\u5f53\u5546\u54c1/\u7269\u6599\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u8ba1\u91cf\u5355\u4f4d\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_10", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq));
                continue;
            }
            if (promobjectId != 1082578038828457984L) {
                if (promotelink.equals(SCM)) {
                    Object materialgroup = ruleDetail.get("materialgroup");
                    if (materialgroup == null && material == null) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u7b2c%d\u884c\u4e2d:\u5f53\u4fc3\u9500\u7c7b\u522b\u4e0d\u4e3a\u6574\u5355\u4e14\u73af\u8282\u4e3a\u4f9b\u5e94\u94fe\uff0c\u7269\u6599\u7ec4/\u7269\u6599\u6709\u4e14\u5fc5\u6709\u4e00\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_11", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq));
                    }
                } else {
                    Object itemclass = ruleDetail.get("itemclass");
                    if (itemclass == null && item == null) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u7b2c%d\u884c\u4e2d:\u5f53\u4fc3\u9500\u7c7b\u522b\u4e0d\u4e3a\u6574\u5355\u4e14\u73af\u8282\u4e3a\u5168\u6e20\u9053\uff0c\u5546\u54c1/\u5546\u54c1\u5206\u7c7b\u6709\u4e14\u5fc5\u6709\u4e00\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_12", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq));
                    }
                }
            }
            if (rowtype.equalsIgnoreCase(MAIN_ROW)) {
                Object obj3;
                for (DynamicObject obj2 : entrys) {
                    key = obj2.getString("fieldkey");
                    boolean require = obj2.getBoolean("require");
                    name = obj2.getString("fieldname");
                    if (promoteObject.getString("number").equalsIgnoreCase(ZD_OBJECT) && productTotalkeys.contains(key) || ladderType.equalsIgnoreCase(TOPLADDER) && productTopKeys.contains(key) && this.isTopLadder(ruleDetail, ruleDetailList)) continue;
                    if (productKeys.contains(key) && require && ruleDetail.get(key) == null) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u7b2c%d\u884c\u4e3b\u4ea7\u54c1\u884c\u4e2d\u7684\u5b57\u6bb5:%S,\u5728\u4fc3\u9500\u7c7b\u578b\u4e2d\u8bbe\u7f6e\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_13", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq, name));
                    }
                    if (!productDigitalKeys.contains(key) || !require || ruleDetail.getBigDecimal(key).compareTo(BigDecimal.ZERO) > 0) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u7b2c%d\u884c\u4e3b\u4ea7\u54c1\u884c\u4e2d\u7684\u5b57\u6bb5:%S,\u5728\u4fc3\u9500\u7c7b\u578b\u4e2d\u8bbe\u7f6e\u5927\u4e8e0\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_14", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq, name));
                }
                if (promoteObject.getString("number").equalsIgnoreCase(ZD_OBJECT) && ladderType.equalsIgnoreCase(NOLADDER)) {
                    int count = 0;
                    for (Object obj3 : ruleDetailList) {
                        DynamicObject topromotionno = obj3.getDynamicObject("promotiongroupno");
                        if (topromotionno == null || DynamicObjectUtils.getPkValue((DynamicObject)topromotionno) != DynamicObjectUtils.getPkValue((DynamicObject)promotionno) || obj3.getString("rowtype") == null || !obj3.getString("rowtype").equalsIgnoreCase(MAIN_ROW)) continue;
                        ++count;
                    }
                    if (count > 1) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u7b2c%d\u884c\u4e2d:\u4fc3\u9500\u5bf9\u8c61\u4e3a\u6574\u5355\u65f6\uff0c \u65e0\u9636\u68af\u65f6\u6bcf\u4e2a\u4fc3\u9500\u7ec4\u53ea\u5141\u8bb8\u6dfb\u52a0\u4e00\u4e2a\u4e3b\u5546\u54c1\u884c\u3002", (String)"PromotePolicySaveValidator_15", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq));
                        return;
                    }
                } else if (promoteObject.getString("number").equalsIgnoreCase(ZD_OBJECT) && !ladderType.equalsIgnoreCase(NOLADDER)) {
                    int count = 0;
                    for (Object obj3 : ruleDetailList) {
                        DynamicObject toladderno = obj3.getDynamicObject("ladderno");
                        DynamicObject topromotionno = obj3.getDynamicObject("promotiongroupno");
                        if (topromotionno == null || DynamicObjectUtils.getPkValue((DynamicObject)topromotionno) != DynamicObjectUtils.getPkValue((DynamicObject)promotionno) || toladderno == null || DynamicObjectUtils.getPkValue((DynamicObject)toladderno) != DynamicObjectUtils.getPkValue((DynamicObject)ladderno) || obj3.getString("rowtype") == null || !obj3.getString("rowtype").equalsIgnoreCase(MAIN_ROW)) continue;
                        ++count;
                    }
                    if (count > 1) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u7b2c%d\u884c\u4e2d:\u6709\u9636\u68af\u65f6\u6bcf\u4e2a\u4fc3\u9500\u7ec4\u4e0b\u7684\u6bcf\u4e2a\u9636\u68af\u53ea\u5141\u8bb8\u6dfb\u52a0\u4e00\u4e2a\u4e3b\u5546\u54c1\u884c\u3002", (String)"PromotePolicySaveValidator_16", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq));
                        return;
                    }
                }
                DynamicObjectCollection promoteValues = ruleDetail.getDynamicObjectCollection("prostrategy");
                ArrayList<Object> strategies = new ArrayList<Object>(8);
                if (null == promoteValues || promoteValues.size() == 0) {
                    this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4e2d\u7b2c%d\u884c\u4e2d\u4fc3\u9500\u7b56\u7565\uff1a\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_17", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq));
                } else {
                    obj3 = promoteValues.iterator();
                    while (obj3.hasNext()) {
                        DynamicObject obj4 = (DynamicObject)obj3.next();
                        strategies.add(obj4.getDynamicObject(1).get("number"));
                    }
                }
                if (strategies.contains(ZDPZS_STRATEGY) && rowtype.equalsIgnoreCase(MAIN_ROW)) {
                    this.checkApointAndGift(ruleDetail, ruleDetailList, dataEntity, ladderType);
                }
                if (!strategies.contains(ZDPZS_STRATEGY) && rowtype.equalsIgnoreCase(MAIN_ROW)) {
                    this.checkNoApointAndGift(ruleDetail, ruleDetailList, dataEntity, ladderType);
                }
                if (promoteObject.getString("number").equalsIgnoreCase(ZDCPZH_OBJECT) && pgroupno != null) {
                    obj3 = ruleDetailList.iterator();
                    while (obj3.hasNext()) {
                        DynamicObject obj5 = (DynamicObject)obj3.next();
                        if (obj5.getInt("seq") <= seq) continue;
                        DynamicObject topgroupno = obj5.getDynamicObject("pggroupno");
                        DynamicObject topromotioNo = obj5.getDynamicObject("promotiongroupno");
                        DynamicObject toladderno = obj5.getDynamicObject("ladderno");
                        if (topromotioNo == null || topgroupno == null || DynamicObjectUtils.getPkValue((DynamicObject)topromotioNo) != DynamicObjectUtils.getPkValue((DynamicObject)promotionno) || !ladderType.equals(NOLADDER) && (ladderType.equals(NOLADDER) || DynamicObjectUtils.getPkValue((DynamicObject)ladderno) != DynamicObjectUtils.getPkValue((DynamicObject)toladderno)) || DynamicObjectUtils.getPkValue((DynamicObject)topgroupno) != DynamicObjectUtils.getPkValue((DynamicObject)pgroupno)) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u7b2c%d\u884c\u4e2d\u9488\u5bf9\u6307\u5b9a\u4ea7\u54c1\u7ec4\u7684\u4fc3\u9500\uff0c\u6bcf\u4e2a\u4ea7\u54c1\u7ec4\u53f7\u53ea\u5141\u8bb8\u6dfb\u52a0\u5355\u4e00\u4ea7\u54c1\u3002", (String)"PromotePolicySaveValidator_18", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq));
                    }
                }
                ArrayList<String> benList = new ArrayList<String>(Collections.singletonList("thisgiftqty"));
                ArrayList<String> zheList = new ArrayList<String>(Collections.singletonList("discounttate"));
                ArrayList<String> zhengList = new ArrayList<String>(Collections.singletonList("totaldiscount"));
                ArrayList<String> guList = new ArrayList<String>(Collections.singletonList("fixeddisctamount"));
                ArrayList<String> danzheList = new ArrayList<String>(Collections.singletonList("pricedisctamt"));
                ArrayList<String> cudanList = new ArrayList<String>(Collections.singletonList("prounitprice"));
                for (DynamicObject obj6 : entrys) {
                    String key2 = obj6.getString("fieldkey");
                    boolean require = obj6.getBoolean("require");
                    String name2 = obj6.getString("fieldname");
                    if (strategies.contains(BPZS_STRATEGY) && benList.contains(key2) && require && ruleDetail.getBigDecimal(key2).compareTo(BigDecimal.ZERO) <= 0) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4e2d\u7b2c%d\u884c\u4e2d\u4fc3\u9500\u7b56\u7565\u5305\u542b\u672c\u54c1\u8d60\u9001\u7684\u60c5\u51b5\u4e0b\uff0c\u8be5\u4fc3\u9500\u7c7b\u578b\u89c4\u5b9a%S\u5927\u4e8e0\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_19", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq, name2));
                    }
                    if (strategies.contains(ZKL_STRATEGY) && zheList.contains(key2) && require && ruleDetail.getBigDecimal(key2).compareTo(BigDecimal.ZERO) <= 0) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4e2d\u7b2c%d\u884c\u4e2d\u4fc3\u9500\u7b56\u7565\u5305\u542b\u6298\u6263\u7387\u7684\u60c5\u51b5\u4e0b\uff0c\u8be5\u4fc3\u9500\u7c7b\u578b\u89c4\u5b9a%S\u5927\u4e8e0\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_20", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq, name2));
                    }
                    if (strategies.contains(ZDZKL_STRATEGY) && zhengList.contains(key2) && require && ruleDetail.getBigDecimal(key2).compareTo(BigDecimal.ZERO) <= 0) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4e2d\u7b2c%d\u884c\u4e2d\u4fc3\u9500\u7b56\u7565\u5305\u542b\u6574\u5355\u6298\u6263\u7387\u7684\u60c5\u51b5\u4e0b\uff0c\u8be5\u4fc3\u9500\u7c7b\u578b\u89c4\u5b9a%S\u5927\u4e8e0\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_21", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq, name2));
                    }
                    if (strategies.contains(ZDZKE_STRATEGY) && guList.contains(key2) && require && ruleDetail.getBigDecimal(key2).compareTo(BigDecimal.ZERO) <= 0) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4e2d\u7b2c%d\u884c\u4e2d\u4fc3\u9500\u7b56\u7565\u5305\u542b\u6574\u5355\u6298\u6263\u989d\u7684\u60c5\u51b5\u4e0b\uff0c\u8be5\u4fc3\u9500\u7c7b\u578b\u89c4\u5b9a%S\u5927\u4e8e0\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_22", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq, name2));
                    }
                    if (strategies.contains(DJZKE_STRATEGY) && danzheList.contains(key2) && require && ruleDetail.getBigDecimal(key2).compareTo(BigDecimal.ZERO) <= 0) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4e2d\u7b2c%d\u884c\u4e2d\u4fc3\u9500\u7b56\u7565\u5305\u542b\u5355\u4ef7\u6298\u6263\u989d\u7684\u60c5\u51b5\u4e0b\uff0c\u8be5\u4fc3\u9500\u7c7b\u578b\u89c4\u5b9a%S\u5927\u4e8e0\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_23", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq, name2));
                    }
                    if (!strategies.contains(CXDJ_STRATEGY) || !cudanList.contains(key2) || !require || ruleDetail.getBigDecimal(key2).compareTo(BigDecimal.ZERO) > 0) continue;
                    this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4e2d\u7b2c%d\u884c\u4e2d\u4fc3\u9500\u7b56\u7565\u5305\u542b\u4fc3\u9500\u5355\u4ef7\u7684\u60c5\u51b5\u4e0b\uff0c\u8be5\u4fc3\u9500\u7c7b\u578b\u89c4\u5b9a%S\u5927\u4e8e0\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_24", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq, name2));
                }
            } else if (rowtype.equalsIgnoreCase(GIFT_ROW)) {
                for (DynamicObject obj : entrys) {
                    key = obj.getString("fieldkey");
                    boolean require = obj.getBoolean("require");
                    name = obj.getString("fieldname");
                    if (giftKeys.contains(key) && require && ruleDetail.get(key) == null) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u7b2c%d\u884c\u8d60\u54c1\u884c\u4e2d\u7684\u5b57\u6bb5:%S,\u5728\u4fc3\u9500\u7c7b\u578b\u4e2d\u8bbe\u7f6e\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_25", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq, name));
                    }
                    if (!giftDigitalKeys.contains(key) || !require || ruleDetail.getBigDecimal(key).compareTo(BigDecimal.ZERO) > 0) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u7b2c%d\u884c\u8d60\u54c1\u884c\u4e2d\u7684\u5b57\u6bb5:%S,\u5728\u4fc3\u9500\u7c7b\u578b\u4e2d\u8bbe\u7f6e\u5927\u4e8e0\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_26", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq, name));
                }
                if (item == null && material == null) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u7b2c%d\u884c\u8d60\u54c1\u884c\u4e2d\u7684\u7269\u6599/\u5546\u54c1\u4e8c\u9009\u4e00\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_27", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq));
                }
                if (unit == null) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u7b2c%d\u884c\u8d60\u54c1\u884c\u4e2d\u7684\u8ba1\u91cf\u5355\u4f4d\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_28", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq));
                }
            }
            this.checkLadderConsistent(ruleDetail, ruleDetailList, dataEntity);
        }
    }

    private boolean checkStartAndEndTime(ExtendedDataEntity dataEntity, DynamicObjectCollection ruleDetailList, DynamicObject promotePolicy) {
        boolean check = true;
        for (DynamicObject row : ruleDetailList) {
            boolean end;
            boolean start = row.get("prostarttime") == null;
            boolean bl = end = row.get("proendtime") == null;
            if (start ^ end) {
                check = false;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u7b2c%d\u884c\u4fc3\u9500\u7ec4\u5f00\u59cb\u65f6\u95f4\u4e0e\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u540c\u65f6\u5b58\u5728\u6216\u8005\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"PromotePolicySaveValidator_29", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), row.getInt("seq")));
            }
            Date startDate = row.getDate("prostarttime");
            Date endDate = row.getDate("proendtime");
            Date effectivedate = promotePolicy.getDate("effectivedate");
            Date expirationdate = promotePolicy.getDate("expirationdate");
            if (startDate == null || endDate == null || effectivedate == null || expirationdate == null) continue;
            if (startDate.before(effectivedate) || startDate.after(expirationdate)) {
                check = false;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u7b2c%d\u884c\u4fc3\u9500\u7ec4\u5f00\u59cb\u65f6\u95f4\u9700\u6ee1\u8db3\u8868\u5934\u751f\u6548\u8ddf\u5931\u6548\u65f6\u95f4\u533a\u95f4\u3002", (String)"PromotePolicySaveValidator_30", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), row.getInt("seq")));
                continue;
            }
            if (!endDate.before(effectivedate) && !endDate.after(expirationdate)) continue;
            check = false;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u7b2c%d\u884c\u4fc3\u9500\u7ec4\u7ed3\u675f\u65f6\u95f4\u9700\u6ee1\u8db3\u8868\u5934\u751f\u6548\u8ddf\u5931\u6548\u65f6\u95f4\u533a\u95f4\u3002", (String)"PromotePolicySaveValidator_31", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), row.getInt("seq")));
        }
        return check;
    }

    private boolean onlyHaveGiftRow(ExtendedDataEntity dataEntity, DynamicObjectCollection ruleDetailList) {
        for (DynamicObject row : ruleDetailList) {
            String rowType = row.getString("rowtype");
            if (rowType == null || !MAIN_ROW.equalsIgnoreCase(rowType)) continue;
            return false;
        }
        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u91cc\u9762\u53ea\u6709\u8d60\u54c1\u884c\u65f6\u4e0d\u53ef\u4fdd\u5b58\u3002", (String)"PromotePolicySaveValidator_32", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]));
        return true;
    }

    private boolean checkSycTimeAndRemark(ExtendedDataEntity dataEntity, DynamicObjectCollection ruleDetailList) {
        Map<String, List<DynamicObject>> promoteGroup = ruleDetailList.stream().collect(Collectors.groupingBy(a -> a.getDynamicObject("promotiongroupno").getString("number")));
        boolean check = true;
        for (Map.Entry<String, List<DynamicObject>> entry : promoteGroup.entrySet()) {
            Map<String, List<DynamicObject>> remarkMap;
            Map<Date, List<DynamicObject>> endtimeMap;
            Map<Date, List<DynamicObject>> starttimeMap;
            List<DynamicObject> list = entry.getValue();
            String promoteNumber = entry.getKey();
            List starttimelist = list.stream().filter(a -> a.get("prostarttime") != null).collect(Collectors.toList());
            if (starttimelist.size() > 0 && starttimelist.size() != list.size()) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4e2d\u4fc3\u9500\u7ec4%S\uff0c\u8bf7\u786e\u4fdd\u4fc3\u9500\u7ec4\u5f00\u59cb\u65f6\u95f4\u5185\u5bb9\u4e00\u81f4\u3002", (String)"PromotePolicySaveValidator_33", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promoteNumber));
                check = false;
            } else if (starttimelist.size() > 0 && (starttimeMap = list.stream().collect(Collectors.groupingBy(a -> a.getDate("prostarttime")))).size() != 1) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4e2d\u4fc3\u9500\u7ec4%S\uff0c\u8bf7\u786e\u4fdd\u4fc3\u9500\u7ec4\u5f00\u59cb\u65f6\u95f4\u5185\u5bb9\u4e00\u81f4\u3002", (String)"PromotePolicySaveValidator_33", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promoteNumber));
                check = false;
            }
            List endtimelist = list.stream().filter(a -> a.get("proendtime") != null).collect(Collectors.toList());
            if (endtimelist.size() > 0 && endtimelist.size() != list.size()) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4e2d\u4fc3\u9500\u7ec4%S,\u8bf7\u786e\u4fdd\u4fc3\u9500\u7ec4\u7ed3\u675f\u65f6\u95f4\u5185\u5bb9\u4e00\u81f4\u3002", (String)"PromotePolicySaveValidator_34", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promoteNumber));
                check = false;
            } else if (endtimelist.size() > 0 && (endtimeMap = list.stream().collect(Collectors.groupingBy(a -> a.getDate("proendtime")))).size() != 1) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4e2d\u4fc3\u9500\u7ec4%S\uff0c\u8bf7\u786e\u4fdd\u4fc3\u9500\u7ec4\u7ed3\u675f\u65f6\u95f4\u5185\u5bb9\u4e00\u81f4\u3002", (String)"PromotePolicySaveValidator_35", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promoteNumber));
                check = false;
            }
            List remarlist = list.stream().filter(a -> a.get("remark") != null).collect(Collectors.toList());
            if (remarlist.size() > 0 && remarlist.size() != list.size()) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4e2d\u4fc3\u9500\u7ec4%S\uff0c\u8bf7\u786e\u4fdd\u4fc3\u9500\u7ec4\u5907\u6ce8\u5185\u5bb9\u4e00\u81f4\u3002", (String)"PromotePolicySaveValidator_36", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promoteNumber));
                check = false;
                continue;
            }
            if (remarlist.size() <= 0 || (remarkMap = list.stream().collect(Collectors.groupingBy(a -> a.getString("remark")))).size() == 1) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4e2d\u4fc3\u9500\u7ec4%S\uff0c\u8bf7\u786e\u4fdd\u4fc3\u9500\u7ec4\u5907\u6ce8\u5185\u5bb9\u4e00\u81f4\u3002", (String)"PromotePolicySaveValidator_36", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promoteNumber));
            check = false;
        }
        return check;
    }

    private boolean checkAuxpty(ExtendedDataEntity dataEntity, DynamicObjectCollection ruleDetailList, DynamicObject promoteObject, Object promotelink) {
        boolean check;
        block6: {
            Object auxpty;
            DynamicObject material;
            DynamicObject item;
            List giftlist;
            List mainlist;
            block5: {
                Object auxpty2;
                DynamicObject material2;
                mainlist = ruleDetailList.stream().filter(a -> a.getString("rowtype").equalsIgnoreCase(MAIN_ROW)).collect(Collectors.toList());
                giftlist = ruleDetailList.stream().filter(a -> a.getString("rowtype").equalsIgnoreCase(GIFT_ROW)).collect(Collectors.toList());
                check = true;
                if (!promotelink.equals(SCM)) break block5;
                for (DynamicObject entry : giftlist) {
                    material2 = entry.getDynamicObject("material");
                    auxpty2 = entry.get("auxpty");
                    if (material2 == null || !material2.getBoolean("isuseauxpty") || auxpty2 != null) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u7b2c%d\u884c\u7684\u7269\u6599\u542f\u7528\u4e86\u8f85\u52a9\u5c5e\u6027\uff0c \u8bf7\u586b\u5199\u5bf9\u5e94\u7684\u8f85\u52a9\u5c5e\u6027\u3002", (String)"PromotePolicySaveValidator_37", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                    check = false;
                }
                if (!promoteObject.getString("number").equalsIgnoreCase(ZDCPZH_OBJECT)) break block6;
                for (DynamicObject entry : mainlist) {
                    material2 = entry.getDynamicObject("material");
                    auxpty2 = entry.get("auxpty");
                    if (material2 == null || !material2.getBoolean("isuseauxpty") || auxpty2 != null) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u7b2c%d\u884c\u7684\u7269\u6599\u542f\u7528\u4e86\u8f85\u52a9\u5c5e\u6027\uff0c \u8bf7\u586b\u5199\u5bf9\u5e94\u7684\u8f85\u52a9\u5c5e\u6027\u3002", (String)"PromotePolicySaveValidator_37", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                    check = false;
                }
                break block6;
            }
            for (DynamicObject entry : giftlist) {
                item = entry.getDynamicObject("item");
                material = entry.getDynamicObject("material");
                auxpty = entry.get("auxpty");
                if (item == null || material == null || !material.getBoolean("isuseauxpty") || auxpty != null) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u7b2c%d\u884c\u7684\u5546\u54c1\u542f\u7528\u4e86\u8f85\u52a9\u5c5e\u6027\uff0c \u8bf7\u586b\u5199\u5bf9\u5e94\u7684\u8f85\u52a9\u5c5e\u6027\u3002", (String)"PromotePolicySaveValidator_38", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                check = false;
            }
            if (promoteObject.getString("number").equalsIgnoreCase(ZDCPZH_OBJECT)) {
                for (DynamicObject entry : mainlist) {
                    item = entry.getDynamicObject("item");
                    material = entry.getDynamicObject("material");
                    auxpty = entry.get("auxpty");
                    if (item == null || material == null || !material.getBoolean("isuseauxpty") || auxpty != null) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u7b2c%d\u884c\u7684\u5546\u54c1\u542f\u7528\u4e86\u8f85\u52a9\u5c5e\u6027\uff0c \u8bf7\u586b\u5199\u5bf9\u5e94\u7684\u8f85\u52a9\u5c5e\u6027\u3002", (String)"PromotePolicySaveValidator_38", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                    check = false;
                }
            }
        }
        return check;
    }

    private boolean checckPromotionGroupAndLadderno(ExtendedDataEntity dataEntity, DynamicObjectCollection ruleDetailList, String ladderType) {
        boolean check = true;
        for (DynamicObject row : ruleDetailList) {
            if (row.getDynamicObject("promotiongroupno") == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u7b2c%d\u884c\u4fc3\u9500\u7ec4\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_39", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), row.getInt("seq")));
                check = false;
            }
            if (ladderType.equalsIgnoreCase(NOLADDER) || row.getDynamicObject("ladderno") != null) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u7b2c%d\u884c\u9636\u68af\u53f7\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_40", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), row.getInt("seq")));
            check = false;
        }
        return check;
    }

    private boolean checkSameFieldsInGroup(ExtendedDataEntity dataEntity, DynamicObjectCollection ruleDetailList, String ladderType, Object promotelink) {
        List mainRows = ruleDetailList.stream().filter(a -> a.getString("rowtype").equalsIgnoreCase(MAIN_ROW)).collect(Collectors.toList());
        if (promotelink.equals(SCM)) {
            if (ladderType.equalsIgnoreCase(NOLADDER)) {
                Map<String, List<DynamicObject>> promotionGroup = mainRows.stream().collect(Collectors.groupingBy(a -> a.getDynamicObject("promotiongroupno").getString("number")));
                for (Map.Entry<String, List<DynamicObject>> entry : promotionGroup.entrySet()) {
                    String promotionNumber = entry.getKey();
                    List<DynamicObject> list = entry.getValue();
                    boolean check = true;
                    List materialList = list.stream().filter(a -> a.getDynamicObject("material") != null).collect(Collectors.toList());
                    Map<String, List<DynamicObject>> sameMaterialMap = materialList.stream().collect(Collectors.groupingBy(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("material")) + "," + DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("unit")) + "," + DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("auxpty"))));
                    if (materialList.size() != sameMaterialMap.size()) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4fc3\u9500\u7ec4%S\u5b58\u5728\u76f8\u540c\u7684\u7269\u6599+\u8ba1\u91cf\u5355\u4f4d+\u8f85\u52a9\u5c5e\u6027\u884c\u3002", (String)"PromotePolicySaveValidator_41", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promotionNumber));
                        check = false;
                    }
                    List materialGroupList = list.stream().filter(a -> a.getDynamicObject("materialgroup") != null).collect(Collectors.toList());
                    Map<Long, List<DynamicObject>> sameMaterialGroupMap = materialGroupList.stream().collect(Collectors.groupingBy(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("materialgroup"))));
                    if (materialGroupList.size() != sameMaterialGroupMap.size()) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4fc3\u9500\u7ec4%S\u5b58\u5728\u76f8\u540c\u7684\u7269\u6599\u7ec4\u884c\u3002", (String)"PromotePolicySaveValidator_42", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promotionNumber));
                        check = false;
                    }
                    if (check) continue;
                    return false;
                }
            } else {
                Map<String, List<DynamicObject>> ladderGroup = mainRows.stream().collect(Collectors.groupingBy(a -> a.getDynamicObject("promotiongroupno").getString("number") + "," + a.getDynamicObject("ladderno").getString("number")));
                for (Map.Entry<String, List<DynamicObject>> entry : ladderGroup.entrySet()) {
                    String promotionNo = entry.getKey().split(",")[0];
                    String ladderNo = entry.getKey().split(",")[1];
                    boolean check = true;
                    List<DynamicObject> list = entry.getValue();
                    List materialList = list.stream().filter(a -> a.getDynamicObject("material") != null).collect(Collectors.toList());
                    Map<String, List<DynamicObject>> materialGroupMap = materialList.stream().collect(Collectors.groupingBy(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("material")) + "," + DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("unit")) + "," + DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("auxpty"))));
                    if (materialList.size() != materialGroupMap.size()) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4fc3\u9500\u7ec4%1$s\u4e2d\u9636\u68af\u7ec4%2$s\u5b58\u5728\u76f8\u540c\u7269\u6599+\u8ba1\u91cf\u5355\u4f4d+\u8f85\u52a9\u5c5e\u6027\u884c\u3002", (String)"PromotePolicySaveValidator_85", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promotionNo, ladderNo));
                        check = false;
                    }
                    List materialGroupList = list.stream().filter(a -> a.getDynamicObject("materialgroup") != null).collect(Collectors.toList());
                    Map<Long, List<DynamicObject>> materialgroupMap = materialGroupList.stream().collect(Collectors.groupingBy(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("material"))));
                    if (materialGroupList.size() != materialgroupMap.size()) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4fc3\u9500\u7ec4%1$s\u4e2d\u9636\u68af\u7ec4%2$s\u5b58\u5728\u76f8\u540c\u7684\u7269\u6599\u7ec4\u884c\u3002", (String)"PromotePolicySaveValidator_86", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promotionNo, ladderNo));
                        check = false;
                    }
                    if (check) continue;
                    return false;
                }
            }
        } else if (ladderType.equalsIgnoreCase(NOLADDER)) {
            Map<String, List<DynamicObject>> promotionGroup = mainRows.stream().collect(Collectors.groupingBy(a -> a.getDynamicObject("promotiongroupno").getString("number")));
            for (Map.Entry<String, List<DynamicObject>> entry : promotionGroup.entrySet()) {
                String promotionNumber = entry.getKey();
                List<DynamicObject> list = entry.getValue();
                boolean check = true;
                List itemList = list.stream().filter(a -> a.getDynamicObject("item") != null).collect(Collectors.toList());
                Map<String, List<DynamicObject>> sameitemMap = itemList.stream().collect(Collectors.groupingBy(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("item")) + "," + DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("unit")) + "," + DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("auxpty"))));
                if (itemList.size() != sameitemMap.size()) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4fc3\u9500\u7ec4%S\u5b58\u5728\u76f8\u540c\u7684\u5546\u54c1+\u8ba1\u91cf\u5355\u4f4d+\u8f85\u52a9\u5c5e\u6027\u884c\u3002", (String)"PromotePolicySaveValidator_45", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promotionNumber));
                    check = false;
                }
                List itemclassList = list.stream().filter(a -> a.getDynamicObject("itemclass") != null).collect(Collectors.toList());
                Map<Long, List<DynamicObject>> sameitemclassMap = itemclassList.stream().collect(Collectors.groupingBy(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("itemclass"))));
                if (itemclassList.size() != sameitemclassMap.size()) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4fc3\u9500\u7ec4%S\u5b58\u5728\u76f8\u540c\u7684\u5546\u54c1\u5206\u7c7b\u884c\u3002", (String)"PromotePolicySaveValidator_46", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promotionNumber));
                    check = false;
                }
                if (check) continue;
                return false;
            }
        } else {
            Map<String, List<DynamicObject>> ladderGroup = mainRows.stream().collect(Collectors.groupingBy(a -> a.getDynamicObject("promotiongroupno").getString("number") + "," + a.getDynamicObject("ladderno").getString("number")));
            for (Map.Entry<String, List<DynamicObject>> entry : ladderGroup.entrySet()) {
                String promotionNo = entry.getKey().split(",")[0];
                String ladderNo = entry.getKey().split(",")[1];
                boolean check = true;
                List<DynamicObject> list = entry.getValue();
                List itemlList = list.stream().filter(a -> a.getDynamicObject("item") != null).collect(Collectors.toList());
                Map<String, List<DynamicObject>> itemMap = itemlList.stream().collect(Collectors.groupingBy(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("item")) + "," + DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("unit")) + "," + DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("auxpty"))));
                if (itemlList.size() != itemMap.size()) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4fc3\u9500\u7ec4%1$s\u4e2d\u9636\u68af\u7ec4%2$s\u5b58\u5728\u76f8\u540c\u5546\u54c1+\u8ba1\u91cf\u5355\u4f4d+\u8f85\u52a9\u5c5e\u6027\u884c\u3002", (String)"PromotePolicySaveValidator_87", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promotionNo, ladderNo));
                    check = false;
                }
                List itemclassList = list.stream().filter(a -> a.getDynamicObject("itemclass") != null).collect(Collectors.toList());
                Map<Long, List<DynamicObject>> itemclassMap = itemclassList.stream().collect(Collectors.groupingBy(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("itemclass"))));
                if (itemclassList.size() != itemclassMap.size()) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4fc3\u9500\u7ec4%1$s\u4e2d\u9636\u68af\u7ec4%2$s\u5b58\u5728\u76f8\u540c\u7684\u5546\u54c1\u5206\u7c7b\u884c\u3002", (String)"PromotePolicySaveValidator_88", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promotionNo, ladderNo));
                    check = false;
                }
                if (check) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkDetailPriority(ExtendedDataEntity dataEntity, DynamicObjectCollection ruleDetailList) {
        Map<Long, List<DynamicObject>> promotionGroup = ruleDetailList.stream().collect(Collectors.groupingBy(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("promotiongroupno"))));
        int groupLength = promotionGroup.size();
        if (groupLength == 1) {
            return true;
        }
        HashSet<Long> keys = new HashSet<Long>(ruleDetailList.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : promotionGroup.entrySet()) {
            List<DynamicObject> list = entry.getValue();
            DynamicObject priority = list.get(0).getDynamicObject("prioritydetail");
            if (priority == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4e2d\u7b2c%d\u884c\u4fc3\u9500\u4f18\u5148\u7ea7\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_49", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), list.get(0).getInt("seq")));
                return false;
            }
            keys.add(DynamicObjectUtils.getPkValue((DynamicObject)priority));
        }
        if (keys.size() != groupLength) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4e2d\u4e0d\u540c\u4fc3\u9500\u7ec4\u95f4\u4e0d\u5141\u8bb8\u6709\u76f8\u540c\u7684\u4fc3\u9500\u7ec4\u4f18\u5148\u7ea7\uff0c\u8bf7\u8c03\u6574\u3002", (String)"PromotePolicySaveValidator_50", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkProstrategies(ExtendedDataEntity dataEntity, DynamicObjectCollection ruleDetailList, String ladderType) {
        Map<String, List<DynamicObject>> promotionMap = ruleDetailList.stream().filter(a -> a.getString("rowtype").equalsIgnoreCase(MAIN_ROW)).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(a -> a.getDynamicObject("promotiongroupno").getString("number")));
        if (ladderType.equalsIgnoreCase(NOLADDER)) {
            for (Map.Entry<String, List<DynamicObject>> promoteGroup : promotionMap.entrySet()) {
                String promotionNo = promoteGroup.getKey();
                List<DynamicObject> list = promoteGroup.getValue();
                if (list.size() == 1) continue;
                DynamicObjectCollection strategies = list.get(0).getDynamicObjectCollection("prostrategy");
                Set<Long> strategiesId = strategies.stream().collect(Collectors.groupingBy(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject(1)))).keySet();
                for (DynamicObject entry : list) {
                    DynamicObjectCollection toStrategies = entry.getDynamicObjectCollection("prostrategy");
                    if (toStrategies == null || toStrategies.size() == 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4fc3\u9500\u7ec4%S\u4e2d\u5b58\u5728\u4fc3\u9500\u7b56\u7565\u672a\u586b\uff0c\u8bf7\u586b\u5199\u3002", (String)"PromotePolicySaveValidator_51", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promotionNo));
                        return false;
                    }
                    Set<Long> toStrategiesId = toStrategies.stream().collect(Collectors.groupingBy(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject(1)))).keySet();
                    if (strategiesId.containsAll(toStrategiesId) && toStrategiesId.containsAll(strategiesId)) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4fc3\u9500\u7ec4%S\u4e2d\u7684\u4fc3\u9500\u7b56\u7565\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8c03\u6574\u3002", (String)"PromotePolicySaveValidator_52", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promotionNo));
                    return false;
                }
            }
        } else {
            Map<String, List<DynamicObject>> ladderGroup = ruleDetailList.stream().filter(a -> a.getString("rowtype").equalsIgnoreCase(MAIN_ROW)).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(a -> a.getDynamicObject("promotiongroupno").getString("number") + "," + a.getDynamicObject("ladderno").getString("number")));
            for (Map.Entry<String, List<DynamicObject>> ladder : ladderGroup.entrySet()) {
                String noAndLadder = ladder.getKey();
                String[] str = noAndLadder.split(",");
                List<DynamicObject> list = ladder.getValue();
                if (list.size() == 1) continue;
                DynamicObjectCollection strategies = list.get(0).getDynamicObjectCollection("prostrategy");
                Set<Long> strategiesId = strategies.stream().collect(Collectors.groupingBy(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject(1)))).keySet();
                for (DynamicObject entry : list) {
                    DynamicObjectCollection toStrategies = entry.getDynamicObjectCollection("prostrategy");
                    if (toStrategies == null) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4fc3\u9500\u7ec4%1$s\u4e2d\u9636\u68af\u7ec4%2$s\u5b58\u5728\u4fc3\u9500\u7b56\u7565\u672a\u586b\uff0c\u8bf7\u586b\u5199\u3002", (String)"PromotePolicySaveValidator_89", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), str[0], str[1]));
                        return false;
                    }
                    Set<Long> toStrategiesId = toStrategies.stream().collect(Collectors.groupingBy(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject(1)))).keySet();
                    if (strategiesId.containsAll(toStrategiesId) && toStrategiesId.containsAll(strategiesId)) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4fc3\u9500\u7ec4%1$s\u4e2d\u9636\u68af\u7ec4%2$s\u7684\u4fc3\u9500\u7b56\u7565\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8c03\u6574\u3002", (String)"PromotePolicySaveValidator_90", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), str[0], str[1]));
                    return false;
                }
            }
        }
        return true;
    }

    private void checkNoLadderCycle(ExtendedDataEntity dataEntity, DynamicObjectCollection ruleDetailList) {
        if (ruleDetailList.size() == 1) {
            return;
        }
        Map<Long, List<DynamicObject>> promoteGroups = ruleDetailList.stream().collect(Collectors.groupingBy(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("promotiongroupno"))));
        for (Map.Entry<Long, List<DynamicObject>> entry : promoteGroups.entrySet()) {
            List<DynamicObject> list = entry.getValue();
            List mainList = list.stream().filter(a -> !a.getString("rowtype").isEmpty() && a.getString("rowtype").equalsIgnoreCase(MAIN_ROW)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(mainList)) {
                return;
            }
            int seq = ((DynamicObject)mainList.get(0)).getInt("seq");
            String promoteNumber = ((DynamicObject)mainList.get(0)).getDynamicObject("promotiongroupno").getString("number");
            BigDecimal minbuypiece = ((DynamicObject)mainList.get(0)).getBigDecimal("minbuypiece");
            BigDecimal minlimitamount = ((DynamicObject)mainList.get(0)).getBigDecimal("minlimitamount");
            BigDecimal minlimitqty = ((DynamicObject)mainList.get(0)).getBigDecimal("minlimitqty");
            boolean iscycleaccount = ((DynamicObject)mainList.get(0)).getBoolean("iscycleaccount");
            boolean isthatcycleaccount = ((DynamicObject)mainList.get(0)).getBoolean("isthatcycleaccount");
            boolean isfixeddisctcycle = ((DynamicObject)mainList.get(0)).getBoolean("isfixeddisctcycle");
            boolean isperpricecycle = ((DynamicObject)mainList.get(0)).getBoolean("isperpricecycle");
            boolean ispropricecycle = ((DynamicObject)mainList.get(0)).getBoolean("ispropricecycle");
            for (DynamicObject obj : mainList) {
                int toseq = obj.getInt("seq");
                if (obj.getBigDecimal("minbuypiece").compareTo(minbuypiece) != 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4fc3\u9500\u7ec4%1$s\u7b2c%2$s\u884c\u548c\u7b2c%3$s\u884c\u7684\u6700\u5c0f\u8d77\u4e70\u4efd\u6570\u4e0d\u4e00\u81f4\u3002", (String)"PromotePolicySaveValidator_91", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promoteNumber, seq, toseq));
                }
                if (obj.getBigDecimal("minlimitamount").compareTo(minlimitamount) != 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4fc3\u9500\u7ec4%1$s\u7b2c%2$s\u884c\u548c\u7b2c%3$s\u884c\u7684\u6700\u5c0f\u8d77\u4e70\u91d1\u989d\u4e0d\u4e00\u81f4\u3002", (String)"PromotePolicySaveValidator_92", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promoteNumber, seq, toseq));
                }
                if (obj.getBigDecimal("minlimitqty").compareTo(minlimitqty) != 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4fc3\u9500\u7ec4%1$s\u7b2c%2$s\u884c\u548c\u7b2c%3$s\u884c\u7684\u6700\u5c0f\u8d77\u4e70\u6570\u91cf\u4e0d\u4e00\u81f4\u3002", (String)"PromotePolicySaveValidator_93", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promoteNumber, seq, toseq));
                }
                if (obj.getBoolean("iscycleaccount") != iscycleaccount) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4fc3\u9500\u7ec4%1$s\u7b2c%2$s\u884c\u548c\u7b2c%3$s\u884c\u7684\u672c\u54c1\u8d60\u9001\u662f\u5426\u5faa\u73af\u4e0d\u4e00\u81f4\u3002", (String)"PromotePolicySaveValidator_94", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promoteNumber, seq, toseq));
                }
                if (obj.getBoolean("isthatcycleaccount") != isthatcycleaccount) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4fc3\u9500\u7ec4%1$s\u7b2c%2$s\u884c\u548c\u7b2c%3$s\u884c\u7684\u6307\u5b9a\u54c1\u8d60\u9001-\u662f\u5426\u5faa\u73af\u8ba1\u7b97\u4e0d\u4e00\u81f4\u3002", (String)"PromotePolicySaveValidator_95", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promoteNumber, seq, toseq));
                }
                if (obj.getBoolean("isfixeddisctcycle") != isfixeddisctcycle) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4fc3\u9500\u7ec4%1$s\u7b2c%2$s\u884c\u548c\u7b2c%3$s\u884c\u7684\u6574\u5355\u6298\u6263\u989d-\u662f\u5426\u5faa\u73af\u8ba1\u7b97\u4e0d\u4e00\u81f4\u3002", (String)"PromotePolicySaveValidator_96", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promoteNumber, seq, toseq));
                }
                if (obj.getBoolean("isperpricecycle") != isperpricecycle) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4fc3\u9500\u7ec4%1$s\u7b2c%2$s\u884c\u548c\u7b2c%3$s\u884c\u7684\u5355\u4ef7\u6298\u6263\u989d-\u662f\u5426\u5faa\u73af\u8ba1\u7b97\u4e0d\u4e00\u81f4\u3002", (String)"PromotePolicySaveValidator_97", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promoteNumber, seq, toseq));
                }
                if (obj.getBoolean("ispropricecycle") == ispropricecycle) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4fc3\u9500\u7ec4%1$s\u7b2c%2$s\u884c\u548c\u7b2c%3$s\u884c\u7684\u4fc3\u9500\u5355\u4ef7-\u662f\u5426\u5faa\u73af\u8ba1\u7b97\u4e0d\u4e00\u81f4\u3002", (String)"PromotePolicySaveValidator_98", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promoteNumber, seq, toseq));
            }
        }
    }

    private boolean checkLadderNoConsistentInGroup(ExtendedDataEntity dataEntity, DynamicObjectCollection ruleDetailList) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (DynamicObject obj : ruleDetailList) {
            list.add(obj);
        }
        Map<String, List<DynamicObject>> ladderMap = list.stream().collect(Collectors.groupingBy(a -> a.getDynamicObject("promotiongroupno").getString("number")));
        boolean checkResult = true;
        for (Map.Entry<String, List<DynamicObject>> promoteGroup : ladderMap.entrySet()) {
            List<DynamicObject> ladderGroup = promoteGroup.getValue();
            Map<String, List<DynamicObject>> ladderNoMap = ladderGroup.stream().collect(Collectors.groupingBy(a -> a.getDynamicObject("ladderno").getString("number")));
            Set<String> ladderNumberSet = ladderNoMap.keySet();
            if (!ladderNumberSet.contains("S1")) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4fc3\u9500\u7ec4%S\u4e2d\u9636\u68af\u5fc5\u987b\u4ece\u6700\u4f4e\u9636\u68af(S1)\u5f00\u59cb\u3002", (String)"PromotePolicySaveValidator_63", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promoteGroup.getKey()));
                return false;
            }
            Set<Integer> ladderNoDigitals = this.translateNumberToDigtal(ladderNumberSet);
            for (int a2 : ladderNoDigitals) {
                if (a2 == 1 || ladderNoDigitals.contains(a2 - 1)) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u4fc3\u9500\u7ec4%S\u4e2d\u9636\u68af\u53f7\u4e0d\u8fde\u7eed\u3002", (String)"PromotePolicySaveValidator_64", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promoteGroup.getKey()));
                checkResult = false;
            }
        }
        return checkResult;
    }

    private Set<Integer> translateNumberToDigtal(Set<String> ladderNumberSet) {
        HashSet<Integer> re = new HashSet<Integer>(ladderNumberSet.size());
        for (String s : ladderNumberSet) {
            if (s.equalsIgnoreCase("S1")) continue;
            re.add(Integer.parseInt(s.substring(1)));
        }
        re.add(1);
        return re;
    }

    private void checkNoApointAndGift(DynamicObject ruleDetail, DynamicObjectCollection ruleDetailList, ExtendedDataEntity dataEntity, String ladderType) {
        DynamicObject promotionno = ruleDetail.getDynamicObject("promotiongroupno");
        if (promotionno == null || ladderType.isEmpty()) {
            return;
        }
        long promoteid = DynamicObjectUtils.getPkValue((DynamicObject)promotionno);
        String ladderStr = null;
        boolean isExist = false;
        if (ladderType.equalsIgnoreCase(NOLADDER)) {
            Map<Long, List<DynamicObject>> maps = ruleDetailList.stream().collect(Collectors.groupingBy(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("promotiongroupno"))));
            List<DynamicObject> list = maps.get(promoteid);
            for (DynamicObject obj : list) {
                if (obj.getString("rowtype") == null || !obj.getString("rowtype").equalsIgnoreCase(GIFT_ROW)) continue;
                isExist = true;
            }
        } else {
            Map<Long, List<DynamicObject>> maps = ruleDetailList.stream().collect(Collectors.groupingBy(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("promotiongroupno"))));
            List<DynamicObject> list = maps.get(promoteid);
            DynamicObject ladderNo = ruleDetail.getDynamicObject("ladderno");
            long ladderId = DynamicObjectUtils.getPkValue((DynamicObject)ladderNo);
            ladderStr = ladderNo.getString("number");
            Map<Long, List<DynamicObject>> ladderMap = list.stream().collect(Collectors.groupingBy(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("ladderno"))));
            for (DynamicObject obj : ladderMap.get(ladderId)) {
                if (obj.getString("rowtype") == null || !obj.getString("rowtype").equalsIgnoreCase(GIFT_ROW)) continue;
                isExist = true;
            }
        }
        if (ladderType.equalsIgnoreCase(NOLADDER) && isExist) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u4fc3\u9500\u7ec4%S\u4e0b\u4fc3\u9500\u7b56\u7565\u6ca1\u6709\u6307\u5b9a\u54c1\u8d60\u9001\uff0c\u4f46\u6709\u591a\u4f59\u7684\u8d60\u54c1\u884c\uff0c\u8bf7\u68c0\u67e5\u5e76\u8c03\u6574\u6570\u636e\u3002", (String)"PromotePolicySaveValidator_65", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promotionno.getString("number")));
        } else if (isExist) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u4fc3\u9500\u7ec4%1$s\u4e0b\u7684\u9636\u68af\u7ec4%2$s\u7684\u4fc3\u9500\u7b56\u7565\u6ca1\u6709\u6307\u5b9a\u54c1\u8d60\u9001\uff0c\u4f46\u6709\u591a\u4f59\u7684\u8d60\u54c1\u884c\uff0c\u8bf7\u68c0\u67e5\u5e76\u8c03\u6574\u6570\u636e\u3002", (String)"PromotePolicySaveValidator_99", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promotionno.getString("number"), ladderStr));
        }
    }

    private boolean checkSameLadderFields(DynamicObjectCollection ruleDetailList, ExtendedDataEntity dataEntity) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(ruleDetailList.size());
        for (DynamicObject obj : ruleDetailList) {
            if (GIFT_ROW.equalsIgnoreCase(obj.getString("rowtype"))) continue;
            list.add(obj);
        }
        Map<Long, List<DynamicObject>> GroupMap = list.stream().collect(Collectors.groupingBy(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("promotiongroupno"))));
        for (Map.Entry<Long, List<DynamicObject>> group : GroupMap.entrySet()) {
            List<DynamicObject> groupList = group.getValue();
            Map<Long, List<DynamicObject>> ladderGroup = groupList.stream().collect(Collectors.groupingBy(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("ladderno"))));
            ArrayList<Long> keys = new ArrayList<Long>(ladderGroup.keySet());
            int size = keys.size();
            if (size == 1) continue;
            List<DynamicObject> firstLadder = ladderGroup.get(keys.get(0));
            String promotionNo = firstLadder.get(0).getDynamicObject("promotiongroupno").getString("number");
            if (firstLadder.get(0).getDynamicObject("ladderno") == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u7b2c%d\u884c\u9636\u68af\u53f7\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_40", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), firstLadder.get(0).getInt("seq")));
            }
            String ladderNo = firstLadder.get(0).getDynamicObject("ladderno").getString("number");
            int ladderLength = firstLadder.size();
            HashSet<String> entryString = new HashSet<String>(8);
            Hashtable<String, Integer> entryCountSet = new Hashtable<String, Integer>();
            for (DynamicObject obj : firstLadder) {
                String str = this.structureCompareStr(obj);
                if (entryString.contains(str)) {
                    entryCountSet.put(str, (Integer)entryCountSet.get(str) + 1);
                    continue;
                }
                entryString.add(str);
                entryCountSet.put(str, 1);
            }
            for (int i = 1; i < size; ++i) {
                List<DynamicObject> toList = ladderGroup.get(keys.get(i));
                String toLadderNo = toList.get(0).getDynamicObject("ladderno").getString("number");
                if (toList.size() != ladderLength) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u7ec4\u53f7%1$s\u7684\u9636\u68af\u7ec4\u53f7%2$s\u3001\u9636\u68af\u7ec4\u53f7%3$s\u7684\u4fc3\u9500\u4e3b\u5546\u54c1\u4fe1\u606f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"PromotePolicySaveValidator_100", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promotionNo, ladderNo, toLadderNo));
                    return false;
                }
                HashMap<String, Integer> toentryCountSet = new HashMap<String, Integer>(entryCountSet);
                for (DynamicObject obj : toList) {
                    String str = this.structureCompareStr(obj);
                    if (!entryString.contains(str)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u7ec4\u53f7%1$s\u7684\u9636\u68af\u7ec4\u53f7%2$s\u3001\u9636\u68af\u7ec4\u53f7%3$s\u7684\u4fc3\u9500\u4e3b\u5546\u54c1\u4fe1\u606f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"PromotePolicySaveValidator_100", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promotionNo, ladderNo, toLadderNo));
                        return false;
                    }
                    toentryCountSet.put(str, (Integer)toentryCountSet.get(str) - 1);
                }
                Map<Integer, List<Integer>> result = toentryCountSet.values().stream().collect(Collectors.groupingBy(a -> a));
                if (result.size() == 1) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u7ec4\u53f7%1$s\u7684\u9636\u68af\u7ec4\u53f7%2$s\u3001\u9636\u68af\u7ec4\u53f7%$s\u7684\u4fc3\u9500\u4e3b\u5546\u54c1\u4fe1\u606f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"PromotePolicySaveValidator_101", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), promotionNo, ladderNo, toLadderNo));
                return false;
            }
        }
        return true;
    }

    private String structureCompareStr(DynamicObject obj) {
        if (obj == null) {
            return "";
        }
        StringBuilder re = new StringBuilder();
        for (String field : structureCompareFields) {
            if (obj.get(field) != null) {
                re.append(DynamicObjectUtils.getPkValue((DynamicObject)obj.getDynamicObject(field)));
            } else {
                re.append('0');
            }
            re.append('+');
        }
        re.append(obj.getBigDecimal("buyqty").intValue());
        re.append('+');
        re.append(obj.getBigDecimal("buyamount").intValue());
        return re.toString();
    }

    private void checkApointAndGift(DynamicObject ruleDetail, DynamicObjectCollection ruleDetailList, ExtendedDataEntity dataEntity, String ladderType) {
        DynamicObject promotionno = ruleDetail.getDynamicObject("promotiongroupno");
        if (promotionno == null || ladderType.isEmpty()) {
            return;
        }
        long promoteid = DynamicObjectUtils.getPkValue((DynamicObject)promotionno);
        boolean isExist = false;
        if (ladderType.equalsIgnoreCase(NOLADDER)) {
            Map<Long, List<DynamicObject>> maps = ruleDetailList.stream().collect(Collectors.groupingBy(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("promotiongroupno"))));
            List<DynamicObject> list = maps.get(promoteid);
            for (DynamicObject obj : list) {
                if (obj.getString("rowtype") == null || !obj.getString("rowtype").equalsIgnoreCase(GIFT_ROW)) continue;
                isExist = true;
            }
        } else {
            Map<Long, List<DynamicObject>> maps = ruleDetailList.stream().collect(Collectors.groupingBy(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("promotiongroupno"))));
            List<DynamicObject> list = maps.get(promoteid);
            DynamicObject ladderNo = ruleDetail.getDynamicObject("ladderno");
            long ladderId = DynamicObjectUtils.getPkValue((DynamicObject)ladderNo);
            Map<Long, List<DynamicObject>> ladderMap = list.stream().collect(Collectors.groupingBy(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("ladderno"))));
            for (DynamicObject obj : ladderMap.get(ladderId)) {
                if (obj.getString("rowtype") == null || !obj.getString("rowtype").equalsIgnoreCase(GIFT_ROW)) continue;
                isExist = true;
            }
        }
        if (!isExist) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u89c4\u5219\u7b2c%d\u884c\uff1a\u540c\u4fc3\u9500\u7ec4/\u540c\u4fc3\u9500\u7ec4\u540c\u9636\u68af\u7ec4\u4e0b\uff0c\u4fc3\u9500\u7b56\u7565\u5305\u542b\u201c\u6307\u5b9a\u54c1\u8d60\u9001/\u6362\u8d60\u201d  \u65f6\uff0c\u5e94\u5b58\u5728\u8d60\u54c1\u884c\u3002", (String)"PromotePolicySaveValidator_68", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), ruleDetail.getInt("seq")));
        }
    }

    private void checkLadderConsistent(DynamicObject ruleDetail, DynamicObjectCollection ruleDetailList, ExtendedDataEntity dataEntity) {
        DynamicObject promotionno = ruleDetail.getDynamicObject("promotiongroupno");
        DynamicObject ladderno = ruleDetail.getDynamicObject("ladderno");
        int seq1 = ruleDetail.getInt("seq");
        if (promotionno == null || ladderno == null) {
            return;
        }
        long promtionNoId = DynamicObjectUtils.getPkValue((DynamicObject)promotionno);
        for (DynamicObject obj : ruleDetailList) {
            DynamicObject topromotionno = obj.getDynamicObject("promotiongroupno");
            DynamicObject toladderno = obj.getDynamicObject("ladderno");
            int seq2 = obj.getInt("seq");
            String toRowtype = obj.getString("rowtype");
            if (topromotionno == null || toladderno == null || seq1 == seq2 || GIFT_ROW.equalsIgnoreCase(toRowtype)) continue;
            long topromtionNoId = DynamicObjectUtils.getPkValue((DynamicObject)topromotionno);
            int max = this.getLadderNumber(toladderno.getString("number"));
            int min = this.getLadderNumber(ladderno.getString("number")) + 1;
            if (promtionNoId != topromtionNoId || min != max || ruleDetail.getBigDecimal("laddermaxamount").compareTo(obj.getBigDecimal("ladderminamount")) <= 0 && ruleDetail.getBigDecimal("laddermaxbase").compareTo(obj.getBigDecimal("ladderminbase")) <= 0 && ruleDetail.getBigDecimal("laddermaxqty").compareTo(obj.getBigDecimal("ladderminqty")) <= 0) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u7ec4\u53f7%1$s\u7684\u9636\u68af\u7ec4\u53f7%2$s\u3001\u9636\u68af\u7ec4\u53f7%3$s\u7684\u9636\u68af\u533a\u95f4\u6709\u91cd\u53e0\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"PromotePolicySaveValidator_102", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), topromotionno.getString("number"), ladderno.getString("number"), toladderno.getString("number")));
        }
    }

    private int getLadderNumber(String s) {
        if (s == null || s.isEmpty() || s.length() <= 1) {
            return 0;
        }
        return Integer.parseInt(s.substring(1));
    }

    private boolean isTopLadder(DynamicObject ruleDetail, DynamicObjectCollection ruleDetailList) {
        if (ruleDetail == null || ruleDetailList == null || ruleDetailList.size() == 0) {
            return false;
        }
        DynamicObject pgno = ruleDetail.getDynamicObject("promotiongroupno");
        DynamicObject ladderno = ruleDetail.getDynamicObject("ladderno");
        if (pgno == null || ladderno == null) {
            return false;
        }
        String pgnoNum = pgno.getString("number");
        String ladderNum = ladderno.getString("number");
        for (DynamicObject obj : ruleDetailList) {
            String toPgnonum = obj.getDynamicObject("promotiongroupno").getString("number");
            String toLadderNum = obj.getDynamicObject("ladderno").getString("number");
            if (!pgnoNum.equals(toPgnonum) || toLadderNum.length() <= ladderNum.length() && (toLadderNum.length() != ladderNum.length() || toLadderNum.compareTo(ladderNum) <= 0)) continue;
            return false;
        }
        return true;
    }

    private void checkPromotePolicyOrderEntity(ExtendedDataEntity dataEntity, DynamicObject promotePolicy) {
        String promoteLink = promotePolicy.getString("promotetype.promlink");
        DynamicObjectCollection orderScopeList = promotePolicy.getDynamicObjectCollection("orderscopeentry");
        if (CollectionUtils.isEmpty((Collection)orderScopeList)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u586b\u5199\u4e00\u884c\u8ba2\u8d27\u5bf9\u8c61\u8303\u56f4\u3002", (String)"PromotePolicySaveValidator_70", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> orders = new HashSet<Long>();
        for (DynamicObject orderScope : orderScopeList) {
            int seq = orderScope.getInt("seq");
            if (PromoteLinkEnum.SCM.getValue().equalsIgnoreCase(promoteLink) && orderScope.getDynamicObject("customer") == null && orderScope.getDynamicObject("customerclass") == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u3010\u8ba2\u8d27\u5bf9\u8c61\u8303\u56f4\u3011\u7b2c%d\u884c\u5ba2\u6237/\u5ba2\u6237\u5206\u7c7b\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_71", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq));
            } else if (PromoteLinkEnum.CHANNELTOCHANNEL.getValue().equalsIgnoreCase(promoteLink) && orderScope.getDynamicObject("orderchannel") == null && orderScope.getDynamicObject("channelclass") == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u3010\u8ba2\u8d27\u5bf9\u8c61\u8303\u56f4\u3011\u7b2c%d\u884c\u8ba2\u8d27\u6e20\u9053/\u6e20\u9053\u5206\u7c7b\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_72", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq));
            }
            long id = 0L;
            if (orderScope.getDynamicObject("customer") != null) {
                id = DynamicObjectUtils.getPkValue((DynamicObject)orderScope.getDynamicObject("customer"));
            } else if (orderScope.getDynamicObject("customerclass") != null) {
                id = DynamicObjectUtils.getPkValue((DynamicObject)orderScope.getDynamicObject("customerclass"));
            } else if (orderScope.getDynamicObject("orderchannel") != null) {
                id = DynamicObjectUtils.getPkValue((DynamicObject)orderScope.getDynamicObject("orderchannel"));
            } else if (orderScope.getDynamicObject("channelclass") != null) {
                id = DynamicObjectUtils.getPkValue((DynamicObject)orderScope.getDynamicObject("channelclass"));
            }
            if (id == 0L) continue;
            if (orders.contains(id)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8ba2\u8d27\u5bf9\u8c61\u8303\u56f4\u4e2d\u7b2c%d\u884c\u4e0e\u4e0a\u9762\u5206\u5f55\u884c\u5ba2\u6237/\u5ba2\u6237\u5206\u7c7b/\u6e20\u9053/\u6e20\u9053\u5206\u7c7b\u91cd\u590d\u3002", (String)"PromotePolicySaveValidator_73", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq));
                return;
            }
            orders.add(id);
        }
    }

    private void checkPromotePolicySaleEntity(ExtendedDataEntity dataEntity, DynamicObject promotePolicy) {
        Map<Long, List<DynamicObject>> sales;
        String promoteLink = promotePolicy.getString("promotetype.promlink");
        DynamicObjectCollection saleScopeList = promotePolicy.getDynamicObjectCollection("salescopeentry");
        if (CollectionUtils.isEmpty((Collection)saleScopeList)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u586b\u5199\u4e00\u884c\u9500\u552e\u4e3b\u4f53\u8303\u56f4\u3002", (String)"PromotePolicySaveValidator_74", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]));
            return;
        }
        int size = saleScopeList.size();
        if (!promoteLink.isEmpty() && promoteLink.equalsIgnoreCase(CHANNELTOCHANNEL)) {
            sales = saleScopeList.parallelStream().collect(Collectors.groupingBy(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("salechannel"))));
            if (sales.size() != size) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9500\u552e\u4e3b\u4f53\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u9500\u552e\u6e20\u9053\u3002", (String)"PromotePolicySaveValidator_75", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]));
            }
        } else if (!promoteLink.isEmpty() && (sales = saleScopeList.parallelStream().collect(Collectors.groupingBy(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("saleorg"))))).size() != size) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9500\u552e\u4e3b\u4f53\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u9500\u552e\u7ec4\u7ec7\u3002", (String)"PromotePolicySaveValidator_76", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]));
        }
        for (DynamicObject saleScope : saleScopeList) {
            int seq = saleScope.getInt("seq");
            if (SCM.equalsIgnoreCase(promoteLink) || CHANNELTOSCM.equalsIgnoreCase(promoteLink)) {
                if (saleScope.getDynamicObject("saleorg") == null) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9500\u552e\u4e3b\u4f53\u7b2c%d\u884c\u9500\u552e\u7ec4\u7ec7\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_77", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq));
                    return;
                }
            } else if (PromoteLinkEnum.CHANNELTOCHANNEL.getValue().equalsIgnoreCase(promoteLink) && saleScope.getDynamicObject("salechannel") == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9500\u552e\u4e3b\u4f53\u7b2c%d\u884c\u9500\u552e\u6e20\u9053\u5fc5\u586b\u3002", (String)"PromotePolicySaveValidator_78", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq));
                return;
            }
            Date effectDate = promotePolicy.getDate("effectivedate");
            Date invalidDate = promotePolicy.getDate("expirationdate");
            Date startDate = saleScope.getDate("starttime");
            Date endDate = saleScope.getDate("endtime");
            if (null != startDate && null == endDate || null == startDate && null != endDate) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9500\u552e\u4e3b\u4f53\u7b2c%d\u884c\u7684\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u540c\u65f6\u6709\u503c\u6216\u8005\u65e0\u503c\u3002", (String)"PromotePolicySaveValidator_79", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq));
                return;
            }
            if (startDate == null || endDate == null || effectDate == null || invalidDate == null) continue;
            if (startDate.compareTo(effectDate) < 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9500\u552e\u4e3b\u4f53\u7b2c%d\u884c\u5f00\u59cb\u65f6\u95f4\u5e94\u665a\u4e8e\u751f\u6548\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"PromotePolicySaveValidator_80", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq));
                return;
            }
            if (endDate.compareTo(invalidDate) > 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9500\u552e\u4e3b\u4f53\u7b2c%d\u884c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u5931\u6548\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"PromotePolicySaveValidator_81", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq));
                return;
            }
            if (endDate.compareTo(startDate) > 0) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9500\u552e\u4e3b\u4f53\u7b2c%d\u884c\u7ed3\u675f\u65f6\u95f4\u5e94\u665a\u4e8e\u5f00\u59cb\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"PromotePolicySaveValidator_82", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), seq));
            return;
        }
    }

    private void checkPromotePolicyHeadInfo(ExtendedDataEntity dataEntity, DynamicObject promotePolicy) {
        Date effectDate = promotePolicy.getDate("effectivedate");
        Date invalidDate = promotePolicy.getDate("expirationdate");
        if (effectDate != null && invalidDate != null && invalidDate.compareTo(effectDate) <= 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u751f\u6548\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"PromotePolicySaveValidator_83", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]));
            return;
        }
        Date now = new Date(System.currentTimeMillis());
        if (invalidDate != null && now.compareTo(invalidDate) > 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u65f6\u95f4\u5df2\u8fc7\u4fc3\u9500\u653f\u7b56\u7684\u5931\u6548\u65f6\u95f4\uff0c\u64cd\u4f5c\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"PromotePolicySaveValidator_84", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]));
            return;
        }
    }
}

