/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.opplugin.retailprice.operation;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocdpm.common.util.CommonUtil;
import kd.occ.ocdpm.common.util.PriceTypeUtil;
import kd.occ.ocdpm.opplugin.retailprice.validator.RetailPriceSaveValidator;

public class CommonRetailItemPriceOp
extends AbstractOperationServicePlugIn {
    private static final String[] PRICE_TYPE_CHECKS = new String[]{"rpcheckbox", "fpcheckbox", "upcheckbox", "mpcheckbox", "spcheckbox", "p1checkbox", "p2checkbox", "p3checkbox", "p4checkbox", "p5checkbox"};
    private static final String SELECTED_ROW = "id, pricedetailentity.id, pricedetailentity.retailprice, pricedetailentity.rpadjustnum, pricedetailentity.uniqueprice, pricedetailentity.upadjustnum, pricedetailentity.factoryprice, pricedetailentity.fpadjustnum, pricedetailentity.memberprice, pricedetailentity.mpadjustnum, pricedetailentity.specialprice, pricedetailentity.spadjustnum, pricedetailentity.price1, pricedetailentity.price2, pricedetailentity.price3, pricedetailentity.price4, pricedetailentity.price5, pricedetailentity.p1adjustnum, pricedetailentity.p2adjustnum, pricedetailentity.p3adjustnum, pricedetailentity.p4adjustnum, pricedetailentity.p5adjustnum";
    private static final String OP_SAVE = "save";
    private static final String OP_SUBMIT = "submit";
    private static final String OP_AUDIT = "audit";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        this.addPrepareField(e);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new RetailPriceSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject dataEntity = e.getDataEntities()[0];
        String operationKey = e.getOperationKey();
        boolean isBranch = "1041388752234404864".equals(dataEntity.getDynamicObject("billtype").getPkValue().toString());
        switch (operationKey) {
            case "save": 
            case "submit": {
                if (dataEntity.getDynamicObjectCollection("pricedetailentity").size() == 0) {
                    dataEntity.set("firstauditdate", null);
                } else if (isBranch) {
                    this.checkPriceChangedCounts(dataEntity);
                }
                dataEntity.set("isunaudit", (Object)Boolean.FALSE);
                break;
            }
            case "audit": {
                if (!isBranch) break;
                this.setPriceTypeAdjustedNum(dataEntity);
                SaveServiceHelper.update((DynamicObject)dataEntity);
                break;
            }
        }
    }

    private void setPriceTypeAdjustedNum(DynamicObject dataEntity) {
        List priceTypeRecord = null;
        DynamicObjectCollection detailEntry = null;
        DynamicObjectCollection recordEntry = null;
        List currentPriceTypes = null;
        if (dataEntity.getDynamicObjectCollection("pricedetailentity").size() != 0 && dataEntity.getDate("firstauditdate") == null) {
            dataEntity.set("firstauditdate", (Object)new Date());
        }
        detailEntry = dataEntity.getDynamicObjectCollection("pricedetailentity");
        currentPriceTypes = PriceTypeUtil.getCurrentPriceType((DynamicObject)dataEntity);
        for (String priceType : currentPriceTypes) {
            for (DynamicObject detail : detailEntry) {
                recordEntry = detail.getDynamicObjectCollection("pricerecord");
                if (recordEntry.size() <= 0) continue;
                priceTypeRecord = recordEntry.stream().filter(e -> e.get("adjustpricetype") != null && e.get("adjustpricetype").equals(PriceTypeUtil.getEnumByPriceType((String)priceType))).collect(Collectors.toList());
                detail.set(PriceTypeUtil.getAdjustNumByPriceType((String)priceType), (Object)priceTypeRecord.size());
            }
        }
    }

    private void checkPriceChangedCounts(DynamicObject dataEntity) {
        List baseDatas = null;
        DynamicObjectCollection col = dataEntity.getDynamicObjectCollection("pricedetailentity");
        QFilter filter = new QFilter("id", "=", dataEntity.getPkValue());
        DynamicObjectCollection priceDetails = this.queryPriceDetails(filter);
        boolean isdistributed = dataEntity.getBoolean("isdistributed");
        Map priceMap = PriceTypeUtil.getPriceMap();
        if (isdistributed) {
            if (col.size() == 0) {
                return;
            }
            for (int i = 0; i < col.size(); ++i) {
                DynamicObject tempDetail = (DynamicObject)col.get(i);
                baseDatas = priceDetails.stream().filter(e -> e.get("pricedetailentity.id").equals(tempDetail.getPkValue())).collect(Collectors.toList());
                if (baseDatas.size() == 0) {
                    int index = CommonUtil.isInPriceDetailList((DynamicObject)((DynamicObject)col.get(i)), (DynamicObjectCollection)dataEntity.getDynamicObjectCollection("pricedetail"), (Boolean)Boolean.FALSE);
                    DynamicObject entry = (DynamicObject)dataEntity.getDynamicObjectCollection("pricedetail").get(index);
                    List list = CommonUtil.checkBox((DynamicObject)dataEntity, (String[])PRICE_TYPE_CHECKS);
                    for (String checkBox : list) {
                        String[] priceTypes = PriceTypeUtil.getPriceTypeByCheckBox((String)checkBox);
                        if (priceTypes == null || priceTypes.length == 0 || ((DynamicObject)col.get(i)).getBigDecimal(priceTypes[0]).compareTo(entry.getBigDecimal(priceTypes[2])) == 0) continue;
                        this.setPriceRecord(dataEntity, (DynamicObject)col.get(i), entry, priceTypes[0], priceTypes[2], Boolean.TRUE);
                    }
                    continue;
                }
                List list = CommonUtil.checkBox((DynamicObject)dataEntity, (String[])PRICE_TYPE_CHECKS);
                for (String checkBox : list) {
                    String[] priceTypes = PriceTypeUtil.getPriceTypeByCheckBox((String)checkBox);
                    if (priceTypes == null || priceTypes.length == 0) continue;
                    this.checkPriceChanged(priceTypes[0], (DynamicObject)priceMap.get(priceTypes[0]), (DynamicObject)col.get(i), (DynamicObject)baseDatas.get(0), dataEntity, Boolean.FALSE);
                }
            }
        } else {
            if (dataEntity.getDate("firstauditdate") == null) {
                return;
            }
            List currentPriceType = PriceTypeUtil.getCurrentPriceType((DynamicObject)dataEntity);
            for (int i = 0; i < col.size(); ++i) {
                DynamicObject tempDetail = (DynamicObject)col.get(i);
                baseDatas = priceDetails.stream().filter(e -> e.get("pricedetailentity.id").equals(tempDetail.getPkValue())).collect(Collectors.toList());
                if (baseDatas.size() <= 0) continue;
                for (String priceType : currentPriceType) {
                    this.checkPriceChanged(priceType, (DynamicObject)priceMap.get(priceType), (DynamicObject)col.get(i), (DynamicObject)baseDatas.get(0), dataEntity, Boolean.FALSE);
                }
            }
            dataEntity.set("isunaudit", (Object)Boolean.FALSE);
        }
    }

    private void checkPriceChanged(String priceType, DynamicObject priceTypeObj, DynamicObject viewData, DynamicObject databaseData, DynamicObject dataEntity, Boolean isInTable) {
        BigDecimal viewPrice = viewData.getBigDecimal(priceType);
        BigDecimal basedataPrice = databaseData.getBigDecimal("pricedetailentity." + priceType);
        int allowJustNum = 0;
        int adjustedNum = 0;
        if (viewPrice.compareTo(basedataPrice) == 0) {
            return;
        }
        if (priceTypeObj.getBoolean("isallowadjust")) {
            allowJustNum = priceTypeObj.getInt("allowadjustnum");
            adjustedNum = databaseData.getInt("pricedetailentity." + PriceTypeUtil.getAdjustNumByPriceType((String)priceType));
            if (adjustedNum < allowJustNum) {
                this.setPriceRecord(dataEntity, viewData, databaseData, priceType, null, isInTable);
            }
        }
    }

    private void setPriceRecord(DynamicObject data, DynamicObject viewData, DynamicObject databaseData, String priceType, String priceOldType, Boolean isInTable) {
        List collect;
        DynamicObjectCollection records = viewData.getDynamicObjectCollection("pricerecord");
        DynamicObject dynamicObject = null;
        dynamicObject = data.getBoolean("isunaudit") || !data.getBoolean("isunaudit") && records.isEmpty() ? this.setNewPriceAdjustRecord(viewData, databaseData, priceType, priceOldType, isInTable) : ((collect = records.stream().filter(e -> e.get("adjustpricetype").equals(PriceTypeUtil.getEnumByPriceType((String)priceType))).collect(Collectors.toList())).size() == 0 ? this.setNewPriceAdjustRecord(viewData, databaseData, priceType, priceOldType, isInTable) : (DynamicObject)collect.get(collect.size() - 1));
        dynamicObject.set("afterprice", (Object)viewData.getBigDecimal(priceType));
        dynamicObject.set("adjusttime", (Object)new Date());
        dynamicObject.set("moderatorid", (Object)CommonUtil.getLoginUser());
    }

    private DynamicObject setNewPriceAdjustRecord(DynamicObject viewData, DynamicObject databaseData, String priceType, String priceOldType, Boolean isInTable) {
        DynamicObject dynamicObject = viewData.getDynamicObjectCollection("pricerecord").addNew();
        String entryPrice = "pricedetailentity." + priceType;
        dynamicObject.set("itemid", (Object)viewData.getDynamicObject("item"));
        dynamicObject.set("barcodeid", (Object)viewData.getDynamicObject("barcode"));
        dynamicObject.set("priceunitid", (Object)viewData.getDynamicObject("priceunit"));
        dynamicObject.set("adjustpricetype", (Object)PriceTypeUtil.getEnumByPriceType((String)priceType));
        if (isInTable.booleanValue()) {
            dynamicObject.set("beforeprice", (Object)databaseData.getBigDecimal(priceOldType));
        } else {
            dynamicObject.set("beforeprice", (Object)databaseData.getBigDecimal(entryPrice));
        }
        return dynamicObject;
    }

    private DynamicObjectCollection queryPriceDetails(QFilter qFilter) {
        DynamicObjectCollection priceDetails = QueryServiceHelper.query((String)"ocdpm_retailpricelist", (String)SELECTED_ROW, (QFilter[])new QFilter[]{qFilter});
        return priceDetails;
    }

    private void addPrepareField(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("item");
        e.getFieldKeys().add("saleattr");
        e.getFieldKeys().add("priceunit");
        e.getFieldKeys().add("barcode");
        e.getFieldKeys().add("stocktype");
        e.getFieldKeys().add("isunaudit");
        e.getFieldKeys().add("firstauditdate");
        e.getFieldKeys().add("treeentryentity");
        e.getFieldKeys().add("isdistributed");
        e.getFieldKeys().add("firstauditdate");
        e.getFieldKeys().add("billtype");
        e.getFieldKeys().add("pricerecord");
        e.getFieldKeys().add("highprice");
        e.getFieldKeys().add("lowprice");
        e.getFieldKeys().add("priceeffectdate");
        e.getFieldKeys().add("priceinvaliddate");
        e.getFieldKeys().add("priceisinvalid");
        e.getFieldKeys().add("pricedetailentity.seq");
        e.getFieldKeys().add("enable");
        e.getFieldKeys().add("disabler");
        e.getFieldKeys().add("disabletime");
        e.getFieldKeys().add("isdistributed");
        e.getFieldKeys().add("rpadjustnum");
        e.getFieldKeys().add("upadjustnum");
        e.getFieldKeys().add("fpadjustnum");
        e.getFieldKeys().add("mpadjustnum");
        e.getFieldKeys().add("spadjustnum");
        e.getFieldKeys().add("hpadjustnum");
        e.getFieldKeys().add("hpadjustnum");
        e.getFieldKeys().add("lpadjustnum");
        e.getFieldKeys().add("p1adjustnum");
        e.getFieldKeys().add("p2adjustnum");
        e.getFieldKeys().add("p3adjustnum");
        e.getFieldKeys().add("p4adjustnum");
        e.getFieldKeys().add("p5adjustnum");
        e.getFieldKeys().add("price1");
        e.getFieldKeys().add("price2");
        e.getFieldKeys().add("price3");
        e.getFieldKeys().add("price4");
        e.getFieldKeys().add("price5");
        e.getFieldKeys().add("adjustpricetype");
        e.getFieldKeys().add("rpcheckbox");
        e.getFieldKeys().add("fpcheckbox");
        e.getFieldKeys().add("upcheckbox");
        e.getFieldKeys().add("mpcheckbox");
        e.getFieldKeys().add("spcheckbox");
        e.getFieldKeys().add("p1checkbox");
        e.getFieldKeys().add("p2checkbox");
        e.getFieldKeys().add("p3checkbox");
        e.getFieldKeys().add("p4checkbox");
        e.getFieldKeys().add("p5checkbox");
    }
}

