/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.opplugin.retailprice.operation;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocdpm.common.util.CommonUtil;
import kd.occ.ocdpm.opplugin.retailprice.validator.RetailPriceSaveValidator;

public class RetailPriceListOp
extends AbstractOperationServicePlugIn {
    private static final String OP_ENABLE = "enable";
    private static final String OP_DISABLE = "disable";
    private static final String OP_SAVE = "save";
    private static final String UNAUDIT = "bar_unaudit";

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] data = e.getDataEntities();
        switch (e.getOperationKey()) {
            case "enable": {
                this.setRetailPriceEnable(data, true);
                break;
            }
            case "disable": {
                this.setRetailPriceEnable(data, false);
                break;
            }
            case "bar_unaudit": {
                this.setIsUnAudit(data);
                break;
            }
        }
    }

    private void setIsUnAudit(DynamicObject[] data) {
        for (DynamicObject obj : data) {
            obj.set("isunaudit", (Object)Boolean.TRUE);
        }
    }

    private DynamicObject[] getUpdateRetailPriceList(DynamicObject[] data, boolean isEnable) {
        ArrayList<DynamicObject> enableList = new ArrayList<DynamicObject>(data.length);
        for (int i = 0; i < data.length; ++i) {
            DynamicObject retailPrice = data[i];
            if (retailPrice == null) continue;
            if ("A".equalsIgnoreCase(retailPrice.getString(OP_ENABLE)) && isEnable || "B".equalsIgnoreCase(retailPrice.getString(OP_ENABLE)) && !isEnable) {
                this.addErrorMsg(retailPrice, isEnable);
                continue;
            }
            enableList.add(retailPrice);
        }
        if (enableList.size() == data.length) {
            this.operationResult.setSuccess(true);
            this.operationResult.setShowMessage(true);
            this.operationResult.setMessage(isEnable ? ResManager.loadKDString((String)"\u751f\u6548\u6210\u529f\u3002", (String)"RetailPriceListOp_0", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5931\u6548\u6210\u529f\u3002", (String)"RetailPriceListOp_1", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]));
        }
        return enableList.toArray(new DynamicObject[enableList.size()]);
    }

    private void addErrorMsg(DynamicObject retailPrice, boolean isEnable) {
        OperateErrorInfo errorInfo = new OperateErrorInfo("RetailPriceListOp_001", ErrorLevel.Error, retailPrice.getPkValue());
        String billNo = retailPrice.getString("billno");
        if (isEnable) {
            errorInfo.setMessage(String.format(ResManager.loadKDString((String)"%s\uff1a\u53ea\u6709\u672a\u751f\u6548\u7684\u5355\u636e\u624d\u5141\u8bb8\u8bbe\u7f6e\u4e3a\u751f\u6548\u3002", (String)"RetailPriceListOp_2", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), billNo));
        } else {
            errorInfo.setMessage(String.format(ResManager.loadKDString((String)"%s\uff1a\u53ea\u6709\u751f\u6548\u7684\u5355\u636e\u624d\u5141\u8bb8\u8bbe\u7f6e\u4e3a\u672a\u751f\u6548\u3002", (String)"RetailPriceListOp_3", (String)"occ-ocdpm-opplugin", (Object[])new Object[0]), billNo));
        }
        this.operationResult.setSuccess(false);
        this.operationResult.addErrorInfo(errorInfo);
    }

    private void setRetailPriceEnable(DynamicObject[] retailPriceList, boolean isEnable) {
        if (retailPriceList == null || retailPriceList.length == 0) {
            return;
        }
        DynamicObject[] updateList = this.getUpdateRetailPriceList(retailPriceList, isEnable);
        if (updateList.length > 0) {
            ArrayList<Object> ids = new ArrayList<Object>(updateList.length);
            for (int i = 0; i < updateList.length; ++i) {
                ids.add(updateList[i].getPkValue());
                updateList[i].set(OP_ENABLE, (Object)(isEnable ? "A" : "B"));
                if (isEnable) {
                    updateList[i].set("disabler", (Object)0L);
                    updateList[i].set("disabletime", null);
                    continue;
                }
                updateList[i].set("disabler", (Object)CommonUtil.getLoginUser());
                updateList[i].set("disabletime", (Object)TimeServiceHelper.now());
            }
            this.operationResult.setSuccessPkIds(ids);
            SaveServiceHelper.update((DynamicObject[])updateList);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new RetailPriceSaveValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("saleattr");
        e.getFieldKeys().add("item");
        e.getFieldKeys().add("priceunit");
        e.getFieldKeys().add("barcode");
        e.getFieldKeys().add("stocktype");
        e.getFieldKeys().add("isunaudit");
        e.getFieldKeys().add("firstauditdate");
        e.getFieldKeys().add("treeentryentity");
        e.getFieldKeys().add("isdistributed");
        e.getFieldKeys().add("firstauditdate");
        e.getFieldKeys().add("billtype");
        e.getFieldKeys().add("pricerecord");
        e.getFieldKeys().add("highprice");
        e.getFieldKeys().add("lowprice");
        e.getFieldKeys().add("priceeffectdate");
        e.getFieldKeys().add("priceinvaliddate");
        e.getFieldKeys().add("priceisinvalid");
        e.getFieldKeys().add("pricedetailentity.seq");
        e.getFieldKeys().add(OP_ENABLE);
        e.getFieldKeys().add("disabler");
        e.getFieldKeys().add("disabletime");
        e.getFieldKeys().add("isdistributed");
        e.getFieldKeys().add("rpadjustnum");
        e.getFieldKeys().add("upadjustnum");
        e.getFieldKeys().add("fpadjustnum");
        e.getFieldKeys().add("mpadjustnum");
        e.getFieldKeys().add("spadjustnum");
        e.getFieldKeys().add("hpadjustnum");
        e.getFieldKeys().add("hpadjustnum");
        e.getFieldKeys().add("lpadjustnum");
        e.getFieldKeys().add("p1adjustnum");
        e.getFieldKeys().add("p2adjustnum");
        e.getFieldKeys().add("p3adjustnum");
        e.getFieldKeys().add("p4adjustnum");
        e.getFieldKeys().add("p5adjustnum");
        e.getFieldKeys().add("price1");
        e.getFieldKeys().add("price2");
        e.getFieldKeys().add("price3");
        e.getFieldKeys().add("price4");
        e.getFieldKeys().add("price5");
        e.getFieldKeys().add("adjustpricetype");
        e.getFieldKeys().add("rpcheckbox");
        e.getFieldKeys().add("fpcheckbox");
        e.getFieldKeys().add("upcheckbox");
        e.getFieldKeys().add("mpcheckbox");
        e.getFieldKeys().add("spcheckbox");
        e.getFieldKeys().add("p1checkbox");
        e.getFieldKeys().add("p2checkbox");
        e.getFieldKeys().add("p3checkbox");
        e.getFieldKeys().add("p4checkbox");
        e.getFieldKeys().add("p5checkbox");
    }
}

