/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.mservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.config.client.util.StringUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocdpm.common.model.result.ResultMessage;
import kd.occ.ocdpm.mservice.api.OpenPromotionService;
import org.apache.commons.collections.CollectionUtils;

public class OpenPromotionServiceImpl
implements OpenPromotionService {
    private Log logger = LogFactory.getLog(OpenPromotionServiceImpl.class);
    private static final Long prodeployid = 1173168193141958656L;

    public JSONObject queryOpenPromotion(List<Long> orgidList) {
        this.logger.info("\u9500\u552e\u7ec4\u7ec7\u662f\u5426\u5f00\u542f\u4fc3\u9500\u67e5\u8be2\u5165\u53c2:" + orgidList);
        ResultMessage result = new ResultMessage();
        try {
            this.checkServiceParam((ResultMessage<Object>)result, orgidList);
            if (StringUtils.isNotEmpty((String)result.getMessage())) {
                return (JSONObject)JSON.toJSON((Object)result);
            }
            DynamicObject proDeploy = BusinessDataServiceHelper.loadSingle((Object)prodeployid, (String)"ocdpm_channeldeploy");
            Map<Long, Boolean> orgOpenMap = this.getOrgOpenPromotionMap(proDeploy, orgidList);
            result.success(orgOpenMap);
        }
        catch (KDBizException e) {
            this.logger.error("\u9500\u552e\u7ec4\u7ec7\u662f\u5426\u5f00\u542f\u4fc3\u9500\u67e5\u8be2\u63a5\u53e3\u5931\u8d25:");
            this.logger.error((Throwable)e);
        }
        JSONObject json = (JSONObject)JSON.toJSON((Object)result);
        this.logger.info("\u9500\u552e\u7ec4\u7ec7\u662f\u5426\u5f00\u542f\u4fc3\u9500\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de:" + json);
        return json;
    }

    private Map<Long, Boolean> getOrgOpenPromotionMap(DynamicObject proDeploy, List<Long> orgIdList) {
        HashMap<Long, Boolean> reMap = new HashMap<Long, Boolean>();
        DynamicObjectCollection entryentity = proDeploy.getDynamicObjectCollection("entryentity");
        entryentity.forEach(entry -> {
            long orgId = entry.getLong("orgid_id");
            if (orgIdList.contains(orgId)) {
                reMap.put(orgId, entry.getBoolean("openpromotion"));
            }
        });
        entryentity.forEach(entry -> {
            if (entry.getBoolean("containlowerorg")) {
                long orgId = entry.getLong("orgid_id");
                List<Long> allOrgId = this.getAllLowerOrgid(orgId);
                Sets.SetView orgSettings = Sets.intersection(new HashSet<Long>(allOrgId), new HashSet(orgIdList));
                for (Long id : orgSettings) {
                    if (reMap.containsKey(id)) continue;
                    reMap.put(id, entry.getBoolean("openpromotion"));
                }
            }
        });
        orgIdList.forEach(a -> {
            if (!reMap.containsKey(a)) {
                reMap.put((Long)a, Boolean.FALSE);
            }
        });
        return reMap;
    }

    private Boolean checkIsOpenPromotion(DynamicObject proDeploy, Long str) {
        boolean flag = false;
        DynamicObjectCollection entryentity = proDeploy.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryentity) {
            DynamicObject org = entry.getDynamicObject("orgid");
            if (org == null) continue;
            Long orgid = (Long)org.getPkValue();
            Boolean openpromotion = entry.getBoolean("openpromotion");
            if (entry.getBoolean("containlowerorg")) {
                List<Long> allOrgId = this.getAllLowerOrgid(orgid);
                if (!allOrgId.contains(str) || !openpromotion.booleanValue()) continue;
                flag = true;
                break;
            }
            if (Long.compare(str, orgid) != 0 || !openpromotion.booleanValue()) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private List<Long> getAllLowerOrgid(Long orgId) {
        ArrayList<Long> allOrgId = new ArrayList<Long>();
        ArrayList<Long> queryOrgIds = new ArrayList<Long>();
        queryOrgIds.add(orgId);
        List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"03", queryOrgIds, (boolean)true);
        allOrgId.addAll(subOrgIds);
        return allOrgId;
    }

    private void checkServiceParam(ResultMessage<Object> result, List<Long> orgidList) {
        StringBuilder sbuild = new StringBuilder();
        if (orgidList.isEmpty()) {
            sbuild.append(ResManager.loadKDString((String)"\u5165\u53c2\u7ec4\u7ec7\u7f16\u7801\u5fc5\u586b", (String)"OpenPromotionServiceImpl_0", (String)"occ-ocdpm-mservice", (Object[])new Object[0]));
        }
    }

    public static List<Long> getOrgRangIdList() {
        List exAllSubOrgs;
        List openAllSubOrgs;
        Sets.SetView lowerSet;
        DynamicObjectCollection settingOrgList = OpenPromotionServiceImpl.getSettingOrgList();
        if (CollectionUtils.isEmpty((Collection)settingOrgList)) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> openPromotionList = new ArrayList<Long>(8);
        ArrayList<Long> openSubOrgIds = new ArrayList<Long>(8);
        ArrayList<Long> exPromotionList = new ArrayList<Long>(8);
        ArrayList<Long> exSubOrgIds = new ArrayList<Long>(8);
        for (DynamicObject entry : settingOrgList) {
            long orgId = DynamicObjectUtils.getPkValue((DynamicObject)entry.getDynamicObject("orgid"));
            boolean openPromotion = entry.getBoolean("openpromotion");
            boolean containLowerOrg = entry.getBoolean("containlowerorg");
            if (openPromotion) {
                if (!openPromotionList.contains(orgId)) {
                    openPromotionList.add(orgId);
                }
                if (!containLowerOrg) continue;
                openSubOrgIds.add(orgId);
                continue;
            }
            if (!exPromotionList.contains(orgId)) {
                exPromotionList.add(orgId);
            }
            if (!containLowerOrg) continue;
            exSubOrgIds.add(orgId);
        }
        Sets.SetView idSet = Sets.difference(new HashSet(openPromotionList), new HashSet(exPromotionList));
        if (CollectionUtils.isNotEmpty(openSubOrgIds) && CollectionUtils.isNotEmpty((Collection)(lowerSet = Sets.difference(new HashSet(openAllSubOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"03", openSubOrgIds, (boolean)false)), new HashSet(exAllSubOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"03", exSubOrgIds, (boolean)false)))))) {
            idSet = Sets.union((Set)idSet, (Set)lowerSet);
        }
        ArrayList<Long> rangeList = new ArrayList<Long>((Collection<Long>)idSet);
        return rangeList;
    }

    private static DynamicObjectCollection getSettingOrgList() {
        DynamicObject proDeploy = BusinessDataServiceHelper.loadSingle((Object)prodeployid, (String)"ocdpm_channeldeploy");
        return proDeploy.getDynamicObjectCollection("entryentity");
    }
}

