/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.mservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.config.client.util.StringUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocdpm.common.model.condition.PricePolicyCondition;
import kd.occ.ocdpm.common.model.result.PricePolicyResult;
import kd.occ.ocdpm.common.model.result.ResultMessage;
import kd.occ.ocdpm.common.retailpriceenum.PriceTypeCheckboxEnum;
import kd.occ.ocdpm.common.retailpriceenum.RetailPriceTypeEnum;
import kd.occ.ocdpm.common.util.CommonUtil;
import kd.occ.ocdpm.mservice.api.PricePolicyService;

public class PricePolicyServiceImpl
implements PricePolicyService {
    private Log logger = LogFactory.getLog(PricePolicyServiceImpl.class);
    private static final String PRICE_QUERY_FIELD = "id,billno,channel,billstatus,billtype,enable,pricedetailentity.item,pricedetailentity.item.name,pricedetailentity.barcode,pricedetailentity.priceunit,pricedetailentity.pricenum,pricedetailentity.saleattr,pricedetailentity.stocktype,pricedetailentity.priceeffectdate,pricedetailentity.priceinvaliddate,pricedetailentity.retailprice,pricedetailentity.uniqueprice,pricedetailentity.factoryprice,pricedetailentity.memberprice,pricedetailentity.specialprice,pricedetailentity.lowprice,treeentryentity.hasdistributed";
    private static final String PRICE_TYPE_QUERY_FIELD = "number,name,iscontrolprice,isallowadjust,pricefield,level,enable,status,disabletime";

    public JSONObject matchPricePolicy(String policyCondition) {
        this.logger.info("\u4ef7\u683c\u653f\u7b56\u8c03\u7528:" + policyCondition);
        PricePolicyCondition condition = (PricePolicyCondition)JSON.parseObject((String)policyCondition, PricePolicyCondition.class);
        ResultMessage<PricePolicyResult> result = new ResultMessage<PricePolicyResult>();
        this.checkServiceParam(result, condition);
        if (StringUtils.isNotEmpty((String)result.getMessage())) {
            return (JSONObject)JSON.toJSON((Object)result);
        }
        QFilter filter = new QFilter("pricedetailentity.item", "=", (Object)Long.parseLong(condition.getItemId()));
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        filter.and(new QFilter("enable", "=", (Object)"A"));
        filter.and(new QFilter("pricedetailentity.priceisinvalid", "=", (Object)"0"));
        filter.and(new QFilter("treeentryentity.branch", "=", (Object)Long.parseLong(condition.getChannel())));
        filter.and(new QFilter("treeentryentity.priceenable", "=", (Object)"1"));
        if (condition.getStore() != null) {
            filter.and(new QFilter("isstore", "=", (Object)(condition.getStore() != false ? "1" : "0")));
        }
        if (condition.getOnlineStore() != null) {
            filter.and(new QFilter("isonlinestore", "=", (Object)(condition.getOnlineStore() != false ? "1" : "0")));
        }
        if (condition.getOnlineMarket() != null) {
            filter.and(new QFilter("isonlinemarket", "=", (Object)(condition.getOnlineMarket() != false ? "1" : "0")));
        }
        if (condition.getPriceUnit() != null) {
            filter.and(new QFilter("pricedetailentity.priceunit", "=", (Object)Long.parseLong(condition.getPriceUnit())));
        }
        if (condition.getStockType() != null) {
            filter.and(new QFilter("pricedetailentity.stocktype", "=", (Object)Long.parseLong(condition.getStockType())));
        }
        filter.and(new QFilter("pricedetailentity.barcode", "=", (Object)Long.parseLong(condition.getBarcode())));
        filter.and(new QFilter("pricedetailentity.priceeffectdate", "<=", (Object)CommonUtil.stringToDateformat((String)condition.getBizDate())));
        filter.and(new QFilter("pricedetailentity.priceinvaliddate", ">=", (Object)CommonUtil.stringToDateformat((String)condition.getBizDate())));
        DynamicObjectCollection pricePolicyList = QueryServiceHelper.query((String)"ocdpm_retailpricelist", (String)PRICE_QUERY_FIELD, (QFilter[])new QFilter[]{filter}, (String)"billtype desc,auditdate desc");
        String billType = null;
        Boolean distributed = null;
        for (DynamicObject dynamicObject : pricePolicyList) {
            billType = dynamicObject.getString("billType");
            distributed = dynamicObject.getBoolean("treeentryentity.hasdistributed");
            if ("1041388752234404864".equals(billType)) {
                result = this.judgePriceTypeLevel(dynamicObject);
                break;
            }
            if (!"1041385340746914816".equals(billType) || !distributed.booleanValue()) continue;
            result = this.judgePriceTypeLevel(dynamicObject);
            break;
        }
        this.logger.info("\u4ef7\u683c\u653f\u7b56\u8fd4\u56de:" + JSON.toJSONString((Object)result));
        return (JSONObject)JSON.toJSON((Object)result);
    }

    private ResultMessage<PricePolicyResult> judgePriceTypeLevel(DynamicObject pricePolicy) {
        ResultMessage result = new ResultMessage();
        PricePolicyResult pricePolicyResult = new PricePolicyResult();
        try {
            List<String> priceFields = this.getPriceField(pricePolicy);
            if (priceFields.size() > 0) {
                QFilter filter = new QFilter("pricefield", "in", priceFields);
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"ocdpm_retailpricetype", (String)PRICE_TYPE_QUERY_FIELD, (QFilter[])new QFilter[]{filter}, (String)"level asc", (int)1);
                if (dynamicObjects.length > 0) {
                    DynamicObject priceType = dynamicObjects[0];
                    pricePolicyResult.setBillNo(pricePolicy.getString("billno"));
                    pricePolicyResult.setBarcode(pricePolicy.getString("pricedetailentity.barcode"));
                    pricePolicyResult.setChannel(pricePolicy.getString("channel"));
                    pricePolicyResult.setControllerPrice(priceType.getBoolean("iscontrolprice"));
                    pricePolicyResult.setItemId(Long.valueOf(pricePolicy.getLong("pricedetailentity.item")));
                    pricePolicyResult.setItemName(pricePolicy.getString("pricedetailentity.item.name"));
                    pricePolicyResult.setMatchStatus("1");
                    this.matchTopLevelPrice(pricePolicyResult, pricePolicy, priceType);
                    pricePolicyResult.setPriceNum(pricePolicy.getBigDecimal("pricedetailentity.pricenum"));
                    pricePolicyResult.setPriceUnit(pricePolicy.getString("pricedetailentity.priceunit"));
                    pricePolicyResult.setStockType(pricePolicy.getString("pricedetailentity.stocktype"));
                    pricePolicyResult.setItemSaleAttrId(pricePolicy.getString("pricedetailentity.saleattr"));
                    result.success((Object)pricePolicyResult);
                }
            }
        }
        catch (Exception e) {
            result.fail(String.format(ResManager.loadKDString((String)"\u53d6\u4ef7\u9519\u8bef:%s", (String)"PricePolicyServiceImpl_6", (String)"occ-ocdpm-mservice", (Object[])new Object[0]), e.getMessage()));
            this.logger.error((Throwable)e);
        }
        return result;
    }

    private List<String> getPriceField(DynamicObject pricePolicy) {
        ArrayList<String> priceFields = new ArrayList<String>(5);
        BigDecimal retailPrice = pricePolicy.getBigDecimal("pricedetailentity.retailprice");
        BigDecimal uniquePrice = pricePolicy.getBigDecimal("pricedetailentity.uniqueprice");
        BigDecimal factoryPrice = pricePolicy.getBigDecimal("pricedetailentity.factoryprice");
        BigDecimal memberPrice = pricePolicy.getBigDecimal("pricedetailentity.memberprice");
        BigDecimal specialPrice = pricePolicy.getBigDecimal("pricedetailentity.specialprice");
        if (retailPrice.compareTo(BigDecimal.ZERO) > 0) {
            priceFields.add(PriceTypeCheckboxEnum.RPCHECKBOX.getPriceType());
        }
        if (uniquePrice.compareTo(BigDecimal.ZERO) > 0) {
            priceFields.add(PriceTypeCheckboxEnum.UPCHECKBOX.getPriceType());
        }
        if (factoryPrice.compareTo(BigDecimal.ZERO) > 0) {
            priceFields.add(PriceTypeCheckboxEnum.FPCHECKBOX.getPriceType());
        }
        if (memberPrice.compareTo(BigDecimal.ZERO) > 0) {
            priceFields.add(PriceTypeCheckboxEnum.MPCHECKBOX.getPriceType());
        }
        if (specialPrice.compareTo(BigDecimal.ZERO) > 0) {
            priceFields.add(PriceTypeCheckboxEnum.SPCHECKBOX.getPriceType());
        }
        return priceFields;
    }

    private void matchTopLevelPrice(PricePolicyResult pricePolicyResult, DynamicObject pricePolicy, DynamicObject priceType) {
        BigDecimal pricenum = pricePolicy.getBigDecimal("pricedetailentity.pricenum");
        if (pricenum.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        pricePolicyResult.setLowestPrice(pricePolicy.getBigDecimal("pricedetailentity.lowprice"));
        switch (priceType.getString("pricefield")) {
            case "A": {
                pricePolicyResult.setPrice(pricePolicy.getBigDecimal("pricedetailentity.retailprice").divide(pricenum, 4, 4));
                pricePolicyResult.setPriceTypeId(priceType.getString("id"));
                pricePolicyResult.setPriceTypeName(RetailPriceTypeEnum.RPCHECKBOX.getName());
                break;
            }
            case "B": {
                pricePolicyResult.setPrice(pricePolicy.getBigDecimal("pricedetailentity.factoryprice").divide(pricenum, 4, 4));
                pricePolicyResult.setPriceTypeId(priceType.getString("id"));
                pricePolicyResult.setPriceTypeName(RetailPriceTypeEnum.FPCHECKBOX.getName());
                break;
            }
            case "C": {
                pricePolicyResult.setPrice(pricePolicy.getBigDecimal("pricedetailentity.uniqueprice").divide(pricenum, 4, 4));
                pricePolicyResult.setPriceTypeId(priceType.getString("id"));
                pricePolicyResult.setPriceTypeName(RetailPriceTypeEnum.UPCHECKBOX.getName());
                break;
            }
            case "D": {
                pricePolicyResult.setPrice(pricePolicy.getBigDecimal("pricedetailentity.memberprice").divide(pricenum, 4, 4));
                pricePolicyResult.setPriceTypeId(priceType.getString("id"));
                pricePolicyResult.setPriceTypeName(RetailPriceTypeEnum.MPCHECKBOX.getName());
                break;
            }
            case "E": {
                pricePolicyResult.setPrice(pricePolicy.getBigDecimal("pricedetailentity.specialprice").divide(pricenum, 4, 4));
                pricePolicyResult.setPriceTypeId(priceType.getString("id"));
                pricePolicyResult.setPriceTypeName(RetailPriceTypeEnum.SPCHECKBOX.getName());
                break;
            }
        }
    }

    private void checkServiceParam(ResultMessage<PricePolicyResult> result, PricePolicyCondition condition) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty((String)condition.getItemId())) {
            sb.append(ResManager.loadKDString((String)"\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a ", (String)"PricePolicyServiceImpl_1", (String)"occ-ocdpm-mservice", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)condition.getBarcode())) {
            sb.append(ResManager.loadKDString((String)"\u5546\u54c1\u6761\u5f62\u7801\u4e0d\u80fd\u4e3a\u7a7a ", (String)"PricePolicyServiceImpl_2", (String)"occ-ocdpm-mservice", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)condition.getChannel())) {
            sb.append(ResManager.loadKDString((String)"\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a ", (String)"PricePolicyServiceImpl_3", (String)"occ-ocdpm-mservice", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)condition.getPriceUnit())) {
            sb.append(ResManager.loadKDString((String)"\u8ba1\u4ef7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a ", (String)"PricePolicyServiceImpl_4", (String)"occ-ocdpm-mservice", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)condition.getBizDate())) {
            sb.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a ", (String)"PricePolicyServiceImpl_5", (String)"occ-ocdpm-mservice", (Object[])new Object[0]));
        }
        result.fail(sb.toString());
    }
}

