/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.mservice.promotionpolicy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocbase.common.entity.PromotionDetailParams;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocdpm.business.promotion.ArbitrarilyCalculateHelper;
import kd.occ.ocdpm.common.entity.CalculateInfoVo;
import kd.occ.ocdpm.common.entity.CalculatePromotionVo;
import kd.occ.ocdpm.common.enums.PromStrategyEnums;
import kd.occ.ocdpm.mservice.promotionpolicy.CalculateDispatcher;
import org.apache.commons.collections.CollectionUtils;

public class ArbitrarilyItemCalculate
implements CalculateDispatcher {
    private static Log logger = LogFactory.getLog(ArbitrarilyItemCalculate.class);

    @Override
    public List<List<PromotionDetailParams>> execute(List<PromotionDetailParams> paramDetailList, CalculatePromotionVo calculatePromotionVo) {
        List calculateInfoVoList = ArbitrarilyCalculateHelper.getCalculateInfoVoList(paramDetailList, (CalculatePromotionVo)calculatePromotionVo);
        if (CollectionUtils.isEmpty((Collection)calculateInfoVoList)) {
            return new ArrayList<List<PromotionDetailParams>>(0);
        }
        DynamicObject mainItem = (DynamicObject)calculatePromotionVo.getMainList().get(0);
        DynamicObjectCollection proStrategyList = mainItem.getDynamicObjectCollection("prostrategy");
        List<List<PromotionDetailParams>> resultList = this.getPromotionCalculateResult(calculateInfoVoList, proStrategyList);
        return resultList;
    }

    private List<List<PromotionDetailParams>> getPromotionCalculateResult(List<CalculateInfoVo> calculateInfoVoList, DynamicObjectCollection proStrategyList) {
        ArrayList<List<PromotionDetailParams>> calculateGroupList = new ArrayList<List<PromotionDetailParams>>(6);
        List<PromotionDetailParams> calculateResultList = null;
        for (DynamicObject proStrategy : proStrategyList) {
            long proStrategyId = DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)proStrategy.get(1)));
            if (proStrategyId == PromStrategyEnums.appointGift.getValue()) {
                calculateResultList = this.calculateAppointGiftResult(calculateInfoVoList);
            } else if (proStrategyId == PromStrategyEnums.pricediscountAmount.getValue()) {
                calculateResultList = this.calculateArbiItemPDAResult(calculateInfoVoList);
            } else if (proStrategyId == PromStrategyEnums.promotionPrice.getValue()) {
                calculateResultList = this.calculateArbiItemProPriceResult(calculateInfoVoList);
            } else if (proStrategyId == PromStrategyEnums.discountRate.getValue()) {
                calculateResultList = this.calculateDiscountRateResult(calculateInfoVoList);
            }
            if (!CollectionUtils.isNotEmpty(calculateResultList)) continue;
            calculateGroupList.add(calculateResultList);
        }
        return calculateGroupList;
    }

    public List<PromotionDetailParams> calculateDiscountRateResult(List<CalculateInfoVo> calculateInfoVoList) {
        return ArbitrarilyCalculateHelper.getDiscountRateResultList(calculateInfoVoList);
    }

    public List<PromotionDetailParams> calculateArbiItemProPriceResult(List<CalculateInfoVo> calculateInfoVoList) {
        return ArbitrarilyCalculateHelper.getArbiItemProPriceResultList(calculateInfoVoList);
    }

    public List<PromotionDetailParams> calculateArbiItemPDAResult(List<CalculateInfoVo> calculateInfoVoList) {
        return ArbitrarilyCalculateHelper.getArbiItemPDAResultList(calculateInfoVoList);
    }

    public List<PromotionDetailParams> calculateAppointGiftResult(List<CalculateInfoVo> calculateInfoVoList) {
        return ArbitrarilyCalculateHelper.getAppointGiftResultList(calculateInfoVoList);
    }
}

