/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.mservice.promotionpolicy;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocdpm.mservice.promotionpolicy.CalculateDispatcher;
import kd.occ.ocdpm.mservice.promotionpolicy.DefaultCalculate;
import org.apache.commons.collections4.CollectionUtils;

public class CalculatePluginDispatcher {
    private static Log logger = LogFactory.getLog(CalculatePluginDispatcher.class);

    public static final CalculateDispatcher getCalculatePlugin(long promotionObjId) {
        String plugin = CalculatePluginDispatcher.getPluginByPromotionObjId(promotionObjId);
        CalculateDispatcher calculateDispatcher = (CalculateDispatcher)CalculatePluginDispatcher.toInstance(plugin);
        if (calculateDispatcher == null) {
            calculateDispatcher = new DefaultCalculate();
        }
        return calculateDispatcher;
    }

    public static Object toInstance(String className) {
        try {
            return Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    private static String getPluginByPromotionObjId(long promotionObjId) {
        Map<Long, String> _pluginMap = CalculatePluginDispatcher.getCalculatePluginMap();
        return _pluginMap.get(promotionObjId);
    }

    public static Map<Long, String> getCalculatePluginMap() {
        QFilter filters = new QFilter("enable", "=", (Object)"1");
        filters.and(new QFilter("status", "=", (Object)"C"));
        DynamicObjectCollection pluginList = QueryServiceHelper.query((String)"ocdpm_promotionplugin", (String)"promotionobj,plugin", (QFilter[])filters.toArray());
        if (CollectionUtils.isEmpty((Collection)pluginList)) {
            return new HashMap<Long, String>(0);
        }
        HashMap<Long, String> pluginMap = new HashMap<Long, String>(pluginList.size());
        for (DynamicObject pluginInfo : pluginList) {
            pluginMap.put(pluginInfo.getLong("promotionobj"), pluginInfo.getString("plugin"));
        }
        return pluginMap;
    }
}

