/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.mservice.promotionpolicy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocbase.common.entity.PromotionDetailParams;
import kd.occ.ocbase.common.pagemodel.OcdpmPromotionRule;
import kd.occ.ocbase.common.util.ChannelDeployUtil;
import kd.occ.ocdpm.business.promotion.PromotionCalculateHelper;
import kd.occ.ocdpm.business.promotion.PromotionParamHelper;
import kd.occ.ocdpm.business.promotion.PromotionPolicyHelper;
import kd.occ.ocdpm.business.promotion.PromotionRuleHelper;
import kd.occ.ocdpm.common.entity.CalculatePromotionVo;
import kd.occ.ocdpm.common.entity.PromotionInParam;
import kd.occ.ocdpm.mservice.api.PromotionPolicyService;
import kd.occ.ocdpm.mservice.promotionpolicy.CalculateDispatcher;
import kd.occ.ocdpm.mservice.promotionpolicy.CalculatePluginDispatcher;
import kd.occ.ocdpm.mservice.promotionpolicy.DefaultCalculate;
import org.apache.commons.collections4.CollectionUtils;

public class PromotionPolicyServiceImpl
implements PromotionPolicyService {
    private static Log logger = LogFactory.getLog(PromotionPolicyServiceImpl.class);

    public JSONArray calculateBillPromotionPolicyResult(String billEntity, long pkValue) {
        List<PromotionDetailParams> calculateList = this.getPromotionPolicyCalculateResults(billEntity, pkValue);
        return JSONArray.parseArray((String)JSON.toJSONString(calculateList));
    }

    public List<PromotionDetailParams> getPromotionPolicyCalculateResults(String billEntity, long pkValue) {
        DynamicObject promotionRule = PromotionRuleHelper.getMatchPromotionRule((String)billEntity, (Object)pkValue);
        String promotionLink = promotionRule.getString("promlink");
        PromotionInParam inputParams = PromotionParamHelper.buildPromotionRuleInputParams((DynamicObject)promotionRule, (String)billEntity, (long)pkValue);
        boolean isRuleEntryConfigPromParam = promotionRule.getDynamicObjectCollection("entryentity").stream().anyMatch(p -> OcdpmPromotionRule.EF_PROMOTIONPARAMID.equals(p.getDynamicObject("combofield").getLong("id")));
        return PromotionPolicyServiceImpl.calculatePromotionPolicy(inputParams, promotionLink, isRuleEntryConfigPromParam);
    }

    private static List<PromotionDetailParams> calculatePromotionPolicy(PromotionInParam inParam, String promotionLink, boolean isRuleEntryConfigPromParam) {
        PromotionParamHelper.checkParamsMustInput((PromotionInParam)inParam);
        DynamicObject[] policyList = PromotionPolicyHelper.getMatchPromotionPolicyList((PromotionInParam)inParam, (String)promotionLink, (boolean)isRuleEntryConfigPromParam);
        List<PromotionDetailParams> calculateList = PromotionPolicyServiceImpl.matchPromotionGroup(inParam, policyList, promotionLink);
        return calculateList;
    }

    private static List<PromotionDetailParams> matchPromotionGroup(PromotionInParam inputParams, DynamicObject[] promotionPolicyList, String promotionLink) {
        ArrayList<PromotionDetailParams> calculateResultList = new ArrayList<PromotionDetailParams>(8);
        List calculatePromotionVoList = PromotionCalculateHelper.buildCalculatePromotionVoList((DynamicObject[])promotionPolicyList, (String)promotionLink);
        Comparator<CalculatePromotionVo> byPriority = Comparator.comparing(CalculatePromotionVo::getPriority);
        Comparator<CalculatePromotionVo> byPolicyId = Comparator.comparing(CalculatePromotionVo::getPolicyId);
        Comparator<CalculatePromotionVo> byGroupPriorityDetail = Comparator.comparing(CalculatePromotionVo::getGroupPrioritydetail);
        calculatePromotionVoList.sort(byPriority.thenComparing(byPolicyId).thenComparing(byGroupPriorityDetail));
        List paramsDetails = PromotionCalculateHelper.getParamsDetails((List)inputParams.getDetailParams(), (String)promotionLink);
        int seq = 1;
        Map<Long, String> pluginMap = CalculatePluginDispatcher.getCalculatePluginMap();
        HashMap<Long, List<Long>> existPriorityPromotionIdMap = new HashMap<Long, List<Long>>();
        HashMap<Long, Long> existPromotionGroupPriorityMap = new HashMap<Long, Long>();
        boolean isEnablePriority = "P".equals(ChannelDeployUtil.getMultyPromotionStrategy((long)inputParams.getSaleOrgId()));
        for (CalculatePromotionVo vo : calculatePromotionVoList) {
            List<List<PromotionDetailParams>> result;
            if (!PromotionPolicyServiceImpl.isNeedCalculate(isEnablePriority, vo, existPriorityPromotionIdMap, existPromotionGroupPriorityMap) || CollectionUtils.isEmpty(result = PromotionPolicyServiceImpl.calculatePluginResult(paramsDetails, vo, pluginMap))) continue;
            for (List<PromotionDetailParams> paramList : result) {
                for (PromotionDetailParams param : paramList) {
                    param.setResultSeq(seq);
                }
                ++seq;
                calculateResultList.addAll(paramList);
            }
            PromotionPolicyServiceImpl.recordCalculateResult(isEnablePriority, vo, existPriorityPromotionIdMap, existPromotionGroupPriorityMap);
        }
        return calculateResultList;
    }

    private static void recordCalculateResult(boolean isEnablePriority, CalculatePromotionVo vo, Map<Long, List<Long>> existPriorityPromotionIdMap, Map<Long, Long> existPromotionGroupPriorityMap) {
        if (!isEnablePriority) {
            return;
        }
        if (existPriorityPromotionIdMap.isEmpty()) {
            ArrayList<Long> promotionIds = new ArrayList<Long>();
            promotionIds.add(vo.getPolicyId());
            existPriorityPromotionIdMap.put(vo.getPriority(), promotionIds);
            existPromotionGroupPriorityMap.put(vo.getPolicyId(), vo.getGroupPrioritydetail());
        } else if (existPriorityPromotionIdMap.containsKey(vo.getPriority())) {
            if (existPriorityPromotionIdMap.get(vo.getPriority()).contains(vo.getPolicyId())) {
                return;
            }
            existPriorityPromotionIdMap.get(vo.getPriority()).add(vo.getPolicyId());
            existPromotionGroupPriorityMap.put(vo.getPolicyId(), vo.getGroupPrioritydetail());
        }
    }

    private static boolean isNeedCalculate(boolean isEnablePriority, CalculatePromotionVo vo, Map<Long, List<Long>> existPriorityPromotionIdMap, Map<Long, Long> existPromotionGroupPriorityMap) {
        if (!isEnablePriority || existPriorityPromotionIdMap.isEmpty()) {
            return true;
        }
        if (!existPriorityPromotionIdMap.containsKey(vo.getPriority())) {
            return false;
        }
        List<Long> promotionids = existPriorityPromotionIdMap.get(vo.getPriority());
        if (promotionids.contains(vo.getPolicyId())) {
            return vo.getGroupPrioritydetail() == existPromotionGroupPriorityMap.get(vo.getPolicyId()).longValue();
        }
        return true;
    }

    private static List<List<PromotionDetailParams>> calculatePluginResult(List<PromotionDetailParams> paramsDetails, CalculatePromotionVo vo, Map<Long, String> pluginMap) {
        String plugin = pluginMap.get(vo.getPromoteObjId());
        CalculateDispatcher calculateDispatcher = (CalculateDispatcher)CalculatePluginDispatcher.toInstance(plugin);
        if (calculateDispatcher == null) {
            calculateDispatcher = new DefaultCalculate();
        }
        List inParamList = PromotionCalculateHelper.getCalculateParamsDetails((CalculatePromotionVo)vo, paramsDetails);
        return calculateDispatcher.execute(inParamList, vo);
    }
}

