/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.mservice.promotionpolicy;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocbase.common.entity.PromotionDetailParams;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocdpm.business.promotion.PromotionCalculateHelper;
import kd.occ.ocdpm.business.promotion.SingleCalculateHelper;
import kd.occ.ocdpm.common.entity.CalculateInfoVo;
import kd.occ.ocdpm.common.entity.CalculatePromotionVo;
import kd.occ.ocdpm.common.enums.PromStrategyEnums;
import kd.occ.ocdpm.mservice.promotionpolicy.CalculateDispatcher;
import org.apache.commons.collections4.CollectionUtils;

public class SingleItemCalculate
implements CalculateDispatcher {
    private static Log logger = LogFactory.getLog(SingleItemCalculate.class);

    @Override
    public List<List<PromotionDetailParams>> execute(List<PromotionDetailParams> paramDetailList, CalculatePromotionVo calculatePromotionVo) {
        List calculateInfoVoList = SingleCalculateHelper.getCalculateInfoVoList(paramDetailList, (CalculatePromotionVo)calculatePromotionVo);
        List<List<PromotionDetailParams>> calculateGroupList = this.getPromotionCalculateResult(calculateInfoVoList);
        return calculateGroupList;
    }

    private List<List<PromotionDetailParams>> getPromotionCalculateResult(List<CalculateInfoVo> calculateInfoVoList) {
        ArrayList<List<PromotionDetailParams>> resultList = new ArrayList<List<PromotionDetailParams>>(calculateInfoVoList.size());
        for (CalculateInfoVo calculateInfoVo : calculateInfoVoList) {
            DynamicObjectCollection proStrategyList = calculateInfoVo.getMainItem().getDynamicObjectCollection("prostrategy");
            List<PromotionDetailParams> singleResult = null;
            for (DynamicObject proStrategy : proStrategyList) {
                CalculateInfoVo vo = PromotionCalculateHelper.buildCalculateInfoVo((CalculateInfoVo)calculateInfoVo);
                long proStrategyId = DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)proStrategy.get(1)));
                if (proStrategyId == PromStrategyEnums.fixedDiscountAmount.getValue()) {
                    singleResult = this.calculateFixedDiscountAmountResult(vo);
                } else if (proStrategyId == PromStrategyEnums.pricediscountAmount.getValue()) {
                    singleResult = this.calculatePriceDisctAmountResult(vo);
                } else if (proStrategyId == PromStrategyEnums.appointGift.getValue()) {
                    singleResult = this.calculateAppointGiftResult(vo);
                } else if (proStrategyId == PromStrategyEnums.discountRate.getValue()) {
                    singleResult = this.calculateDiscountRateResult(vo);
                } else if (proStrategyId == PromStrategyEnums.thisGift.getValue()) {
                    singleResult = this.calculateThisGiftResult(vo);
                } else if (proStrategyId == PromStrategyEnums.promotionPrice.getValue()) {
                    singleResult = this.buildPromotionPrice(vo);
                }
                if (!CollectionUtils.isNotEmpty(singleResult)) continue;
                resultList.add(singleResult);
            }
        }
        return resultList;
    }

    public List<PromotionDetailParams> calculateThisGiftResult(CalculateInfoVo calculateInfoVo) {
        return SingleCalculateHelper.getThisGiftResultList((CalculateInfoVo)calculateInfoVo);
    }

    public List<PromotionDetailParams> buildPromotionPrice(CalculateInfoVo calculateInfoVo) {
        return SingleCalculateHelper.getPromotionPriceResultList((CalculateInfoVo)calculateInfoVo);
    }

    public List<PromotionDetailParams> calculateFixedDiscountAmountResult(CalculateInfoVo calculateInfoVo) {
        return SingleCalculateHelper.getFixedDiscountAmountResultList((CalculateInfoVo)calculateInfoVo);
    }

    public List<PromotionDetailParams> calculateDiscountRateResult(CalculateInfoVo calculateInfoVo) {
        return SingleCalculateHelper.getDiscountRateResultList((CalculateInfoVo)calculateInfoVo);
    }

    public List<PromotionDetailParams> calculateAppointGiftResult(CalculateInfoVo calculateInfoVo) {
        return SingleCalculateHelper.getAppointGiftResultList((CalculateInfoVo)calculateInfoVo);
    }

    public List<PromotionDetailParams> calculatePriceDisctAmountResult(CalculateInfoVo calculateInfoVo) {
        return SingleCalculateHelper.getPriceDisctAmountResultList((CalculateInfoVo)calculateInfoVo);
    }
}

