/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.mservice.promotionpolicy;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocbase.common.entity.PromotionDetailParams;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocdpm.business.promotion.WholeOrderCalculateHelper;
import kd.occ.ocdpm.common.entity.CalculateInfoVo;
import kd.occ.ocdpm.common.entity.CalculatePromotionVo;
import kd.occ.ocdpm.common.enums.PromStrategyEnums;
import kd.occ.ocdpm.mservice.promotionpolicy.CalculateDispatcher;
import org.apache.commons.collections.CollectionUtils;

public class WholeOrderCalculate
implements CalculateDispatcher {
    private static Log logger = LogFactory.getLog(WholeOrderCalculate.class);

    @Override
    public List<List<PromotionDetailParams>> execute(List<PromotionDetailParams> paramDetailList, CalculatePromotionVo calculatePromotionVo) {
        CalculateInfoVo calculateInfoVo = WholeOrderCalculateHelper.getCalculateInfoVo(paramDetailList, (CalculatePromotionVo)calculatePromotionVo);
        if (calculateInfoVo == null) {
            return new ArrayList<List<PromotionDetailParams>>(0);
        }
        DynamicObjectCollection proStrategyList = calculateInfoVo.getMainItem().getDynamicObjectCollection("prostrategy");
        return this.getPromotionCalculateResultList(calculateInfoVo, proStrategyList);
    }

    private List<List<PromotionDetailParams>> getPromotionCalculateResultList(CalculateInfoVo calculateInfoVo, DynamicObjectCollection proStrategyList) {
        ArrayList<List<PromotionDetailParams>> calculateResultList = new ArrayList<List<PromotionDetailParams>>(8);
        List<PromotionDetailParams> result = null;
        for (DynamicObject proStrategy : proStrategyList) {
            long proStrategyId = DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)proStrategy.get(1)));
            if (proStrategyId == PromStrategyEnums.appointGift.getValue()) {
                result = WholeOrderCalculate.calculatePromoteGiftResult(calculateInfoVo);
            } else if (proStrategyId == PromStrategyEnums.wholediscountRate.getValue()) {
                result = this.calculateTotalDiscountResult(calculateInfoVo);
            } else if (proStrategyId == PromStrategyEnums.fixedDiscountAmount.getValue()) {
                result = this.calculateFixedDiscountResult(calculateInfoVo);
            } else if (proStrategyId == PromStrategyEnums.pricediscountAmount.getValue()) {
                result = this.calculateUnitPriceDiscountResult(calculateInfoVo);
            }
            if (!CollectionUtils.isNotEmpty(result)) continue;
            calculateResultList.add(result);
        }
        return calculateResultList;
    }

    public static List<PromotionDetailParams> calculatePromoteGiftResult(CalculateInfoVo calculateInfoVo) {
        return WholeOrderCalculateHelper.getPromoteGiftResultList((CalculateInfoVo)calculateInfoVo);
    }

    public List<PromotionDetailParams> calculateTotalDiscountResult(CalculateInfoVo calculateInfoVo) {
        return WholeOrderCalculateHelper.getTotalDiscountResultList((CalculateInfoVo)calculateInfoVo);
    }

    private List<PromotionDetailParams> calculateFixedDiscountResult(CalculateInfoVo calculateInfoVo) {
        return WholeOrderCalculateHelper.getFixedDiscountResultList((CalculateInfoVo)calculateInfoVo);
    }

    public List<PromotionDetailParams> calculateUnitPriceDiscountResult(CalculateInfoVo calculateInfoVo) {
        return WholeOrderCalculateHelper.getUnitPriceDiscountResultList((CalculateInfoVo)calculateInfoVo);
    }
}

