/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.common;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.occ.ocbase.common.model.DetailItemInfo;
import kd.occ.ocbase.common.model.PromotionOrder;
import kd.occ.ocbase.common.model.PromotionOrderEntry;
import kd.occ.ocdpm.common.ItemRangeUtil;

public class CompareORCalculateUtil {
    public static BigDecimal getEntryQtyOrAmount(PromotionOrderEntry entry, String judgestandard) {
        if ("qty".equals(judgestandard)) {
            return entry.getQty();
        }
        if ("amount".equals(judgestandard)) {
            return entry.getAmount();
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u4fc3\u9500\u6761\u4ef6\u5224\u65ad\u57fa\u51c6\u53ea\u80fd\u4e3a\u6570\u91cf\u6216\u91d1\u989d", (String)"CompareORCalculateUtil_0", (String)"occ-ocdpm-common", (Object[])new Object[0]));
    }

    public static BigDecimal getOrderQtyOrAmount(PromotionOrder order, String judgestandard) {
        if ("qty".equals(judgestandard)) {
            return order.getTotalqty();
        }
        if ("amount".equals(judgestandard)) {
            return order.getTotalamount();
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u4fc3\u9500\u6761\u4ef6\u5224\u65ad\u57fa\u51c6\u53ea\u80fd\u4e3a\u6570\u91cf\u6216\u91d1\u989d", (String)"CompareORCalculateUtil_0", (String)"occ-ocdpm-common", (Object[])new Object[0]));
    }

    public static BigDecimal getQtyOrAmountSum(List<PromotionOrderEntry> entrys, String judgestandard) {
        BigDecimal value = BigDecimal.ZERO;
        for (PromotionOrderEntry entry : entrys) {
            value = value.add(CompareORCalculateUtil.getEntryQtyOrAmount(entry, judgestandard));
        }
        return value;
    }

    public static boolean compareWithJudgeValue(BigDecimal value, BigDecimal judgevalue, int comparator) {
        if (comparator == 0) {
            return value.compareTo(judgevalue) > 0;
        }
        if (comparator == 1) {
            return value.compareTo(judgevalue) >= 0;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u7684\u6bd4\u8f83\u7b26\u503c\uff1a%s", (String)"CompareORCalculateUtil_2", (String)"occ-ocdpm-common", (Object[])new Object[0]), comparator));
    }

    public static Map<DetailItemInfo, BigDecimal> sumOrderByDetailItem(List<PromotionOrderEntry> entrys, String judgestandard) {
        HashMap<DetailItemInfo, BigDecimal> map = new HashMap<DetailItemInfo, BigDecimal>();
        for (PromotionOrderEntry entry : entrys) {
            DetailItemInfo ditem = entry.getItemdetail();
            if (map.get(ditem) == null) {
                map.put(ditem, CompareORCalculateUtil.getEntryQtyOrAmount(entry, judgestandard));
                continue;
            }
            BigDecimal value = (BigDecimal)map.get(ditem);
            value = value.add(CompareORCalculateUtil.getEntryQtyOrAmount(entry, judgestandard));
            map.put(ditem, value);
        }
        return map;
    }

    public static Map<DetailItemInfo, BigDecimal> sumOrderByDetailItemFromItemRange(List<PromotionOrderEntry> entrys, DynamicObject itemrange, String judgestandard) {
        List<PromotionOrderEntry> entrylist = CompareORCalculateUtil.genEntrysInRange(entrys, itemrange);
        return CompareORCalculateUtil.sumOrderByDetailItem(entrylist, judgestandard);
    }

    public static List<PromotionOrderEntry> genEntrysInRange(List<PromotionOrderEntry> entrys, DynamicObject itemrange) {
        Set<DetailItemInfo> rangedetails = ItemRangeUtil.parseItemRange(itemrange);
        ArrayList<PromotionOrderEntry> entryset = new ArrayList<PromotionOrderEntry>();
        for (PromotionOrderEntry entry : entrys) {
            if (!rangedetails.contains(entry.getItemdetail())) continue;
            entryset.add(entry);
        }
        return entryset;
    }

    public static List<PromotionOrderEntry> getEntrysEqualsItem(List<PromotionOrderEntry> entrys, Object itemid, Object unitid, Object attrid) {
        ArrayList<PromotionOrderEntry> list = new ArrayList<PromotionOrderEntry>();
        for (PromotionOrderEntry entry : entrys) {
            if (!entry.getItemid().equals(itemid) || !entry.getUnitid().equals(unitid) || !entry.getAttrid().equals(attrid)) continue;
            list.add(entry);
        }
        return list;
    }
}

