/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.org.api.IOrgService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.QueryUtil;

public class CustomerRangeUtil {
    public static boolean isCustomerRangeEfective(DynamicObject customerrange) {
        DynamicObjectCollection entrys = customerrange.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entrys) {
            if (entry.get("customergroup") == null && entry.get("customergrade") == null && entry.get("customer") == null && entry.get("province") == null && entry.get("city") == null && entry.get("area") == null) continue;
            return true;
        }
        return false;
    }

    public static Set<Object> parseCustomerRange(Object rangeid) {
        DynamicObject range = BusinessDataServiceHelper.loadSingle((Object)rangeid, (String)"dpm_customerrange");
        return CustomerRangeUtil.parseCustomerRange(range);
    }

    public static Set<Object> parseCustomerRange(DynamicObject range) {
        DynamicObjectCollection rangeentrys = range.getDynamicObjectCollection("entryentity");
        HashSet<Object> inidset = new HashSet<Object>();
        HashSet<Object> customergroups = new HashSet<Object>();
        HashSet<Object> customergrades = new HashSet<Object>();
        DynamicObject dObject = null;
        for (DynamicObject entry : rangeentrys) {
            if (entry.getBoolean("isremoved")) continue;
            dObject = entry.getDynamicObject("customergroup");
            if (dObject != null && !customergroups.contains(dObject.getPkValue())) {
                customergroups.add(dObject.getPkValue());
            }
            if ((dObject = entry.getDynamicObject("customergrade")) != null && !customergrades.contains(dObject.getPkValue())) {
                customergrades.add(dObject.getPkValue());
            }
            if ((dObject = entry.getDynamicObject("customer")) == null || inidset.contains(dObject.getPkValue())) continue;
            inidset.add(dObject.getPkValue());
        }
        QFilter filter = null;
        if (customergrades.size() > 0) {
            filter = new QFilter("grade", "in", customergrades);
        }
        if (customergroups.size() > 0) {
            if (filter == null) {
                filter = new QFilter("custclassentity.customergroupid", "in", customergroups);
            } else {
                filter.or(new QFilter("custclassentity.customergroupid", "in", customergroups));
            }
        }
        if (filter != null) {
            Set entryidset = QueryUtil.querySingleCol((String)"ocdbd_channel", (String)"id", (QFilter[])filter.toArray());
            inidset.addAll(entryidset);
        }
        return inidset;
    }

    @Deprecated
    public static boolean isCustomerInRange(Object customerid, Object rangeid) {
        Set<Object> rangeset = CustomerRangeUtil.parseCustomerRange(rangeid);
        return rangeset.contains(customerid);
    }

    public static boolean isCustomerInTheRange(Object customerid, Object rangeid, String ... level) {
        DynamicObject customer = BusinessDataServiceHelper.loadSingle((Object)customerid, (String)"ocdbd_channel");
        DynamicObject range = BusinessDataServiceHelper.loadSingle((Object)rangeid, (String)"dpm_customerrange");
        return CustomerRangeUtil.parseCustomerRange(customer, range, level);
    }

    public static boolean parseCustomerRange(DynamicObject customer, DynamicObject range, String ... level) {
        boolean isMatch = false;
        if (customer == null || range == null) {
            return isMatch;
        }
        isMatch = level != null && level.length > 0 ? (level[0].compareTo("1") == 0 ? CustomerRangeUtil.matchRangeByCustomer(customer.getPkValue(), range) : CustomerRangeUtil.matchCustomerByRange(customer, range)) : CustomerRangeUtil.matchCustomerByRange(customer, range);
        return isMatch;
    }

    public static boolean matchRangeByCustomer(Object customerid, DynamicObject range) {
        boolean isMatch = false;
        DynamicObjectCollection rangeentrys = range.getDynamicObjectCollection("entryentity");
        DynamicObject dObject = null;
        ArrayList<DynamicObject> entrys = new ArrayList<DynamicObject>(rangeentrys.size());
        for (DynamicObject rangeentry : rangeentrys) {
            if (rangeentry.getBoolean("isremoved")) {
                dObject = rangeentry.getDynamicObject("customer");
                if (dObject == null || !customerid.equals(dObject.getPkValue())) continue;
                return false;
            }
            entrys.add(rangeentry);
        }
        for (DynamicObject entry : entrys) {
            dObject = entry.getDynamicObject("customer");
            if (dObject == null || !customerid.equals(dObject.getPkValue())) continue;
            return true;
        }
        return isMatch;
    }

    public static boolean matchCustomerByRange(DynamicObject customer, DynamicObject range) {
        Object addressid;
        boolean isMatch = false;
        Object grade = null;
        String area = "";
        DynamicObject dObject = customer.getDynamicObject("grade");
        if (dObject != null) {
            grade = dObject.getPkValue();
        }
        if ((addressid = customer.get("area")) != null && !addressid.equals("")) {
            area = CustomerRangeUtil.getAddressIds(addressid);
        }
        DynamicObjectCollection custclassentitys = customer.getDynamicObjectCollection("custclassentity");
        HashSet<Object> customergroups = new HashSet<Object>();
        if (custclassentitys != null) {
            for (DynamicObject custclassentity : custclassentitys) {
                dObject = custclassentity.getDynamicObject("customergroupid");
                if (dObject == null) continue;
                customergroups.add(dObject.getPkValue());
            }
        }
        DynamicObjectCollection rangeentrys = range.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : rangeentrys) {
            if (!entry.getBoolean("isremoved") || !CustomerRangeUtil.checkCustomerMeet(entry, customer, area, customergroups, grade)) continue;
            return false;
        }
        for (DynamicObject entry : rangeentrys) {
            if (entry.getBoolean("isremoved") || !CustomerRangeUtil.checkCustomerMeet(entry, customer, area, customergroups, grade)) continue;
            return true;
        }
        return isMatch;
    }

    private static boolean checkCustomerMeet(DynamicObject entry, DynamicObject customer, String area, Set<Object> customergroups, Object grade) {
        DynamicObject dObject = entry.getDynamicObject("customer");
        Object customerid = customer.getPkValue();
        if (dObject != null && !customerid.equals(dObject.getPkValue())) {
            return false;
        }
        dObject = entry.getDynamicObject("province");
        if (dObject != null) {
            if (!area.contains(dObject.getPkValue().toString())) {
                return false;
            }
            dObject = entry.getDynamicObject("city");
            if (dObject != null) {
                if (!area.contains(dObject.getPkValue().toString())) {
                    return false;
                }
                dObject = entry.getDynamicObject("area");
                if (dObject != null && !area.contains(dObject.getPkValue().toString())) {
                    return false;
                }
            }
        }
        if (!((dObject = entry.getDynamicObject("customergrade")) == null || grade != null && dObject.getPkValue().equals(grade))) {
            return false;
        }
        dObject = entry.getDynamicObject("customergroup");
        if (!(dObject == null || customergroups != null && customergroups.contains(dObject.getPkValue()))) {
            return false;
        }
        DynamicObject bizgroup = customer.getDynamicObject("bizgroup");
        dObject = entry.getDynamicObject("saleorgid");
        if (dObject != null) {
            IOrgService orgService;
            List parentIds;
            long bizgroupid;
            if (bizgroup == null) {
                return false;
            }
            long saleorgid = dObject.getLong("id");
            if (saleorgid != (bizgroupid = bizgroup.getLong("id")) && !(parentIds = (orgService = (IOrgService)ServiceFactory.getService(IOrgService.class)).getAllSuperiorOrgs("01", bizgroupid)).contains(saleorgid)) {
                return false;
            }
        }
        return true;
    }

    public static String getAddressIds(Object id) {
        DynamicObject parent;
        StringBuilder address = new StringBuilder();
        address.append(id);
        DynamicObject admindivision = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bd_admindivision");
        if (admindivision != null && (parent = admindivision.getDynamicObject("parent")) != null) {
            address.append('_');
            address.append(CustomerRangeUtil.getAddressIds(parent.getPkValue()));
        }
        return address.toString();
    }
}

