/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.common.chain.processor;

import java.util.Calendar;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.occ.ocbase.common.model.PromotionOrder;
import kd.occ.ocdpm.common.CustomerRangeUtil;
import kd.occ.ocdpm.common.cache.DPMAppCache;
import kd.occ.ocdpm.common.chain.processor.IProcessor;
import kd.occ.ocdpm.common.execute.PromotionExecuteContext;
import kd.occ.ocdpm.common.model.Promotion;

public class MatchPromotionProcessor
implements IProcessor {
    private static String QUERY_FIELDS = "id,priority,isexclusive,customerrange.id,scheduletype,schedulevalues,modifytime";
    protected static Log log = LogFactory.getLog(DPMAppCache.class);

    @Override
    public void process(PromotionExecuteContext ctx) {
        this.matchPolicys(ctx);
    }

    private void matchPolicys(PromotionExecuteContext context) {
        log.info("\u6e20\u9053\u4e91\uff1amatchPolicys" + context.getOrder());
        PromotionOrder order = context.getOrder();
        ORM orm = ORM.create();
        try (DataSet dataset = orm.queryDataSet(this.getClass().getName(), "dpm_policy", QUERY_FIELDS, this.buildQFilters(order)).orderBy(new String[]{"isexclusive desc", "priority", "modifytime desc"});){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long rangeid = row.getLong("customerrange.id");
                if (rangeid != null && !rangeid.equals(0L) && !CustomerRangeUtil.isCustomerInTheRange(order.getCustomerid(), rangeid, new String[0]) || !this.isPolicyInSchedule(row.getString("scheduletype"), row.getString("schedulevalues"), order.getCreatetime())) continue;
                context.put(Promotion.getPromotion(row.get("id")), null);
            }
        }
        log.info("\u6e20\u9053\u4e91\uff1amatchPolicys" + context.getPromotions());
    }

    private boolean isPolicyInSchedule(String type, String schedulevalues, Date promotiontime) {
        if (type == null || type.trim().isEmpty() || "day".equals(type)) {
            return true;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(promotiontime);
        Integer dayofmonth = c.get(5);
        Integer dayofweek = c.get(7);
        if ("week".equals(type)) {
            return this.isInValues(schedulevalues, dayofweek);
        }
        if ("month".equals(type)) {
            return this.isInValues(schedulevalues, dayofmonth);
        }
        return false;
    }

    private boolean isInValues(String values, int value) {
        String[] arr = values.split(",");
        boolean flag = false;
        for (int i = 0; i < arr.length; ++i) {
            if (value != Integer.parseInt(arr[i])) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private QFilter[] buildQFilters(PromotionOrder order) {
        QFilter filter = new QFilter("owner", "=", order.getOwnerid());
        filter.and(new QFilter("starttime", "<=", (Object)order.getCreatetime()));
        filter.and(new QFilter("endtime", ">=", (Object)order.getCreatetime()));
        filter.and(new QFilter("policystatus", "=", (Object)"D"));
        return filter.toArray();
    }
}

