/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.common.chain.processor;

import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.occ.ocbase.common.model.PromotionOrder;
import kd.occ.ocdpm.common.CustomerRangeUtil;
import kd.occ.ocdpm.common.cache.DPMAppCache;
import kd.occ.ocdpm.common.execute.PromotionUsableContext;
import kd.occ.ocdpm.common.model.Promotion;

public class MatchUsablePromotionProcessor {
    private static String QUERY_FIELDS = "id,priority,isexclusive,customerrange.id,scheduletype,schedulevalues";
    protected static Log log = LogFactory.getLog(DPMAppCache.class);

    public void usablePromotionProcessor(PromotionUsableContext context) {
        this.matchUsablePolicys(context);
    }

    private void matchUsablePolicys(PromotionUsableContext context) {
        PromotionOrder order = context.getOrder();
        ORM orm = ORM.create();
        Object promotionid = null;
        HashSet<Promotion> promotions = new HashSet<Promotion>();
        Promotion promotion = null;
        try (DataSet dataset = orm.queryDataSet(this.getClass().getName(), "dpm_policy", QUERY_FIELDS, this.buildQFilters(order)).orderBy(new String[]{"priority", "isexclusive desc"});){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long rangeid = row.getLong("customerrange.id");
                if (rangeid != null && !rangeid.equals(0L) && !CustomerRangeUtil.isCustomerInTheRange(order.getCustomerid(), rangeid, new String[0]) || !this.isPolicyInSchedule(row.getString("scheduletype"), row.getString("schedulevalues"), order.getCreatetime())) continue;
                promotionid = row.get("id");
                promotion = Promotion.getPromotion(promotionid);
                promotions.add(promotion);
            }
            context.setPromotions(promotions);
        }
    }

    private boolean isPolicyInSchedule(String type, String schedulevalues, Date promotiontime) {
        if (type == null || type.trim().isEmpty() || "day".equals(type)) {
            return true;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(promotiontime);
        Integer dayofmonth = c.get(5);
        Integer dayofweek = c.get(7);
        if ("week".equals(type)) {
            return this.isInValues(schedulevalues, dayofweek);
        }
        if ("month".equals(type)) {
            return this.isInValues(schedulevalues, dayofmonth);
        }
        return false;
    }

    private boolean isInValues(String values, int value) {
        String[] arr = values.split(",");
        boolean flag = false;
        for (int i = 0; i < arr.length; ++i) {
            if (value != Integer.parseInt(arr[i])) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private QFilter[] buildQFilters(PromotionOrder order) {
        QFilter filter = new QFilter("owner", "=", order.getOwnerid());
        Date createtime = new Date();
        filter.and(new QFilter("starttime", "<=", (Object)createtime));
        filter.and(new QFilter("endtime", ">=", (Object)createtime));
        filter.and(new QFilter("policystatus", "=", (Object)"D"));
        return filter.toArray();
    }
}

