/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.common.limit;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.occ.ocdpm.common.limit.LimitContextEntry;

public class LimitContext {
    private Map<Object, LimitContextEntry> qtymap = new HashMap<Object, LimitContextEntry>();
    private Map<Object, List<Object>> orderentryids = new HashMap<Object, List<Object>>();

    public Map<Object, LimitContextEntry> getQtyLimitContext() {
        return this.qtymap;
    }

    public Set<Object> getEntryIds() {
        return this.qtymap.keySet();
    }

    public void setOrderEntryIds(Map<Object, List<Object>> orderentryid) {
        HashMap<Object, List<Object>> neworderentryids = new HashMap<Object, List<Object>>();
        neworderentryids.putAll(orderentryid);
        this.orderentryids = neworderentryids;
    }

    public Map<Object, List<Object>> getOrderEntryIds() {
        return this.orderentryids;
    }

    public void deleteQtyLimit(Object limitQtyId) {
        if (limitQtyId != null && this.qtymap.get(limitQtyId) != null) {
            this.qtymap.remove(limitQtyId);
        }
    }

    public void putQtyLimit(Object limitQtyId, BigDecimal qty, String type) {
        this.putQtyLimit(limitQtyId, qty, type, false);
    }

    public void putQtyLimit(Object limitQtyId, BigDecimal qty, String type, boolean isPresent) {
        if (limitQtyId != null) {
            if (this.qtymap.get(limitQtyId) == null) {
                this.qtymap.put(limitQtyId, new LimitContextEntry(qty, isPresent, type));
            } else {
                LimitContextEntry context = this.qtymap.get(limitQtyId);
                context.add(qty);
            }
        }
    }

    public LimitContextEntry getLimitContextEntry(Object obj) {
        return this.qtymap.get(obj);
    }

    public BigDecimal getQtyLimit(Object obj) {
        LimitContextEntry entry = this.getLimitContextEntry(obj);
        if (entry != null) {
            return entry.baseqty;
        }
        return null;
    }

    public boolean getQtyLimitIsPresent(Object obj) {
        LimitContextEntry entry = this.getLimitContextEntry(obj);
        if (entry != null) {
            return entry.isPresent;
        }
        return false;
    }

    public LimitContext combine(LimitContext ... contexts) {
        for (int i = 0; i < contexts.length; ++i) {
            LimitContext context = contexts[i];
            if (context == null) continue;
            this.qtymap.putAll(context.qtymap);
            this.orderentryids.putAll(context.orderentryids);
        }
        return this;
    }

    public Map<Object, LimitContextEntry> getEntries() {
        return this.qtymap;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (Map.Entry<Object, LimitContextEntry> entry : this.qtymap.entrySet()) {
            str.append('{');
            str.append(entry.getKey());
            str.append(':');
            str.append(entry.getValue());
            str.append('}');
            str.append('\n');
        }
        return str.toString();
    }
}

