/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.common.limit.handler.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.occ.ocbase.common.model.PromotionOrder;
import kd.occ.ocbase.common.model.PromotionOrderEntry;
import kd.occ.ocdpm.common.execute.PromotionExecuteContext;
import kd.occ.ocdpm.common.limit.LimitContext;
import kd.occ.ocdpm.common.limit.handler.impl.LimitPromotionQtyHandler;
import kd.occ.ocdpm.common.model.execution.AbstractExecution;
import kd.occ.ocdpm.common.model.execution.impl.AddPresentExecution;

public class LimitPromotionPresentQtyHandler
extends LimitPromotionQtyHandler {
    public LimitPromotionPresentQtyHandler(Date executeDate, PromotionOrder order, PromotionExecuteContext context) {
        super(executeDate, order, context);
        PromotionOrder orderWithPresent = new PromotionOrder();
        orderWithPresent.setOwnerid(order.getOwnerid());
        orderWithPresent.setCustomerid(order.getCustomerid());
        for (PromotionOrderEntry entry : order.getEntries()) {
            if (!entry.isIspresent()) continue;
            orderWithPresent.addEntry(entry);
        }
        this.order = orderWithPresent;
    }

    @Override
    protected LimitContext generateSubstractMap(LimitContext context, List<AbstractExecution> executions, PromotionOrderEntry orderItem, DynamicObject limitRule, PromotionOrder order) {
        HashSet matchEntryIds = new HashSet();
        for (AbstractExecution abstractExecution : executions) {
            if (!(abstractExecution instanceof AddPresentExecution) || !orderItem.isIspresent() || !orderItem.getEntryid().equals(abstractExecution.getEntryid())) continue;
            context.putQtyLimit(limitRule.getPkValue(), orderItem.getQty(), this.getHandlerType(), true);
        }
        BigDecimal qty = BigDecimal.ZERO;
        for (Object entryId : matchEntryIds) {
            PromotionOrderEntry poe = order.getEntryById(entryId);
            qty = qty.add(poe.getQty());
        }
        if (qty.compareTo(BigDecimal.ZERO) != 0) {
            context.putQtyLimit(limitRule.getPkValue(), qty, this.getHandlerType());
        }
        this.limitContext = context;
        return context;
    }

    @Override
    public QFilter getLimitHandlerFilter() {
        Object ownerId = this.order.getOwnerid();
        QFilter filter = new QFilter("owner", "=", ownerId).and("starttime", "<=", (Object)this.executeDate).and("endtime", ">=", (Object)this.executeDate).and("status", "=", (Object)"C").and("enable", "=", (Object)"1").and("isactonpolicy", "=", (Object)"1").and("limittype", "=", (Object)"qty").and("limitforpresent", "=", (Object)"1");
        return filter;
    }

    @Override
    public String getHandlerType() {
        return "4";
    }
}

