/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.common.limit.handler.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.handler.UnitBatchHandler;
import kd.occ.ocbase.common.model.PromotionOrder;
import kd.occ.ocbase.common.model.PromotionOrderEntry;
import kd.occ.ocdpm.common.CustomerRangeUtil;
import kd.occ.ocdpm.common.execute.PromotionExecuteContext;
import kd.occ.ocdpm.common.limit.LimitContext;
import kd.occ.ocdpm.common.limit.handler.impl.AbstractQtyHandler;
import kd.occ.ocdpm.common.model.execution.AbstractExecution;
import kd.occ.ocdpm.common.model.execution.PromotionExecutionUnit;
import kd.occ.ocdpm.common.model.execution.ReplaceablePromotionExecution;
import kd.occ.ocdpm.common.model.execution.impl.AddPresentExecution;
import kd.occ.ocdpm.common.model.execution.impl.OrderDiffExecution;

public class LimitPromotionQtyHandler
extends AbstractQtyHandler {
    public LimitPromotionQtyHandler(Date executeDate, PromotionOrder order, PromotionExecuteContext context) {
        super(executeDate, order, context);
    }

    public LimitPromotionQtyHandler(Date executeDate, PromotionOrder order) {
        super(executeDate, order, null);
    }

    @Override
    public LimitContext handle() {
        LimitContext limitContext = new LimitContext();
        if (this.context == null) {
            return limitContext;
        }
        QFilter filter = this.getLimitHandlerFilter();
        DynamicObject[] limitRules = BusinessDataServiceHelper.load((String)"dpm_limit", (String)"id,modifytime,customerrangeid,policy.promotionpolicy,qtylimititems.item,qtylimititems.id,qtylimititems.unit,qtylimititems.attr,qtylimititems.leftlimitqty", (QFilter[])filter.toArray(), (String)"modifytime DESC");
        if (limitRules.length == 0) {
            return limitContext;
        }
        List orderItems = this.order.getPolicyEntries();
        if (orderItems.size() == 0) {
            return limitContext;
        }
        HashMap<Object, List<Object>> orderentryids = new HashMap<Object, List<Object>>();
        this.matchLimit(limitContext, orderentryids, limitRules, orderItems, "1");
        if (orderentryids.size() != orderItems.size()) {
            this.matchLimit(limitContext, orderentryids, limitRules, orderItems, "2");
        }
        limitContext.setOrderEntryIds(orderentryids);
        this.limitContext = limitContext;
        return limitContext;
    }

    private void matchLimit(LimitContext limitContext, Map<Object, List<Object>> orderentryids, DynamicObject[] limitRules, List<PromotionOrderEntry> orderItems, String level) {
        List<Object> limitinfo = null;
        Object customerId = this.order.getCustomerid();
        Object limitid = null;
        Object itemid = null;
        Object orderentryid = null;
        for (DynamicObject limitRule : limitRules) {
            Object rangeid = limitRule.getDynamicObject("customerrangeid").getPkValue();
            if (!CustomerRangeUtil.isCustomerInTheRange(customerId, rangeid, level)) continue;
            DynamicObjectCollection policyList = limitRule.getDynamicObjectCollection("policy");
            List<AbstractExecution> promotionExecutions = this.executePromotionLimitResult(this.context.getExecutions(), policyList);
            if (promotionExecutions.size() == 0) continue;
            limitid = limitRule.getPkValue();
            DynamicObjectCollection qtylimititems = limitRule.getDynamicObjectCollection("qtylimititems");
            for (PromotionOrderEntry orderItem : orderItems) {
                if (orderItem.isIspresent()) continue;
                itemid = orderItem.getItemid();
                orderentryid = orderItem.getEntryid();
                DynamicObject entry = LimitPromotionQtyHandler.checkitemIsOnQtyLimitEntries(itemid, orderItem.getUnitid(), orderItem.getAttrid(), qtylimititems);
                if (entry == null || (limitinfo = orderentryids.get(orderentryid)) != null) continue;
                limitContext.combine(this.generateSubstractMap(limitContext, promotionExecutions, orderItem, entry, this.order));
                if (limitContext.getLimitContextEntry(entry.getPkValue()) == null) continue;
                limitinfo = new ArrayList<Object>();
                limitinfo.add(limitid);
                limitinfo.add(entry.getPkValue());
                orderentryids.put(orderentryid, limitinfo);
            }
        }
    }

    private List<AbstractExecution> executePromotionLimitResult(Collection<ReplaceablePromotionExecution> replaceablePromotionExecutions, DynamicObjectCollection policyCollection) {
        HashSet<Object> promotionids = new HashSet<Object>(policyCollection.size());
        for (DynamicObject object : policyCollection) {
            promotionids.add(object.getDynamicObject("promotionpolicy").getPkValue());
        }
        ArrayList<AbstractExecution> executions = new ArrayList<AbstractExecution>();
        if (replaceablePromotionExecutions.size() != 0) {
            char[] charset = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j'};
            for (ReplaceablePromotionExecution promotionsExecution : replaceablePromotionExecutions) {
                if (!promotionids.contains(promotionsExecution.getPromotionid())) continue;
                for (char c : charset) {
                    PromotionExecutionUnit unit = promotionsExecution.get(Character.valueOf(c));
                    if (unit == null) continue;
                    executions.addAll(unit.getExecutionlist());
                }
            }
        }
        return executions;
    }

    protected LimitContext generateSubstractMap(LimitContext context, List<AbstractExecution> executions, PromotionOrderEntry orderItem, DynamicObject limitRule, PromotionOrder order) {
        BigDecimal baseQty = BigDecimal.ZERO;
        UnitBatchHandler unitBatchHandler = new UnitBatchHandler();
        for (AbstractExecution abstractExecution : executions) {
            if (orderItem.isIspresent()) break;
            if (abstractExecution instanceof AddPresentExecution && abstractExecution.getSourceentryids().contains(orderItem.getEntryid().toString())) {
                baseQty = unitBatchHandler.getBaseQty(orderItem.getItemid(), orderItem.getQty(), orderItem.getUnitid());
                context.putQtyLimit(limitRule.getPkValue(), baseQty, this.getHandlerType());
                break;
            }
            if (abstractExecution instanceof OrderDiffExecution) {
                baseQty = unitBatchHandler.getBaseQty(orderItem.getItemid(), orderItem.getQty(), orderItem.getUnitid());
                context.putQtyLimit(limitRule.getPkValue(), baseQty, this.getHandlerType());
                break;
            }
            if (!abstractExecution.getEntryid().equals(orderItem.getEntryid())) continue;
            baseQty = unitBatchHandler.getBaseQty(orderItem.getItemid(), orderItem.getQty(), orderItem.getUnitid());
            context.putQtyLimit(limitRule.getPkValue(), baseQty, this.getHandlerType());
            break;
        }
        return context;
    }

    @Override
    public QFilter getLimitHandlerFilter() {
        Object ownerId = this.order.getOwnerid();
        QFilter filter = new QFilter("owner", "=", ownerId).and("starttime", "<=", (Object)this.executeDate).and("endtime", ">=", (Object)this.executeDate).and("status", "=", (Object)"C").and("enable", "=", (Object)"1").and("isactonpolicy", "=", (Object)"1").and("limittype", "=", (Object)"qty");
        return filter;
    }

    @Override
    public String getHandlerType() {
        return "3";
    }
}

