/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.common.limit.handler.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.handler.UnitBatchHandler;
import kd.occ.ocbase.common.model.PromotionOrder;
import kd.occ.ocbase.common.model.PromotionOrderEntry;
import kd.occ.ocdpm.common.CustomerRangeUtil;
import kd.occ.ocdpm.common.execute.PromotionExecuteContext;
import kd.occ.ocdpm.common.limit.LimitContext;
import kd.occ.ocdpm.common.limit.handler.impl.AbstractQtyHandler;

public class LimitQtyHandler
extends AbstractQtyHandler {
    public LimitQtyHandler(Date executeDate, PromotionOrder order, PromotionExecuteContext context) {
        super(executeDate, order, context);
    }

    public LimitQtyHandler(Date executeDate, PromotionOrder order) {
        super(executeDate, order, null);
    }

    @Override
    public LimitContext handle() {
        QFilter filter = this.getLimitHandlerFilter();
        DynamicObject[] limitRules = BusinessDataServiceHelper.load((String)"dpm_limit", (String)"id,modifytime,customerrangeid,qtylimititems.item,qtylimititems.id,qtylimititems.unit,qtylimititems.attr,qtylimititems.leftlimitqty", (QFilter[])filter.toArray(), (String)"modifytime DESC");
        LimitContext limitContext = new LimitContext();
        if (limitRules.length == 0) {
            return limitContext;
        }
        HashSet<PromotionOrderEntry> orderItems = new HashSet<PromotionOrderEntry>();
        List orderPolicyItems = this.order.getPolicyEntries();
        ArrayList<Object> entryIds = new ArrayList<Object>();
        if (orderPolicyItems != null) {
            for (PromotionOrderEntry orderPolicyItem : orderPolicyItems) {
                entryIds.add(orderPolicyItem.getEntryid());
            }
        }
        for (PromotionOrderEntry entrie : this.order.getEntries()) {
            if (entryIds.contains(entrie.getEntryid())) continue;
            orderItems.add(entrie);
        }
        if (orderItems.size() == 0) {
            return limitContext;
        }
        HashMap<Object, List<Object>> orderentryids = new HashMap<Object, List<Object>>();
        this.matchLimit(limitContext, orderentryids, limitRules, orderItems, "1");
        if (orderentryids.size() != orderItems.size()) {
            this.matchLimit(limitContext, orderentryids, limitRules, orderItems, "2");
        }
        limitContext.setOrderEntryIds(orderentryids);
        this.limitContext = limitContext;
        return limitContext;
    }

    private void matchLimit(LimitContext limitContext, Map<Object, List<Object>> orderentryids, DynamicObject[] limitRules, Set<PromotionOrderEntry> orderItems, String level) {
        Object customerId = this.order.getCustomerid();
        Object orderentryid = null;
        Object limitentryid = "";
        List<Object> limitinfo = null;
        BigDecimal baseQty = BigDecimal.ZERO;
        UnitBatchHandler unitBatchHandler = new UnitBatchHandler();
        Object limitid = null;
        Object itemid = null;
        for (DynamicObject limitRule : limitRules) {
            Object rangeid = limitRule.getDynamicObject("customerrangeid").getPkValue();
            if (!CustomerRangeUtil.isCustomerInTheRange(customerId, rangeid, level)) continue;
            limitid = limitRule.getPkValue();
            DynamicObjectCollection qtylimititems = limitRule.getDynamicObjectCollection("qtylimititems");
            for (PromotionOrderEntry orderItem : orderItems) {
                DynamicObject entry;
                orderentryid = orderItem.getEntryid();
                if (orderItem.isIspresent() || (entry = LimitQtyHandler.checkitemIsOnQtyLimitEntries(itemid = orderItem.getItemid(), orderItem.getUnitid(), orderItem.getAttrid(), qtylimititems)) == null || (limitinfo = orderentryids.get(orderentryid)) != null) continue;
                limitentryid = entry.getPkValue();
                baseQty = unitBatchHandler.getBaseQty(itemid, orderItem.getQty(), orderItem.getUnitid());
                this.setQtyLimitContext(limitContext, limitentryid, baseQty);
                limitinfo = new ArrayList<Object>();
                limitinfo.add(limitid);
                limitinfo.add(limitentryid);
                orderentryids.put(orderentryid, limitinfo);
            }
        }
    }

    protected void setQtyLimitContext(LimitContext limitContext, Object pkvalue, BigDecimal qty) {
        limitContext.putQtyLimit(pkvalue, qty, this.getHandlerType());
    }

    @Override
    public QFilter getLimitHandlerFilter() {
        Object ownerId = this.order.getOwnerid();
        QFilter filter = new QFilter("owner", "=", ownerId).and("starttime", "<=", (Object)this.executeDate).and("endtime", ">=", (Object)this.executeDate).and("status", "=", (Object)"C").and("enable", "=", (Object)"1").and("isactonpolicy", "=", (Object)"0").and("limittype", "=", (Object)"qty");
        return filter;
    }

    @Override
    public String getHandlerType() {
        return "1";
    }
}

