/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.common.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocdpm.common.model.condition.IPromotionCondition;
import kd.occ.ocdpm.common.model.result.IPromotionResult;
import kd.occ.ocdpm.common.parse.PromotionConditionParser;
import kd.occ.ocdpm.common.parse.PromotionResultParser;

public class Promotion {
    private Object id;
    private String number;
    private String name;
    private int priority;
    private boolean isexclusive;
    private Date starttime;
    private Date endtime;
    private boolean islimit;
    private boolean iscombinationsplit;
    private Date modifytime;
    private List<PromotionEntry> entrylist = new ArrayList<PromotionEntry>();
    private static LocalCache<Object, Promotion> promotioncache = new LocalCache(50);
    private static LocalCache<Object, IPromotionCondition> conditioncache = new LocalCache(100);
    private static LocalCache<Object, IPromotionResult> resultcache = new LocalCache(100);
    private static final String QUERY_FIELD = "id,number,name,priority,isexclusive,starttime,endtime,modifytime,iscombinationsplit,entryentity.seq,entryentity.conditionexp,entryentity.resultexp";

    private Promotion(Object policyid) {
        DynamicObject policy = BusinessDataServiceHelper.loadSingleFromCache((Object)policyid, (String)"dpm_policy", (String)QUERY_FIELD);
        this.id = policy.getPkValue();
        this.number = policy.getString("number");
        this.name = policy.getLocaleString("name").getLocaleValue();
        this.priority = policy.getInt("priority");
        this.isexclusive = policy.getBoolean("isexclusive");
        this.starttime = policy.getDate("starttime");
        this.endtime = policy.getDate("endtime");
        this.iscombinationsplit = policy.getBoolean("iscombinationsplit");
        this.modifytime = policy.getDate("modifytime");
        DynamicObjectCollection entrys = policy.getDynamicObjectCollection("entryentity");
        String conditionexp = "";
        String resultexp = "";
        block0: for (int i = entrys.size(); i >= 1; --i) {
            for (DynamicObject entry : entrys) {
                int seq = entry.getInt("seq");
                if (i != seq) continue;
                conditionexp = entry.getString("conditionexp");
                resultexp = entry.getString("resultexp");
                this.entrylist.add(new PromotionEntry(conditionexp, resultexp));
                if (conditionexp != null && !conditionexp.trim().isEmpty() && conditionexp.matches("^\\d{1,}((AND|OR)\\d{1,})*$")) {
                    for (String condition : conditionexp.split("AND|OR")) {
                        conditioncache.remove(condition);
                    }
                }
                if (resultexp == null || resultexp.trim().isEmpty() || !resultexp.matches("^\\d{1,}((AND|OR)\\d{1,})*$")) continue block0;
                for (String result : resultexp.split("AND|OR")) {
                    resultcache.remove(result);
                }
            }
        }
    }

    public static Promotion getPromotion(Object policyid) {
        Promotion promotion = (Promotion)promotioncache.get(policyid);
        if (promotion != null) {
            DynamicObject tempPolicy = BusinessDataServiceHelper.loadSingleFromCache((Object)policyid, (String)"dpm_policy", (String)"id,modifytime");
            Date modifydate = tempPolicy.getDate("modifytime");
            Date cacheProDate = promotion.getModifytime();
            if (cacheProDate.compareTo(modifydate) < 0) {
                promotion = null;
            }
        }
        if (promotion == null) {
            promotion = new Promotion(policyid);
            promotioncache.put(policyid, promotion);
        }
        return promotion;
    }

    public Object getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isIsexclusive() {
        return this.isexclusive;
    }

    public Date getstarttime() {
        return this.starttime;
    }

    public Date getendtime() {
        return this.endtime;
    }

    public void setislimit(boolean islimit) {
        this.islimit = islimit;
    }

    public boolean getislimit() {
        return this.islimit;
    }

    public boolean isIscombinationsplit() {
        return this.iscombinationsplit;
    }

    public int unitsize() {
        return this.entrylist.size();
    }

    public Date getModifytime() {
        return this.modifytime;
    }

    public String getConditionExp(int index) {
        return this.entrylist.get(index).getConditionexp();
    }

    public String getResultExp(int index) {
        return this.entrylist.get(index).getResultexp();
    }

    public static IPromotionCondition getCondition(Object conditionid) {
        IPromotionCondition condition = (IPromotionCondition)conditioncache.get(conditionid);
        if (condition == null) {
            condition = PromotionConditionParser.parseCondition(conditionid);
            conditioncache.put(conditionid, condition);
        }
        return condition;
    }

    public static IPromotionResult getResult(Object resultid) {
        IPromotionResult result = (IPromotionResult)resultcache.get(resultid);
        if (result == null) {
            result = PromotionResultParser.parseResult(resultid);
            resultcache.put(resultid, result);
        }
        return result;
    }

    private static class PromotionEntry {
        private String conditionexp;
        private String resultexp;

        private PromotionEntry(String conditionexp, String resultexp) {
            this.conditionexp = conditionexp;
            this.resultexp = resultexp;
        }

        public String getConditionexp() {
            return this.conditionexp;
        }

        public String getResultexp() {
            return this.resultexp;
        }
    }

    private static class LocalCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private int cachesize = 100;

        private LocalCache(int cachesize) {
            this.cachesize = cachesize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.cachesize;
        }

        @Override
        public synchronized V put(K key, V value) {
            return super.put(key, value);
        }
    }
}

