/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.common.model.execution;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.occ.ocdpm.common.model.execution.AbstractExecution;
import kd.occ.ocdpm.common.model.execution.ExecutionInCache;
import kd.occ.ocdpm.common.model.execution.PromotionExecutionUnit;
import kd.occ.ocdpm.common.model.execution.impl.AddPresentExecution;
import kd.occ.ocdpm.common.model.execution.impl.EntryAmountDiffExecution;
import kd.occ.ocdpm.common.model.execution.impl.EntryPriceDiffExecution;
import kd.occ.ocdpm.common.model.execution.impl.OrderDiffExecution;

public class PromotionExecutionFactory {
    public static AbstractExecution createPromotionExecution(String type) {
        if ("addpresent".equals(type)) {
            return new AddPresentExecution();
        }
        if ("entryamountdiff".equals(type)) {
            return new EntryAmountDiffExecution();
        }
        if ("entrypricediff".equals(type)) {
            return new EntryPriceDiffExecution();
        }
        if ("orderdiff".equals(type)) {
            return new OrderDiffExecution();
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u7ed3\u679c\u7c7b\u578b\uff1a%s\u4e0d\u5408\u6cd5", (String)"PromotionExecutionFactory_2", (String)"occ-ocdpm-common", (Object[])new Object[0]), type));
    }

    public static AbstractExecution loadPromotionExecutionFromDB(DynamicObject executionobj) {
        AbstractExecution execution = PromotionExecutionFactory.createPromotionExecution(executionobj.getString("type"));
        execution.loadFromDymObj(executionobj);
        return execution;
    }

    public static AbstractExecution loadPromotionExecutionFromCache(ExecutionInCache cacheobj) {
        AbstractExecution execution = PromotionExecutionFactory.createPromotionExecution(cacheobj.getType());
        execution.loadFromCache(cacheobj);
        return execution;
    }

    public static PromotionExecutionUnit loadUnit(DynamicObject executionunit) {
        PromotionExecutionUnit u = new PromotionExecutionUnit();
        u.setId(executionunit.getPkValue());
        u.setIsused(executionunit.getBoolean("isused"));
        u.setGroupnumber(Character.valueOf(executionunit.getString("groupnumber").charAt(0)));
        for (DynamicObject executionobj : executionunit.getDynamicObjectCollection("entryentity")) {
            u.add(PromotionExecutionFactory.loadPromotionExecutionFromDB(executionobj));
        }
        return u;
    }
}

