/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.common.model.execution;

import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.occ.ocbase.common.model.PromotionOrder;
import kd.occ.ocdpm.common.model.execution.AbstractExecution;
import kd.occ.ocdpm.common.model.execution.IPromotionExecution;

public class PromotionExecutionUnit {
    private Object id;
    private List<AbstractExecution> executionlist;
    private boolean isused = false;
    private Character groupnumber = null;

    public PromotionExecutionUnit() {
        this.id = DBServiceHelper.genGlobalLongId();
        this.executionlist = new LinkedList<AbstractExecution>();
    }

    public List<AbstractExecution> getExecutionlist() {
        LinkedList<AbstractExecution> list = new LinkedList<AbstractExecution>();
        list.addAll(this.executionlist);
        return list;
    }

    public void setExecutionlist(List<AbstractExecution> executionlist) {
        LinkedList<AbstractExecution> list = new LinkedList<AbstractExecution>();
        list.addAll(executionlist);
        this.executionlist = list;
    }

    public boolean isIsused() {
        return this.isused;
    }

    public PromotionExecutionUnit(boolean isUsed) {
        this.isused = isUsed;
        this.executionlist = new LinkedList<AbstractExecution>();
    }

    public void add(AbstractExecution execution) {
        if (execution != null) {
            this.executionlist.add(execution);
        }
    }

    public void add(List<AbstractExecution> list) {
        if (list != null) {
            this.executionlist.addAll(list);
        }
    }

    public void putOnOrder(PromotionOrder order) {
        for (IPromotionExecution iPromotionExecution : this.executionlist) {
            iPromotionExecution.putOnOrder(order);
        }
    }

    public boolean isUsed() {
        return this.isused;
    }

    public void setIsused(boolean isUsed) {
        this.isused = isUsed;
    }

    public Character getGroupnumber() {
        return this.groupnumber;
    }

    public void setGroupnumber(Character groupnumber) {
        this.groupnumber = groupnumber;
    }

    public DynamicObject createExecution(Object policyid) {
        DynamicObject executionunit = BusinessDataServiceHelper.newDynamicObject((String)"dpm_execution");
        executionunit.set("id", this.id);
        executionunit.set("isused", (Object)this.isused);
        executionunit.set("groupnumber", (Object)this.groupnumber);
        executionunit.set("policy", (Object)BusinessDataServiceHelper.loadSingle((Object)policyid, (String)"dpm_policy", (String)"id,number"));
        DynamicObjectCollection col = executionunit.getDynamicObjectCollection("entryentity");
        for (AbstractExecution execution : this.executionlist) {
            execution.handleExecution(col.addNew());
        }
        return executionunit;
    }

    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = id;
    }

    private static class GroupNoGenerator {
        private char[] charset = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j'};
        private int index = -1;

        private GroupNoGenerator() {
        }

        public char generateGroupNo() {
            return this.charset[this.index++];
        }
    }
}

