/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.common.model.execution.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.occ.ocbase.common.enums.SaleOrderEntryType;
import kd.occ.ocbase.common.model.PromotionOrder;
import kd.occ.ocbase.common.model.PromotionOrderEntry;
import kd.occ.ocdpm.common.model.execution.AbstractExecution;

public class AddPresentExecution
extends AbstractExecution {
    public AddPresentExecution() {
        this.type = "addpresent";
        this.entryid = DBServiceHelper.genGlobalLongId();
    }

    @Override
    public void putOnOrder(PromotionOrder order) {
        PromotionOrderEntry entry = new PromotionOrderEntry();
        entry.setEntryid(this.entryid);
        entry.setItemid(this.itemid);
        entry.setUnitid(this.unitid);
        entry.setAttrid(this.attrid);
        entry.setIscombination(this.iscombination);
        entry.setIspresent(true);
        entry.setQty(this.qty);
        entry.setPsourceentryid((Object)this.sourceentryids);
        if (this.iscombination) {
            entry.setType(SaleOrderEntryType.COMBINATION);
            order.addEntry(entry);
            order.addEntrys(this.getCombinationDetail(this.qty, this.itemid, this.entryid, this.sourceentryids));
        } else {
            entry.setType(SaleOrderEntryType.COMMON);
            order.addEntry(entry);
        }
    }

    private List<PromotionOrderEntry> getCombinationDetail(BigDecimal qty, Object combinationid, Object sourcebillid, String sourceentryids) {
        ArrayList<PromotionOrderEntry> detailentry = new ArrayList<PromotionOrderEntry>();
        DynamicObject combination = BusinessDataServiceHelper.loadSingle((Object)combinationid, (String)"dpm_item_combination");
        for (DynamicObject detail : combination.getDynamicObjectCollection("itemdetail")) {
            PromotionOrderEntry entry = new PromotionOrderEntry();
            entry.setEntryid((Object)DBServiceHelper.genGlobalLongId());
            entry.setItemid(detail.getDynamicObject("item").getPkValue());
            entry.setUnitid(detail.getDynamicObject("unit").getPkValue());
            entry.setAttrid(detail.getDynamicObject("attr") == null ? Long.valueOf(0L) : detail.getDynamicObject("attr").getPkValue());
            entry.setIscombination(false);
            entry.setSourceentryid(sourcebillid);
            entry.setType(SaleOrderEntryType.COMBINATION_SON);
            entry.setIspresent(true);
            entry.setQty(qty.multiply(detail.getBigDecimal("qty")));
            entry.setPsourceentryid((Object)sourceentryids);
            detailentry.add(entry);
        }
        return detailentry;
    }
}

