/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.common.model.execution.impl;

import java.math.BigDecimal;
import java.util.List;
import kd.occ.ocbase.common.enums.SaleOrderEntryType;
import kd.occ.ocbase.common.model.PromotionOrder;
import kd.occ.ocbase.common.model.PromotionOrderEntry;
import kd.occ.ocdpm.common.PromotionOrderDivideUtil;
import kd.occ.ocdpm.common.model.execution.AbstractExecution;

public class EntryPriceDiffExecution
extends AbstractExecution {
    public EntryPriceDiffExecution() {
        this.type = "entrypricediff";
    }

    public EntryPriceDiffExecution(Object entryid, BigDecimal pricediff) {
        this();
        this.entryid = entryid;
        this.pricediff = pricediff;
    }

    @Override
    public void putOnOrder(PromotionOrder order) {
        for (PromotionOrderEntry entry : order.getEntries()) {
            if (!entry.getEntryid().equals(this.entryid)) continue;
            entry.setPrice(entry.getPrice().add(this.pricediff));
            BigDecimal amountdiff = this.pricediff.multiply(entry.getQty());
            if (SaleOrderEntryType.COMBINATION.getFlagStr().equals(entry.getType())) {
                List childentrys = order.getChildEntrysByEntryid(entry.getSourceentryid());
                PromotionOrderDivideUtil.divideEntrys(childentrys, entry.getAmount(), amountdiff);
            }
            if (SaleOrderEntryType.COMBINATION_SON.getFlagStr().equals(entry.getType())) {
                PromotionOrderEntry sourceentry = order.getEntryById(entry.getSourceentryid());
                sourceentry.setAmount(sourceentry.getAmount().add(amountdiff));
            }
            entry.setAmount(entry.getAmount().add(amountdiff));
            order.setTotalamount(order.getTotalamount().add(amountdiff));
        }
    }
}

