/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.common.model.result.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.occ.ocbase.common.model.DetailItemInfo;
import kd.occ.ocbase.common.model.PromotionOrder;
import kd.occ.ocbase.common.model.PromotionOrderEntry;
import kd.occ.ocdpm.common.CompareORCalculateUtil;
import kd.occ.ocdpm.common.model.condition.impl.AbstractCondition;
import kd.occ.ocdpm.common.model.execution.AbstractExecution;
import kd.occ.ocdpm.common.model.execution.impl.AddPresentExecution;
import kd.occ.ocdpm.common.model.result.AbstractResult;

public class PresentPromotionResult
extends AbstractResult {
    public static final String BATCHTYPE = "batchtype";
    public static final String ISBEYONDPART = "isbeyondpart";
    public static final String ISPRESENTSELF = "ispresentself";
    public static final String BATCHITEM = "batchitem";
    public static final String BATCHUNIT = "batchunit";
    public static final String BATCHATTR = "batchattr";
    public static final String BATCHQTY = "batchqty";
    public static final String BATCHSTANDARD = "batchstandard";
    public static final String BATCHITEMRANGE = "itemrange";
    public static final String ISRANGESPLIT = "israngesplit";
    public static final String PRESENTENTITY = "presententity";
    public static final String PRESENTITEM = "presentitem";
    public static final String PRESENTUNIT = "presentunit";
    public static final String PRESENTATTR = "presentattr";
    public static final String PRESENTQTY = "presentqty";
    public static final String PRESENTSELFQTY = "presentselfqty";
    public static final String JUDGESTANDARD = "judgestandard";

    public PresentPromotionResult(Object resultid, String resulttype) {
        super(resultid, resulttype);
    }

    @Override
    public List<AbstractExecution> calExecution(PromotionOrder order, AbstractCondition condition) {
        List<AbstractExecution> executions = this.calAddPresentExecutions(order, condition);
        if (executions != null && !executions.isEmpty()) {
            Iterator<AbstractExecution> it = executions.iterator();
            while (it.hasNext()) {
                AbstractExecution execution = it.next();
                if (execution.getQty().compareTo(BigDecimal.ZERO) > 0) continue;
                it.remove();
            }
        }
        return executions;
    }

    private List<AbstractExecution> calAddPresentExecutions(PromotionOrder order, AbstractCondition condition) {
        DynamicObject conditionobj = this.getConditionDyObj();
        if (this.isBatchRangeSplit() || this.isFirstConditionSplit(conditionobj)) {
            Map<DetailItemInfo, BigDecimal> rangemap = null;
            rangemap = this.isBatchRangeSplit() ? CompareORCalculateUtil.sumOrderByDetailItemFromItemRange(order.getEntries(), this.getItemRangeModel(), this.getResultModel().getString(BATCHSTANDARD)) : CompareORCalculateUtil.sumOrderByDetailItemFromItemRange(order.getEntries(), conditionobj.getDynamicObject(BATCHITEMRANGE), conditionobj.getString(JUDGESTANDARD));
            return this.calculateRangeSplit(rangemap, conditionobj, order.getEntries());
        }
        return this.calculate(order, conditionobj, condition);
    }

    private List<AbstractExecution> calculateRangeSplit(Map<DetailItemInfo, BigDecimal> rangemap, DynamicObject condition, List<PromotionOrderEntry> entrys) {
        ArrayList<AbstractExecution> executions = new ArrayList<AbstractExecution>(rangemap.size());
        boolean iscumulative = this.getResultModel().getBoolean("iscumulative");
        int mutiple = 1;
        String sourceentryids = "";
        for (Map.Entry<DetailItemInfo, BigDecimal> entry : rangemap.entrySet()) {
            DetailItemInfo item = entry.getKey();
            BigDecimal value = entry.getValue();
            if (iscumulative) {
                mutiple = this.calculateEntryMutiple(value, condition, this.getResultModel());
            }
            List<PromotionOrderEntry> newentrys = CompareORCalculateUtil.getEntrysEqualsItem(entrys, item.getItemid(), item.getUnitid(), item.getAttrid());
            sourceentryids = this.genSourceentryidsStr(newentrys);
            if (this.isPresentSelf()) {
                AddPresentExecution execution = this.genSelfPresentBase(item, mutiple, value, sourceentryids);
                if (execution == null) continue;
                executions.add(execution);
                continue;
            }
            executions.addAll(this.genOtherPresentBase(value, mutiple, sourceentryids));
        }
        return executions;
    }

    private String genSourceentryidsStr(List<PromotionOrderEntry> entrys) {
        StringBuilder psourcebillids = new StringBuilder();
        for (int i = 0; i < entrys.size(); ++i) {
            PromotionOrderEntry entry = entrys.get(i);
            psourcebillids.append(entry.getEntryid());
            if (i == entrys.size() - 1) continue;
            psourcebillids.append(',');
        }
        return psourcebillids.toString();
    }

    private List<AbstractExecution> calculate(PromotionOrder order, DynamicObject conditionobj, AbstractCondition condition) {
        List<AbstractExecution> executions = this.calculateMutiple(order, conditionobj, this.getResultModel());
        return executions;
    }

    private boolean isBatchRangeSplit() {
        return this.getResultModel().getBoolean(ISRANGESPLIT);
    }

    private List<AbstractExecution> calculateMutiple(PromotionOrder order, DynamicObject condition, DynamicObject result) {
        BigDecimal batchvalue = BigDecimal.ZERO;
        BigDecimal batchqty = result.getBigDecimal(BATCHQTY);
        int mutiple = -1;
        StringBuilder sourceentryids = new StringBuilder();
        if (this.isUseBatch()) {
            String batchtype;
            switch (batchtype = result.getDynamicObject(BATCHTYPE).getString("number")) {
                case "singleitem": {
                    DynamicObject unit = result.getDynamicObject(BATCHUNIT);
                    DynamicObject attr = result.getDynamicObject(BATCHATTR);
                    List<PromotionOrderEntry> entryseqitem = CompareORCalculateUtil.getEntrysEqualsItem(order.getEntries(), result.getDynamicObject(BATCHITEM).getPkValue(), unit == null ? Long.valueOf(0L) : unit.getPkValue(), attr == null ? Long.valueOf(0L) : attr.getPkValue());
                    for (PromotionOrderEntry entry : entryseqitem) {
                        sourceentryids.append(entry.getEntryid());
                        sourceentryids.append(',');
                    }
                    batchvalue = CompareORCalculateUtil.getQtyOrAmountSum(entryseqitem, result.getString(BATCHSTANDARD));
                    break;
                }
                case "itemrange": {
                    List<PromotionOrderEntry> entrysinrange = CompareORCalculateUtil.genEntrysInRange(order.getEntries(), this.getItemRangeModel());
                    for (PromotionOrderEntry entry : entrysinrange) {
                        sourceentryids.append(entry.getEntryid());
                        sourceentryids.append(',');
                    }
                    batchvalue = CompareORCalculateUtil.getQtyOrAmountSum(entrysinrange, result.getString(BATCHSTANDARD));
                    break;
                }
                case "wholeorder": {
                    batchvalue = CompareORCalculateUtil.getOrderQtyOrAmount(order, result.getString(BATCHSTANDARD));
                    for (PromotionOrderEntry entry : order.getEntries()) {
                        sourceentryids.append(entry.getEntryid());
                        sourceentryids.append(',');
                    }
                    break;
                }
            }
            if (this.isBeyondPart()) {
                BigDecimal judgevalue = condition.getBigDecimal("judgevalue");
                batchvalue = batchvalue.subtract(judgevalue);
            }
            if (batchqty.compareTo(BigDecimal.ZERO) > 0) {
                mutiple = batchvalue.divideToIntegralValue(batchqty).intValue();
            }
        } else {
            mutiple = 1;
        }
        mutiple = mutiple < 0 ? 0 : mutiple;
        int length = sourceentryids.length();
        if (length > 0) {
            sourceentryids = sourceentryids.delete(length - 1, length);
        }
        return this.genOtherPresentBase(batchvalue, mutiple, sourceentryids.toString());
    }

    private int calculateEntryMutiple(BigDecimal value, DynamicObject condition, DynamicObject result) {
        BigDecimal batchqty = result.getBigDecimal(BATCHQTY);
        int mutiple = -1;
        if (this.isUseBatch()) {
            if (this.isBeyondPart()) {
                BigDecimal judgevalue = condition.getBigDecimal("judgevalue");
                value = value.subtract(judgevalue);
            }
            if (batchqty.compareTo(BigDecimal.ZERO) > 0) {
                mutiple = value.divideToIntegralValue(batchqty).intValue();
            }
        } else {
            BigDecimal judgevalue = condition.getBigDecimal("judgevalue");
            mutiple = CompareORCalculateUtil.compareWithJudgeValue(value, judgevalue, condition.getInt("comparison")) ? 1 : 0;
        }
        return mutiple < 0 ? 0 : mutiple;
    }

    private boolean isUseBatch() {
        String batchtype = this.getResultModel().getString(BATCHTYPE);
        return batchtype != null && !batchtype.trim().isEmpty();
    }

    private boolean isPresentSelf() {
        return this.getResultModel().getBoolean(ISPRESENTSELF);
    }

    private boolean isBeyondPart() {
        return this.getResultModel().getBoolean(ISBEYONDPART);
    }

    private List<AbstractExecution> genOtherPresentBase(BigDecimal batchvalue, int multiple, String sourceentryids) {
        DynamicObjectCollection presents = this.getResultModel().getDynamicObjectCollection(PRESENTENTITY);
        ArrayList<AbstractExecution> executions = new ArrayList<AbstractExecution>();
        BigDecimal presentqty = BigDecimal.ZERO;
        boolean iscumulative = this.getResultModel().getBoolean("iscumulative");
        boolean isladder = this.getResultModel().getBoolean("isladder");
        boolean ismultistage = this.getResultModel().getBoolean("ismultistage");
        DynamicObject unit = null;
        DynamicObject attr = null;
        DynamicObject item = null;
        if (ismultistage) {
            HashMap iteminfos = new HashMap();
            String key = "";
            Map<BigDecimal, BigDecimal> presentrules = new HashMap();
            ArrayList<AddPresentExecution> abstractExecutions = new ArrayList<AddPresentExecution>();
            for (DynamicObject dynamicObject : presents) {
                unit = dynamicObject.getDynamicObject(PRESENTUNIT);
                attr = dynamicObject.getDynamicObject(PRESENTATTR);
                item = dynamicObject.getDynamicObject(PRESENTITEM);
                key = String.format("%s,%s,%s", item.getPkValue(), unit == null ? Long.valueOf(0L) : unit.getPkValue(), attr == null ? Long.valueOf(0L) : attr.getPkValue());
                presentrules = (Map)iteminfos.get(key);
                presentqty = dynamicObject.getBigDecimal(PRESENTQTY);
                if (presentrules == null) {
                    AddPresentExecution execution = new AddPresentExecution();
                    execution.setItemid(item.getPkValue());
                    execution.setUnitid(unit == null ? Long.valueOf(0L) : unit.getPkValue());
                    execution.setAttrid(attr == null ? Long.valueOf(0L) : attr.getPkValue());
                    execution.setIscombination(item.getBoolean("iscombination"));
                    execution.setSourceentryids(sourceentryids);
                    abstractExecutions.add(execution);
                    presentrules = new HashMap();
                }
                presentrules.put(dynamicObject.getBigDecimal("matchqty"), dynamicObject.getBigDecimal(PRESENTQTY));
                iteminfos.put(key, presentrules);
            }
            for (AbstractExecution abstractExecution : abstractExecutions) {
                key = String.format("%s,%s,%s", abstractExecution.getItemid(), abstractExecution.getUnitid(), abstractExecution.getAttrid());
                presentqty = this.calculateQty(batchvalue, (Map)iteminfos.get(key));
                if (presentqty.compareTo(BigDecimal.ZERO) <= 0) continue;
                abstractExecution.setQty(presentqty);
                executions.add(abstractExecution);
            }
        } else {
            BigDecimal startladderqty = BigDecimal.ZERO;
            BigDecimal endladderqty = BigDecimal.ZERO;
            for (DynamicObject entry : presents) {
                if (isladder) {
                    startladderqty = entry.getBigDecimal("startladderqty");
                    endladderqty = entry.getBigDecimal("endladderqty");
                    if (batchvalue.compareTo(startladderqty) < 0 || batchvalue.compareTo(endladderqty) > 0) continue;
                }
                AddPresentExecution execution = new AddPresentExecution();
                unit = entry.getDynamicObject(PRESENTUNIT);
                attr = entry.getDynamicObject(PRESENTATTR);
                item = entry.getDynamicObject(PRESENTITEM);
                execution.setItemid(item.getPkValue());
                execution.setUnitid(unit == null ? Long.valueOf(0L) : unit.getPkValue());
                execution.setAttrid(attr == null ? Long.valueOf(0L) : attr.getPkValue());
                presentqty = entry.getBigDecimal(PRESENTQTY);
                if (iscumulative) {
                    execution.setQty(presentqty.multiply(new BigDecimal(multiple)));
                } else {
                    execution.setQty(presentqty);
                }
                execution.setIscombination(item.getBoolean("iscombination"));
                execution.setSourceentryids(sourceentryids);
                executions.add(execution);
            }
        }
        return executions;
    }

    private BigDecimal calculateQty(BigDecimal batchvalue, Map<BigDecimal, BigDecimal> presentrules) {
        BigDecimal qty = BigDecimal.ZERO;
        try {
            BigDecimal batchqty = BigDecimal.ZERO;
            BigDecimal presentqty = BigDecimal.ZERO;
            BigDecimal mutiple = BigDecimal.ZERO;
            ArrayList<Map.Entry<BigDecimal, BigDecimal>> list = new ArrayList<Map.Entry<BigDecimal, BigDecimal>>(presentrules.entrySet());
            Collections.sort(list, new Comparator<Map.Entry<BigDecimal, BigDecimal>>(){

                @Override
                public int compare(Map.Entry<BigDecimal, BigDecimal> o1, Map.Entry<BigDecimal, BigDecimal> o2) {
                    return o2.getKey().compareTo(o1.getKey());
                }
            });
            for (Map.Entry entry : list) {
                if (batchvalue.compareTo(BigDecimal.ZERO) <= 0 || (mutiple = new BigDecimal(batchvalue.divideToIntegralValue(batchqty = (BigDecimal)entry.getKey()).intValue())).compareTo(BigDecimal.ZERO) <= 0) continue;
                presentqty = (BigDecimal)entry.getValue();
                qty = qty.add(presentqty.multiply(mutiple));
                batchvalue = batchvalue.subtract(mutiple.multiply(batchqty));
            }
        }
        catch (Exception e) {
            return qty;
        }
        return qty;
    }

    private AddPresentExecution genSelfPresentBase(DetailItemInfo info, int multiple, BigDecimal batchvalue, String sourceentryids) {
        DynamicObjectCollection presents = this.getResultModel().getDynamicObjectCollection(PRESENTENTITY);
        BigDecimal presentqty = BigDecimal.ZERO;
        boolean iscumulative = this.getResultModel().getBoolean("iscumulative");
        boolean isladder = this.getResultModel().getBoolean("isladder");
        boolean ismultistage = this.getResultModel().getBoolean("ismultistage");
        HashSet<DynamicObject> listpresents = new HashSet<DynamicObject>();
        if (ismultistage || isladder) {
            String ykey = info.getItemid().toString();
            Object pkvalue = "";
            DynamicObject item = null;
            for (DynamicObject present : presents) {
                item = present.getDynamicObject(PRESENTITEM);
                pkvalue = item.getPkValue().toString();
                if (ykey.compareTo((String)pkvalue) != 0) continue;
                listpresents.add(present);
            }
        }
        if (ismultistage) {
            HashMap<BigDecimal, BigDecimal> presentrules = new HashMap<BigDecimal, BigDecimal>(listpresents.size());
            for (DynamicObject present : listpresents) {
                presentrules.put(present.getBigDecimal("matchqty"), present.getBigDecimal(PRESENTQTY));
            }
            presentqty = this.calculateQty(batchvalue, presentrules);
        } else if (isladder) {
            BigDecimal startladderqty = BigDecimal.ZERO;
            BigDecimal endladderqty = BigDecimal.ZERO;
            for (DynamicObject entry : listpresents) {
                startladderqty = entry.getBigDecimal("startladderqty");
                endladderqty = entry.getBigDecimal("endladderqty");
                if (batchvalue.compareTo(startladderqty) < 0 || batchvalue.compareTo(endladderqty) > 0) continue;
                presentqty = entry.getBigDecimal(PRESENTQTY);
                break;
            }
        } else {
            presentqty = this.getResultModel().getBigDecimal(PRESENTSELFQTY);
            if (iscumulative) {
                presentqty = presentqty.multiply(new BigDecimal(multiple));
            }
        }
        if (presentqty.compareTo(BigDecimal.ZERO) > 0) {
            AddPresentExecution execution = new AddPresentExecution();
            execution.setItemid(info.getItemid());
            Object unitid = info.getUnitid();
            if (unitid == null || unitid.equals(0L)) {
                execution.setIscombination(true);
            }
            execution.setUnitid(info.getUnitid());
            execution.setAttrid(info.getAttrid());
            execution.setQty(presentqty);
            execution.setSourceentryids(sourceentryids);
            return execution;
        }
        return null;
    }

    private boolean isFirstConditionSplit(DynamicObject condition) {
        return condition != null && condition.getBoolean(ISRANGESPLIT);
    }
}

