/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.common.model.result.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.occ.ocbase.common.model.DetailItemInfo;
import kd.occ.ocbase.common.model.PromotionOrder;
import kd.occ.ocbase.common.model.PromotionOrderEntry;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocdpm.common.CompareORCalculateUtil;
import kd.occ.ocdpm.common.model.condition.impl.AbstractCondition;
import kd.occ.ocdpm.common.model.execution.AbstractExecution;
import kd.occ.ocdpm.common.model.execution.impl.EntryAmountDiffExecution;
import kd.occ.ocdpm.common.model.execution.impl.EntryPriceDiffExecution;
import kd.occ.ocdpm.common.model.result.AbstractResult;

public class RebatePromotionResult
extends AbstractResult {
    private Map<Long, List<DynamicObject>> itemClassIds = new HashMap<Long, List<DynamicObject>>();
    private Map<Long, List<DynamicObject>> itemBrandIds = new HashMap<Long, List<DynamicObject>>();
    private Map<DetailItemInfo, List<DynamicObject>> itemIds = new HashMap<DetailItemInfo, List<DynamicObject>>();

    public RebatePromotionResult(Object resultid, String resulttype) {
        super(resultid, resulttype);
    }

    @Override
    protected List<AbstractExecution> calExecution(PromotionOrder order, AbstractCondition condition) {
        ArrayList<AbstractExecution> executionUnit = new ArrayList<AbstractExecution>();
        ArrayList<PromotionOrderEntry> orderItems = new ArrayList<PromotionOrderEntry>();
        for (PromotionOrderEntry poe : order.getEntries()) {
            if (poe.isIspresent() && poe.getPrice().compareTo(BigDecimal.ZERO) == 0) continue;
            orderItems.add(poe);
        }
        String batchType = this.getResultModel().getDynamicObject("batchtype").getString("number");
        String judgeStandard = "";
        if (condition != null) {
            judgeStandard = condition.getConditionModel().getString("judgestandard");
        }
        switch (batchType) {
            case "itemrange": {
                this.parseReductionsContent();
                if (this.getResultModel().getBoolean("isactonsingleentry")) {
                    executionUnit.addAll(this.executePromotionOnSingleItemByActOnSingEntry(orderItems, judgeStandard));
                    break;
                }
                executionUnit.addAll(this.executePromotionOnSingleItemByActOnWholeEntry(orderItems, judgeStandard));
                break;
            }
            case "wholeorder": {
                executionUnit.addAll(this.executePromotionOnWoleOrder(orderItems, judgeStandard));
            }
        }
        return executionUnit;
    }

    private List<AbstractExecution> executePromotionOnSingleItemByActOnSingEntry(List<PromotionOrderEntry> orderItems, String judgeStandard) {
        ArrayList<AbstractExecution> list = new ArrayList<AbstractExecution>();
        boolean isladder = this.getResultModel().getBoolean("isladder");
        BigDecimal startladderqty = BigDecimal.ZERO;
        BigDecimal endladderqty = BigDecimal.ZERO;
        BigDecimal batchvalue = BigDecimal.ZERO;
        block0: for (PromotionOrderEntry promotionOrderEntry : orderItems) {
            List<DynamicObject> entryRule = this.getMatchItemRebateRate(promotionOrderEntry);
            if (entryRule == null) continue;
            if (isladder) {
                batchvalue = judgeStandard.isEmpty() ? promotionOrderEntry.getQtyOrAmount("qty") : promotionOrderEntry.getQtyOrAmount(judgeStandard);
                for (DynamicObject dynamicObject : entryRule) {
                    startladderqty = dynamicObject.getBigDecimal("startladderqty");
                    endladderqty = dynamicObject.getBigDecimal("endladderqty");
                    if (batchvalue.compareTo(startladderqty) < 0 || batchvalue.compareTo(endladderqty) > 0) continue;
                    BigDecimal rebateRate = dynamicObject.getBigDecimal("discountrate");
                    BigDecimal rate = rebateRate.divide(BigDecimal.valueOf(100L), 10, 1);
                    EntryPriceDiffExecution execution = new EntryPriceDiffExecution(promotionOrderEntry.getEntryid(), promotionOrderEntry.getPrice().multiply(rate).negate());
                    list.add(execution);
                    continue block0;
                }
                continue;
            }
            DynamicObject dynamicObject = entryRule.get(0);
            BigDecimal startOrderQty = dynamicObject.getBigDecimal("startorderqty");
            BigDecimal startOrderAmount = dynamicObject.getBigDecimal("startorderamount");
            if (BigDecimal.ZERO.compareTo(startOrderQty) != 0 && promotionOrderEntry.getQty().compareTo(startOrderQty) < 0 || BigDecimal.ZERO.compareTo(startOrderAmount) != 0 && promotionOrderEntry.getAmount().compareTo(startOrderAmount) < 0) continue;
            BigDecimal rebateRate = dynamicObject.getBigDecimal("discountrate");
            BigDecimal rate = rebateRate.divide(BigDecimal.valueOf(100L), 10, 1);
            BigDecimal rebateLoopQty = dynamicObject.getBigDecimal("loopqty");
            if (rebateLoopQty.compareTo(BigDecimal.ZERO) == 0) {
                EntryPriceDiffExecution execution = new EntryPriceDiffExecution(promotionOrderEntry.getEntryid(), promotionOrderEntry.getPrice().multiply(rate).negate());
                list.add(execution);
                continue;
            }
            BigDecimal loopTime = promotionOrderEntry.getQty().divide(rebateLoopQty, 0, 1);
            BigDecimal freeAmount = promotionOrderEntry.getPrice().multiply(rate).multiply(loopTime).negate();
            EntryAmountDiffExecution execution = new EntryAmountDiffExecution(promotionOrderEntry.getEntryid(), freeAmount);
            list.add(execution);
        }
        return list;
    }

    private List<AbstractExecution> executePromotionOnSingleItemByActOnWholeEntry(List<PromotionOrderEntry> orderItems, String judgeStandard) {
        HashMap combineOrders = new HashMap();
        for (PromotionOrderEntry promotionOrderEntry : orderItems) {
            DetailItemInfo itemInfo = promotionOrderEntry.getItemdetail();
            if (combineOrders.get(itemInfo) == null) {
                combineOrders.put(itemInfo, new ArrayList());
            }
            ((List)combineOrders.get(itemInfo)).add(promotionOrderEntry);
        }
        ArrayList<AbstractExecution> executionUnit = new ArrayList<AbstractExecution>();
        BigDecimal totalQty = BigDecimal.ZERO;
        boolean isladder = this.getResultModel().getBoolean("isladder");
        BigDecimal startladderqty = BigDecimal.ZERO;
        BigDecimal endladderqty = BigDecimal.ZERO;
        block1: for (Map.Entry entry : combineOrders.entrySet()) {
            List entries = (List)entry.getValue();
            List<DynamicObject> entryRule = this.getMatchItemRebateRate((PromotionOrderEntry)entries.get(0));
            if (entryRule == null) continue;
            if (isladder) {
                BigDecimal batchvalue = BigDecimal.ZERO;
                batchvalue = judgeStandard.isEmpty() ? CompareORCalculateUtil.getQtyOrAmountSum(entries, "qty") : CompareORCalculateUtil.getQtyOrAmountSum(entries, judgeStandard);
                for (DynamicObject dynamicObject : entryRule) {
                    startladderqty = dynamicObject.getBigDecimal("startladderqty");
                    endladderqty = dynamicObject.getBigDecimal("endladderqty");
                    if (batchvalue.compareTo(startladderqty) < 0 || batchvalue.compareTo(endladderqty) > 0) continue;
                    BigDecimal rebateRate = dynamicObject.getBigDecimal("discountrate");
                    BigDecimal rate = rebateRate.divide(BigDecimal.valueOf(100L), 10, 1);
                    for (PromotionOrderEntry poe : entries) {
                        EntryPriceDiffExecution execution = new EntryPriceDiffExecution(poe.getEntryid(), poe.getPrice().multiply(rate).negate());
                        executionUnit.add(execution);
                    }
                    continue block1;
                }
                continue;
            }
            DynamicObject dynamicObject = entryRule.get(0);
            BigDecimal startOrderQty = dynamicObject.getBigDecimal("startorderqty");
            BigDecimal startOrderAmount = dynamicObject.getBigDecimal("startorderamount");
            totalQty = BigDecimal.ZERO;
            BigDecimal totalAmount = BigDecimal.ZERO;
            for (PromotionOrderEntry poe : entries) {
                totalQty = totalQty.add(poe.getQty());
                totalAmount = totalAmount.add(poe.getAmount());
            }
            if (BigDecimal.ZERO.compareTo(startOrderQty) != 0 && totalQty.compareTo(startOrderQty) < 0 || BigDecimal.ZERO.compareTo(startOrderAmount) != 0 && totalAmount.compareTo(startOrderAmount) < 0) continue;
            BigDecimal rebateRate = dynamicObject.getBigDecimal("discountrate");
            BigDecimal rate = rebateRate.divide(BigDecimal.valueOf(100L), 10, 1);
            for (PromotionOrderEntry poe : entries) {
                EntryPriceDiffExecution execution = new EntryPriceDiffExecution(poe.getEntryid(), poe.getPrice().multiply(rate).negate());
                executionUnit.add(execution);
            }
        }
        return executionUnit;
    }

    private List<AbstractExecution> executePromotionOnWoleOrder(List<PromotionOrderEntry> orderItems, String judgeStandard) {
        int size = orderItems.size();
        ArrayList<AbstractExecution> executionUnit = new ArrayList<AbstractExecution>(size);
        DynamicObject resultInfo = this.getResultModel();
        boolean isladder = resultInfo.getBoolean("isladder");
        if (isladder) {
            DynamicObjectCollection rangeList = resultInfo.getDynamicObjectCollection("entryentity");
            BigDecimal batchvalue = BigDecimal.ZERO;
            BigDecimal startladderqty = BigDecimal.ZERO;
            BigDecimal endladderqty = BigDecimal.ZERO;
            batchvalue = judgeStandard.isEmpty() ? CompareORCalculateUtil.getQtyOrAmountSum(orderItems, "qty") : CompareORCalculateUtil.getQtyOrAmountSum(orderItems, judgeStandard);
            for (DynamicObject range : rangeList) {
                startladderqty = range.getBigDecimal("startladderqty");
                endladderqty = range.getBigDecimal("endladderqty");
                if (batchvalue.compareTo(startladderqty) < 0 || batchvalue.compareTo(endladderqty) > 0) continue;
                BigDecimal rebateRate = range.getBigDecimal("discountrate");
                BigDecimal rate = rebateRate.divide(BigDecimal.valueOf(100L), 10, 1);
                for (PromotionOrderEntry poe : orderItems) {
                    EntryPriceDiffExecution execution = new EntryPriceDiffExecution(poe.getEntryid(), poe.getPrice().multiply(rate).negate());
                    executionUnit.add(execution);
                }
                break;
            }
        } else {
            BigDecimal wholeRebateRate = resultInfo.getBigDecimal("wholediscountrate");
            BigDecimal rate = wholeRebateRate.divide(BigDecimal.valueOf(100L), 10, 1);
            for (PromotionOrderEntry entry : orderItems) {
                EntryPriceDiffExecution execution = new EntryPriceDiffExecution(entry.getEntryid(), entry.getPrice().multiply(rate).negate());
                executionUnit.add(execution);
            }
        }
        return executionUnit;
    }

    private void parseReductionsContent() {
        DynamicObject resultInfo = this.getResultModel();
        DynamicObjectCollection rangeList = resultInfo.getDynamicObjectCollection("entryentity");
        List<DynamicObject> listRange = null;
        long idkey = 0L;
        for (int i = 0; i < rangeList.size(); ++i) {
            DynamicObject range = (DynamicObject)rangeList.get(i);
            DynamicObject itemclass = range.getDynamicObject("itemclass");
            DynamicObject itembrand = range.getDynamicObject("itembrand");
            DynamicObject item = range.getDynamicObject("item");
            if (item != null && (Long)item.getPkValue() != 0L) {
                DynamicObject attr;
                DetailItemInfo itemInfo = new DetailItemInfo();
                itemInfo.setItemid(item.getPkValue());
                DynamicObject unit = range.getDynamicObject("unit");
                if (unit != null) {
                    itemInfo.setUnitid(unit.getPkValue());
                }
                if ((attr = range.getDynamicObject("attr")) != null) {
                    itemInfo.setAttrid(attr.getPkValue());
                }
                if ((listRange = this.itemIds.get(itemInfo)) == null) {
                    listRange = new ArrayList<DynamicObject>();
                }
                listRange.add(range);
                this.itemIds.put(itemInfo, listRange);
            }
            if (itembrand != null && (Long)itembrand.getPkValue() != 0L) {
                idkey = itembrand.getLong("id");
                listRange = this.itemIds.get(idkey);
                if (listRange == null) {
                    listRange = new ArrayList<DynamicObject>();
                }
                listRange.add(range);
                this.itemBrandIds.put(idkey, listRange);
            }
            if (itemclass == null || (Long)itemclass.getPkValue() == 0L) continue;
            idkey = itemclass.getLong("id");
            listRange = this.itemIds.get(idkey);
            if (listRange == null) {
                listRange = new ArrayList<DynamicObject>();
            }
            listRange.add(range);
            this.itemClassIds.put(idkey, listRange);
        }
    }

    private List<DynamicObject> getMatchItemRebateRate(PromotionOrderEntry matchItem) {
        DetailItemInfo matchItemInfo = matchItem.getItemdetail();
        List<DynamicObject> listRange = this.itemIds.get(matchItemInfo);
        if (listRange != null) {
            return listRange;
        }
        if (matchItem.isIscombination()) {
            return null;
        }
        DynamicObject item = BusinessDataServiceHelper.loadSingle((Object)matchItem.getItemid(), (String)"ocdbd_iteminfo");
        DynamicObjectCollection brands = item.getDynamicObjectCollection("itembrands");
        for (DynamicObject brand : brands) {
            listRange = this.itemBrandIds.get(brand.get("fbasedataid.id"));
            if (listRange == null) continue;
            return listRange;
        }
        DynamicObjectCollection itemClassColl = item.getDynamicObjectCollection("itemclassentity");
        if (!CommonUtils.isNull((Object)itemClassColl)) {
            ArrayList<Long> itemClassIdList = new ArrayList<Long>(itemClassColl.size());
            Long itemClassId = 0L;
            for (DynamicObject itemclass : itemClassColl) {
                itemClassId = itemclass.getLong("goodsclasssid_id");
                listRange = this.itemClassIds.get(itemClassId);
                if (listRange != null) {
                    return listRange;
                }
                itemClassIdList.add(itemClassId);
            }
            DynamicObject[] itemclassObjs = BusinessDataServiceHelper.load((Object[])itemClassIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"mdr_item_class"));
            List<DynamicObject> ranges = null;
            for (DynamicObject itemclassObj : itemclassObjs) {
                for (DynamicObject parentClass = itemclassObj.getDynamicObject("parent"); parentClass != null; parentClass = (DynamicObject)parentClass.getParent()) {
                    ranges = this.itemClassIds.get(parentClass.getPkValue());
                    if (ranges == null) continue;
                    return ranges;
                }
            }
        }
        return null;
    }
}

