/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.common.model.result.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.occ.ocbase.common.model.DetailItemInfo;
import kd.occ.ocbase.common.model.PromotionOrder;
import kd.occ.ocbase.common.model.PromotionOrderEntry;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocdpm.common.CompareORCalculateUtil;
import kd.occ.ocdpm.common.model.condition.impl.AbstractCondition;
import kd.occ.ocdpm.common.model.execution.AbstractExecution;
import kd.occ.ocdpm.common.model.execution.impl.EntryAmountDiffExecution;
import kd.occ.ocdpm.common.model.execution.impl.EntryPriceDiffExecution;
import kd.occ.ocdpm.common.model.execution.impl.OrderDiffExecution;
import kd.occ.ocdpm.common.model.result.AbstractResult;

public class ReductionsPromotionResult
extends AbstractResult {
    private Map<Long, List<DynamicObject>> itemClassIds = new HashMap<Long, List<DynamicObject>>();
    private Map<Long, List<DynamicObject>> itemBrandIds = new HashMap<Long, List<DynamicObject>>();
    private Map<DetailItemInfo, List<DynamicObject>> itemIds = new HashMap<DetailItemInfo, List<DynamicObject>>();
    private int amtprecision = 2;

    public ReductionsPromotionResult(Object resultid, String resulttype) {
        super(resultid, resulttype);
    }

    @Override
    protected List<AbstractExecution> calExecution(PromotionOrder order, AbstractCondition condition) {
        ArrayList<AbstractExecution> executionUnit = new ArrayList<AbstractExecution>();
        ArrayList<PromotionOrderEntry> orderItems = new ArrayList<PromotionOrderEntry>();
        for (PromotionOrderEntry poe : order.getEntries()) {
            if (poe.isIspresent() && poe.getPrice().compareTo(BigDecimal.ZERO) == 0) continue;
            orderItems.add(poe);
        }
        DynamicObject resultInfo = this.getResultModel();
        String batchType = resultInfo.getDynamicObject("batchtype").getString("number");
        String judgeStandard = "";
        if (condition != null) {
            judgeStandard = condition.getConditionModel().getString("judgestandard");
        }
        switch (batchType) {
            case "itemrange": {
                this.parseReductionsContent();
                if (resultInfo.getBoolean("isactonsingleentry")) {
                    executionUnit.addAll(this.executePromotionOnSingleItemByActOnSingEntry(order, orderItems, judgeStandard));
                    break;
                }
                executionUnit.addAll(this.executePromotionOnSingleItemByActOnWholeEntry(order, orderItems, judgeStandard));
                break;
            }
            case "wholeorder": {
                executionUnit.addAll(this.executePromotionOnWoleOrder(order, orderItems, judgeStandard));
            }
        }
        return executionUnit;
    }

    private List<AbstractExecution> executePromotionOnSingleItemByActOnSingEntry(PromotionOrder order, List<PromotionOrderEntry> orderItems, String judgeStandard) {
        ArrayList<AbstractExecution> executionUnit = new ArrayList<AbstractExecution>();
        DynamicObject resultInfo = this.getResultModel();
        String reductionType = resultInfo.getString("reductiontype");
        boolean isfullreduction = resultInfo.getBoolean("isfullreduction");
        boolean isladder = resultInfo.getBoolean("isladder");
        BigDecimal amount = BigDecimal.ZERO;
        block0: for (PromotionOrderEntry promotionOrderEntry : orderItems) {
            AbstractExecution execution;
            List<DynamicObject> entrys = this.getMatchItemReductionAmount(promotionOrderEntry);
            if (entrys == null) continue;
            if (isladder) {
                BigDecimal startladderqty = BigDecimal.ZERO;
                BigDecimal endladderqty = BigDecimal.ZERO;
                BigDecimal batchvalue = BigDecimal.ZERO;
                batchvalue = judgeStandard.isEmpty() ? promotionOrderEntry.getQtyOrAmount("qty") : promotionOrderEntry.getQtyOrAmount(judgeStandard);
                for (DynamicObject entry : entrys) {
                    startladderqty = entry.getBigDecimal("startladderqty");
                    endladderqty = entry.getBigDecimal("endladderqty");
                    if (batchvalue.compareTo(startladderqty) < 0 || batchvalue.compareTo(endladderqty) > 0) continue;
                    if ("reduceamount".equals(reductionType)) {
                        amount = entry.getBigDecimal("reductionamount");
                        execution = new EntryAmountDiffExecution(promotionOrderEntry.getEntryid(), amount.negate());
                        executionUnit.add(execution);
                        continue block0;
                    }
                    if (!"reduceprice".equals(reductionType)) continue block0;
                    amount = entry.getBigDecimal("reductionprice");
                    execution = new EntryPriceDiffExecution(promotionOrderEntry.getEntryid(), amount.negate());
                    executionUnit.add(execution);
                    continue block0;
                }
                continue;
            }
            DynamicObject entry = entrys.get(0);
            BigDecimal startOrderQty = entry.getBigDecimal("startorderqty");
            BigDecimal startOrderAmount = entry.getBigDecimal("startorderamount");
            BigDecimal entryQty = promotionOrderEntry.getQty();
            BigDecimal entryAmount = promotionOrderEntry.getAmount();
            if (BigDecimal.ZERO.compareTo(startOrderQty) != 0 && entryQty.compareTo(startOrderQty) < 0 || BigDecimal.ZERO.compareTo(startOrderAmount) != 0 && entryAmount.compareTo(startOrderAmount) < 0) continue;
            if ("reduceamount".equals(reductionType)) {
                amount = entry.getBigDecimal("reductionamount");
                if (isfullreduction) {
                    BigDecimal mutiple = BigDecimal.ZERO;
                    if (startOrderAmount.compareTo(BigDecimal.ZERO) > 0) {
                        mutiple = new BigDecimal(entryAmount.divideToIntegralValue(startOrderAmount).intValue());
                    } else if (startOrderQty.compareTo(BigDecimal.ZERO) > 0) {
                        mutiple = new BigDecimal(entryQty.divideToIntegralValue(startOrderQty).intValue());
                    }
                    if (mutiple.compareTo(BigDecimal.ZERO) <= 0) continue;
                    amount = amount.multiply(mutiple).setScale(this.amtprecision, 1);
                }
                execution = new EntryAmountDiffExecution(promotionOrderEntry.getEntryid(), amount.negate());
                executionUnit.add(execution);
                continue;
            }
            if (!"reduceprice".equals(reductionType)) continue;
            amount = entry.getBigDecimal("reductionprice");
            execution = new EntryPriceDiffExecution(promotionOrderEntry.getEntryid(), amount.negate());
            executionUnit.add(execution);
        }
        return executionUnit;
    }

    private List<AbstractExecution> executePromotionOnSingleItemByActOnWholeEntry(PromotionOrder order, List<PromotionOrderEntry> orderItems, String judgeStandard) {
        HashMap combineOrders = new HashMap();
        DynamicObject resultInfo = this.getResultModel();
        String reductionType = resultInfo.getString("reductiontype");
        for (PromotionOrderEntry promotionOrderEntry : orderItems) {
            DetailItemInfo itemInfo = promotionOrderEntry.getItemdetail();
            if (combineOrders.get(itemInfo) == null) {
                combineOrders.put(itemInfo, new ArrayList());
            }
            ((List)combineOrders.get(itemInfo)).add(promotionOrderEntry);
        }
        ArrayList<AbstractExecution> executionUnit = new ArrayList<AbstractExecution>();
        boolean isfullreduction = resultInfo.getBoolean("isfullreduction");
        boolean isladder = this.getResultModel().getBoolean("isladder");
        BigDecimal totalQty = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal startladderqty = BigDecimal.ZERO;
        BigDecimal endladderqty = BigDecimal.ZERO;
        BigDecimal maxAmount = BigDecimal.ZERO;
        Object maxAmountEntryId = null;
        BigDecimal amount = BigDecimal.ZERO;
        block1: for (Map.Entry entry : combineOrders.entrySet()) {
            EntryPriceDiffExecution execution;
            EntryAmountDiffExecution execution2;
            EntryAmountDiffExecution execution3;
            BigDecimal reductionAmount;
            BigDecimal rate;
            Object totalFreeAmount;
            List entries = (List)entry.getValue();
            List<DynamicObject> entryRules = this.getMatchItemReductionAmount((PromotionOrderEntry)entries.get(0));
            if (entryRules == null) continue;
            if (isladder) {
                Object poe2;
                totalQty = BigDecimal.ZERO;
                totalAmount = BigDecimal.ZERO;
                maxAmount = BigDecimal.ZERO;
                maxAmountEntryId = null;
                for (Object poe2 : entries) {
                    if (maxAmount.compareTo(poe2.getAmount()) <= 0) {
                        maxAmount = poe2.getAmount();
                        maxAmountEntryId = poe2.getEntryid();
                    }
                    totalQty = totalQty.add(poe2.getQty());
                    totalAmount = totalAmount.add(poe2.getAmount());
                }
                BigDecimal batchvalue = BigDecimal.ZERO;
                batchvalue = !judgeStandard.isEmpty() && judgeStandard.compareTo("amount") == 0 ? totalAmount : totalQty;
                poe2 = entryRules.iterator();
                while (poe2.hasNext()) {
                    DynamicObject dynamicObject = (DynamicObject)poe2.next();
                    startladderqty = dynamicObject.getBigDecimal("startladderqty");
                    endladderqty = dynamicObject.getBigDecimal("endladderqty");
                    if (batchvalue.compareTo(startladderqty) < 0 || batchvalue.compareTo(endladderqty) > 0) continue;
                    if ("reduceamount".equals(reductionType)) {
                        amount = dynamicObject.getBigDecimal("reductionamount");
                        totalFreeAmount = amount;
                        for (PromotionOrderEntry promotionOrderEntry : entries) {
                            if (promotionOrderEntry.getEntryid().equals(maxAmountEntryId)) continue;
                            rate = promotionOrderEntry.getAmount().divide(totalAmount, 10, 1);
                            reductionAmount = amount.multiply(rate).setScale(this.amtprecision, 1);
                            totalFreeAmount = ((BigDecimal)totalFreeAmount).subtract(reductionAmount);
                            execution3 = new EntryAmountDiffExecution(promotionOrderEntry.getEntryid(), reductionAmount.negate());
                            executionUnit.add(execution3);
                        }
                        execution2 = new EntryAmountDiffExecution(maxAmountEntryId, ((BigDecimal)totalFreeAmount).negate());
                        executionUnit.add(execution2);
                        continue block1;
                    }
                    if (!"reduceprice".equals(reductionType)) continue block1;
                    for (PromotionOrderEntry promotionOrderEntry : entries) {
                        amount = dynamicObject.getBigDecimal("reductionprice");
                        execution = new EntryPriceDiffExecution(promotionOrderEntry.getEntryid(), amount.negate());
                        executionUnit.add(execution);
                    }
                    continue block1;
                }
                continue;
            }
            DynamicObject entryRule = entryRules.get(0);
            BigDecimal startOrderQty = entryRule.getBigDecimal("startorderqty");
            BigDecimal startOrderAmount = entryRule.getBigDecimal("startorderamount");
            totalQty = BigDecimal.ZERO;
            totalAmount = BigDecimal.ZERO;
            maxAmount = BigDecimal.ZERO;
            maxAmountEntryId = null;
            for (Object poe : entries) {
                if (maxAmount.compareTo(poe.getAmount()) <= 0) {
                    maxAmount = poe.getAmount();
                    maxAmountEntryId = poe.getEntryid();
                }
                totalQty = totalQty.add(poe.getQty());
                totalAmount = totalAmount.add(poe.getAmount());
            }
            if (BigDecimal.ZERO.compareTo(startOrderQty) != 0 && totalQty.compareTo(startOrderQty) < 0 || BigDecimal.ZERO.compareTo(startOrderAmount) != 0 && totalAmount.compareTo(startOrderAmount) < 0) continue;
            if ("reduceamount".equals(reductionType)) {
                Object poe;
                amount = entryRule.getBigDecimal("reductionamount");
                if (isfullreduction) {
                    BigDecimal mutiple = BigDecimal.ZERO;
                    if (startOrderAmount.compareTo(BigDecimal.ZERO) > 0) {
                        mutiple = new BigDecimal(totalAmount.divideToIntegralValue(startOrderAmount).intValue());
                    } else if (startOrderQty.compareTo(BigDecimal.ZERO) > 0) {
                        mutiple = new BigDecimal(totalQty.divideToIntegralValue(startOrderQty).intValue());
                    }
                    if (mutiple.compareTo(BigDecimal.ZERO) <= 0) continue;
                    amount = amount.multiply(mutiple).setScale(this.amtprecision, 1);
                }
                totalFreeAmount = amount;
                poe = entries.iterator();
                while (poe.hasNext()) {
                    PromotionOrderEntry promotionOrderEntry;
                    promotionOrderEntry = (PromotionOrderEntry)poe.next();
                    if (promotionOrderEntry.getEntryid().equals(maxAmountEntryId)) continue;
                    rate = promotionOrderEntry.getAmount().divide(totalAmount, 10, 1);
                    reductionAmount = amount.multiply(rate).setScale(this.amtprecision, 1);
                    totalFreeAmount = ((BigDecimal)totalFreeAmount).subtract(reductionAmount);
                    execution3 = new EntryAmountDiffExecution(promotionOrderEntry.getEntryid(), reductionAmount.negate());
                    executionUnit.add(execution3);
                }
                execution2 = new EntryAmountDiffExecution(maxAmountEntryId, ((BigDecimal)totalFreeAmount).negate());
                executionUnit.add(execution2);
                continue;
            }
            if (!"reduceprice".equals(reductionType)) continue;
            amount = entryRule.getBigDecimal("reductionprice");
            for (PromotionOrderEntry promotionOrderEntry : entries) {
                execution = new EntryPriceDiffExecution(promotionOrderEntry.getEntryid(), amount.negate());
                executionUnit.add(execution);
            }
        }
        return executionUnit;
    }

    private List<AbstractExecution> executePromotionOnWoleOrder(PromotionOrder order, List<PromotionOrderEntry> orderItems, String judgeStandard) {
        ArrayList<AbstractExecution> executionUnit;
        block11: {
            String reductionType;
            DynamicObject resultInfo;
            block13: {
                block12: {
                    executionUnit = new ArrayList<AbstractExecution>();
                    resultInfo = this.getResultModel();
                    boolean isladder = resultInfo.getBoolean("isladder");
                    reductionType = resultInfo.getString("reductiontype");
                    if (!isladder) break block12;
                    DynamicObjectCollection rangeList = resultInfo.getDynamicObjectCollection("entryentity");
                    BigDecimal startladderqty = BigDecimal.ZERO;
                    BigDecimal endladderqty = BigDecimal.ZERO;
                    BigDecimal batchvalue = BigDecimal.ZERO;
                    batchvalue = judgeStandard.isEmpty() ? CompareORCalculateUtil.getQtyOrAmountSum(orderItems, "qty") : CompareORCalculateUtil.getQtyOrAmountSum(orderItems, judgeStandard);
                    for (DynamicObject range : rangeList) {
                        startladderqty = range.getBigDecimal("startladderqty");
                        endladderqty = range.getBigDecimal("endladderqty");
                        if (batchvalue.compareTo(startladderqty) < 0 || batchvalue.compareTo(endladderqty) > 0) continue;
                        if ("reduceamount".equals(reductionType)) {
                            OrderDiffExecution execution = new OrderDiffExecution(range.getBigDecimal("reductionamount").negate());
                            execution.setSourceentryids(this.genSourceentryidsStr(orderItems));
                            executionUnit.add(execution);
                        } else {
                            BigDecimal reductionprice = range.getBigDecimal("reductionprice");
                            for (int i = 0; i < orderItems.size(); ++i) {
                                PromotionOrderEntry entry = orderItems.get(i);
                                EntryPriceDiffExecution execution = new EntryPriceDiffExecution(entry.getEntryid(), reductionprice.negate());
                                executionUnit.add(execution);
                            }
                        }
                        break block11;
                    }
                    break block11;
                }
                if (!"reduceamount".equals(reductionType)) break block13;
                BigDecimal wholeReductionsAmount = resultInfo.getBigDecimal("wholereductionamount");
                if (resultInfo.getBoolean("isfullreduction")) {
                    String fullreductiontype = resultInfo.getString("fullreductiontype");
                    BigDecimal fullimpairment = resultInfo.getBigDecimal("fullimpairment");
                    BigDecimal mutiple = BigDecimal.ZERO;
                    if ("amount".equals(fullreductiontype)) {
                        BigDecimal totalamount = order.getTotalamount();
                        mutiple = new BigDecimal(totalamount.divideToIntegralValue(fullimpairment).intValue());
                    } else if ("qty".equals(fullreductiontype)) {
                        BigDecimal totalqty = order.getTotalqty();
                        mutiple = new BigDecimal(totalqty.divideToIntegralValue(fullimpairment).intValue());
                    }
                    if (mutiple.compareTo(BigDecimal.ZERO) > 0) {
                        wholeReductionsAmount = wholeReductionsAmount.multiply(mutiple).setScale(this.amtprecision, 1);
                    } else {
                        return executionUnit;
                    }
                }
                OrderDiffExecution execution = new OrderDiffExecution(wholeReductionsAmount.negate());
                execution.setSourceentryids(this.genSourceentryidsStr(orderItems));
                executionUnit.add(execution);
                break block11;
            }
            if (!"reduceprice".equals(reductionType)) break block11;
            BigDecimal wholeReductionsPrice = resultInfo.getBigDecimal("wholereductionprice");
            for (int i = 0; i < orderItems.size(); ++i) {
                PromotionOrderEntry entry = orderItems.get(i);
                EntryPriceDiffExecution execution = new EntryPriceDiffExecution(entry.getEntryid(), wholeReductionsPrice.negate());
                executionUnit.add(execution);
            }
        }
        return executionUnit;
    }

    private String genSourceentryidsStr(List<PromotionOrderEntry> entrys) {
        StringBuilder psourcebillids = new StringBuilder();
        for (int i = 0; i < entrys.size(); ++i) {
            PromotionOrderEntry entry = entrys.get(i);
            psourcebillids.append(entry.getEntryid());
            if (i == entrys.size() - 1) continue;
            psourcebillids.append(',');
        }
        return psourcebillids.toString();
    }

    private void parseReductionsContent() {
        DynamicObject resultInfo = this.getResultModel();
        DynamicObjectCollection rangeList = resultInfo.getDynamicObjectCollection("entryentity");
        List<DynamicObject> listRange = null;
        long idkey = 0L;
        for (int i = 0; i < rangeList.size(); ++i) {
            DynamicObject range = (DynamicObject)rangeList.get(i);
            DynamicObject itemclass = range.getDynamicObject("itemclass");
            DynamicObject itembrand = range.getDynamicObject("itembrand");
            DynamicObject item = range.getDynamicObject("item");
            if (item != null && (Long)item.getPkValue() != 0L) {
                DynamicObject attr;
                DetailItemInfo itemInfo = new DetailItemInfo();
                itemInfo.setItemid(item.getPkValue());
                DynamicObject unit = range.getDynamicObject("unit");
                if (unit != null) {
                    itemInfo.setUnitid(unit.getPkValue());
                }
                if ((attr = range.getDynamicObject("attr")) != null) {
                    itemInfo.setAttrid(attr.getPkValue());
                }
                if ((listRange = this.itemIds.get(itemInfo)) == null) {
                    listRange = new ArrayList<DynamicObject>();
                }
                listRange.add(range);
                this.itemIds.put(itemInfo, listRange);
            }
            if (itembrand != null && (Long)itembrand.getPkValue() != 0L) {
                idkey = itembrand.getLong("id");
                listRange = this.itemIds.get(idkey);
                if (listRange == null) {
                    listRange = new ArrayList<DynamicObject>();
                }
                listRange.add(range);
                this.itemBrandIds.put(idkey, listRange);
            }
            if (itemclass == null || (Long)itemclass.getPkValue() == 0L) continue;
            idkey = itemclass.getLong("id");
            listRange = this.itemIds.get(idkey);
            if (listRange == null) {
                listRange = new ArrayList<DynamicObject>();
            }
            listRange.add(range);
            this.itemClassIds.put(idkey, listRange);
        }
    }

    private List<DynamicObject> getMatchItemReductionAmount(PromotionOrderEntry matchItem) {
        DetailItemInfo matchItemInfo = matchItem.getItemdetail();
        List<DynamicObject> listRange = this.itemIds.get(matchItemInfo);
        if (listRange != null) {
            return listRange;
        }
        if (matchItem.isIscombination()) {
            return null;
        }
        DynamicObject item = BusinessDataServiceHelper.loadSingle((Object)matchItem.getItemid(), (String)"ocdbd_iteminfo");
        DynamicObjectCollection brands = item.getDynamicObjectCollection("itembrands");
        for (DynamicObject brand : brands) {
            listRange = this.itemBrandIds.get(brand.get("fbasedataid.id"));
            if (listRange == null) continue;
            return listRange;
        }
        DynamicObjectCollection itemClassColl = item.getDynamicObjectCollection("itemclassentity");
        if (!CommonUtils.isNull((Object)itemClassColl)) {
            ArrayList<Long> itemClassIdList = new ArrayList<Long>(itemClassColl.size());
            Long itemClassId = 0L;
            for (DynamicObject itemclass : itemClassColl) {
                itemClassId = itemclass.getLong("goodsclasssid_id");
                listRange = this.itemClassIds.get(itemClassId);
                if (listRange != null) {
                    return listRange;
                }
                itemClassIdList.add(itemClassId);
            }
            DynamicObject[] itemclassObjs = BusinessDataServiceHelper.load((Object[])itemClassIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"mdr_item_class"));
            List<DynamicObject> ranges = null;
            for (DynamicObject itemclassObj : itemclassObjs) {
                for (DynamicObject parentClass = itemclassObj.getDynamicObject("parent"); parentClass != null; parentClass = (DynamicObject)parentClass.getParent()) {
                    ranges = this.itemClassIds.get(parentClass.getPkValue());
                    if (ranges == null) continue;
                    return ranges;
                }
            }
        }
        return null;
    }
}

