/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.common.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.fs.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CommonUtil {
    private static final Log logger = LogFactory.getLog(CommonUtil.class);

    public static <T> List<T> castList(Object obj, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        if (obj instanceof List) {
            for (Object o : (List)obj) {
                result.add(clazz.cast(o));
            }
            return result;
        }
        return null;
    }

    public static Map<String, Object> objectToMap(Object obj) {
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (key.compareToIgnoreCase("class") == 0) continue;
                Method getter = property.getReadMethod();
                Object value = getter != null ? getter.invoke(obj, new Object[0]) : null;
                map.put(key, value);
            }
        }
        catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            logger.info(e.getMessage());
        }
        return map;
    }

    public static boolean isPkValueEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        boolean result = true;
        if (obj instanceof Long) {
            long value = Long.parseLong(obj.toString());
            result = value != 0L;
        } else if (obj instanceof String) {
            result = ((String)obj).trim().isEmpty();
        }
        return result;
    }

    public static boolean listIsEmpty(List<?> obj) {
        return obj == null || obj.size() == 0;
    }

    public static long getPkValue(DynamicObject object, String colSign) {
        if (object != null) {
            DynamicObject colObj = object.getDynamicObject(colSign);
            String pkValueStr = colObj == null ? "0" : colObj.getPkValue().toString();
            return Long.parseLong(pkValueStr);
        }
        return 0L;
    }

    public static DynamicObject getUserInfo(Object userId) {
        return BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user");
    }

    public static DynamicObject getLoginUser() {
        return CommonUtil.getUserInfo(RequestContext.get().getUserId());
    }

    public static int isInPriceDetailList(DynamicObject obj, DynamicObjectCollection priceDetails, Boolean flag) {
        int target = -1;
        Object itemPK = null;
        Object item = null;
        Object barcodePK = null;
        Object barcode = null;
        Long unitPK = null;
        Long unit = null;
        if (flag.booleanValue()) {
            itemPK = obj.getDynamicObject("itempk").getPkValue();
            barcodePK = obj.getDynamicObject("barcodepk").getPkValue();
            unitPK = obj.getDynamicObject("unit") == null ? Long.valueOf(0L) : obj.getDynamicObject("unit").getPkValue();
            for (int i = 0; i < priceDetails.size(); ++i) {
                item = ((DynamicObject)priceDetails.get(i)).getDynamicObject("item").getPkValue();
                barcode = ((DynamicObject)priceDetails.get(i)).getDynamicObject("barcode").getPkValue();
                Long l = unit = ((DynamicObject)priceDetails.get(i)).getDynamicObject("priceunit") == null ? Long.valueOf(0L) : ((DynamicObject)priceDetails.get(i)).getDynamicObject("priceunit").getPkValue();
                if (!itemPK.equals(item) || !barcode.equals(barcodePK) || !((Object)unit).equals(unitPK)) continue;
                target = i;
                break;
            }
        } else {
            itemPK = obj.getDynamicObject("item").getPkValue();
            barcodePK = obj.getDynamicObject("barcode").getPkValue();
            unitPK = obj.getDynamicObject("priceunit") == null ? Long.valueOf(0L) : obj.getDynamicObject("priceunit").getPkValue();
            for (int i = 0; i < priceDetails.size(); ++i) {
                item = ((DynamicObject)priceDetails.get(i)).getDynamicObject("itempk").getPkValue();
                barcode = ((DynamicObject)priceDetails.get(i)).getDynamicObject("barcodepk").getPkValue();
                Long l = unit = ((DynamicObject)priceDetails.get(i)).getDynamicObject("unit") == null ? Long.valueOf(0L) : ((DynamicObject)priceDetails.get(i)).getDynamicObject("unit").getPkValue();
                if (!itemPK.equals(item) || !barcode.equals(barcodePK) || !((Object)unit).equals(unitPK)) continue;
                target = i;
                break;
            }
        }
        return target;
    }

    public static List<String> checkBox(DynamicObject object, String[] checkBoxes) {
        ArrayList<String> list = new ArrayList<String>(10);
        for (String box : checkBoxes) {
            if (!object.getBoolean(box)) continue;
            list.add(box);
        }
        return list;
    }

    public static Date stringToDateformat(String date) {
        Date formatDate = null;
        try {
            if (StringUtils.isNotEmpty((String)date)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                formatDate = sdf.parse(date);
            }
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
        }
        return formatDate;
    }
}

