/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PriceTypeUtil {
    private static String[] priceTypes = null;
    private static final String[] PRICE_TYPE_CHECKS = new String[]{"rpcheckbox", "fpcheckbox", "upcheckbox", "mpcheckbox", "spcheckbox", "p1checkbox", "p2checkbox", "p3checkbox", "p4checkbox", "p5checkbox"};
    private static final List<String> PRICE_FIELDS = Arrays.asList("A", "B", "C", "D", "E", "F", "G", "H", "I", "J");

    public static List<DynamicObject> getEnableRetailPriceTypeList() {
        Map<Object, DynamicObject> priceTypesFromCache = PriceTypeUtil.getPriceTypesFromCache();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(priceTypesFromCache.size());
        for (Map.Entry<Object, DynamicObject> entry : priceTypesFromCache.entrySet()) {
            list.add(entry.getValue());
        }
        return list;
    }

    public static String[] getPriceTypeByCheckBox(String checkBox) {
        switch (checkBox) {
            case "rpcheckbox": {
                priceTypes = new String[]{"retailprice", "retailvalue", "oldretail"};
                break;
            }
            case "fpcheckbox": {
                priceTypes = new String[]{"factoryprice", "factoryvalue", "oldfactory"};
                break;
            }
            case "upcheckbox": {
                priceTypes = new String[]{"uniqueprice", "uniquevalue", "oldunique"};
                break;
            }
            case "mpcheckbox": {
                priceTypes = new String[]{"memberprice", "retailvalue", "oldretail"};
                break;
            }
            case "spcheckbox": {
                priceTypes = new String[]{"specialprice", "specialvalue", "oldspecial"};
                break;
            }
            case "p1checkbox": {
                priceTypes = new String[]{"price1", "value1", "oldvalue1"};
                break;
            }
            case "p2checkbox": {
                priceTypes = new String[]{"price2", "value2", "oldvalue2"};
                break;
            }
            case "p3checkbox": {
                priceTypes = new String[]{"price3", "value3", "oldvalue3"};
                break;
            }
            case "p4checkbox": {
                priceTypes = new String[]{"price4", "value4", "oldvalue4"};
                break;
            }
            case "p5checkbox": {
                priceTypes = new String[]{"price5", "value5", "oldvalue5"};
                break;
            }
        }
        return priceTypes;
    }

    public static String getCheckBoxByEnum(String enumValue) {
        String checkBox = null;
        switch (enumValue) {
            case "A": {
                checkBox = "rpcheckbox";
                break;
            }
            case "B": {
                checkBox = "fpcheckbox";
                break;
            }
            case "C": {
                checkBox = "upcheckbox";
                break;
            }
            case "D": {
                checkBox = "mpcheckbox";
                break;
            }
            case "E": {
                checkBox = "spcheckbox";
                break;
            }
            case "F": {
                checkBox = "p1checkbox";
                break;
            }
            case "G": {
                checkBox = "p2checkbox";
                break;
            }
            case "H": {
                checkBox = "p3checkbox";
                break;
            }
            case "I": {
                checkBox = "p4checkbox";
                break;
            }
            case "J": {
                checkBox = "p5checkbox";
                break;
            }
        }
        return checkBox;
    }

    public static String getEnumByPriceType(String priceType) {
        String checkBox = null;
        switch (priceType) {
            case "retailprice": {
                checkBox = "A";
                break;
            }
            case "factoryprice": {
                checkBox = "B";
                break;
            }
            case "uniqueprice": {
                checkBox = "C";
                break;
            }
            case "memberprice": {
                checkBox = "D";
                break;
            }
            case "specialprice": {
                checkBox = "E";
                break;
            }
            case "price1": {
                checkBox = "F";
                break;
            }
            case "price2": {
                checkBox = "G";
                break;
            }
            case "price3": {
                checkBox = "H";
                break;
            }
            case "price4": {
                checkBox = "I";
                break;
            }
            case "price5": {
                checkBox = "J";
                break;
            }
        }
        return checkBox;
    }

    public static String getAdjustNumByPriceType(String priceType) {
        String adjustNum = null;
        switch (priceType) {
            case "retailprice": {
                adjustNum = "rpadjustnum";
                break;
            }
            case "factoryprice": {
                adjustNum = "fpadjustnum";
                break;
            }
            case "uniqueprice": {
                adjustNum = "upadjustnum";
                break;
            }
            case "memberprice": {
                adjustNum = "mpadjustnum";
                break;
            }
            case "specialprice": {
                adjustNum = "spadjustnum";
                break;
            }
            case "price1": {
                adjustNum = "p1adjustnum";
                break;
            }
            case "price2": {
                adjustNum = "p2adjustnum";
                break;
            }
            case "price3": {
                adjustNum = "p3adjustnum";
                break;
            }
            case "price4": {
                adjustNum = "p4adjustnum";
                break;
            }
            case "price5": {
                adjustNum = "p5adjustnum";
                break;
            }
        }
        return adjustNum;
    }

    private static Map<String, DynamicObject> transPriceTypesFromCache() {
        Map<Object, DynamicObject> objectDynamicObjectMap = PriceTypeUtil.getPriceTypesFromCache();
        HashMap<String, DynamicObject> priceMaps = new HashMap<String, DynamicObject>(10);
        String priceField = null;
        String[] priceTypeByCheckBox = null;
        for (Map.Entry<Object, DynamicObject> entry : objectDynamicObjectMap.entrySet()) {
            priceField = entry.getValue().getString("pricefield");
            priceTypeByCheckBox = PriceTypeUtil.getPriceTypeByCheckBox(PriceTypeUtil.getCheckBoxByEnum(priceField));
            if (priceTypeByCheckBox == null || priceTypeByCheckBox.length <= 0) continue;
            priceMaps.put(priceTypeByCheckBox[0], entry.getValue());
        }
        return priceMaps;
    }

    private static Map<Object, DynamicObject> getPriceTypesFromCache() {
        QFilter filter = new QFilter("pricefield", "in", PRICE_FIELDS);
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"ocdpm_retailpricetype", (QFilter[])new QFilter[]{filter});
        return objectDynamicObjectMap;
    }

    public static Map<String, DynamicObject> getPriceMap() {
        return PriceTypeUtil.transPriceTypesFromCache();
    }

    public static String getNameByPriceType(String priceType) {
        String priceName = null;
        switch (priceType) {
            case "retailprice": {
                priceName = ResManager.loadKDString((String)"\u6807\u51c6\u96f6\u552e\u4ef7", (String)"PriceTypeUtil_0", (String)"occ-ocdpm-common", (Object[])new Object[0]);
                break;
            }
            case "factoryprice": {
                priceName = ResManager.loadKDString((String)"\u5382\u5bb6\u63a7\u4ef7", (String)"PriceTypeUtil_1", (String)"occ-ocdpm-common", (Object[])new Object[0]);
                break;
            }
            case "uniqueprice": {
                priceName = ResManager.loadKDString((String)"\u552f\u4e00\u4ef7", (String)"PriceTypeUtil_2", (String)"occ-ocdpm-common", (Object[])new Object[0]);
                break;
            }
            case "memberprice": {
                priceName = ResManager.loadKDString((String)"\u4f1a\u5458\u4ef7", (String)"PriceTypeUtil_3", (String)"occ-ocdpm-common", (Object[])new Object[0]);
                break;
            }
            case "specialprice": {
                priceName = ResManager.loadKDString((String)"\u7279\u4ef7", (String)"PriceTypeUtil_4", (String)"occ-ocdpm-common", (Object[])new Object[0]);
                break;
            }
            case "price1": {
                priceName = ResManager.loadKDString((String)"\u9884\u7559\u4ef7\u683c1", (String)"PriceTypeUtil_5", (String)"occ-ocdpm-common", (Object[])new Object[0]);
                break;
            }
            case "price2": {
                priceName = ResManager.loadKDString((String)"\u9884\u7559\u4ef7\u683c2", (String)"PriceTypeUtil_6", (String)"occ-ocdpm-common", (Object[])new Object[0]);
                break;
            }
            case "price3": {
                priceName = ResManager.loadKDString((String)"\u9884\u7559\u4ef7\u683c3", (String)"PriceTypeUtil_7", (String)"occ-ocdpm-common", (Object[])new Object[0]);
                break;
            }
            case "price4": {
                priceName = ResManager.loadKDString((String)"\u9884\u7559\u4ef7\u683c4", (String)"PriceTypeUtil_8", (String)"occ-ocdpm-common", (Object[])new Object[0]);
                break;
            }
            case "price5": {
                priceName = ResManager.loadKDString((String)"\u9884\u7559\u4ef7\u683c5", (String)"PriceTypeUtil_9", (String)"occ-ocdpm-common", (Object[])new Object[0]);
                break;
            }
        }
        return priceName;
    }

    public static String getPriceTypeByProp(String property) {
        String prop = null;
        switch (property) {
            case "retailvalue": {
                prop = "retailprice";
                break;
            }
            case "rvadjustnum": {
                prop = "rpadjustnum";
                break;
            }
            case "factoryvalue": {
                prop = "factoryprice";
                break;
            }
            case "fvadjustnum": {
                prop = "fpadjustnum";
                break;
            }
            case "uniquevalue": {
                prop = "uniqueprice";
                break;
            }
            case "uvadjustnum": {
                prop = "upadjustnum";
                break;
            }
            case "membervalue": {
                prop = "memberprice";
                break;
            }
            case "mvadjustnum": {
                prop = "mpadjustnum";
                break;
            }
            case "specialvalue": {
                prop = "specialprice";
                break;
            }
            case "svadjustnum": {
                prop = "spadjustnum";
                break;
            }
            case "highvalue": {
                prop = "highprice";
                break;
            }
            case "lowvalue": {
                prop = "lowprice";
                break;
            }
            case "value1": {
                prop = "price1";
                break;
            }
            case "v1adjustnum": {
                prop = "p1adjustnum";
                break;
            }
            case "value2": {
                prop = "price2";
                break;
            }
            case "v2adjustnum": {
                prop = "p2adjustnum";
                break;
            }
            case "value3": {
                prop = "price3";
                break;
            }
            case "v3adjustnum": {
                prop = "p3adjustnum";
                break;
            }
            case "value4": {
                prop = "price4";
                break;
            }
            case "v4adjustnum": {
                prop = "p4adjustnum";
                break;
            }
            case "value5": {
                prop = "price5";
                break;
            }
            case "v5adjustnum": {
                prop = "p5adjustnum";
                break;
            }
            case "isenable": {
                prop = "priceisinvalid";
                break;
            }
            case "disopdate": {
                prop = "disableopdate";
                break;
            }
            case "disoper": {
                prop = "disabloper";
                break;
            }
        }
        return prop;
    }

    public static List<String> getCurrentPriceType(DynamicObject object) {
        ArrayList<String> list = new ArrayList<String>(10);
        for (String checkBox : PRICE_TYPE_CHECKS) {
            String[] priceType;
            if (!object.getBoolean(checkBox) || (priceType = PriceTypeUtil.getPriceTypeByCheckBox(checkBox)) == null || priceType.length <= 0) continue;
            String priceTypeByCheckBox = priceType[0];
            list.add(priceTypeByCheckBox);
        }
        return list;
    }

    public static List<String> getCurrentCheckBox(DynamicObject object) {
        ArrayList<String> list = new ArrayList<String>(10);
        for (String checkBox : PRICE_TYPE_CHECKS) {
            if (!object.getBoolean(checkBox)) continue;
            list.add(checkBox);
        }
        return list;
    }
}

