/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.business.Handler;

import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DBServiceHelper;

public class PricePolicyUpgradeHandler {
    private DBRoute drpDBRoute;

    private DBRoute getDRPDBRoute() {
        if (this.drpDBRoute == null) {
            this.drpDBRoute = DBRoute.of((String)"occ");
        }
        return this.drpDBRoute;
    }

    private boolean isExitData() {
        DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"occ"), (String)"SELECT COUNT(FISUPGRADE) FROM  T_MDR_PRICEPOLICY WHERE FISUPGRADE =0 ");
        if (dataSet.hasNext()) {
            int count = dataSet.next().getInteger(0);
            dataSet.close();
            if (count > 0) {
                return false;
            }
        }
        return true;
    }

    private int getpricePolicyCount() {
        DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"occ"), (String)"SELECT COUNT(FNUMBER) FROM  T_DPM_PRICEPOLICY ");
        if (dataSet.hasNext()) {
            int count = dataSet.next().getInteger(0);
            dataSet.close();
            if (count > 0) {
                return count + 1;
            }
        }
        return 1;
    }

    public void upgrade() {
        if (this.isExitData()) {
            return;
        }
        List<Map<Object, Object>> pricePolicyInfos = null;
        int count = this.getpricePolicyCount();
        for (int i = 1; i < 4; ++i) {
            pricePolicyInfos = this.getPricePolicyInfo(i);
            if (CollectionUtils.isEmpty(pricePolicyInfos)) continue;
            count = this.updatePricePolicy(pricePolicyInfos, count);
        }
        String sql = "UPDATE T_MDR_PRICEPOLICY SET FISUPGRADE =1 ";
        DB.execute((DBRoute)this.getDRPDBRoute(), (String)sql);
    }

    private List<Map<Object, Object>> getPricePolicyInfo(int grouping) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT T1.FID,T1.FSTATUS,T1.FCREATORID,T1.FCREATETIME,T1.FMODIFIERID,T1.FENABLE,T1.FMODIFYTIME,T1.FMASTERID,T1.FOWNER,T1.FCUSTOMER,T1.FGROUPID,T1.FPRIORITY,T1.FITEM,T2.FMATERIAL,T1.FUNIT,T1.FQTYFROM,T1.FQTYTO,T1.FPRICE,T1.FLOWESTPRICE,T1.FBEGINDATE,T1.FENDDATE,T1.FASSISTATTR ");
        sql.append("FROM T_MDR_PRICEPOLICY T1  ");
        sql.append("INNER JOIN T_MDR_ITEM T2 ON T1.FITEM = T2.FID ");
        switch (grouping) {
            case 1: {
                sql.append("WHERE T1.FCUSTOMER = 0  AND T1.FGROUPID=0 AND T1.FISUPGRADE =0  ORDER BY FOWNER ");
                break;
            }
            case 2: {
                sql.append("WHERE T1.FCUSTOMER > 0  AND T1.FGROUPID=0 AND T1.FISUPGRADE =0 ORDER BY FOWNER,FCUSTOMER ");
                break;
            }
            case 3: {
                sql.append("WHERE T1.FCUSTOMER = 0  AND T1.FGROUPID>0 AND T1.FISUPGRADE =0  ORDER BY FOWNER,FGROUPID ");
                break;
            }
            default: {
                return null;
            }
        }
        return (List)DB.query((DBRoute)this.getDRPDBRoute(), (String)sql.toString(), (ResultSetHandler)new ResultSetHandler<List<Map<Object, Object>>>(){

            public List<Map<Object, Object>> handle(ResultSet rs) throws Exception {
                if (rs == null) {
                    return new ArrayList<Map<Object, Object>>(0);
                }
                ArrayList<Map<Object, Object>> results = new ArrayList<Map<Object, Object>>(rs.getRow());
                HashMap<String, Object> result = null;
                while (rs.next()) {
                    result = new HashMap<String, Object>(24);
                    result.put("FID", rs.getObject("FID"));
                    result.put("FSTATUS", rs.getObject("FSTATUS"));
                    result.put("FCREATORID", rs.getObject("FCREATORID"));
                    result.put("FCREATETIME", rs.getObject("FCREATETIME"));
                    result.put("FMODIFIERID", rs.getObject("FMODIFIERID"));
                    result.put("FENABLE", rs.getObject("FENABLE"));
                    result.put("FMODIFYTIME", rs.getObject("FMODIFYTIME"));
                    result.put("FMASTERID", rs.getObject("FMASTERID"));
                    result.put("FOWNER", rs.getObject("FOWNER"));
                    result.put("FCUSTOMER", rs.getObject("FCUSTOMER"));
                    result.put("FGROUPID", rs.getObject("FGROUPID"));
                    result.put("FPRIORITY", rs.getObject("FPRIORITY"));
                    result.put("FITEM", rs.getObject("FITEM"));
                    result.put("FMATERIAL", rs.getObject("FMATERIAL"));
                    result.put("FUNIT", rs.getObject("FUNIT"));
                    result.put("FQTYFROM", rs.getObject("FQTYFROM"));
                    result.put("FQTYTO", rs.getObject("FQTYTO"));
                    result.put("FPRICE", rs.getObject("FPRICE"));
                    result.put("FLOWESTPRICE", rs.getObject("FLOWESTPRICE"));
                    result.put("FBEGINDATE", rs.getObject("FBEGINDATE"));
                    result.put("FENDDATE", rs.getObject("FENDDATE"));
                    result.put("FASSISTATTR", rs.getObject("FASSISTATTR"));
                    results.add(result);
                }
                return results;
            }
        });
    }

    private int updatePricePolicy(List<Map<Object, Object>> pricePolicyInfos, int count) {
        if (pricePolicyInfos.isEmpty()) {
            return count;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO T_DPM_PRICEPOLICY(FID,FNUMBER,FOWNERID,FSTATUS,FCREATORID,FMODIFIERID,FENABLE,FCREATETIME,FMODIFYTIME,FMASTERID,FCURRENCYID,");
        sql.append("FPRICETYPEID,FBUSINESSTYPEID,FGOODSBRANDID,FCUSTOMERRANGE,FAUDITDATE,FREMARK,FBEGINDATE,FENDDATE) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ");
        StringBuilder sql_l = new StringBuilder();
        sql_l.append("INSERT INTO T_DPM_PRICEPOLICY_L(FID,FPKID,FLocaleID,FNAME) VALUES(?,?,?,?) ");
        StringBuilder ksql = new StringBuilder();
        ksql.append("INSERT INTO T_DPM_CUSTOMERSCOPE (FID,FENTRYID,FSEQ,FCUSTOMERID,FCUSTOMERGROUPID,FPROVINCEID,FCITYID,FAREAID,FISDEFAULT) ");
        ksql.append("VALUES(?,?,?,?,?,?,?,?,?) ");
        StringBuilder esql = new StringBuilder();
        esql.append("INSERT INTO T_DPM_PRICEPOLICYENTRY (FID,FENTRYID,FSEQ,FITEMID,FMATERIALID,FUNITID,FGOODSBRANDID,FITEMCLASSID,FSALEATTRID,FINVTYPEID,FASSISTATTRID,FFLEXAUXPROPID, ");
        esql.append("FDISCOUNTWAY,FBEGINDATE,FENDDATE,FQTYFROM,FQTYTO,FPRICE,FLOWESTPRICE,FDISCOUNT,FENABLE) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        ArrayList<Object[]> paramsList_L = new ArrayList<Object[]>();
        ArrayList<Object[]> kParamsList = new ArrayList<Object[]>();
        ArrayList<Object[]> eParamsList = new ArrayList<Object[]>(pricePolicyInfos.size());
        String oldkey = "";
        String skey = "";
        long fid = 0L;
        long customerid = 0L;
        long groupid = 0L;
        int seq = 1;
        long customerEntryid = 0L;
        long priceentryid = 0L;
        int size = 0;
        int priceSize = 0;
        int customerSize = 0;
        long[] pkFIds = DBServiceHelper.genLongIds((String)"T_DPM_PRICEPOLICY", (int)pricePolicyInfos.size());
        long[] pkIds = DBServiceHelper.genLongIds((String)"T_DPM_PRICEPOLICYENTRY", (int)pricePolicyInfos.size());
        long[] customerPkIds = DBServiceHelper.genLongIds((String)"T_DPM_CUSTOMERSCOPE", (int)pricePolicyInfos.size());
        String[] basePkIds = DBServiceHelper.genStringIds((String)"T_DPM_PRICEPOLICY_L", (int)pricePolicyInfos.size());
        int customerrange = 67;
        Date minbegindate = null;
        Date maxenddate = null;
        List<Object> headerValueList = null;
        for (Map<Object, Object> pricePolicyInfo : pricePolicyInfos) {
            Object ownerid = pricePolicyInfo.get("FOWNER");
            customerid = Long.parseLong(pricePolicyInfo.get("FCUSTOMER").toString());
            groupid = Long.parseLong(pricePolicyInfo.get("FGROUPID").toString());
            skey = String.format("%s_%s_%s", ownerid, customerid, groupid);
            if (oldkey.compareTo(skey) != 0) {
                seq = 1;
                oldkey = skey;
                fid = pkFIds[size];
                if (customerid != groupid) {
                    customerEntryid = customerPkIds[customerSize];
                    ++customerSize;
                    kParamsList.add(this.getCustomerInfo(pricePolicyInfo, fid, customerEntryid).toArray());
                    customerrange = customerid != 0L ? 65 : 66;
                }
                if (headerValueList != null) {
                    headerValueList.add(minbegindate);
                    headerValueList.add(maxenddate);
                    paramsList.add(headerValueList.toArray());
                }
                minbegindate = (Date)pricePolicyInfo.get("FBEGINDATE");
                maxenddate = (Date)pricePolicyInfo.get("FENDDATE");
                headerValueList = this.getBaseInfo(pricePolicyInfo, fid, count, (char)customerrange);
                paramsList_L.add(this.getBaseLInfo(fid, basePkIds[size], count).toArray());
                ++size;
                ++count;
            } else {
                if (minbegindate != null && minbegindate.compareTo((Date)pricePolicyInfo.get("FBEGINDATE")) > 0) {
                    minbegindate = (Date)pricePolicyInfo.get("FBEGINDATE");
                }
                if (maxenddate != null && maxenddate.compareTo((Date)pricePolicyInfo.get("FENDDATE")) < 0) {
                    maxenddate = (Date)pricePolicyInfo.get("FENDDATE");
                }
            }
            priceentryid = pkIds[priceSize];
            eParamsList.add(this.getPriceInfo(pricePolicyInfo, fid, priceentryid, seq).toArray());
            ++priceSize;
            ++seq;
        }
        if (headerValueList != null) {
            headerValueList.add(minbegindate);
            headerValueList.add(maxenddate);
            paramsList.add(headerValueList.toArray());
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                DB.executeBatch((DBRoute)this.getDRPDBRoute(), (String)sql.toString(), paramsList);
                DB.executeBatch((DBRoute)this.getDRPDBRoute(), (String)sql_l.toString(), paramsList_L);
                if (kParamsList.size() > 0) {
                    DB.executeBatch((DBRoute)this.getDRPDBRoute(), (String)ksql.toString(), kParamsList);
                }
                DB.executeBatch((DBRoute)this.getDRPDBRoute(), (String)esql.toString(), eParamsList);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        return count;
    }

    private List<Object> getBaseInfo(Map<Object, Object> pricePolicyInfo, long fid, int number, char customerrange) {
        ArrayList<Object> dataValueList = new ArrayList<Object>(19);
        long zero = 0L;
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String name = String.format("CP%s%s", format.format(new Date()), number);
        dataValueList.add(fid);
        dataValueList.add(name);
        dataValueList.add(Long.valueOf(pricePolicyInfo.get("FOWNER").toString()));
        dataValueList.add(Character.valueOf('C'));
        dataValueList.add(pricePolicyInfo.get("FCREATORID"));
        dataValueList.add(pricePolicyInfo.get("FMODIFIERID"));
        dataValueList.add(Character.valueOf('1'));
        dataValueList.add(pricePolicyInfo.get("FCREATETIME"));
        dataValueList.add(pricePolicyInfo.get("FMODIFYTIME"));
        dataValueList.add(pricePolicyInfo.get("FMASTERID"));
        dataValueList.add(1L);
        dataValueList.add(zero);
        dataValueList.add(960049153897982976L);
        dataValueList.add(zero);
        dataValueList.add(Character.valueOf(customerrange));
        dataValueList.add(pricePolicyInfo.get("FMODIFYTIME"));
        dataValueList.add(" ");
        return dataValueList;
    }

    private List<Object> getBaseLInfo(long fid, String pkid, int number) {
        ArrayList<Object> dataValueList = new ArrayList<Object>(20);
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String name = String.format("CP%s%s", format.format(new Date()), number);
        dataValueList.add(fid);
        dataValueList.add(pkid);
        dataValueList.add("zh_CN");
        dataValueList.add(name);
        return dataValueList;
    }

    private List<Object> getCustomerInfo(Map<Object, Object> pricePolicyInfo, long fid, long entryid) {
        ArrayList<Object> dataValueList = new ArrayList<Object>(9);
        long zero = 0L;
        dataValueList.add(fid);
        dataValueList.add(entryid);
        dataValueList.add(1L);
        dataValueList.add(Long.valueOf(pricePolicyInfo.get("FCUSTOMER").toString()));
        dataValueList.add(Long.valueOf(pricePolicyInfo.get("FGROUPID").toString()));
        dataValueList.add(zero);
        dataValueList.add(zero);
        dataValueList.add(zero);
        dataValueList.add(Character.valueOf('0'));
        return dataValueList;
    }

    private List<Object> getPriceInfo(Map<Object, Object> pricePolicyInfo, long fid, long priceentryid, int seq) {
        ArrayList<Object> dataValueList = new ArrayList<Object>(20);
        long zero = 0L;
        dataValueList.add(fid);
        dataValueList.add(priceentryid);
        dataValueList.add(seq);
        dataValueList.add(pricePolicyInfo.get("FITEM"));
        dataValueList.add(pricePolicyInfo.get("FMATERIAL"));
        dataValueList.add(pricePolicyInfo.get("FUNIT"));
        dataValueList.add(zero);
        dataValueList.add(zero);
        dataValueList.add(zero);
        dataValueList.add(zero);
        dataValueList.add(pricePolicyInfo.get("FASSISTATTR"));
        dataValueList.add(zero);
        dataValueList.add(" ");
        dataValueList.add(pricePolicyInfo.get("FBEGINDATE"));
        dataValueList.add(pricePolicyInfo.get("FENDDATE"));
        dataValueList.add(pricePolicyInfo.get("FQTYFROM"));
        dataValueList.add(pricePolicyInfo.get("FQTYTO"));
        dataValueList.add(pricePolicyInfo.get("FPRICE"));
        dataValueList.add(pricePolicyInfo.get("FLOWESTPRICE"));
        dataValueList.add(zero);
        if (pricePolicyInfo.get("FSTATUS").toString().compareTo("C") == 0) {
            dataValueList.add(pricePolicyInfo.get("FENABLE"));
        } else {
            dataValueList.add(Character.valueOf('0'));
        }
        return dataValueList;
    }
}

