/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.business.promote.helper;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;

public class AutoBindHelper {
    public static void initpage(IDataModel model, long pkid) {
        QFilter filter = new QFilter("promotebillid", "=", (Object)pkid);
        DynamicObject[] rules = BusinessDataServiceHelper.load((String)"ocdpm_promote_rule", (String)AutoBindHelper.getFeilds(), (QFilter[])filter.toArray(), (String)"seqno");
        int size = rules[0].getDynamicObjectCollection("giftitementry").size();
        model.setValue("bindpickqty", rules[0].get("bindpickqty"));
        model.setValue("bindreduceamount", rules[0].get("bindreduceamount"));
        model.setValue("itemgroup", rules[0].get("itemgroup"));
        if (size > 0) {
            DynamicObjectCollection ruleentrys = model.getEntryEntity("ruleentry");
            ruleentrys.clear();
            for (DynamicObject rule : rules) {
                DynamicObject entry = new DynamicObject(ruleentrys.getDynamicObjectType());
                entry.set("groupseqno", rule.get("groupseqno"));
                entry.set("sumitemqty", rule.get("sumitemqty"));
                entry.set("pickqty", rule.get("pickqty"));
                AutoBindHelper.fillSubEntry(rule, entry);
                ruleentrys.add((Object)entry);
            }
        } else {
            DynamicObject rule = rules[0];
            DynamicObjectCollection itemEntry = rule.getDynamicObjectCollection("itementry");
            DynamicObjectCollection itemList = model.getEntryEntity("itementry");
            for (DynamicObject entry : itemEntry) {
                DynamicObject item = new DynamicObject(itemList.getDynamicObjectType());
                item.set("type", entry.get("type"));
                DynamicObject iteminfo = entry.getDynamicObject("itemid");
                item.set("itemname", iteminfo == null ? null : iteminfo.get("name"));
                item.set("itemid", (Object)iteminfo);
                item.set("itemclassid", entry.get("itemclassid"));
                item.set("barcodeid", entry.get("barcodeid"));
                item.set("itemlabelid", entry.get("itemlabelid"));
                item.set("itembrandid", entry.get("brandid"));
                item.set("costassumeobject", entry.get("costassumeobject"));
                item.set("costassumeobjid", entry.get("costassumeobjid"));
                item.set("assumecostscale", entry.get("assumecostscale"));
                item.set("retailprice", iteminfo == null ? BigDecimal.ZERO : iteminfo.get("retailprice"));
                item.set("modelnum", iteminfo == null ? null : iteminfo.get("modelnum"));
                itemList.add((Object)item);
            }
        }
    }

    private static void fillSubEntry(DynamicObject rule, DynamicObject entry) {
        DynamicObjectCollection subentrys = entry.getDynamicObjectCollection("groupitementry");
        DynamicObjectCollection gifts = rule.getDynamicObjectCollection("giftitementry");
        for (DynamicObject gift : gifts) {
            DynamicObject subentry = new DynamicObject(subentrys.getDynamicObjectType());
            DynamicObject item = DynamicObjectUtils.getDynamicObject((DynamicObject)gift, (String)"gitemid");
            subentry.set("gitemid", (Object)item);
            if (item != null) {
                subentry.set("gitemname", item.get("name"));
                subentry.set("gretailprice", item.get("retailprice"));
                subentry.set("gmodelnum", item.get("modelnum"));
            }
            subentry.set("gbarcodeid", gift.get("gitemid"));
            subentry.set("gtype", gift.get("gtype"));
            subentry.set("gitemclassid", gift.get("gitemclassid"));
            subentry.set("gitemlabelid", gift.get("gitemlabelid"));
            subentry.set("gitembrandid", gift.get("gbrandid"));
            subentry.set("saleqty", gift.get("itemqty"));
            subentrys.add((Object)subentry);
        }
    }

    private static String getFeilds() {
        return String.join((CharSequence)",", "bindpickqty", "bindreduceamount", "pickqty", "groupseqno", "sumitemqty", "itementry", "giftitementry", "itemgroup", "itementry.itemid", "itementry.type", "itementry.barcodeid", "itementry.itemclassid", "itementry.itemlabelid", "itementry.brandid", "itementry.limitqty", "itementry.costassumeobject", "itementry.costassumeobjid", "itementry.assumecostscale", "giftitementry.gitemid", "giftitementry.gbarcodeid", "giftitementry.gitemclassid", "giftitementry.gitemlabelid", "giftitementry.gbrandid", "giftitementry.itemqty", "giftitementry.gtype");
    }
}

