/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.business.promote.helper;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.PosItemUtil;
import kd.occ.ocdpm.common.enums.PromoteItemEnum;

public class ItemHelper {
    public static void fillItemEntity(ListSelectedRowCollection returnData, DynamicObjectCollection itemEntity, String formId) {
        List<Object> id = returnData.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        switch (formId) {
            case "ocdbd_iteminfo": {
                ItemHelper.addItemInfo(itemEntity, id, formId);
                break;
            }
            case "mdr_item_class": {
                ItemHelper.addItemClass(itemEntity, id, formId);
                break;
            }
            case "mdr_item_brand": {
                ItemHelper.addItemBrand(itemEntity, id, formId);
                break;
            }
            case "ocdbd_item_label": {
                ItemHelper.addItemLabel(itemEntity, id, formId);
                break;
            }
        }
    }

    public static void fillExItemEntity(ListSelectedRowCollection returnData, DynamicObjectCollection exItemEntity, String formId) {
        List<Object> id = returnData.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        switch (formId) {
            case "ocdbd_iteminfo": {
                ItemHelper.addExItemInfo(exItemEntity, id, formId);
                break;
            }
            case "mdr_item_class": {
                ItemHelper.addExItemClass(exItemEntity, id, formId);
                break;
            }
            case "mdr_item_brand": {
                ItemHelper.addExItemBrand(exItemEntity, id, formId);
                break;
            }
            case "ocdbd_item_label": {
                ItemHelper.addExItemLabel(exItemEntity, id, formId);
                break;
            }
        }
    }

    public static void addItemLabel(DynamicObjectCollection itemEntity, List<Object> id, String formId) {
        DynamicObject[] labelInfo;
        for (DynamicObject label : labelInfo = BusinessDataServiceHelper.load((String)"ocdbd_item_label", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", id)})) {
            DynamicObject entry = new DynamicObject(itemEntity.getDynamicObjectType());
            entry.set("itemlabelid", (Object)label);
            String type = PromoteItemEnum.getTpyeValueBykey((String)formId);
            entry.set("type", (Object)type);
            entry.set("typecopy", (Object)type);
            itemEntity.add((Object)entry);
        }
    }

    public static void addExItemLabel(DynamicObjectCollection itemEntity, List<Object> id, String formId) {
        DynamicObject[] labelInfo;
        for (DynamicObject label : labelInfo = BusinessDataServiceHelper.load((String)"ocdbd_item_label", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", id)})) {
            DynamicObject entry = new DynamicObject(itemEntity.getDynamicObjectType());
            entry.set("exitemlabelid", (Object)label);
            String type = PromoteItemEnum.getTpyeValueBykey((String)formId);
            entry.set("extype", (Object)type);
            entry.set("extypecopy", (Object)type);
            itemEntity.add((Object)entry);
        }
    }

    public static void addItemBrand(DynamicObjectCollection itemEntity, List<Object> id, String formId) {
        DynamicObject[] brandInfo;
        for (DynamicObject brand : brandInfo = BusinessDataServiceHelper.load((String)"mdr_item_brand", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", id)})) {
            DynamicObject entry = new DynamicObject(itemEntity.getDynamicObjectType());
            entry.set("brandid", (Object)brand);
            String type = PromoteItemEnum.getTpyeValueBykey((String)formId);
            entry.set("type", (Object)type);
            entry.set("typecopy", (Object)type);
            itemEntity.add((Object)entry);
        }
    }

    public static void addExItemBrand(DynamicObjectCollection itemEntity, List<Object> id, String formId) {
        DynamicObject[] brandInfo;
        for (DynamicObject brand : brandInfo = BusinessDataServiceHelper.load((String)"mdr_item_brand", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", id)})) {
            DynamicObject entry = new DynamicObject(itemEntity.getDynamicObjectType());
            entry.set("exbrandid", (Object)brand);
            String type = PromoteItemEnum.getTpyeValueBykey((String)formId);
            entry.set("extype", (Object)type);
            entry.set("extypecopy", (Object)type);
            itemEntity.add((Object)entry);
        }
    }

    public static void addItemClass(DynamicObjectCollection itemEntity, List<Object> id, String formId) {
        DynamicObject[] classInfo;
        for (DynamicObject itemClass : classInfo = BusinessDataServiceHelper.load((String)"mdr_item_class", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", id)})) {
            DynamicObject entry = new DynamicObject(itemEntity.getDynamicObjectType());
            entry.set("itemclassid", (Object)itemClass);
            String type = PromoteItemEnum.getTpyeValueBykey((String)formId);
            entry.set("type", (Object)type);
            entry.set("typecopy", (Object)type);
            itemEntity.add((Object)entry);
        }
    }

    public static void addExItemClass(DynamicObjectCollection itemEntity, List<Object> id, String formId) {
        DynamicObject[] classInfo;
        for (DynamicObject itemClass : classInfo = BusinessDataServiceHelper.load((String)"mdr_item_class", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", id)})) {
            DynamicObject entry = new DynamicObject(itemEntity.getDynamicObjectType());
            entry.set("exitemclassid", (Object)itemClass);
            String type = PromoteItemEnum.getTpyeValueBykey((String)formId);
            entry.set("extype", (Object)type);
            entry.set("extypecopy", (Object)type);
            itemEntity.add((Object)entry);
        }
    }

    public static void addItemInfo(DynamicObjectCollection itemEntity, List<Object> itemId, String formId) {
        DynamicObject[] items = ItemHelper.getItemEntity(itemId);
        Map labelMap = PosItemUtil.getItemLabelMap(itemId);
        Map barCodeMap = PosItemUtil.getBarCodeMap(itemId);
        Map itemClassMap = PosItemUtil.getItemClassMap(itemId);
        for (DynamicObject item : items) {
            DynamicObject entry = new DynamicObject(itemEntity.getDynamicObjectType());
            String type = PromoteItemEnum.getTpyeValueBykey((String)formId);
            String id = String.valueOf(item.getPkValue());
            entry.set("type", (Object)type);
            entry.set("itemid", (Object)item);
            entry.set("brandid", (Object)item.getDynamicObject("itembrands"));
            entry.set("materielid", item.get("material"));
            entry.set("unitid", (Object)item.getDynamicObject("retailunit"));
            entry.set("barcodeid", barCodeMap.get(id));
            entry.set("itemlabelid", labelMap.get(id));
            entry.set("itemclassid", itemClassMap.get(id));
            entry.set("itemprice", item.get("retailprice"));
            itemEntity.add((Object)entry);
        }
    }

    public static void addExItemInfo(DynamicObjectCollection itemEntity, List<Object> itemId, String formId) {
        DynamicObject[] items = ItemHelper.getItemEntity(itemId);
        Map itemLabelMap = PosItemUtil.getItemLabelMap(itemId);
        Map barCodeMap = PosItemUtil.getBarCodeMap(itemId);
        Map itemClassMap = PosItemUtil.getItemClassMap(itemId);
        for (DynamicObject item : items) {
            DynamicObject itemInfo = new DynamicObject(itemEntity.getDynamicObjectType());
            String id = String.valueOf(item.getPkValue());
            itemInfo.set("extype", (Object)PromoteItemEnum.getTpyeValueBykey((String)formId));
            itemInfo.set("exmaterielid", item.get("material"));
            itemInfo.set("exitemid", (Object)item);
            itemInfo.set("exbrandid", (Object)item.getDynamicObject("itembrands"));
            itemInfo.set("exunitid", (Object)item.getDynamicObject("retailunit"));
            itemInfo.set("exbarcodeid", barCodeMap.get(id));
            itemInfo.set("exitemlabelid", itemLabelMap.get(id));
            itemInfo.set("exitemclassid", itemClassMap.get(id));
            itemEntity.add((Object)itemInfo);
        }
    }

    private static DynamicObject[] getItemEntity(List<Object> itemId) {
        return BusinessDataServiceHelper.load((String)"ocdbd_iteminfo", (String)ItemHelper.getItemInfoField(), (QFilter[])new QFilter[]{new QFilter("id", "in", itemId)});
    }

    public static String getItemInfoField() {
        return String.join((CharSequence)",", "itemclassentity.goodsclasssid", "itemclassentity.classstandardid", "material", "itemclassentity", "itembrands", "retailunit", "retailprice");
    }
}

