/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.business.promote.helper;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocdbd.common.util.StringUtil;

public class PromotionHelper {
    private static Log logger = LogFactory.getLog(PromotionHelper.class);

    public static void showF7Page(IFormView iFormView, AbstractFormPlugin formPlugin, String datasourceFormid, String callbacktag) {
        QFilter filter = F7Utils.getCommonStatusFilter();
        if ("ocdbd_user".equals(datasourceFormid)) {
            DynamicObject org = (DynamicObject)formPlugin.getView().getModel().getValue("org");
            QFilter memberfilter = BaseDataServiceHelper.getBaseDataProFilter((String)datasourceFormid, (Long)DynamicObjectUtils.getPkValue((DynamicObject)org), (String)"id");
            filter.and(memberfilter);
        }
        ListShowParameter listParam = FormShowUtils.openChooseList(null, (String)datasourceFormid, (ShowType)ShowType.Modal, Arrays.asList(filter.toArray()), (boolean)true, (boolean)true);
        listParam.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, callbacktag));
        iFormView.showForm((FormShowParameter)listParam);
    }

    public static void showDynamicPage(IFormView iFormView, AbstractFormPlugin formPlugin, String billid, String callbacktag) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(billid);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, callbacktag));
        iFormView.showForm(formShowParameter);
    }

    public static String gerformIdByPkId(long pkId) {
        QFilter filter = new QFilter("promotebillid", "=", (Object)pkId);
        DynamicObject[] rulers = BusinessDataServiceHelper.load((String)"ocdpm_promote_rule", (String)"formid", (QFilter[])filter.toArray());
        if (rulers.length > 0) {
            return rulers[0].getString("formid");
        }
        return null;
    }

    public static boolean isExistsPromoteRule(long pkId) {
        QFilter filter = new QFilter("promotebillid", "=", (Object)pkId);
        return QueryServiceHelper.exists((String)"ocdpm_promote_rule", (QFilter[])filter.toArray());
    }

    public static void updateInvalidPromotescheme() {
        QFilter filter = new QFilter("promotestatus", "=", (Object)"B");
        filter.or("promotestatus", "=", (Object)"A");
        filter.and("enddate", "<=", (Object)PromotionHelper.getFormatDate());
        DynamicObject[] targetSchemes = BusinessDataServiceHelper.load((String)"ocdpm_promote", (String)String.join((CharSequence)",", "id", "promotestatus", "terminator", "terminatortime"), (QFilter[])filter.toArray());
        if (null == targetSchemes || targetSchemes.length < 1) {
            return;
        }
        for (DynamicObject targetScheme : targetSchemes) {
            targetScheme.set("promotestatus", (Object)"C");
            targetScheme.set("terminator", (Object)UserServiceHelper.getCurrentUserId());
            targetScheme.set("terminatortime", (Object)TimeServiceHelper.now());
        }
        SaveServiceHelper.update((DynamicObject[])targetSchemes);
    }

    public static void updateEffectPromotescheme() {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        filter.and("promotestatus", "=", (Object)"A");
        filter.and("startdate", ">=", (Object)PromotionHelper.getFormatDate());
        DynamicObject[] targetSchemes = BusinessDataServiceHelper.load((String)"ocdpm_promote", (String)String.join((CharSequence)",", "id", "promotestatus"), (QFilter[])filter.toArray());
        if (null == targetSchemes || targetSchemes.length < 1) {
            return;
        }
        for (DynamicObject targetScheme : targetSchemes) {
            targetScheme.set("promotestatus", (Object)"B");
        }
        SaveServiceHelper.update((DynamicObject[])targetSchemes);
    }

    private static Date getFormatDate() {
        Date today = TimeServiceHelper.today();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TimeServiceHelper.getDateFormatString());
        String formattime = simpleDateFormat.format(today);
        Date fomatetoday = null;
        try {
            fomatetoday = simpleDateFormat.parse(formattime);
        }
        catch (ParseException e) {
            logger.info(StringUtil.getErrorMsg((Exception)e));
        }
        return fomatetoday;
    }

    public static void saveItemEntry(DynamicObject rulerentity, DynamicObject entity) {
        DynamicObjectCollection itemEntry = entity.getDynamicObjectCollection("itementry");
        DynamicObjectCollection ruleItemEntry = rulerentity.getDynamicObjectCollection("itementry");
        for (DynamicObject entry : itemEntry) {
            DynamicObject ruleItem = new DynamicObject(ruleItemEntry.getDynamicObjectType());
            ruleItem.set("type", entry.get("type"));
            ruleItem.set("itemid", entry.get("item"));
            ruleItem.set("material", entry.get("material"));
            ruleItem.set("itemclassid", entry.get("itemclass"));
            ruleItem.set("brandid", entry.get("itembrand"));
            ruleItem.set("itemlabelid", entry.get("itemlabel"));
            ruleItem.set("barcodeid", entry.get("barcode"));
            ruleItem.set("unit", entry.get("unit"));
            ruleItem.set("qty", entry.get("qty"));
            ruleItem.set("auxpty", entry.get("auxpty"));
            ruleItem.set("costassumeobject", entry.get("costassumeobject"));
            ruleItem.set("costassumeobjid", entry.get("costassumeobjid"));
            ruleItem.set("assumecostscale", entry.get("assumecostscale"));
            ruleItem.set("invtype", entry.get("invtype"));
            ruleItem.set("saleattr", entry.get("saleattr"));
            ruleItemEntry.add((Object)ruleItem);
        }
    }

    public static void initItemEntryView(IDataModel model, DynamicObject rule) {
        DynamicObjectCollection itemEntry = model.getEntryEntity("itementry");
        DynamicObjectCollection ruleItemEntry = rule.getDynamicObjectCollection("itementry");
        itemEntry.clear();
        for (DynamicObject ruleItem : ruleItemEntry) {
            DynamicObject entry = new DynamicObject(itemEntry.getDynamicObjectType());
            String type = ruleItem.getString("type");
            entry.set("type", (Object)type);
            if ("1".equals(type)) {
                DynamicObject item = ruleItem.getDynamicObject("itemid");
                entry.set("item", (Object)item);
                entry.set("itemname", item.get("name"));
                entry.set("material", ruleItem.get("material"));
                entry.set("barcode", ruleItem.get("barcodeid"));
                entry.set("unit", ruleItem.get("unit"));
                entry.set("auxpty", ruleItem.get("auxpty"));
                entry.set("modelnum", item.get("modelnum"));
                entry.set("retailprice", item.get("retailprice"));
            }
            entry.set("itemclass", ruleItem.get("itemclassid"));
            entry.set("itembrand", ruleItem.get("brandid"));
            entry.set("itemlabel", ruleItem.get("itemlabelid"));
            entry.set("qty", ruleItem.get("qty"));
            entry.set("costassumeobject", ruleItem.get("costassumeobject"));
            entry.set("costassumeobjid", ruleItem.get("costassumeobjid"));
            entry.set("assumecostscale", ruleItem.get("assumecostscale"));
            entry.set("invtype", ruleItem.get("invtype"));
            entry.set("saleattr", ruleItem.get("saleattr"));
            itemEntry.add((Object)entry);
        }
    }

    public static String getFeilds() {
        Set selectorSet = EntityMetadataCache.getDataEntityType((String)"ocdpm_promote_rule").getAllFields().keySet();
        return String.join((CharSequence)",", selectorSet);
    }
}

