/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.business.promotion;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.occ.ocbase.common.entity.PromotionDetailParams;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocdpm.business.promotion.CalculateRelationHelper;
import kd.occ.ocdpm.business.promotion.PromotionCalculateHelper;
import kd.occ.ocdpm.common.entity.CalculateInfoVo;
import kd.occ.ocdpm.common.entity.CalculatePromotionVo;
import kd.occ.ocdpm.common.entity.CalculateRelationVo;
import kd.occ.ocdpm.common.entity.Comparator;
import kd.occ.ocdpm.common.enums.PromStrategyEnums;
import kd.occ.ocdpm.common.enums.PromotionTypeEnum;
import org.apache.commons.collections4.CollectionUtils;

public class AppointCalculateHelper {
    public static List<CalculateInfoVo> buildCalculateInfoVoList(List<PromotionDetailParams> paramDetailList, CalculatePromotionVo calculatePromotionVo) {
        DynamicObject firstMainItem;
        List mainList = calculatePromotionVo.getMainList();
        String promoteLinked = calculatePromotionVo.getPromoteLinked();
        String ladderType = calculatePromotionVo.getLadderType();
        String proCondition = calculatePromotionVo.getProCondition();
        List<CalculateRelationVo> relationList = CalculateRelationHelper.getCalculateRelationList(paramDetailList, mainList, proCondition, ladderType, promoteLinked);
        BigDecimal minMultiple = AppointCalculateHelper.getCalculateMinMultiple(relationList, firstMainItem = (DynamicObject)mainList.get(0), ladderType);
        if (minMultiple.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal totalCompare = PromotionCalculateHelper.getTotalAchieveScalar(paramDetailList, proCondition);
            List<CalculateInfoVo> calculateInfoVoList = AppointCalculateHelper.buildCalculateInfoVoList(calculatePromotionVo, relationList, totalCompare, minMultiple);
            return calculateInfoVoList;
        }
        return new ArrayList<CalculateInfoVo>(0);
    }

    private static List<CalculateInfoVo> buildCalculateInfoVoList(CalculatePromotionVo calculatePromotionVo, List<CalculateRelationVo> relationList, BigDecimal totalCompare, BigDecimal minMultiple) {
        ArrayList<CalculateInfoVo> calculateInfoVoList = new ArrayList<CalculateInfoVo>(relationList.size());
        for (CalculateRelationVo relation : relationList) {
            CalculateInfoVo calculateInfoVo = AppointCalculateHelper.buildCalculateInfoVo(calculatePromotionVo, relation.getMainItem(), minMultiple);
            calculateInfoVo.setTatalCompare(totalCompare);
            calculateInfoVo.setParamList(relation.getParamList());
            calculateInfoVoList.add(calculateInfoVo);
        }
        return calculateInfoVoList;
    }

    private static CalculateInfoVo buildCalculateInfoVo(CalculatePromotionVo vo, DynamicObject mainItem, BigDecimal minMultiple) {
        CalculateInfoVo calculateInfoVo = new CalculateInfoVo();
        calculateInfoVo.setMainItem(mainItem);
        calculateInfoVo.setMinMultiple(minMultiple);
        DynamicObject promotionPolicy = vo.getPromotionPolicy();
        calculateInfoVo.setPromotePolicy(promotionPolicy);
        calculateInfoVo.setPolicyId(DynamicObjectUtils.getPkValue((DynamicObject)promotionPolicy));
        calculateInfoVo.setGiftList(vo.getGiftList());
        calculateInfoVo.setLadderType(vo.getLadderType());
        calculateInfoVo.setProCondition(vo.getProCondition());
        calculateInfoVo.setPolicyNo(promotionPolicy.getString("billno"));
        calculateInfoVo.setCycleAccount(mainItem.getBoolean("iscycleaccount"));
        calculateInfoVo.setThatCycleAccount(mainItem.getBoolean("isthatcycleaccount"));
        calculateInfoVo.setFixedDisctCycle(mainItem.getBoolean("isfixeddisctcycle"));
        calculateInfoVo.setProPriceCycle(mainItem.getBoolean("ispropricecycle"));
        calculateInfoVo.setPerPriceCycle(mainItem.getBoolean("isperpricecycle"));
        return calculateInfoVo;
    }

    private static BigDecimal getCalculateMinMultiple(List<CalculateRelationVo> relationList, DynamicObject mainItem, String ladderType) {
        Comparator mainComparator;
        if (CollectionUtils.isEmpty(relationList)) {
            return BigDecimal.ZERO;
        }
        BigDecimal minMultiple = relationList.stream().map(CalculateRelationVo::getMultiple).min((x1, x2) -> x1.compareTo((BigDecimal)x2)).get();
        if ("A".equalsIgnoreCase(ladderType) && ((mainComparator = CalculateRelationHelper.buildComparatorData(mainItem)).getMinMultipleGradient().compareTo(minMultiple) > 0 || mainComparator.getMaxMultipleGradient() != null && BigDecimal.ZERO.compareTo(mainComparator.getMaxMultipleGradient()) != 0 && mainComparator.getMaxMultipleGradient().compareTo(minMultiple) <= 0)) {
            minMultiple = BigDecimal.ZERO;
        }
        return minMultiple;
    }

    public static boolean getIsSatisfiedCalculateResult(List<PromotionDetailParams> paramDetailList, CalculatePromotionVo calculatePromotionVo) {
        Set<Long> paramIdSet = AppointCalculateHelper.getParamDetailIdSet(paramDetailList, calculatePromotionVo.isItem());
        HashSet policyDetailIdSet = new HashSet(calculatePromotionVo.getMainItemIdList());
        Sets.SetView differenceSet = Sets.difference(policyDetailIdSet, paramIdSet);
        return CollectionUtils.isEmpty((Collection)differenceSet);
    }

    private static Set<Long> getParamDetailIdSet(List<PromotionDetailParams> paramList, boolean isItem) {
        List<Object> ids = new ArrayList(paramList.size());
        ids = isItem ? paramList.stream().map(PromotionDetailParams::getItemId).collect(Collectors.toList()) : paramList.stream().map(PromotionDetailParams::getMaterialId).collect(Collectors.toList());
        return new HashSet<Long>(ids);
    }

    public static List<PromotionDetailParams> getDiscountRateResultList(List<CalculateInfoVo> calculateInfoVoList) {
        boolean isCalculate;
        if (CollectionUtils.isEmpty(calculateInfoVoList)) {
            return new ArrayList<PromotionDetailParams>(0);
        }
        ArrayList<PromotionDetailParams> calculateResult = new ArrayList<PromotionDetailParams>(calculateInfoVoList.size());
        CalculateInfoVo firstCalculateInfoVo = calculateInfoVoList.get(0);
        boolean bl = isCalculate = (PromotionTypeEnum.qty.getValue().equalsIgnoreCase(firstCalculateInfoVo.getProCondition()) || PromotionTypeEnum.amount.getValue().equalsIgnoreCase(firstCalculateInfoVo.getProCondition())) && "A".equalsIgnoreCase(firstCalculateInfoVo.getLadderType());
        if (isCalculate) {
            for (CalculateInfoVo calculateInfoVo : calculateInfoVoList) {
                List<PromotionDetailParams> result;
                BigDecimal multiple = calculateInfoVo.getMinMultiple();
                if ("C".equalsIgnoreCase(calculateInfoVo.getLadderType()) && !calculateInfoVo.isThatCycleAccount()) {
                    multiple = calculateInfoVo.getMainItem().getBigDecimal("buymutiple");
                }
                if (!CollectionUtils.isNotEmpty(result = PromotionCalculateHelper.getCalculateDiscountRateResult(calculateInfoVo = PromotionCalculateHelper.getSingleAllocationCalculateResult(calculateInfoVo, multiple, PromStrategyEnums.discountRate)))) continue;
                calculateResult.addAll(result);
            }
        }
        return calculateResult;
    }

    public static List<PromotionDetailParams> getAppointGiftResultList(List<CalculateInfoVo> calculateInfoVoList) {
        if (CollectionUtils.isEmpty(calculateInfoVoList)) {
            return new ArrayList<PromotionDetailParams>(0);
        }
        ArrayList<PromotionDetailParams> calculateResult = new ArrayList<PromotionDetailParams>(calculateInfoVoList.size());
        CalculateInfoVo firstCalculateInfoVo = calculateInfoVoList.get(0);
        for (CalculateInfoVo calculateInfoVo : calculateInfoVoList) {
            BigDecimal multiple = calculateInfoVo.getMinMultiple();
            if ("C".equalsIgnoreCase(calculateInfoVo.getLadderType()) && !calculateInfoVo.isThatCycleAccount()) {
                multiple = calculateInfoVo.getMainItem().getBigDecimal("buymutiple");
            }
            calculateInfoVo = PromotionCalculateHelper.getSingleAllocationCalculateResult(calculateInfoVo, multiple, PromStrategyEnums.appointGift);
            calculateResult.addAll(calculateInfoVo.getParamList());
        }
        BigDecimal calculateMultiple = AppointCalculateHelper.getMinMultipleForCalculate(firstCalculateInfoVo, firstCalculateInfoVo.isThatCycleAccount());
        List<PromotionDetailParams> giftList = PromotionCalculateHelper.calculateAppointGifyResult(firstCalculateInfoVo.getGiftList(), calculateMultiple);
        calculateResult.addAll(giftList);
        return calculateResult;
    }

    private static BigDecimal getMinMultipleForCalculate(CalculateInfoVo calculateInfoVo, boolean isCycle) {
        BigDecimal minMultiple = BigDecimal.ONE;
        if (!"A".equalsIgnoreCase(calculateInfoVo.getLadderType()) && isCycle) {
            minMultiple = calculateInfoVo.getMinMultiple().divide(calculateInfoVo.getMainItem().getBigDecimal("buymutiple"), 0, 1);
        }
        return minMultiple;
    }

    public static List<PromotionDetailParams> getPromotionPriceResultList(List<CalculateInfoVo> calculateInfoVoList) {
        boolean isSatisfiedCondition;
        if (CollectionUtils.isEmpty(calculateInfoVoList)) {
            return new ArrayList<PromotionDetailParams>(0);
        }
        ArrayList<PromotionDetailParams> calculateResult = new ArrayList<PromotionDetailParams>(calculateInfoVoList.size());
        CalculateInfoVo firstCalculateInfoVo = calculateInfoVoList.get(0);
        boolean bl = isSatisfiedCondition = PromotionTypeEnum.qty.getValue().equalsIgnoreCase(firstCalculateInfoVo.getProCondition()) && ("A".equalsIgnoreCase(firstCalculateInfoVo.getLadderType()) || "C".equalsIgnoreCase(firstCalculateInfoVo.getLadderType()));
        if (isSatisfiedCondition) {
            for (CalculateInfoVo calculateInfoVo : calculateInfoVoList) {
                List paramList;
                DynamicObject mainItem = calculateInfoVo.getMainItem();
                BigDecimal promotionPrice = mainItem.getBigDecimal("prounitprice");
                BigDecimal multiple = calculateInfoVo.getMinMultiple();
                if ("C".equalsIgnoreCase(calculateInfoVo.getLadderType()) && !calculateInfoVo.isProPriceCycle()) {
                    multiple = calculateInfoVo.getMainItem().getBigDecimal("buymutiple");
                }
                if (!CollectionUtils.isNotEmpty((Collection)(paramList = (calculateInfoVo = PromotionCalculateHelper.getSingleAllocationCalculateResult(calculateInfoVo, multiple, PromStrategyEnums.promotionPrice)).getParamList()))) continue;
                for (PromotionDetailParams param : paramList) {
                    BigDecimal deductAmount = param.getUnitTaxPrice().subtract(promotionPrice).multiply(param.getAchieveScalar()).setScale(calculateInfoVo.getPrecision(), 6);
                    param.setDeductAmount(deductAmount);
                    param.setPromotionPrice(promotionPrice);
                    calculateResult.add(param);
                }
            }
        }
        return calculateResult;
    }

    public static List<PromotionDetailParams> getThisGiftResultList(List<CalculateInfoVo> calculateInfoVoList) {
        boolean isSatisfiedCondition;
        if (CollectionUtils.isEmpty(calculateInfoVoList)) {
            return new ArrayList<PromotionDetailParams>(0);
        }
        ArrayList<PromotionDetailParams> calculateResult = new ArrayList<PromotionDetailParams>(calculateInfoVoList.size());
        CalculateInfoVo firstCalculateInfoVo = calculateInfoVoList.get(0);
        boolean bl = isSatisfiedCondition = (PromotionTypeEnum.qty.getValue().equalsIgnoreCase(firstCalculateInfoVo.getProCondition()) || PromotionTypeEnum.amount.getValue().equalsIgnoreCase(firstCalculateInfoVo.getProCondition())) && "A".equalsIgnoreCase(firstCalculateInfoVo.getLadderType()) || PromotionTypeEnum.qty.getValue().equalsIgnoreCase(firstCalculateInfoVo.getProCondition()) && "C".equalsIgnoreCase(firstCalculateInfoVo.getLadderType());
        if (isSatisfiedCondition) {
            for (CalculateInfoVo calculateInfoVo : calculateInfoVoList) {
                BigDecimal multiple = calculateInfoVo.getMinMultiple();
                if ("C".equalsIgnoreCase(calculateInfoVo.getLadderType()) && !calculateInfoVo.isCycleAccount()) {
                    multiple = calculateInfoVo.getMainItem().getBigDecimal("buymutiple");
                }
                calculateInfoVo = PromotionCalculateHelper.getSingleAllocationCalculateResult(calculateInfoVo, multiple, PromStrategyEnums.thisGift);
                calculateResult.addAll(calculateInfoVo.getParamList());
            }
            for (CalculateInfoVo calculateInfoVo : calculateInfoVoList) {
                BigDecimal calculateMultiple = AppointCalculateHelper.getMinMultipleForCalculate(calculateInfoVo, calculateInfoVo.isCycleAccount());
                PromotionDetailParams param = (PromotionDetailParams)calculateInfoVo.getParamList().get(0);
                PromotionDetailParams giftParam = PromotionCalculateHelper.calculateThisGifyResult(calculateInfoVo.getMainItem(), param, calculateMultiple, calculateInfoVo.getPolicyNo(), calculateInfoVo.getPolicyId());
                calculateResult.add(giftParam);
            }
        }
        return calculateResult;
    }

    public static List<PromotionDetailParams> getFixedDiscountResultList(List<CalculateInfoVo> calculateInfoVoList) {
        if (CollectionUtils.isEmpty(calculateInfoVoList)) {
            return new ArrayList<PromotionDetailParams>(0);
        }
        ArrayList<PromotionDetailParams> calculateResult = new ArrayList<PromotionDetailParams>(calculateInfoVoList.size());
        for (CalculateInfoVo calculateInfoVo : calculateInfoVoList) {
            List<PromotionDetailParams> result;
            BigDecimal calculateMultiple = AppointCalculateHelper.getMinMultipleForCalculate(calculateInfoVo, calculateInfoVo.isFixedDisctCycle());
            BigDecimal multiple = calculateInfoVo.getMinMultiple();
            if ("C".equalsIgnoreCase(calculateInfoVo.getLadderType()) && !calculateInfoVo.isFixedDisctCycle()) {
                multiple = calculateInfoVo.getMainItem().getBigDecimal("buymutiple");
            }
            if (!CollectionUtils.isNotEmpty(result = PromotionCalculateHelper.getDivideFixedDiscountAmountList(calculateInfoVo = PromotionCalculateHelper.getSingleAllocationCalculateResult(calculateInfoVo, multiple, PromStrategyEnums.fixedDiscountAmount), calculateMultiple))) continue;
            calculateResult.addAll(result);
        }
        return calculateResult;
    }

    public static List<PromotionDetailParams> getPricediscountAmountResultList(List<CalculateInfoVo> calculateInfoVoList) {
        boolean isCalculate;
        if (CollectionUtils.isEmpty(calculateInfoVoList)) {
            return new ArrayList<PromotionDetailParams>(0);
        }
        ArrayList<PromotionDetailParams> calculateResult = new ArrayList<PromotionDetailParams>(calculateInfoVoList.size());
        CalculateInfoVo firstCalculateInfoVo = calculateInfoVoList.get(0);
        boolean bl = isCalculate = PromotionTypeEnum.qty.getValue().equalsIgnoreCase(firstCalculateInfoVo.getProCondition()) && ("A".equalsIgnoreCase(firstCalculateInfoVo.getLadderType()) || "C".equalsIgnoreCase(firstCalculateInfoVo.getLadderType()));
        if (isCalculate) {
            for (CalculateInfoVo calculateInfoVo : calculateInfoVoList) {
                BigDecimal singleDeductAmount = calculateInfoVo.getMainItem().getBigDecimal("pricedisctamt");
                BigDecimal multiple = calculateInfoVo.getMinMultiple();
                if ("C".equalsIgnoreCase(calculateInfoVo.getLadderType()) && !calculateInfoVo.isPerPriceCycle()) {
                    multiple = calculateInfoVo.getMainItem().getBigDecimal("buymutiple");
                }
                calculateInfoVo = PromotionCalculateHelper.getSingleAllocationCalculateResult(calculateInfoVo, multiple, PromStrategyEnums.pricediscountAmount);
                List paramList = calculateInfoVo.getParamList();
                for (PromotionDetailParams param : paramList) {
                    param.setPriceDiscountAmount(singleDeductAmount);
                    BigDecimal deductAmount = param.getAchieveScalar().multiply(singleDeductAmount).setScale(calculateInfoVo.getPrecision(), 6);
                    param.setDeductAmount(deductAmount);
                }
                if (!CollectionUtils.isNotEmpty((Collection)paramList)) continue;
                calculateResult.addAll(paramList);
            }
        }
        return calculateResult;
    }
}

