/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.business.promotion;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.occ.ocbase.common.entity.PromotionDetailParams;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocdpm.business.promotion.CalculateRelationHelper;
import kd.occ.ocdpm.business.promotion.PromotionCalculateHelper;
import kd.occ.ocdpm.common.entity.CalculateInfoVo;
import kd.occ.ocdpm.common.entity.CalculatePromotionVo;
import kd.occ.ocdpm.common.entity.CalculateRelationVo;
import kd.occ.ocdpm.common.enums.PromStrategyEnums;
import kd.occ.ocdpm.common.enums.PromotionTypeEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.SerializationUtils;

public class ArbitrarilyCalculateHelper {
    public static List<CalculateInfoVo> getCalculateInfoVoList(List<PromotionDetailParams> paramDetailList, CalculatePromotionVo calculatePromotionVo) {
        List<CalculateRelationVo> relationList = CalculateRelationHelper.getCalculateRelationList(paramDetailList, calculatePromotionVo);
        ArrayList calculateParamList = new ArrayList(paramDetailList.size());
        for (CalculateRelationVo relationVo : relationList) {
            if (relationVo.getMainItem() == null || !CollectionUtils.isNotEmpty((Collection)relationVo.getParamList())) continue;
            calculateParamList.addAll(relationVo.getParamList());
        }
        if (CollectionUtils.isNotEmpty(calculateParamList)) {
            BigDecimal tatalCompare = PromotionTypeEnum.amount.getValue().equalsIgnoreCase(calculatePromotionVo.getProCondition()) ? calculateParamList.stream().map(PromotionDetailParams::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : calculateParamList.stream().map(PromotionDetailParams::getQty).reduce(BigDecimal.ZERO, BigDecimal::add);
            DynamicObject mainItem = (DynamicObject)calculatePromotionVo.getMainList().get(0);
            BigDecimal minMultiple = CalculateRelationHelper.getMinMultipleResult(mainItem, tatalCompare);
            if (minMultiple.compareTo(BigDecimal.ZERO) > 0) {
                return ArbitrarilyCalculateHelper.buildCalculateInfoVoList(relationList, calculatePromotionVo, tatalCompare, minMultiple);
            }
        }
        return new ArrayList<CalculateInfoVo>(0);
    }

    private static List<CalculateInfoVo> buildCalculateInfoVoList(List<CalculateRelationVo> relationList, CalculatePromotionVo calculatePromotionVo, BigDecimal tatalCompare, BigDecimal minMultiple) {
        ArrayList<CalculateInfoVo> calculateInfoVoList = new ArrayList<CalculateInfoVo>(relationList.size());
        for (CalculateRelationVo vo : relationList) {
            DynamicObject mainItemValue = vo.getMainItem();
            if (mainItemValue == null || CollectionUtils.isEmpty((Collection)vo.getParamList())) continue;
            CalculateInfoVo voInfo = ArbitrarilyCalculateHelper.buildCalculateInfoVo(calculatePromotionVo, tatalCompare, minMultiple);
            voInfo.setParamList(vo.getParamList());
            voInfo.setMainItem(mainItemValue);
            voInfo.setCycleAccount(mainItemValue.getBoolean("iscycleaccount"));
            voInfo.setThatCycleAccount(mainItemValue.getBoolean("isthatcycleaccount"));
            voInfo.setFixedDisctCycle(mainItemValue.getBoolean("isfixeddisctcycle"));
            voInfo.setProPriceCycle(mainItemValue.getBoolean("ispropricecycle"));
            voInfo.setPerPriceCycle(mainItemValue.getBoolean("isperpricecycle"));
            calculateInfoVoList.add(voInfo);
        }
        return calculateInfoVoList;
    }

    private static CalculateInfoVo buildCalculateInfoVo(CalculatePromotionVo calculatePromotionVo, BigDecimal tatalCompare, BigDecimal minMultiple) {
        CalculateInfoVo calculateInfoVo = new CalculateInfoVo();
        calculateInfoVo.setGiftList(calculatePromotionVo.getGiftList());
        calculateInfoVo.setLadderType(calculatePromotionVo.getLadderType());
        calculateInfoVo.setMinMultiple(minMultiple);
        calculateInfoVo.setProCondition(calculatePromotionVo.getProCondition());
        calculateInfoVo.setTatalCompare(tatalCompare);
        DynamicObject promotePolicy = calculatePromotionVo.getPromotionPolicy();
        calculateInfoVo.setPromotePolicy(promotePolicy);
        calculateInfoVo.setPolicyId(DynamicObjectUtils.getPkValue((DynamicObject)promotePolicy));
        calculateInfoVo.setPolicyNo(DynamicObjectUtils.getString((DynamicObject)promotePolicy, (String)"billno"));
        return calculateInfoVo;
    }

    public static List<PromotionDetailParams> getAppointGiftResultList(List<CalculateInfoVo> calculateInfoVoList) {
        if (CollectionUtils.isEmpty(calculateInfoVoList)) {
            return new ArrayList<PromotionDetailParams>(0);
        }
        ArrayList<PromotionDetailParams> calculateResult = new ArrayList<PromotionDetailParams>(calculateInfoVoList.size());
        CalculateInfoVo firstCalculateInfoVo = calculateInfoVoList.get(0);
        boolean isNoLadder = "C".equalsIgnoreCase(firstCalculateInfoVo.getLadderType());
        calculateInfoVoList = PromotionCalculateHelper.getCalculateInfoVoResult(calculateInfoVoList, PromStrategyEnums.appointGift, isNoLadder);
        for (CalculateInfoVo calculateInfoVo : calculateInfoVoList) {
            calculateResult.addAll(calculateInfoVo.getParamList());
        }
        BigDecimal multiple = firstCalculateInfoVo.isThatCycleAccount() ? firstCalculateInfoVo.getMinMultiple() : BigDecimal.ONE;
        List<PromotionDetailParams> giftList = PromotionCalculateHelper.calculateAppointGifyResult(firstCalculateInfoVo.getGiftList(), multiple);
        calculateResult.addAll(giftList);
        return calculateResult;
    }

    public static List<PromotionDetailParams> getArbiItemPDAResultList(List<CalculateInfoVo> calculateInfoVoList) {
        boolean isSatisfiedCondition;
        if (CollectionUtils.isEmpty(calculateInfoVoList)) {
            return new ArrayList<PromotionDetailParams>(0);
        }
        ArrayList<PromotionDetailParams> calculateList = new ArrayList<PromotionDetailParams>(calculateInfoVoList.size());
        CalculateInfoVo firstCalculateInfoVo = calculateInfoVoList.get(0);
        boolean bl = isSatisfiedCondition = PromotionTypeEnum.qty.getValue().equalsIgnoreCase(firstCalculateInfoVo.getProCondition()) && ("A".equalsIgnoreCase(firstCalculateInfoVo.getLadderType()) || "C".equalsIgnoreCase(firstCalculateInfoVo.getLadderType()));
        if (isSatisfiedCondition) {
            boolean isNoLadder = "C".equalsIgnoreCase(firstCalculateInfoVo.getLadderType());
            calculateInfoVoList = PromotionCalculateHelper.getCalculateInfoVoResult(calculateInfoVoList, PromStrategyEnums.pricediscountAmount, isNoLadder);
            for (CalculateInfoVo calculateInfoVo : calculateInfoVoList) {
                DynamicObject mainItem = calculateInfoVo.getMainItem();
                BigDecimal discountAmount = mainItem.getBigDecimal("pricedisctamt");
                List paramList = calculateInfoVo.getParamList();
                for (PromotionDetailParams param : paramList) {
                    PromotionDetailParams paramResult = (PromotionDetailParams)SerializationUtils.clone((Serializable)param);
                    paramResult.setPriceDiscountAmount(discountAmount);
                    BigDecimal totalDeductAmount = discountAmount.multiply(param.getAchieveScalar()).setScale(calculateInfoVo.getPrecision(), 6);
                    paramResult.setDeductAmount(totalDeductAmount);
                    calculateList.add(paramResult);
                }
            }
        }
        return calculateList;
    }

    public static List<PromotionDetailParams> getArbiItemProPriceResultList(List<CalculateInfoVo> calculateInfoVoList) {
        boolean isSatisfiedCondition;
        if (CollectionUtils.isEmpty(calculateInfoVoList)) {
            return new ArrayList<PromotionDetailParams>(0);
        }
        ArrayList<PromotionDetailParams> calculateList = new ArrayList<PromotionDetailParams>(calculateInfoVoList.size());
        CalculateInfoVo firstCalculateInfoVo = calculateInfoVoList.get(0);
        boolean bl = isSatisfiedCondition = PromotionTypeEnum.qty.getValue().equalsIgnoreCase(firstCalculateInfoVo.getProCondition()) && ("A".equalsIgnoreCase(firstCalculateInfoVo.getLadderType()) || "C".equalsIgnoreCase(firstCalculateInfoVo.getLadderType()));
        if (isSatisfiedCondition) {
            boolean isNoLadder = "C".equalsIgnoreCase(firstCalculateInfoVo.getLadderType());
            calculateInfoVoList = PromotionCalculateHelper.getCalculateInfoVoResult(calculateInfoVoList, PromStrategyEnums.promotionPrice, isNoLadder);
            for (CalculateInfoVo calculateInfoVo : calculateInfoVoList) {
                DynamicObject mainItem = calculateInfoVo.getMainItem();
                BigDecimal promotionPrice = mainItem.getBigDecimal("prounitprice");
                for (PromotionDetailParams param : calculateInfoVo.getParamList()) {
                    param.setPromotionPrice(promotionPrice);
                    BigDecimal deductAmount = param.getUnitTaxPrice().subtract(promotionPrice);
                    BigDecimal totalDeductAmount = param.getAchieveScalar().multiply(deductAmount).setScale(calculateInfoVo.getPrecision(), 6);
                    param.setDeductAmount(totalDeductAmount);
                    calculateList.add(param);
                }
            }
        }
        return calculateList;
    }

    public static List<PromotionDetailParams> getDiscountRateResultList(List<CalculateInfoVo> calculateInfoVoList) {
        boolean isSatisfiedCondition;
        if (CollectionUtils.isEmpty(calculateInfoVoList)) {
            return new ArrayList<PromotionDetailParams>(0);
        }
        ArrayList<PromotionDetailParams> calculateList = new ArrayList<PromotionDetailParams>(calculateInfoVoList.size());
        CalculateInfoVo firstCalculateInfoVo = calculateInfoVoList.get(0);
        boolean bl = isSatisfiedCondition = "A".equalsIgnoreCase(firstCalculateInfoVo.getLadderType()) && (PromotionTypeEnum.qty.getValue().equalsIgnoreCase(firstCalculateInfoVo.getProCondition()) || PromotionTypeEnum.amount.getValue().equalsIgnoreCase(firstCalculateInfoVo.getProCondition()));
        if (isSatisfiedCondition) {
            calculateInfoVoList = PromotionCalculateHelper.getCalculateInfoVoResult(calculateInfoVoList, PromStrategyEnums.discountRate, false);
            for (CalculateInfoVo calculateInfoVo : calculateInfoVoList) {
                DynamicObject mainItem = calculateInfoVo.getMainItem();
                BigDecimal discountRate = mainItem.getBigDecimal("discounttate");
                BigDecimal rate = discountRate.multiply(new BigDecimal("0.01"));
                List paramList = calculateInfoVo.getParamList();
                for (PromotionDetailParams param : paramList) {
                    param.setDiscount(discountRate);
                    BigDecimal deductAmount = BigDecimal.ZERO;
                    deductAmount = PromotionTypeEnum.qty.getValue().equalsIgnoreCase(calculateInfoVo.getProCondition()) ? param.getQty().multiply(param.getUnitTaxPrice()).multiply(rate).setScale(calculateInfoVo.getPrecision(), 6) : param.getTaxAmount().multiply(rate).setScale(calculateInfoVo.getPrecision(), 6);
                    param.setDeductAmount(deductAmount);
                    calculateList.add(param);
                }
            }
        }
        return calculateList;
    }
}

