/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.business.promotion;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.occ.ocbase.common.entity.PromotionDetailParams;
import kd.occ.ocdpm.common.entity.CalculatePromotionVo;
import kd.occ.ocdpm.common.entity.CalculateRelationVo;
import kd.occ.ocdpm.common.entity.Comparator;
import kd.occ.ocdpm.common.enums.PromoteLinkEnum;
import kd.occ.ocdpm.common.enums.PromotionTypeEnum;
import org.apache.commons.collections.CollectionUtils;

public class CalculateRelationHelper {
    public static List<CalculateRelationVo> getCalculateRelationList(List<PromotionDetailParams> paramList, CalculatePromotionVo calculatePromotionVo) {
        boolean isSatisfiedCalculate;
        long id;
        if (CollectionUtils.isEmpty(paramList) || calculatePromotionVo == null) {
            return new ArrayList<CalculateRelationVo>(0);
        }
        ArrayList<CalculateRelationVo> ralationList = new ArrayList<CalculateRelationVo>(8);
        String promoteLinked = calculatePromotionVo.getPromoteLinked();
        boolean isSCM = PromoteLinkEnum.SCM.getValue().equalsIgnoreCase(promoteLinked);
        List mainItemList = calculatePromotionVo.getMainList();
        int size = CollectionUtils.isEmpty((Collection)mainItemList) ? 0 : mainItemList.size();
        HashMap<String, DynamicObject> idsMap = new HashMap<String, DynamicObject>(size);
        HashMap<String, DynamicObject> idAuxptyMap = new HashMap<String, DynamicObject>(size);
        HashMap<Long, DynamicObject> classMap = new HashMap<Long, DynamicObject>(size);
        CalculateRelationHelper.divideIntoMap(idsMap, idAuxptyMap, classMap, mainItemList, isSCM);
        HashSet<String> paramIdSet = new HashSet<String>(paramList.size());
        HashSet<String> paramIdAuxSet = new HashSet<String>(paramList.size());
        HashSet paramClassSet = new HashSet(paramList.size());
        for (PromotionDetailParams param : paramList) {
            id = isSCM ? param.getMaterialId() : param.getItemId();
            paramIdSet.add(CalculateRelationHelper.getGroupKey(id, param.getUnitId()));
            paramIdAuxSet.add(CalculateRelationHelper.getGroupKey(id, param.getAuxptyId(), param.getUnitId()));
            if (param.getLinkedClassList() == null) continue;
            paramClassSet.addAll(new HashSet(param.getLinkedClassList()));
        }
        Sets.SetView sameIdResult = Sets.intersection(new HashSet(paramIdSet), new HashSet(idsMap.keySet()));
        Sets.SetView idAndAuxptyResult = Sets.intersection(new HashSet(idAuxptyMap.keySet()), paramIdAuxSet);
        Sets.SetView classResult = Sets.intersection(paramClassSet, new HashSet(classMap.keySet()));
        boolean bl = isSatisfiedCalculate = CollectionUtils.isNotEmpty((Collection)sameIdResult) || CollectionUtils.isNotEmpty((Collection)idAndAuxptyResult) || CollectionUtils.isNotEmpty((Collection)classResult);
        if (isSatisfiedCalculate) {
            Map<String, List<PromotionDetailParams>> paramMap = CalculateRelationHelper.getParamDetailMap(isSCM, paramList);
            Iterator<Map.Entry<String, List<PromotionDetailParams>>> iterator = paramMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, List<PromotionDetailParams>> param;
                PromotionDetailParams paramValue;
                id = isSCM ? paramValue.getMaterialId() : paramValue.getItemId();
                DynamicObject matchMainItem = (DynamicObject)idAuxptyMap.get(CalculateRelationHelper.getGroupKey(id, (paramValue = (param = iterator.next()).getValue().get(0)).getAuxptyId(), paramValue.getUnitId()));
                if (matchMainItem == null) {
                    matchMainItem = CalculateRelationHelper.getMatchMainItem(idsMap, (Set<Long>)classResult, classMap, paramValue, matchMainItem, id, calculatePromotionVo);
                }
                CalculateRelationVo calculateRelationVo = new CalculateRelationVo();
                calculateRelationVo.setMainItem(matchMainItem);
                calculateRelationVo.setParamList(param.getValue());
                ralationList.add(calculateRelationVo);
            }
        }
        return ralationList;
    }

    private static DynamicObject getMatchMainItem(Map<String, DynamicObject> idsMap, Set<Long> classResult, Map<Long, DynamicObject> classMap, PromotionDetailParams paramValue, DynamicObject matchMainItem, long id, CalculatePromotionVo calculatePromotionVo) {
        ArrayList sameSet;
        matchMainItem = idsMap.get(CalculateRelationHelper.getGroupKey(id, paramValue.getUnitId()));
        if (matchMainItem != null) {
            return matchMainItem;
        }
        List linkedClassList = paramValue.getLinkedClassList();
        if (CollectionUtils.isNotEmpty((Collection)linkedClassList) && CollectionUtils.isNotEmpty(sameSet = new ArrayList(Sets.intersection(classResult, new HashSet(linkedClassList))))) {
            if (PromotionTypeEnum.amount.getValue().equalsIgnoreCase(calculatePromotionVo.getProCondition())) {
                return classMap.get(sameSet.get(0));
            }
            Iterator iterator = sameSet.iterator();
            while (iterator.hasNext()) {
                long classId = (Long)iterator.next();
                matchMainItem = classMap.get(classId);
                if (matchMainItem == null || matchMainItem.getLong("unit_id") != paramValue.getUnitId()) continue;
                return matchMainItem;
            }
        }
        return null;
    }

    private static void divideIntoMap(Map<String, DynamicObject> idsMap, Map<String, DynamicObject> idAuxptyMap, Map<Long, DynamicObject> classMap, List<DynamicObject> mainItemList, boolean isSCM) {
        if (CollectionUtils.isEmpty(mainItemList)) {
            return;
        }
        mainItemList.forEach(mainItem -> {
            long auxptyId = mainItem.getLong("auxpty_id");
            long id = isSCM ? mainItem.getLong("material_id") : mainItem.getLong("item_id");
            long classId = isSCM ? mainItem.getLong("materialgroup_id") : mainItem.getLong("itemclass_id");
            long unitId = mainItem.getLong("unit_id");
            if (classId > 0L) {
                classMap.put(classId, (DynamicObject)mainItem);
            } else if (auxptyId > 0L) {
                idAuxptyMap.put(CalculateRelationHelper.getGroupKey(id, auxptyId, unitId), (DynamicObject)mainItem);
            } else {
                idsMap.put(CalculateRelationHelper.getGroupKey(id, unitId), (DynamicObject)mainItem);
            }
        });
    }

    public static List<CalculateRelationVo> getCalculateRelationList(List<PromotionDetailParams> paramList, List<DynamicObject> mainItemList, String proCondition, String ladderType, String promoteLinked) {
        if (CollectionUtils.isEmpty(paramList) || CollectionUtils.isEmpty(mainItemList)) {
            return new ArrayList<CalculateRelationVo>(0);
        }
        ArrayList<CalculateRelationVo> ralationList = new ArrayList<CalculateRelationVo>(mainItemList.size());
        boolean isSCM = PromoteLinkEnum.SCM.getValue().equalsIgnoreCase(promoteLinked);
        Map<String, List<PromotionDetailParams>> paramMap = CalculateRelationHelper.getParamDetailMap(isSCM, paramList);
        Map<String, DynamicObject> mainItemMap = CalculateRelationHelper.getMainItemListMap(isSCM, mainItemList);
        for (Map.Entry<String, DynamicObject> entry : mainItemMap.entrySet()) {
            CalculateRelationVo relationVo;
            DynamicObject mainItem = entry.getValue();
            List<PromotionDetailParams> pList = paramMap.get(entry.getKey());
            if (CollectionUtils.isEmpty(pList)) continue;
            Comparator mainComparator = CalculateRelationHelper.buildComparatorData(mainItem);
            BigDecimal totalCompare = BigDecimal.ZERO;
            totalCompare = PromotionTypeEnum.qty.getValue().equalsIgnoreCase(proCondition) ? pList.stream().map(PromotionDetailParams::getQty).reduce(BigDecimal.ZERO, BigDecimal::add) : pList.stream().map(PromotionDetailParams::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (totalCompare.compareTo(BigDecimal.ZERO) <= 0 || totalCompare.compareTo(mainComparator.getCondition()) < 0) {
                relationVo = new CalculateRelationVo();
                relationVo.setMainItem(mainItem);
                relationVo.setParamList(pList);
                relationVo.setMultiple(BigDecimal.ZERO);
                ralationList.add(relationVo);
                continue;
            }
            BigDecimal multiple = totalCompare.divide(mainComparator.getCondition(), 0, 1);
            if ("C".equalsIgnoreCase(ladderType)) {
                if (multiple.compareTo(mainComparator.getMinBuyMultiple()) >= 0 && multiple.compareTo(mainComparator.getConditionBuyMutiple()) >= 0) {
                    boolean isCirculate;
                    boolean bl = isCirculate = mainItem.getBoolean("iscycleaccount") || mainItem.getBoolean("isthatcycleaccount") || mainItem.getBoolean("isfixeddisctcycle") || mainItem.getBoolean("isperpricecycle") || mainItem.getBoolean("ispropricecycle");
                    if (isCirculate) {
                        BigDecimal circulateMultiple = multiple.divide(mainComparator.getConditionBuyMutiple(), 0, 1);
                        multiple = mainComparator.getConditionBuyMutiple().multiply(circulateMultiple);
                    } else {
                        multiple = mainComparator.getConditionBuyMutiple();
                    }
                } else {
                    multiple = BigDecimal.ZERO;
                }
            }
            relationVo = new CalculateRelationVo();
            relationVo.setMainItem(mainItem);
            relationVo.setParamList(pList);
            relationVo.setMultiple(multiple);
            ralationList.add(relationVo);
        }
        return ralationList;
    }

    public static BigDecimal getMinMultipleResult(DynamicObject mainItem, BigDecimal compareTotal) {
        boolean isCirculate;
        Comparator comparator = CalculateRelationHelper.buildComparatorData(mainItem);
        boolean isSatisfiedCalculate = CalculateRelationHelper.isSatisfiedCalculate(compareTotal, comparator);
        boolean bl = isCirculate = mainItem.getBoolean("iscycleaccount") || mainItem.getBoolean("isthatcycleaccount") || mainItem.getBoolean("isfixeddisctcycle") || mainItem.getBoolean("isperpricecycle") || mainItem.getBoolean("ispropricecycle");
        if (isSatisfiedCalculate) {
            BigDecimal multiple = BigDecimal.ONE;
            if (isCirculate && comparator.getCondition().compareTo(BigDecimal.ZERO) > 0) {
                multiple = compareTotal.divide(comparator.getCondition(), 0, 1);
            }
            return multiple;
        }
        return BigDecimal.ZERO;
    }

    public static boolean isSatisfiedCalculate(DynamicObject mainItemDetail, BigDecimal tatalCompare) {
        Comparator comparator = CalculateRelationHelper.buildComparatorData(mainItemDetail);
        return CalculateRelationHelper.isSatisfiedCalculate(tatalCompare, comparator);
    }

    private static boolean isSatisfiedCalculate(BigDecimal tatalCompare, Comparator comparator) {
        boolean isCalculate = false;
        if (comparator.getMinGradient() != null && BigDecimal.ZERO.compareTo(comparator.getMinGradient()) < 0) {
            isCalculate = comparator.getMaxGradient() == null || BigDecimal.ZERO.compareTo(comparator.getMaxGradient()) == 0 ? tatalCompare.compareTo(comparator.getMinGradient()) >= 0 : tatalCompare.compareTo(comparator.getMinGradient()) >= 0 && comparator.getMaxGradient().compareTo(tatalCompare) > 0;
        } else if (BigDecimal.ZERO.compareTo(comparator.getMinBuy()) == 0) {
            if (tatalCompare.compareTo(comparator.getCondition()) >= 0) {
                isCalculate = true;
            }
        } else if (tatalCompare.compareTo(comparator.getMinBuy()) >= 0) {
            isCalculate = true;
        }
        return isCalculate;
    }

    public static Comparator buildComparatorData(DynamicObject mainItemDetail) {
        Comparator comparator = new Comparator();
        String promotionCondition = mainItemDetail.getString("procondition");
        if (PromotionTypeEnum.qty.getValue().equalsIgnoreCase(promotionCondition)) {
            comparator.setCondition(mainItemDetail.getBigDecimal("buyqty"));
            comparator.setMinBuy(mainItemDetail.getBigDecimal("minlimitqty"));
            comparator.setMinGradient(mainItemDetail.getBigDecimal("ladderminqty"));
            comparator.setMaxGradient(mainItemDetail.getBigDecimal("laddermaxqty"));
        } else {
            comparator.setCondition(mainItemDetail.getBigDecimal("buyamount"));
            comparator.setMinBuy(mainItemDetail.getBigDecimal("minlimitamount"));
            comparator.setMinGradient(mainItemDetail.getBigDecimal("ladderminamount"));
            comparator.setMaxGradient(mainItemDetail.getBigDecimal("laddermaxamount"));
        }
        comparator.setConditionBuyMutiple(mainItemDetail.getBigDecimal("buymutiple"));
        comparator.setMinBuyMultiple(mainItemDetail.getBigDecimal("minbuypiece"));
        comparator.setMinMultipleGradient(mainItemDetail.getBigDecimal("ladderminbase"));
        comparator.setMaxMultipleGradient(mainItemDetail.getBigDecimal("laddermaxbase"));
        return comparator;
    }

    private static Map<Long, List<PromotionDetailParams>> getParamItemIds(Boolean isSCM, List<PromotionDetailParams> paramDetailList) {
        if (isSCM.booleanValue()) {
            return paramDetailList.stream().collect(Collectors.groupingBy(PromotionDetailParams::getMaterialId));
        }
        return paramDetailList.stream().collect(Collectors.groupingBy(PromotionDetailParams::getItemId));
    }

    private static Map<String, List<PromotionDetailParams>> getParamDetailMap(Boolean isSCM, List<PromotionDetailParams> paramList) {
        if (isSCM.booleanValue()) {
            return paramList.stream().collect(Collectors.groupingBy(a -> CalculateRelationHelper.getGroupKey(a.getMaterialId(), a.getAuxptyId(), a.getUnitId())));
        }
        return paramList.stream().collect(Collectors.groupingBy(a -> CalculateRelationHelper.getGroupKey(a.getItemId(), a.getAuxptyId(), a.getUnitId())));
    }

    private static Map<String, DynamicObject> getMainItemListMap(Boolean isSCM, List<DynamicObject> mainItemList) {
        if (isSCM.booleanValue()) {
            return mainItemList.stream().collect(Collectors.toMap(a -> a.getLong("material_id") + "_" + a.getLong("auxpty_id") + "_" + a.getLong("unit_id"), a -> a, (k1, k2) -> k1));
        }
        return mainItemList.stream().collect(Collectors.toMap(a -> a.getLong("item_id") + "_" + a.getLong("auxpty_id") + "_" + a.getLong("unit_id"), a -> a, (k1, k2) -> k1));
    }

    public static String getGroupKey(long id, long auxptyId) {
        return String.format("%d_%d", id, auxptyId);
    }

    public static String getGroupKey(long id, long auxptyId, long unitId) {
        return String.format("%d_%d_%d", id, auxptyId, unitId);
    }
}

