/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.business.promotion;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.cache.ItemClassTreeCache;
import kd.occ.ocbase.common.entity.PromotionDetailParams;
import kd.occ.ocbase.common.model.FCNode;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocdpm.common.entity.CalculateInfoVo;
import kd.occ.ocdpm.common.entity.CalculatePromotionVo;
import kd.occ.ocdpm.common.enums.PromStrategyEnums;
import kd.occ.ocdpm.common.enums.PromoteLinkEnum;
import kd.occ.ocdpm.common.enums.PromotionRowTypeEnum;
import kd.occ.ocdpm.common.enums.PromotionTypeEnum;
import kd.occ.ocdpm.common.enums.TypeBetGroupEnum;
import kd.occ.ocdpm.common.enums.TypeInGroupEnum;
import org.apache.commons.collections.CollectionUtils;

public class PromotionCalculateHelper {
    private static Log logger = LogFactory.getLog(PromotionCalculateHelper.class);

    public static List<PromotionDetailParams> getCalculateDiscountRateResult(CalculateInfoVo calculateInfoVo) {
        BigDecimal discountRate = calculateInfoVo.getMainItem().getBigDecimal("discounttate");
        BigDecimal rate = discountRate.multiply(new BigDecimal("0.01"));
        List paramList = calculateInfoVo.getParamList();
        for (PromotionDetailParams param : paramList) {
            BigDecimal deductAmount;
            param.setDiscount(discountRate);
            if (PromotionTypeEnum.qty.getValue().equalsIgnoreCase(calculateInfoVo.getProCondition())) {
                deductAmount = param.getAchieveScalar().multiply(param.getUnitTaxPrice()).multiply(rate).setScale(calculateInfoVo.getPrecision(), 6);
                param.setDeductAmount(deductAmount);
                continue;
            }
            deductAmount = param.getAchieveScalar().multiply(rate).setScale(calculateInfoVo.getPrecision(), 6);
            param.setDeductAmount(deductAmount);
        }
        return paramList;
    }

    public static CalculateInfoVo getSingleAllocationCalculateResult(CalculateInfoVo calculateInfoVo, BigDecimal minMultiple, PromStrategyEnums promStrategyEnums) {
        CalculateInfoVo resultCalculateInfoVo = PromotionCalculateHelper.buildCalculateInfoVo(calculateInfoVo);
        BigDecimal totalAchieveScalar = PromotionCalculateHelper.getTotalAchieveScalar(resultCalculateInfoVo.getMainItem(), minMultiple, resultCalculateInfoVo.getProCondition());
        List paramList = resultCalculateInfoVo.getParamList();
        int laseOne = paramList.size();
        BigDecimal addTotal = BigDecimal.ZERO;
        for (int i = 0; i < paramList.size(); ++i) {
            PromotionDetailParams param = (PromotionDetailParams)paramList.get(i);
            PromotionCalculateHelper.setAppointGiftMainInfo(param, resultCalculateInfoVo.getMainItem(), resultCalculateInfoVo.getPolicyNo(), resultCalculateInfoVo.getPolicyId(), promStrategyEnums);
            BigDecimal achieveScalar = BigDecimal.ZERO;
            if (i == laseOne - 1) {
                achieveScalar = totalAchieveScalar.subtract(addTotal);
            } else {
                achieveScalar = PromotionCalculateHelper.getAllocationDecimal(totalAchieveScalar, resultCalculateInfoVo.getTatalCompare(), param, resultCalculateInfoVo.getProCondition(), resultCalculateInfoVo.getPrecision());
                addTotal = addTotal.add(achieveScalar);
            }
            param.setAchieveScalar(achieveScalar);
        }
        return resultCalculateInfoVo;
    }

    public static BigDecimal getAllocationDecimal(BigDecimal totalAchieveScalar, BigDecimal actualAchieveScalar, PromotionDetailParams paramInfo, String promoteCondition, int precision) {
        if (actualAchieveScalar.compareTo(BigDecimal.ZERO) <= 0) {
            return BigDecimal.ZERO;
        }
        if (precision <= 0) {
            precision = 2;
        }
        BigDecimal divideDecimal = BigDecimal.ZERO;
        divideDecimal = PromotionTypeEnum.amount.getValue().equalsIgnoreCase(promoteCondition) ? totalAchieveScalar.multiply(paramInfo.getTaxAmount()).divide(actualAchieveScalar, precision, 6) : totalAchieveScalar.multiply(paramInfo.getQty()).divide(actualAchieveScalar, precision, 6);
        return divideDecimal;
    }

    public static void setAppointGiftMainInfo(PromotionDetailParams param, DynamicObject mainItem, String billNo, long policyId, PromStrategyEnums promotionprice) {
        PromotionCalculateHelper.setAppointGiftMainInfo(param, mainItem, billNo, policyId, promotionprice.getValue());
    }

    private static void setAppointGiftMainInfo(PromotionDetailParams param, DynamicObject mainItem, String billNo, long policyId, long promStrategyId) {
        param.setGroupId(mainItem.getLong("promotiongroupno_id"));
        param.setProCondition(mainItem.getString("procondition"));
        param.setBillNo(billNo);
        param.setId(policyId);
        param.setRowType(PromotionRowTypeEnum.mainRow.getValue());
        param.setPgGroupNo(mainItem.getLong("pggroupno_id"));
        param.setLadderNo(mainItem.getLong("ladderno_id"));
        param.setPromStrategyId(promStrategyId);
    }

    public static BigDecimal getTotalAchieveScalar(DynamicObject mainItem, BigDecimal minMultiple, String proCondition) {
        BigDecimal achieveScalar = BigDecimal.ZERO;
        achieveScalar = PromotionTypeEnum.amount.getValue().equalsIgnoreCase(proCondition) ? mainItem.getBigDecimal("buyamount").multiply(minMultiple) : mainItem.getBigDecimal("buyqty").multiply(minMultiple);
        return achieveScalar;
    }

    public static BigDecimal getTotalAchieveScalar(List<PromotionDetailParams> paramList, String promoteCondition) {
        if (CollectionUtils.isEmpty(paramList)) {
            return BigDecimal.ZERO;
        }
        if (PromotionTypeEnum.amount.getValue().equalsIgnoreCase(promoteCondition)) {
            return paramList.stream().map(PromotionDetailParams::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return paramList.stream().map(PromotionDetailParams::getQty).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public static List<PromotionDetailParams> getCalculateParamsDetails(CalculatePromotionVo calculatePromotionVo, List<PromotionDetailParams> paramsDetails) {
        if (CollectionUtils.isEmpty(paramsDetails)) {
            return new ArrayList<PromotionDetailParams>(0);
        }
        ArrayList<PromotionDetailParams> calculateList = new ArrayList<PromotionDetailParams>(paramsDetails.size());
        for (PromotionDetailParams param : paramsDetails) {
            long id = calculatePromotionVo.isItem() ? param.getItemId() : param.getMaterialId();
            if (calculatePromotionVo.getExceptionList().contains(id) || calculatePromotionVo.getExceptionAuxptyList().contains(PromotionCalculateHelper.getGroupKey(id, param.getAuxptyId()))) continue;
            calculateList.add(param);
        }
        return calculateList;
    }

    public static List<CalculatePromotionVo> buildCalculatePromotionVoList(DynamicObject[] policyList, String promotionLink) {
        if (policyList == null || policyList.length == 0) {
            return new ArrayList<CalculatePromotionVo>(0);
        }
        ArrayList<CalculatePromotionVo> voList = new ArrayList(policyList.length);
        ArrayList<Object> exceptionIdList = new ArrayList(8);
        ArrayList<Object> exceptionAuxptyList = new ArrayList(8);
        for (int i = 0; i < policyList.length; ++i) {
            Map<String, List<DynamicObject>> exAuxMap;
            Map<Long, List<DynamicObject>> exMap;
            DynamicObject promotionPolicy = policyList[i];
            DynamicObjectCollection exceptionList = promotionPolicy.getDynamicObjectCollection("exceptionentry");
            if (PromoteLinkEnum.SCM.getValue().equalsIgnoreCase(promotionLink)) {
                exMap = exceptionList.stream().collect(Collectors.groupingBy(a -> a.getLong("exceptionmaterial_id")));
                exAuxMap = exceptionList.stream().collect(Collectors.groupingBy(a -> PromotionCalculateHelper.getGroupKey(a.getLong("exceptionmaterial_id"), a.getLong("exceptionauxpty_id"))));
            } else {
                exMap = exceptionList.stream().collect(Collectors.groupingBy(a -> a.getLong("exceptionitem_id")));
                exAuxMap = exceptionList.stream().collect(Collectors.groupingBy(a -> PromotionCalculateHelper.getGroupKey(a.getLong("exceptionitem_id"), a.getLong("exceptionauxpty_id"))));
            }
            if (exMap.size() > 0) {
                exceptionIdList = new ArrayList<Long>(exMap.keySet());
            }
            if (exAuxMap.size() > 0) {
                exceptionAuxptyList = new ArrayList<String>(exAuxMap.keySet());
            }
            DynamicObjectCollection policyDetailList = promotionPolicy.getDynamicObjectCollection("entryentity");
            Map<String, List<DynamicObject>> detailGroupMap = policyDetailList.stream().collect(Collectors.groupingBy(p -> PromotionCalculateHelper.getGroupKey(p.getLong("promotiongroupno_id"), p.getLong("ladderno_id"))));
            for (Map.Entry<String, List<DynamicObject>> detailVo : detailGroupMap.entrySet()) {
                CalculatePromotionVo calVo = PromotionCalculateHelper.bulidCalculatePromotionVo(promotionPolicy, promotionLink);
                PromotionCalculateHelper.setPromotionItemInfo(calVo, detailVo.getValue(), promotionLink);
                calVo.setExceptionList(exceptionIdList);
                calVo.setExceptionAuxptyList(exceptionAuxptyList);
                voList.add(calVo);
            }
        }
        voList = voList.stream().sorted(Comparator.comparing(CalculatePromotionVo::getPolicyId)).collect(Collectors.toList());
        return voList;
    }

    private static void setPromotionItemInfo(CalculatePromotionVo calculatePromotionVo, List<DynamicObject> mainItemList, String promoteLinked) {
        int size = mainItemList.size();
        HashSet<Long> linkedIdList = new HashSet<Long>(size);
        HashSet<String> linkedAuxIdList = new HashSet<String>(size);
        HashSet<Long> linkedClassIdList = new HashSet<Long>(size);
        calculatePromotionVo.setGroupPrioritydetail(Long.parseLong(mainItemList.get(0).getDynamicObject("prioritydetail").getString("number")));
        boolean isItem = calculatePromotionVo.isItem();
        Map<String, List<DynamicObject>> groupByMap = mainItemList.stream().collect(Collectors.groupingBy(a -> a.getString("rowtype")));
        calculatePromotionVo.setPromotionDetailList(mainItemList);
        List<DynamicObject> mainRowList = groupByMap.get(PromotionRowTypeEnum.mainRow.getValue());
        if (CollectionUtils.isNotEmpty(mainRowList)) {
            for (DynamicObject mainItem : mainRowList) {
                long classId;
                long auxptyId = mainItem.getLong("auxpty_id");
                long id = isItem ? mainItem.getLong("item_id") : mainItem.getLong("material_id");
                long l = classId = isItem ? mainItem.getLong("itemclass_id") : mainItem.getLong("materialgroup_id");
                if (auxptyId > 0L) {
                    linkedAuxIdList.add(PromotionCalculateHelper.getGroupKey(id, auxptyId));
                }
                if (classId > 0L) {
                    linkedClassIdList.add(classId);
                }
                linkedIdList.add(id);
            }
        }
        calculatePromotionVo.setMainClassIdList(new ArrayList(linkedClassIdList));
        calculatePromotionVo.setMainItemIdList(new ArrayList(linkedIdList));
        calculatePromotionVo.setMainItemAuxList(new ArrayList(linkedAuxIdList));
        calculatePromotionVo.setMainList(mainRowList);
        calculatePromotionVo.setGiftList(groupByMap.get(PromotionRowTypeEnum.giftRow.getValue()));
    }

    private static CalculatePromotionVo bulidCalculatePromotionVo(DynamicObject promotionPolicy, String promotionLink) {
        CalculatePromotionVo calculatePromotionVo = new CalculatePromotionVo();
        calculatePromotionVo.setCurrencyId(promotionPolicy.getLong("currency_id"));
        calculatePromotionVo.setPolicyNo(promotionPolicy.getString("billno"));
        calculatePromotionVo.setPolicyId(promotionPolicy.getLong("id"));
        calculatePromotionVo.setPriority(promotionPolicy.getLong("priority"));
        DynamicObject promotionType = promotionPolicy.getDynamicObject("promotetype");
        if (promotionType != null) {
            calculatePromotionVo.setPromoteObjId(promotionType.getLong("promobject_id"));
            String proLinked = promotionType.getString("promlink");
            calculatePromotionVo.setItem(!PromoteLinkEnum.SCM.getValue().equalsIgnoreCase(proLinked));
            calculatePromotionVo.setPromoteLinked(proLinked);
            calculatePromotionVo.setLadderType(promotionType.getString("laddertype"));
            calculatePromotionVo.setProCondition(promotionType.getString("promrequire"));
        }
        calculatePromotionVo.setPromotionPolicy(promotionPolicy);
        return calculatePromotionVo;
    }

    public static List<PromotionDetailParams> getParamsDetails(List<PromotionDetailParams> paramDetailList, String promoteLinked) {
        if (PromoteLinkEnum.SCM.getValue().equalsIgnoreCase(promoteLinked)) {
            List<Long> materialIdList = paramDetailList.stream().map(a -> a.getMaterialId()).collect(Collectors.toList());
            Map<Long, Set<Long>> materialClassMap = PromotionCalculateHelper.getMaterialClassListMap(materialIdList);
            for (PromotionDetailParams param : paramDetailList) {
                Set<Long> classList = materialClassMap.get(param.getMaterialId());
                if (!CollectionUtils.isNotEmpty(classList)) continue;
                param.setLinkedClassList(new ArrayList<Long>(classList));
            }
        } else {
            List<Long> itemIdList = paramDetailList.stream().map(a -> a.getItemId()).collect(Collectors.toList());
            Map<Long, Set<Long>> itemClassMap = PromotionCalculateHelper.getItemClassListMap(itemIdList);
            for (PromotionDetailParams param : paramDetailList) {
                Set<Long> classList = itemClassMap.get(param.getItemId());
                if (!CollectionUtils.isNotEmpty(classList)) continue;
                param.setLinkedClassList(new ArrayList<Long>(classList));
            }
        }
        return paramDetailList;
    }

    private static Map<Long, Set<Long>> getItemClassListMap(List<Long> itemIds) {
        QFilter filter = new QFilter("id", "in", itemIds);
        DynamicObject[] itemList = BusinessDataServiceHelper.load((String)"ocdbd_iteminfo", (String)"itemclassentity,itemclassentity.id,itemclassentity.goodsclasssid,itemclassentity.classstandardid", (QFilter[])filter.toArray());
        if (itemList == null || itemList.length == 0) {
            return new HashMap<Long, Set<Long>>(0);
        }
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(itemList.length);
        for (int i = 0; i < itemList.length; ++i) {
            DynamicObjectCollection classList = itemList[i].getDynamicObjectCollection("itemclassentity");
            ArrayList<Long> allClassIdList = new ArrayList<Long>(classList.size());
            for (DynamicObject classInfo : classList) {
                allClassIdList.addAll(PromotionCalculateHelper.getParentIds(classInfo.getLong("goodsclasssid_id")));
            }
            map.put(itemList[i].getLong("id"), new HashSet(allClassIdList));
        }
        return map;
    }

    private static List<Long> getParentIds(Object id) {
        if (id == null) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> list = new ArrayList<Long>(8);
        ItemClassTreeCache cache = ItemClassTreeCache.getCache();
        Map childMap = cache.getChildMap();
        while (id != null && !id.equals(0L)) {
            list.add(Long.parseLong(id.toString()));
            FCNode fcNode = (FCNode)childMap.get(id);
            if (fcNode == null) break;
            id = fcNode.getFather();
        }
        return list;
    }

    public static Map<Long, Set<Long>> getMaterialClassListMap(List<Long> materialIds) {
        QFilter filter = new QFilter("material", "in", materialIds);
        DynamicObject[] materialList = BusinessDataServiceHelper.load((String)"bd_materialgroupdetail", (String)"material,group", (QFilter[])filter.toArray());
        if (materialList == null || materialList.length == 0) {
            return new HashMap<Long, Set<Long>>(0);
        }
        HashMap<Long, HashSet<Long>> map = new HashMap<Long, HashSet<Long>>(materialList.length);
        long classId = 0L;
        for (int i = 0; i < materialList.length; ++i) {
            classId = materialList[i].getLong("group_id");
            HashSet<Long> classIdList = (HashSet<Long>)map.get(materialList[i].getLong("material_id"));
            if (CollectionUtils.isEmpty((Collection)classIdList)) {
                classIdList = new HashSet<Long>(0);
            }
            classIdList.add(classId);
            map.put(materialList[i].getLong("material_id"), classIdList);
        }
        HashMap<Long, Set<Long>> pMap = new HashMap<Long, Set<Long>>(map.size());
        for (Map.Entry m : map.entrySet()) {
            QFilter pfilter = new QFilter("id", "in", m.getValue());
            DynamicObject[] classList = BusinessDataServiceHelper.load((String)"bd_materialgroup", (String)"longnumber,", (QFilter[])pfilter.toArray());
            QFilter ifilter = new QFilter("1", "!=", (Object)1);
            for (DynamicObject classInfo : classList) {
                ifilter.or(new QFilter("number", "in", (Object)classInfo.getString("longnumber").split("!")));
            }
            DynamicObjectCollection parentList = QueryServiceHelper.query((String)"bd_materialgroup", (String)"id", (QFilter[])ifilter.toArray());
            pMap.put((Long)m.getKey(), new HashSet(parentList.stream().map(a -> a.getLong("id")).collect(Collectors.toList())));
        }
        return pMap;
    }

    private static String getGroupKey(long key1, long key2) {
        return String.format("%s_%s", key1, key2);
    }

    public static List<PromotionDetailParams> calculateAppointGifyResult(List<DynamicObject> giftList, BigDecimal multiple) {
        ArrayList<PromotionDetailParams> calculateResultList = new ArrayList<PromotionDetailParams>(0);
        if (CollectionUtils.isEmpty(giftList)) {
            return calculateResultList;
        }
        DynamicObject policy = (DynamicObject)giftList.get(0).getParent();
        String billNo = policy.getString("billno");
        long policyId = DynamicObjectUtils.getPkValue((DynamicObject)policy);
        BigDecimal thatGiftQty = BigDecimal.ZERO;
        for (DynamicObject gift : giftList) {
            PromotionDetailParams giftDetail = PromotionCalculateHelper.buildPromotionDetailParams(gift);
            giftDetail.setBillNo(billNo);
            giftDetail.setId(policyId);
            thatGiftQty = gift.getBigDecimal("thatgiftqty").multiply(multiple);
            giftDetail.setGiftQty(thatGiftQty);
            BigDecimal gexPrice = gift.getBigDecimal("thatgiftexcprice");
            giftDetail.setGexPrice(gexPrice);
            BigDecimal totalGexPrice = gexPrice.multiply(multiple).multiply(gift.getBigDecimal("thatgiftqty"));
            giftDetail.setTotalGexPrice(totalGexPrice);
            giftDetail.setTypeBetGroupId(DynamicObjectUtils.getPkValue((DynamicObject)gift.getDynamicObject("typebetgroup")));
            giftDetail.setTypeInGroupId(DynamicObjectUtils.getPkValue((DynamicObject)gift.getDynamicObject("typeingroup")));
            giftDetail.setPromStrategyId(PromStrategyEnums.appointGift.getValue());
            calculateResultList.add(giftDetail);
        }
        return calculateResultList;
    }

    private static PromotionDetailParams buildPromotionDetailParams(DynamicObject policyDetail) {
        PromotionDetailParams promoteResult = new PromotionDetailParams();
        promoteResult.setItemId(DynamicObjectUtils.getPkValue((DynamicObject)policyDetail.getDynamicObject("item")));
        promoteResult.setMaterialId(DynamicObjectUtils.getPkValue((DynamicObject)policyDetail.getDynamicObject("material")));
        promoteResult.setUnitId(DynamicObjectUtils.getPkValue((DynamicObject)policyDetail.getDynamicObject("unit")));
        promoteResult.setAuxptyId(DynamicObjectUtils.getPkValue((DynamicObject)policyDetail.getDynamicObject("auxpty")));
        promoteResult.setGroupId(DynamicObjectUtils.getPkValue((DynamicObject)policyDetail.getDynamicObject("promotiongroupno")));
        promoteResult.setLadderNo(DynamicObjectUtils.getPkValue((DynamicObject)policyDetail.getDynamicObject("ladderno")));
        promoteResult.setRemark(policyDetail.getString("remark"));
        promoteResult.setTypeBetGroupId(DynamicObjectUtils.getPkValue((DynamicObject)policyDetail.getDynamicObject("typebetgroup")));
        promoteResult.setTypeInGroupId(DynamicObjectUtils.getPkValue((DynamicObject)policyDetail.getDynamicObject("typeingroup")));
        promoteResult.setPgGroupNo(DynamicObjectUtils.getPkValue((DynamicObject)policyDetail.getDynamicObject("pggroupno")));
        promoteResult.setRowType(policyDetail.getString("rowtype"));
        promoteResult.setProCondition(policyDetail.getString("procondition"));
        promoteResult.setSeq(policyDetail.getInt("seq"));
        return promoteResult;
    }

    public static PromotionDetailParams calculateThisGifyResult(DynamicObject mainItem, PromotionDetailParams paramInfo, BigDecimal minMultiple, String policyNo, long policyId) {
        PromotionDetailParams giftDetail = new PromotionDetailParams();
        giftDetail.setGroupId(DynamicObjectUtils.getPkValue((DynamicObject)mainItem.getDynamicObject("promotiongroupno")));
        giftDetail.setLadderNo(DynamicObjectUtils.getPkValue((DynamicObject)mainItem.getDynamicObject("ladderno")));
        giftDetail.setRemark(mainItem.getString("remark"));
        giftDetail.setRowType(PromotionRowTypeEnum.giftRow.getValue());
        giftDetail.setProCondition(mainItem.getString("procondition"));
        giftDetail.setSeq(1);
        giftDetail.setMaterialId(paramInfo.getMaterialId());
        giftDetail.setItemId(paramInfo.getItemId());
        giftDetail.setAuxptyId(paramInfo.getAuxptyId());
        giftDetail.setUnitId(paramInfo.getUnitId());
        giftDetail.setGiftQty(mainItem.getBigDecimal("thisgiftqty").multiply(minMultiple));
        giftDetail.setBillNo(policyNo);
        giftDetail.setId(policyId);
        giftDetail.setPromStrategyId(PromStrategyEnums.thisGift.getValue());
        giftDetail.setPgGroupNo(1102838563977973760L);
        giftDetail.setTypeBetGroupId(TypeBetGroupEnum.all.getTypeBetGroupId());
        giftDetail.setTypeInGroupId(TypeInGroupEnum.detailqty.getTypeInGroupId());
        return giftDetail;
    }

    public static List<PromotionDetailParams> getDivideFixedDiscountAmountList(CalculateInfoVo calculateInfoVo, BigDecimal minMultiple) {
        DynamicObject mainItem = calculateInfoVo.getMainItem();
        BigDecimal totalDeductAmount = mainItem.getBigDecimal("fixeddisctamount").multiply(minMultiple);
        List paramList = calculateInfoVo.getParamList();
        BigDecimal addAmount = BigDecimal.ZERO;
        int laseOne = paramList.size() - 1;
        for (int i = 0; i < paramList.size(); ++i) {
            PromotionDetailParams param = (PromotionDetailParams)paramList.get(i);
            param.setTotalAmount(totalDeductAmount);
            if (laseOne == i) {
                param.setDeductAmount(totalDeductAmount.subtract(addAmount));
                continue;
            }
            BigDecimal singleDeductAmount = PromotionCalculateHelper.getAllocationDecimal(totalDeductAmount, calculateInfoVo.getTatalCompare(), param, calculateInfoVo.getProCondition(), calculateInfoVo.getPrecision());
            param.setDeductAmount(singleDeductAmount);
            addAmount = addAmount.add(singleDeductAmount);
        }
        return paramList;
    }

    public static List<CalculateInfoVo> getCalculateInfoVoResult(List<CalculateInfoVo> calculateInfoVoList, PromStrategyEnums promStrategyEnums, boolean isNoLadder) {
        if (isNoLadder) {
            return PromotionCalculateHelper.getAllocationCalculateResult(calculateInfoVoList, promStrategyEnums);
        }
        return PromotionCalculateHelper.getNoAllocationCalculateResult(calculateInfoVoList, promStrategyEnums);
    }

    private static List<CalculateInfoVo> getAllocationCalculateResult(List<CalculateInfoVo> calculateInfoVoList, PromStrategyEnums pricediscountamount) {
        ArrayList<CalculateInfoVo> divideList = new ArrayList<CalculateInfoVo>(calculateInfoVoList.size());
        ArrayList allParamList = new ArrayList(calculateInfoVoList.size());
        calculateInfoVoList.forEach(calculateInfoVo -> allParamList.addAll(calculateInfoVo.getParamList()));
        CalculateInfoVo firstCalculateInfoVo = calculateInfoVoList.get(0);
        BigDecimal multiple = BigDecimal.ONE;
        if (PromStrategyEnums.appointGift.getValue() == pricediscountamount.getValue() && firstCalculateInfoVo.isThatCycleAccount() || PromStrategyEnums.pricediscountAmount.getValue() == pricediscountamount.getValue() && firstCalculateInfoVo.isPerPriceCycle() || PromStrategyEnums.promotionPrice.getValue() == pricediscountamount.getValue() && firstCalculateInfoVo.isProPriceCycle()) {
            multiple = firstCalculateInfoVo.getMinMultiple();
        }
        BigDecimal totalAchieveScalar = PromotionCalculateHelper.getTotalAchieveScalar(firstCalculateInfoVo.getMainItem(), multiple, firstCalculateInfoVo.getProCondition());
        int laseOne = allParamList.size();
        BigDecimal addTotal = BigDecimal.ZERO;
        for (int i = 0; i < calculateInfoVoList.size(); ++i) {
            CalculateInfoVo calculateInfoVo2 = PromotionCalculateHelper.buildCalculateInfoVo(calculateInfoVoList.get(i));
            List paramList = calculateInfoVo2.getParamList();
            for (PromotionDetailParams param : paramList) {
                PromotionCalculateHelper.setAppointGiftMainInfo(param, calculateInfoVo2.getMainItem(), calculateInfoVo2.getPolicyNo(), calculateInfoVo2.getPolicyId(), pricediscountamount);
                BigDecimal achieveScalar = BigDecimal.ZERO;
                if (i == laseOne) {
                    achieveScalar = totalAchieveScalar.subtract(addTotal);
                } else {
                    achieveScalar = PromotionCalculateHelper.getAllocationDecimal(totalAchieveScalar, calculateInfoVo2.getTatalCompare(), param, calculateInfoVo2.getProCondition(), calculateInfoVo2.getPrecision());
                    addTotal = addTotal.add(achieveScalar);
                }
                param.setAchieveScalar(achieveScalar);
            }
            divideList.add(calculateInfoVo2);
        }
        return divideList;
    }

    public static CalculateInfoVo buildCalculateInfoVo(CalculateInfoVo calculateInfoVo) {
        CalculateInfoVo copyVo = new CalculateInfoVo();
        copyVo.setCycleAccount(calculateInfoVo.isCycleAccount());
        copyVo.setFixedDisctCycle(calculateInfoVo.isFixedDisctCycle());
        copyVo.setGiftList(new ArrayList(calculateInfoVo.getGiftList()));
        copyVo.setLadderType(calculateInfoVo.getLadderType());
        copyVo.setMainItem(calculateInfoVo.getMainItem());
        copyVo.setMinMultiple(calculateInfoVo.getMinMultiple());
        copyVo.setParamList(PromotionCalculateHelper.deepCopyParamList(calculateInfoVo.getParamList()));
        copyVo.setPerPriceCycle(calculateInfoVo.isPerPriceCycle());
        copyVo.setPolicyId(calculateInfoVo.getPolicyId());
        copyVo.setPolicyNo(calculateInfoVo.getPolicyNo());
        copyVo.setPrecision(calculateInfoVo.getPrecision());
        copyVo.setProCondition(calculateInfoVo.getProCondition());
        copyVo.setPromotePolicy(calculateInfoVo.getPromotePolicy());
        copyVo.setProPriceCycle(calculateInfoVo.isProPriceCycle());
        copyVo.setTatalCompare(calculateInfoVo.getTatalCompare());
        copyVo.setThatCycleAccount(calculateInfoVo.isThatCycleAccount());
        return copyVo;
    }

    public static List<PromotionDetailParams> deepCopyParamList(List<PromotionDetailParams> paramList) {
        if (CollectionUtils.isEmpty(paramList)) {
            return new ArrayList<PromotionDetailParams>(0);
        }
        ArrayList<PromotionDetailParams> copyList = new ArrayList<PromotionDetailParams>(paramList.size());
        for (PromotionDetailParams param : paramList) {
            PromotionDetailParams copy = PromotionCalculateHelper.clone(param);
            if (copy == null) continue;
            copyList.add(copy);
        }
        return copyList;
    }

    public static PromotionDetailParams clone(PromotionDetailParams paramDetail) {
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(paramDetail);
            ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            ObjectInputStream in = new ObjectInputStream(byteIn);
            PromotionDetailParams clone = (PromotionDetailParams)in.readObject();
            return clone;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static List<CalculateInfoVo> getNoAllocationCalculateResult(List<CalculateInfoVo> calculateInfoVoList, PromStrategyEnums promStrategyEnums) {
        ArrayList<CalculateInfoVo> noDivideList = new ArrayList<CalculateInfoVo>(calculateInfoVoList.size());
        for (CalculateInfoVo calculateInfoVo : calculateInfoVoList) {
            CalculateInfoVo copyCalculateInfoVo = PromotionCalculateHelper.buildCalculateInfoVo(calculateInfoVo);
            DynamicObject mainItem = copyCalculateInfoVo.getMainItem();
            List paramList = copyCalculateInfoVo.getParamList();
            for (PromotionDetailParams param : paramList) {
                PromotionCalculateHelper.setAppointGiftMainInfo(param, mainItem, calculateInfoVo.getPolicyNo(), calculateInfoVo.getPolicyId(), promStrategyEnums.getValue());
                if (PromotionTypeEnum.amount.getValue().equalsIgnoreCase(calculateInfoVo.getProCondition())) {
                    param.setAchieveScalar(param.getTaxAmount());
                    continue;
                }
                param.setAchieveScalar(param.getQty());
            }
            noDivideList.add(copyCalculateInfoVo);
        }
        return noDivideList;
    }

    public static CalculateInfoVo getSingleNoAllocationCalculateResult(CalculateInfoVo calculateInfoVo, PromStrategyEnums promStrategyEnums) {
        CalculateInfoVo copyCalculateInfoVo = PromotionCalculateHelper.buildCalculateInfoVo(calculateInfoVo);
        DynamicObject mainItem = copyCalculateInfoVo.getMainItem();
        List paramList = copyCalculateInfoVo.getParamList();
        for (PromotionDetailParams param : paramList) {
            PromotionCalculateHelper.setAppointGiftMainInfo(param, mainItem, calculateInfoVo.getPolicyNo(), calculateInfoVo.getPolicyId(), promStrategyEnums.getValue());
            if (PromotionTypeEnum.amount.getValue().equalsIgnoreCase(calculateInfoVo.getProCondition())) {
                param.setAchieveScalar(param.getTaxAmount());
                continue;
            }
            param.setAchieveScalar(param.getQty());
        }
        return copyCalculateInfoVo;
    }

    public static BigDecimal calculateTotalCompare(List<PromotionDetailParams> paramsDetailList, String promoteType) {
        if (CollectionUtils.isNotEmpty(paramsDetailList)) {
            if ("A".equalsIgnoreCase(promoteType)) {
                return paramsDetailList.stream().map(PromotionDetailParams::getQty).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            return paramsDetailList.stream().map(PromotionDetailParams::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return BigDecimal.ZERO;
    }
}

