/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.business.promotion;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.entity.PromotionDetailParams;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocdpm.common.entity.PromotionInParam;
import kd.occ.ocdpm.common.enums.PromoteLinkEnum;
import kd.occ.ocdpm.common.util.FilterConditionUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class PromotionParamHelper {
    private static final long materialInId = 1104405340751064075L;
    private static final long itemInId = 1104405340751064076L;

    public static PromotionInParam buildPromotionRuleInputParams(DynamicObject promotionRule, String billEntity, long pkValue) {
        if (promotionRule == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6784\u9020\u4fc3\u9500\u5fae\u670d\u52a1\u63a5\u53e3\u5165\u53c2\u6709\u8bef\uff0c\u539f\u56e0\u662f\uff1a\u6ca1\u6709\u5339\u914d\u5230\u4fc3\u9500\u89c4\u5219\u3002", (String)"PromotionParamHelper_0", (String)"occ-ocdpm-business", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)billEntity)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6784\u9020\u4fc3\u9500\u5fae\u670d\u52a1\u63a5\u53e3\u5165\u53c2\u6709\u8bef\uff0c\u539f\u56e0\u662f\uff1a\u9002\u7528\u5355\u636e\u6807\u8bc6\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"PromotionParamHelper_1", (String)"occ-ocdpm-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection promotionRuleDetailList = promotionRule.getDynamicObjectCollection("entryentity");
        Set<String> billColNameList = PromotionParamHelper.getBillQueryColNameList(promotionRuleDetailList);
        DynamicObject sourceBillInfo = PromotionParamHelper.querySourceBillInfo(billEntity, billColNameList, pkValue);
        String promotionLinked = promotionRule.getString("promlink");
        PromotionInParam promotionInParam = PromotionParamHelper.bulidPromotionInParam(promotionRule, sourceBillInfo, promotionRuleDetailList, promotionLinked);
        return promotionInParam;
    }

    private static PromotionInParam bulidPromotionInParam(DynamicObject promotionRule, DynamicObject sourceBillInfo, DynamicObjectCollection promotionRuleDetailList, String promotionLinked) {
        HashMap<String, String> detailInParamsMap = new HashMap<String, String>(0);
        HashMap<String, String> headInParamsMap = new HashMap<String, String>(0);
        long combofieldId = 0L;
        String sourceEntity = null;
        for (DynamicObject detail : promotionRuleDetailList) {
            DynamicObject inParam = detail.getDynamicObject("combofield");
            if (inParam == null) continue;
            combofieldId = DynamicObjectUtils.getPkValue((DynamicObject)inParam);
            if ("B".equalsIgnoreCase(inParam.getString("paramtype"))) {
                detailInParamsMap.put(inParam.getString("param"), detail.getString("billcolname"));
            } else {
                headInParamsMap.put(inParam.getString("param"), detail.getString("billcolname"));
            }
            if (PromoteLinkEnum.SCM.getValue().equalsIgnoreCase(promotionLinked)) {
                if (1104405340751064075L != combofieldId) continue;
                sourceEntity = detail.getString("sourceentity");
                continue;
            }
            if (1104405340751064076L != combofieldId) continue;
            sourceEntity = detail.getString("sourceentity");
        }
        if (StringUtils.isEmpty(sourceEntity)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u9002\u7528\u5355\u636e\u201d\u5b57\u6bb5\u5bf9\u5e94\u5546\u54c1/\u7269\u6599\u8bbe\u7f6e\u7684\u6620\u5c04\u5206\u5f55\u5b57\u6bb5\u6709\u8bef\u3002", (String)"PromotionParamHelper_2", (String)"occ-ocdpm-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection sourceDetailList = PromotionParamHelper.getSourceDetailList(promotionRule, sourceBillInfo, sourceEntity);
        if (CollectionUtils.isEmpty((Collection)sourceDetailList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5165\u53c2\u660e\u7ec6\u5bf9\u5e94\u201c\u9002\u7528\u5355\u636e\u201d\u7684\u5206\u5f55\u6570\u636e\u4e3a\u7a7a\u3002", (String)"PromotionParamHelper_3", (String)"occ-ocdpm-business", (Object[])new Object[0]));
        }
        List<PromotionDetailParams> detailParamList = PromotionParamHelper.createPromotionDetailParams(sourceDetailList, detailInParamsMap);
        PromotionInParam paramInfo = PromotionParamHelper.createPromotionInParam(sourceBillInfo, headInParamsMap);
        paramInfo.setDetailParams(detailParamList);
        return paramInfo;
    }

    private static DynamicObjectCollection getSourceDetailList(DynamicObject promotionRule, DynamicObject sourceBillInfo, String sourceEntity) {
        DynamicObjectCollection sourceDetailList = sourceBillInfo.getDynamicObjectCollection(sourceEntity);
        DynamicObject sourceBill = promotionRule.getDynamicObject("billentity");
        String entryFilter = promotionRule.getString("entryfilter");
        QFilter cusFilter = FilterConditionUtil.translateInfoSqlFilter((String)sourceBill.getPkValue().toString(), (String)entryFilter);
        QFilter sourceBillFilter = new QFilter("id", "=", sourceBillInfo.getPkValue());
        if (cusFilter != null) {
            sourceBillFilter.and(cusFilter);
            DynamicObjectCollection removeList = QueryServiceHelper.query((String)sourceBill.getPkValue().toString(), (String)(sourceEntity + "." + "id"), (QFilter[])sourceBillFilter.toArray());
            if (CollectionUtils.isNotEmpty((Collection)removeList)) {
                List ids = removeList.stream().map(a -> a.getLong(sourceEntity + "." + "id")).collect(Collectors.toList());
                Map<Long, DynamicObject> sourceDetailMap = sourceDetailList.stream().collect(Collectors.toMap(a -> DynamicObjectUtils.getPkValue((DynamicObject)a), a -> a, (k1, k2) -> k1));
                sourceDetailList = new DynamicObjectCollection();
                for (Map.Entry<Long, DynamicObject> sourceDetail : sourceDetailMap.entrySet()) {
                    if (ids.contains(sourceDetail.getKey())) continue;
                    sourceDetailList.add((Object)sourceDetail.getValue());
                }
            }
        }
        return sourceDetailList;
    }

    private static PromotionInParam createPromotionInParam(DynamicObject sourceBillInfo, Map<String, String> headInParamsMap) {
        JSONObject inParamJson = new JSONObject();
        for (Map.Entry<String, String> entry : headInParamsMap.entrySet()) {
            String name = entry.getValue();
            if (StringUtils.isEmpty((CharSequence)name)) continue;
            Object jsonValue = sourceBillInfo.get(name);
            if (jsonValue instanceof DynamicObject) {
                inParamJson.put(entry.getKey(), (Object)DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)jsonValue)));
                continue;
            }
            inParamJson.put(entry.getKey(), jsonValue);
        }
        return (PromotionInParam)JSONObject.toJavaObject((JSON)inParamJson, PromotionInParam.class);
    }

    private static List<PromotionDetailParams> createPromotionDetailParams(DynamicObjectCollection sourceDetailList, Map<String, String> detailInParamsMap) {
        ArrayList<PromotionDetailParams> paramList = new ArrayList<PromotionDetailParams>(sourceDetailList.size());
        String billColName = null;
        Object jsonValue = null;
        for (DynamicObject detailValue : sourceDetailList) {
            JSONObject detailJson = new JSONObject();
            for (Map.Entry<String, String> entry : detailInParamsMap.entrySet()) {
                billColName = entry.getValue();
                if (StringUtils.isEmpty((CharSequence)billColName)) continue;
                jsonValue = detailValue.get(billColName);
                if (jsonValue instanceof DynamicObject) {
                    detailJson.put(entry.getKey(), (Object)DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)jsonValue)));
                    continue;
                }
                if (jsonValue instanceof BigDecimal) {
                    detailJson.put(entry.getKey(), (Object)new BigDecimal(jsonValue.toString()));
                    continue;
                }
                if (jsonValue instanceof Integer) {
                    detailJson.put(entry.getKey(), (Object)Integer.parseInt(jsonValue.toString()));
                    continue;
                }
                if (!(jsonValue instanceof Long)) continue;
                detailJson.put(entry.getKey(), (Object)Long.parseLong(jsonValue.toString()));
            }
            detailJson.put("entryid", detailValue.getPkValue());
            detailJson.put("seq", (Object)detailValue.getInt("seq"));
            PromotionDetailParams param = (PromotionDetailParams)JSONObject.toJavaObject((JSON)detailJson, PromotionDetailParams.class);
            if (param == null) continue;
            paramList.add(param);
        }
        return paramList;
    }

    private static Set<String> getBillQueryColNameList(DynamicObjectCollection ruleDetailList) {
        HashSet<String> billColNameList = new HashSet<String>(ruleDetailList.size());
        HashSet entityNameList = new HashSet(ruleDetailList.size());
        ruleDetailList.forEach(r -> {
            String value = r.getString("querycolname");
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                billColNameList.add(value);
            }
            if (StringUtils.isNotEmpty((CharSequence)(value = r.getString("sourceentity")))) {
                entityNameList.add(value);
            }
        });
        for (String value : entityNameList) {
            billColNameList.add(value);
            billColNameList.add(value + ".id");
            billColNameList.add(value + ".seq");
        }
        return billColNameList;
    }

    private static DynamicObject querySourceBillInfo(String billEntity, Set<String> billColNameList, Object pkValue) {
        QFilter filter = new QFilter("id", "=", pkValue);
        String selectCols = billColNameList.stream().collect(Collectors.joining(","));
        DynamicObject billInfo = BusinessDataServiceHelper.loadSingleFromCache((String)billEntity, (String)selectCols, (QFilter[])filter.toArray());
        if (billInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f7f\u7528\u4fc3\u9500\u7684\u5355\u636e\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"PromotionParamHelper_4", (String)"occ-ocdpm-business", (Object[])new Object[0]));
        }
        return billInfo;
    }

    public static void checkParamsMustInput(PromotionInParam inputParams) {
        if (inputParams == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4fc3\u9500\u670d\u52a1\u5165\u53c2\u6570\u636e\u6709\u8bef\u3002", (String)"PromotionParamHelper_5", (String)"occ-ocdpm-business", (Object[])new Object[0]));
        }
        StringBuilder errorMsg = new StringBuilder();
        PromotionParamHelper.checkHeadInputParams(inputParams, errorMsg);
        PromotionParamHelper.checkDetailInPutParams(inputParams.getDetailParams(), errorMsg);
        if (StringUtils.isNotEmpty((CharSequence)errorMsg.toString())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fc3\u9500\u670d\u52a1\u6570\u636e\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u539f\u56e0\u662f\uff1a%s", (String)"PromotionParamHelper_6", (String)"occ-ocdpm-business", (Object[])new Object[0]), errorMsg.toString()));
        }
    }

    private static void checkHeadInputParams(PromotionInParam inputParam, StringBuilder totalMsg) {
        ArrayList<String> colNameList = new ArrayList<String>(2);
        if (inputParam.getSaleOrgId() == 0L && inputParam.getSaleChannelId() == 0L) {
            colNameList.add(ResManager.loadKDString((String)"\u9500\u552e\u7ec4\u7ec7/\u9500\u552e\u6e20\u9053", (String)"PromotionParamHelper_7", (String)"occ-ocdpm-business", (Object[])new Object[0]));
        }
        if (inputParam.getCustomerId() == 0L && inputParam.getOrderChannelId() == 0L) {
            colNameList.add(ResManager.loadKDString((String)"\u5ba2\u6237/\u8ba2\u8d27\u6e20\u9053", (String)"PromotionParamHelper_8", (String)"occ-ocdpm-business", (Object[])new Object[0]));
        }
        if (inputParam.getCurrencyId() == 0L) {
            colNameList.add(ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u522b", (String)"PromotionParamHelper_9", (String)"occ-ocdpm-business", (Object[])new Object[0]));
        }
        if (inputParam.getInspectionDate() == null) {
            colNameList.add(ResManager.loadKDString((String)"\u4fc3\u9500\u53c2\u4e0e\u6821\u9a8c\u65f6\u95f4", (String)"PromotionParamHelper_10", (String)"occ-ocdpm-business", (Object[])new Object[0]));
        }
        if (!CollectionUtils.isEmpty(colNameList)) {
            totalMsg.append(String.format(ResManager.loadKDString((String)"\u8868\u5934\u6570\u636e%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"PromotionParamHelper_18", (String)"occ-ocdpm-business", (Object[])new Object[0]) + "\n", String.join((CharSequence)",", colNameList)));
        }
    }

    private static void checkDetailInPutParams(List<PromotionDetailParams> paramList, StringBuilder errorMsg) {
        if (CollectionUtils.isEmpty(paramList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4fc3\u9500\u670d\u52a1\u5165\u53c2\u5206\u5f55\u6570\u636e\u6709\u8bef\u3002", (String)"PromotionParamHelper_12", (String)"occ-ocdpm-business", (Object[])new Object[0]));
        }
        paramList.stream().forEach(detailValue -> PromotionParamHelper.checkDetailValue(detailValue, errorMsg));
    }

    private static void checkDetailValue(PromotionDetailParams detailValue, StringBuilder totalMsg) {
        ArrayList<String> colNameList = new ArrayList<String>(0);
        if (detailValue.getMaterialId() == 0L && detailValue.getItemId() == 0L) {
            colNameList.add(ResManager.loadKDString((String)"\u5546\u54c1/\u7269\u6599", (String)"PromotionParamHelper_13", (String)"occ-ocdpm-business", (Object[])new Object[0]));
        }
        if (detailValue.getUnitId() == 0L) {
            colNameList.add(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"PromotionParamHelper_14", (String)"occ-ocdpm-business", (Object[])new Object[0]));
        }
        if (BigDecimal.ZERO.compareTo(detailValue.getQty()) == 0) {
            colNameList.add(ResManager.loadKDString((String)"\u8d2d\u4e70\u6570\u91cf", (String)"PromotionParamHelper_15", (String)"occ-ocdpm-business", (Object[])new Object[0]));
        }
        if (!CollectionUtils.isEmpty(colNameList)) {
            totalMsg.append(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u5206\u5f55\u6570\u636e%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"PromotionParamHelper_19", (String)"occ-ocdpm-business", (Object[])new Object[0]) + "\n", detailValue.getSeq(), String.join((CharSequence)",", colNameList)));
        }
    }
}

