/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.business.promotion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocdpm.business.promotion.PromotionTypeHelper;
import kd.occ.ocdpm.business.promotionitem.PromotionItemHelper;
import kd.occ.ocdpm.common.entity.PromotionInParam;
import kd.occ.ocdpm.common.enums.PromoteLinkEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class PromotionPolicyHelper {
    private static final String[] query_promotionPolicy_cols = new String[]{"id", "billno", "org", "currency", "promotetype", "expirationdate", "effectivedate", "priority", "invalidtime", "entryentity", "exceptionauxpty", "entryentity.id,entryentity.seq,entryentity.promotiongroupno,entryentity.ladderno,entryentity.rowtype,entryentity.pggroupno,entryentity.itemclass,entryentity.item,entryentity.materialgroup,entryentity.unit,entryentity.baseunit,entryentity.remark,entryentity.prostarttime,entryentity.proendtime,entryentity.procondition,entryentity.buyqty,entryentity.basebuyqty,entryentity.basegiftqty,entryentity.buyamount,entryentity.buymutiple,entryentity.minlimitqty,entryentity.minlimitamount,entryentity.ladderminbase,entryentity.laddermaxbase,entryentity.ladderminqty,entryentity.laddermaxqty,entryentity.ladderminamount,entryentity.laddermaxamount,entryentity.thisgiftqty,entryentity.iscycleaccount,entryentity.typeingroup,entryentity.thatgiftqty,entryentity.thatgiftexcprice,entryentity.isthatcycleaccount,entryentity.typebetgroup,entryentity.discounttate,entryentity.totaldiscount,entryentity.fixeddisctamount,entryentity.isfixeddisctcycle,entryentity.pricedisctamt,entryentity.isperpricecycle,entryentity.prounitprice,entryentity.ispropricecycle,entryentity.material,entryentity.auxpty,entryentity.minbuypiece,entryentity.prioritydetail,entryentity.prostrategy", "exceptionentry.id,exceptionentry.seq,exceptionentry.exceptionitem,exceptionentry.exceptionmaterial,exceptionentry.exceptionunit,exceptionentry.exceptionauxpty"};

    @Deprecated
    public static DynamicObject[] getMatchPromotionPolicyList(PromotionInParam promotionInParam, String promotionLink) {
        return PromotionPolicyHelper.getPromotionPolicyList(promotionInParam, promotionLink, false);
    }

    public static DynamicObject[] getMatchPromotionPolicyList(PromotionInParam promotionInParam, String promotionLink, boolean isRuleEntryConfigPromParam) {
        return PromotionPolicyHelper.getPromotionPolicyList(promotionInParam, promotionLink, isRuleEntryConfigPromParam);
    }

    private static DynamicObject[] getPromotionPolicyList(PromotionInParam promotionInParam, String promotionLink, boolean isRuleEntryConfigPromParam) {
        QFilter filter = PromotionPolicyHelper.buildMatchPromotionPolicyFilter(promotionInParam, promotionLink, isRuleEntryConfigPromParam);
        DynamicObject[] policyList = BusinessDataServiceHelper.load((String)"ocdpm_promotepolicy", (String)Arrays.toString(query_promotionPolicy_cols), (QFilter[])filter.toArray());
        if (policyList == null || policyList.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6ca1\u6709\u5339\u914d\u7684\u4fc3\u9500\u653f\u7b56\u3002", (String)"PromotionPolicyHelper_0", (String)"occ-ocdpm-business", (Object[])new Object[0]));
        }
        return policyList;
    }

    private static QFilter buildMatchPromotionPolicyFilter(PromotionInParam promotionInParam, String promotionLink, boolean isRuleEntryConfigPromParam) {
        boolean isOpenPromotion;
        if (promotionInParam == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4fc3\u9500\u5fae\u670d\u52a1\u5165\u53c2\u6570\u636e\u6709\u8bef\u3002", (String)"PromotionPolicyHelper_1", (String)"occ-ocdpm-business", (Object[])new Object[0]));
        }
        long saleOrgId = promotionInParam.getSaleOrgId();
        if ((promotionLink.equalsIgnoreCase(PromoteLinkEnum.SCM.getValue()) || promotionLink.equalsIgnoreCase(PromoteLinkEnum.CHANNELTOSCM.getValue())) && !(isOpenPromotion = PromotionPolicyHelper.checkSaleOrgOpenPromotion(saleOrgId))) {
            return new QFilter("1", "!=", (Object)1);
        }
        long saleChannelId = promotionInParam.getSaleChannelId();
        long customerId = promotionInParam.getCustomerId();
        long orderChannelId = promotionInParam.getOrderChannelId();
        Date checkDate = promotionInParam.getInspectionDate();
        long currencyId = promotionInParam.getCurrencyId();
        long promotionId = promotionInParam.getPromotionId();
        QFilter headFilters = PromotionPolicyHelper.buildHeadFilters(checkDate, currencyId, promotionLink, promotionId, isRuleEntryConfigPromParam);
        QFilter saleFilters = PromotionPolicyHelper.buildSaleFilters(checkDate, saleOrgId, saleChannelId, promotionLink);
        QFilter detailFilters = PromotionPolicyHelper.buildDetailFilters(checkDate);
        QFilter totalFilter = headFilters.and(saleFilters).and(detailFilters);
        if (customerId != 0L || orderChannelId != 0L) {
            QFilter orderFilter = PromotionPolicyHelper.buildOrderFilters(customerId, orderChannelId, promotionLink);
            totalFilter = totalFilter.and(orderFilter);
        }
        return totalFilter;
    }

    private static boolean checkSaleOrgOpenPromotion(long saleOrgId) {
        List<Long> openPromotionList = PromotionItemHelper.getOpenPromotionOrgList();
        return openPromotionList.contains(saleOrgId);
    }

    private static QFilter buildDetailFilters(Date checkDate) {
        QFilter startFilter = new QFilter("entryentity.prostarttime", "<=", (Object)checkDate);
        startFilter.or("entryentity.prostarttime", "is null", null);
        QFilter endFilter = new QFilter("entryentity.proendtime", ">=", (Object)checkDate);
        endFilter.or("entryentity.proendtime", "is null", null);
        return startFilter.and(endFilter);
    }

    private static QFilter buildOrderFilters(long customerId, long orderChannelId, String promotionLink) {
        if (promotionLink.equalsIgnoreCase(PromoteLinkEnum.SCM.getValue())) {
            QFilter filter = new QFilter("orderscopeentry.customer", "=", (Object)customerId);
            List<Long> cuClassifyIds = PromotionPolicyHelper.getCustomerClassifiesById(customerId);
            filter.or(new QFilter("orderscopeentry.customerclass", "in", cuClassifyIds));
            return filter;
        }
        QFilter filter = new QFilter("orderscopeentry.orderchannel", "=", (Object)orderChannelId);
        List<Long> chClassifyIds = PromotionPolicyHelper.getChannelClassifiesById(orderChannelId);
        if (!CollectionUtils.isEmpty(chClassifyIds)) {
            filter.or(new QFilter("orderscopeentry.channelclass", "in", chClassifyIds));
        }
        return filter;
    }

    public static List<Long> getChannelClassifiesById(long orderChannelId) {
        QFilter filter = new QFilter("id", "=", (Object)orderChannelId);
        DynamicObjectCollection channelClassList = QueryServiceHelper.query((String)"ocdbd_channel", (String)"id,channelclassentity,channelclassentity.id,channelclassentity.channelclass", (QFilter[])filter.toArray());
        if (CollectionUtils.isEmpty((Collection)channelClassList)) {
            return new ArrayList<Long>(0);
        }
        List<Long> ids = channelClassList.stream().filter(a -> a.getLong("channelclassentity.channelclass") > 0L).map(a -> a.getLong("channelclassentity.channelclass")).distinct().collect(Collectors.toList());
        QFilter customerFilter = new QFilter("id", "in", ids);
        DynamicObjectCollection customerGroupList = QueryServiceHelper.query((String)"ocdbd_channel_class", (String)"id,number,longnumber", (QFilter[])customerFilter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)customerGroupList)) {
            QFilter classFilter = new QFilter("1", "!=", (Object)1);
            for (DynamicObject customerGroup : customerGroupList) {
                if (!StringUtils.isNotEmpty((String)customerGroup.getString("number"))) continue;
                classFilter.or(new QFilter("number", "in", (Object)StringUtils.split((String)customerGroup.getString("longnumber"), (String)"\\.")));
            }
            customerGroupList = QueryServiceHelper.query((String)"ocdbd_channel_class", (String)"id", (QFilter[])classFilter.toArray());
            for (DynamicObject customerGroup : customerGroupList) {
                if (customerGroup.getLong("id") == 0L) continue;
                ids.add(customerGroup.getLong("id"));
            }
        }
        return ids;
    }

    public static List<Long> getCustomerClassifiesById(long customerId) {
        QFilter filter = new QFilter("customer", "=", (Object)customerId);
        DynamicObjectCollection customerClassList = QueryServiceHelper.query((String)"bd_customergroupdetail", (String)"group,customer", (QFilter[])filter.toArray());
        if (CollectionUtils.isEmpty((Collection)customerClassList)) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> ids = new ArrayList<Long>(customerClassList.size());
        customerClassList.forEach(m -> ids.add(m.getLong("group")));
        QFilter customerFilter = new QFilter("id", "in", ids);
        DynamicObjectCollection customerGroupList = QueryServiceHelper.query((String)"bd_customergroup", (String)"id,number,longnumber", (QFilter[])customerFilter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)customerGroupList)) {
            QFilter classFilter = new QFilter("1", "!=", (Object)1);
            for (DynamicObject customerGroup : customerGroupList) {
                if (!StringUtils.isNotEmpty((String)customerGroup.getString("number"))) continue;
                QFilter orFilter = new QFilter("number", "in", (Object)StringUtils.split((String)customerGroup.getString("longnumber"), (String)"!"));
                classFilter.or(orFilter);
            }
            customerGroupList = QueryServiceHelper.query((String)"bd_customergroup", (String)"id", (QFilter[])classFilter.toArray());
            for (DynamicObject customerGroup : customerGroupList) {
                if (customerGroup.getLong("id") <= 0L) continue;
                ids.add(customerGroup.getLong("id"));
            }
        }
        return ids;
    }

    private static QFilter buildSaleFilters(Date checkDate, long saleOrgId, long saleChannelId, String promotionLink) {
        QFilter startFilter = new QFilter("salescopeentry.starttime", "<=", (Object)checkDate);
        startFilter.or("salescopeentry.starttime", "is null", null);
        QFilter endFilter = new QFilter("salescopeentry.endtime", ">=", (Object)checkDate);
        endFilter.or("salescopeentry.endtime", "is null", null);
        QFilter tfilter = startFilter.and(endFilter);
        if (promotionLink.equalsIgnoreCase(PromoteLinkEnum.SCM.getValue()) || promotionLink.equalsIgnoreCase(PromoteLinkEnum.CHANNELTOSCM.getValue())) {
            tfilter.and(new QFilter("salescopeentry.saleorg", "=", (Object)saleOrgId));
        } else {
            tfilter.and(new QFilter("salescopeentry.salechannel", "=", (Object)saleChannelId));
        }
        return tfilter;
    }

    private static QFilter buildHeadFilters(Date checkDate, long currencyId, String promotionLink, long promotionId, boolean isRuleEntryConfigPromParam) {
        List<Long> promotionTypeIds = PromotionTypeHelper.getPromotionTypeIdsByPromotionLink(promotionLink);
        QFilter filter = new QFilter("promotetype", "in", promotionTypeIds);
        filter.and(new QFilter("effectivedate", "<=", (Object)checkDate));
        filter.and(new QFilter("expirationdate", ">=", (Object)checkDate));
        filter.and(new QFilter("currency", "=", (Object)currencyId));
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        if (isRuleEntryConfigPromParam) {
            filter.and(new QFilter("id", "=", (Object)promotionId));
        }
        return filter;
    }
}

