/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.business.promotion;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.occ.ocbase.common.entity.PromotionDetailParams;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocdpm.business.promotion.CalculateRelationHelper;
import kd.occ.ocdpm.business.promotion.PromotionCalculateHelper;
import kd.occ.ocdpm.common.entity.CalculateInfoVo;
import kd.occ.ocdpm.common.entity.CalculatePromotionVo;
import kd.occ.ocdpm.common.entity.CalculateRelationVo;
import kd.occ.ocdpm.common.enums.PromStrategyEnums;
import kd.occ.ocdpm.common.enums.PromotionTypeEnum;
import org.apache.commons.collections4.CollectionUtils;

public class SingleCalculateHelper {
    public static List<CalculateInfoVo> getCalculateInfoVoList(List<PromotionDetailParams> paramDetailList, CalculatePromotionVo calculatePromotionVo) {
        List<CalculateRelationVo> relationList = CalculateRelationHelper.getCalculateRelationList(paramDetailList, calculatePromotionVo);
        ArrayList<CalculateInfoVo> calculateInfoVoList = new ArrayList<CalculateInfoVo>(relationList.size());
        BigDecimal totalCompare = BigDecimal.ZERO;
        for (CalculateRelationVo relationVo : relationList) {
            BigDecimal minMultiple;
            DynamicObject mainItem = relationVo.getMainItem();
            List paramList = relationVo.getParamList();
            if (mainItem == null || !CollectionUtils.isNotEmpty((Collection)paramList) || (minMultiple = CalculateRelationHelper.getMinMultipleResult(mainItem, totalCompare = PromotionTypeEnum.amount.getValue().equalsIgnoreCase(calculatePromotionVo.getProCondition()) ? paramList.stream().map(PromotionDetailParams::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : paramList.stream().map(PromotionDetailParams::getQty).reduce(BigDecimal.ZERO, BigDecimal::add))).compareTo(BigDecimal.ZERO) <= 0) continue;
            CalculateInfoVo calculateInfoVo = SingleCalculateHelper.buildCalculateInfoVo(calculatePromotionVo, totalCompare, minMultiple);
            calculateInfoVo.setMainItem(mainItem);
            calculateInfoVo.setParamList(paramList);
            calculateInfoVo.setCycleAccount(mainItem.getBoolean("iscycleaccount"));
            calculateInfoVo.setThatCycleAccount(mainItem.getBoolean("isthatcycleaccount"));
            calculateInfoVo.setFixedDisctCycle(mainItem.getBoolean("isfixeddisctcycle"));
            calculateInfoVo.setProPriceCycle(mainItem.getBoolean("ispropricecycle"));
            calculateInfoVo.setPerPriceCycle(mainItem.getBoolean("isperpricecycle"));
            calculateInfoVoList.add(calculateInfoVo);
        }
        return calculateInfoVoList;
    }

    private static CalculateInfoVo buildCalculateInfoVo(CalculatePromotionVo calculatePromotionVo, BigDecimal totalCompare, BigDecimal minMultiple) {
        CalculateInfoVo calculateInfoVo = new CalculateInfoVo();
        calculateInfoVo.setGiftList(calculatePromotionVo.getGiftList());
        calculateInfoVo.setLadderType(calculatePromotionVo.getLadderType());
        calculateInfoVo.setMinMultiple(minMultiple);
        calculateInfoVo.setProCondition(calculatePromotionVo.getProCondition());
        calculateInfoVo.setTatalCompare(totalCompare);
        DynamicObject promotePolicy = calculatePromotionVo.getPromotionPolicy();
        calculateInfoVo.setPromotePolicy(promotePolicy);
        calculateInfoVo.setPolicyId(DynamicObjectUtils.getPkValue((DynamicObject)promotePolicy));
        calculateInfoVo.setPolicyNo(DynamicObjectUtils.getString((DynamicObject)promotePolicy, (String)"billno"));
        return calculateInfoVo;
    }

    public static List<PromotionDetailParams> getThisGiftResultList(CalculateInfoVo calculateInfoVo) {
        BigDecimal minMultiple = SingleCalculateHelper.getMinMultiple(calculateInfoVo, calculateInfoVo.isCycleAccount());
        CalculateInfoVo mainCalculateInfoVo = SingleCalculateHelper.getSingleCalculateInfoVoResult(calculateInfoVo, minMultiple, PromStrategyEnums.thisGift);
        List paramList = mainCalculateInfoVo.getParamList();
        PromotionDetailParams giftParam = (PromotionDetailParams)calculateInfoVo.getParamList().get(0);
        PromotionDetailParams giftResult = PromotionCalculateHelper.calculateThisGifyResult(calculateInfoVo.getMainItem(), giftParam, minMultiple, calculateInfoVo.getPolicyNo(), calculateInfoVo.getPolicyId());
        paramList.add(giftResult);
        return paramList;
    }

    public static List<PromotionDetailParams> getPromotionPriceResultList(CalculateInfoVo calculateInfoVo) {
        if (!PromotionTypeEnum.qty.getValue().equalsIgnoreCase(calculateInfoVo.getProCondition())) {
            return new ArrayList<PromotionDetailParams>(0);
        }
        BigDecimal minMultiple = SingleCalculateHelper.getMinMultiple(calculateInfoVo, calculateInfoVo.isProPriceCycle());
        calculateInfoVo = SingleCalculateHelper.getSingleCalculateInfoVoResult(calculateInfoVo, minMultiple, PromStrategyEnums.promotionPrice);
        List<PromotionDetailParams> paramList = SingleCalculateHelper.getCalculatePromotionPriceResult(calculateInfoVo);
        return paramList;
    }

    public static List<PromotionDetailParams> getFixedDiscountAmountResultList(CalculateInfoVo calculateInfoVo) {
        BigDecimal minMultiple = SingleCalculateHelper.getMinMultiple(calculateInfoVo, calculateInfoVo.isFixedDisctCycle());
        calculateInfoVo = SingleCalculateHelper.getSingleCalculateInfoVoResult(calculateInfoVo, minMultiple, PromStrategyEnums.fixedDiscountAmount);
        return PromotionCalculateHelper.getDivideFixedDiscountAmountList(calculateInfoVo, minMultiple);
    }

    public static List<PromotionDetailParams> getDiscountRateResultList(CalculateInfoVo calculateInfoVo) {
        if (!"A".equalsIgnoreCase(calculateInfoVo.getLadderType())) {
            return new ArrayList<PromotionDetailParams>(0);
        }
        BigDecimal minMultiple = SingleCalculateHelper.getMinMultiple(calculateInfoVo, false);
        calculateInfoVo = SingleCalculateHelper.getSingleCalculateInfoVoResult(calculateInfoVo, minMultiple, PromStrategyEnums.discountRate);
        return PromotionCalculateHelper.getCalculateDiscountRateResult(calculateInfoVo);
    }

    public static List<PromotionDetailParams> getAppointGiftResultList(CalculateInfoVo calculateInfoVo) {
        BigDecimal minMultiple = SingleCalculateHelper.getMinMultiple(calculateInfoVo, calculateInfoVo.isThatCycleAccount());
        calculateInfoVo = SingleCalculateHelper.getSingleCalculateInfoVoResult(calculateInfoVo, minMultiple, PromStrategyEnums.appointGift);
        List paramList = calculateInfoVo.getParamList();
        List<PromotionDetailParams> giftList = PromotionCalculateHelper.calculateAppointGifyResult(calculateInfoVo.getGiftList(), minMultiple);
        paramList.addAll(giftList);
        return paramList;
    }

    public static List<PromotionDetailParams> getPriceDisctAmountResultList(CalculateInfoVo calculateInfoVo) {
        if (!PromotionTypeEnum.qty.getValue().equalsIgnoreCase(calculateInfoVo.getProCondition())) {
            return new ArrayList<PromotionDetailParams>(0);
        }
        BigDecimal minMultiple = SingleCalculateHelper.getMinMultiple(calculateInfoVo, calculateInfoVo.isPerPriceCycle());
        calculateInfoVo = SingleCalculateHelper.getSingleCalculateInfoVoResult(calculateInfoVo, minMultiple, PromStrategyEnums.pricediscountAmount);
        BigDecimal priceDisctAmount = calculateInfoVo.getMainItem().getBigDecimal("pricedisctamt");
        List paramList = calculateInfoVo.getParamList();
        BigDecimal deductAmount = BigDecimal.ZERO;
        for (PromotionDetailParams param : paramList) {
            deductAmount = priceDisctAmount.multiply(param.getAchieveScalar()).setScale(calculateInfoVo.getPrecision(), 6);
            param.setDeductAmount(deductAmount);
            param.setPriceDiscountAmount(priceDisctAmount);
        }
        return paramList;
    }

    private static BigDecimal getMinMultiple(CalculateInfoVo calculateInfoVo, boolean isCycle) {
        BigDecimal minMultiple = BigDecimal.ONE;
        if (!"A".equalsIgnoreCase(calculateInfoVo.getLadderType()) && isCycle) {
            minMultiple = PromotionTypeEnum.qty.getValue().equalsIgnoreCase(calculateInfoVo.getProCondition()) ? calculateInfoVo.getTatalCompare().divide(calculateInfoVo.getMainItem().getBigDecimal("buyqty"), 0, 1) : calculateInfoVo.getTatalCompare().divide(calculateInfoVo.getMainItem().getBigDecimal("buyamount"), 0, 1);
        }
        return minMultiple;
    }

    private static CalculateInfoVo getSingleCalculateInfoVoResult(CalculateInfoVo calculateInfoVo, BigDecimal minMultiple, PromStrategyEnums promStrategyEnums) {
        boolean isNoLadder = "C".equalsIgnoreCase(calculateInfoVo.getLadderType());
        return SingleCalculateHelper.getSingleCalculateInfoVoResult(calculateInfoVo, minMultiple, promStrategyEnums, isNoLadder);
    }

    private static CalculateInfoVo getSingleCalculateInfoVoResult(CalculateInfoVo calculateInfoVo, BigDecimal minMultiple, PromStrategyEnums promStrategyEnums, boolean isNoLadder) {
        if (isNoLadder) {
            return PromotionCalculateHelper.getSingleAllocationCalculateResult(calculateInfoVo, minMultiple, promStrategyEnums);
        }
        return PromotionCalculateHelper.getSingleNoAllocationCalculateResult(calculateInfoVo, promStrategyEnums);
    }

    private static List<PromotionDetailParams> getCalculatePromotionPriceResult(CalculateInfoVo calculateInfoVo) {
        BigDecimal promotionPrice = calculateInfoVo.getMainItem().getBigDecimal("prounitprice");
        List paramList = calculateInfoVo.getParamList();
        for (PromotionDetailParams param : paramList) {
            param.setPromotionPrice(promotionPrice);
            BigDecimal deductAmount = param.getUnitTaxPrice().subtract(promotionPrice).multiply(param.getAchieveScalar());
            param.setDeductAmount(deductAmount);
        }
        return paramList;
    }
}

