/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.business.promotion;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.occ.ocbase.common.entity.PromotionDetailParams;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocdpm.business.promotion.CalculateRelationHelper;
import kd.occ.ocdpm.business.promotion.PromotionCalculateHelper;
import kd.occ.ocdpm.common.entity.CalculateInfoVo;
import kd.occ.ocdpm.common.entity.CalculatePromotionVo;
import kd.occ.ocdpm.common.enums.PromStrategyEnums;
import kd.occ.ocdpm.common.enums.PromotionTypeEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.SerializationUtils;

public class WholeOrderCalculateHelper {
    public static CalculateInfoVo getCalculateInfoVo(List<PromotionDetailParams> paramDetailList, CalculatePromotionVo calculatePromotionVo) {
        BigDecimal tatalCompare = PromotionCalculateHelper.calculateTotalCompare(paramDetailList, calculatePromotionVo.getProCondition());
        List mainItemList = calculatePromotionVo.getMainList();
        DynamicObject mainItem = (DynamicObject)mainItemList.get(0);
        BigDecimal minMultiple = CalculateRelationHelper.getMinMultipleResult(mainItem, tatalCompare);
        if (minMultiple.compareTo(BigDecimal.ZERO) > 0) {
            return WholeOrderCalculateHelper.buildCalculateInfoVo(paramDetailList, calculatePromotionVo, tatalCompare, minMultiple);
        }
        return null;
    }

    private static CalculateInfoVo buildCalculateInfoVo(List<PromotionDetailParams> paramsDetailList, CalculatePromotionVo calculatePromotionVo, BigDecimal tatalCompare, BigDecimal minMultiple) {
        CalculateInfoVo calculateInfoVo = new CalculateInfoVo();
        calculateInfoVo.setGiftList(calculatePromotionVo.getGiftList());
        calculateInfoVo.setLadderType(calculatePromotionVo.getLadderType());
        calculateInfoVo.setMinMultiple(minMultiple);
        calculateInfoVo.setProCondition(calculatePromotionVo.getProCondition());
        calculateInfoVo.setTatalCompare(tatalCompare);
        DynamicObject mainItem = (DynamicObject)calculatePromotionVo.getMainList().get(0);
        calculateInfoVo.setMainItem(mainItem);
        calculateInfoVo.setParamList(paramsDetailList);
        DynamicObject promotePolicy = calculatePromotionVo.getPromotionPolicy();
        calculateInfoVo.setPromotePolicy(promotePolicy);
        calculateInfoVo.setPolicyId(DynamicObjectUtils.getPkValue((DynamicObject)promotePolicy));
        calculateInfoVo.setPolicyNo(DynamicObjectUtils.getString((DynamicObject)promotePolicy, (String)"billno"));
        calculateInfoVo.setThatCycleAccount(mainItem.getBoolean("isthatcycleaccount"));
        calculateInfoVo.setFixedDisctCycle(mainItem.getBoolean("isfixeddisctcycle"));
        calculateInfoVo.setProPriceCycle(mainItem.getBoolean("ispropricecycle"));
        calculateInfoVo.setPerPriceCycle(mainItem.getBoolean("isperpricecycle"));
        return calculateInfoVo;
    }

    public static List<PromotionDetailParams> getPromoteGiftResultList(CalculateInfoVo calculateInfoVo) {
        ArrayList<PromotionDetailParams> resultList = new ArrayList<PromotionDetailParams>(0);
        PromotionDetailParams param = new PromotionDetailParams();
        DynamicObject mainItem = calculateInfoVo.getMainItem();
        BigDecimal multiple = BigDecimal.ONE;
        if (calculateInfoVo.isThatCycleAccount()) {
            multiple = calculateInfoVo.getMinMultiple();
        }
        if ("A".equalsIgnoreCase(calculateInfoVo.getLadderType())) {
            param.setWholeAchieveScalar(calculateInfoVo.getTatalCompare());
        } else {
            BigDecimal conDecimal = BigDecimal.ZERO;
            conDecimal = PromotionTypeEnum.amount.getValue().equalsIgnoreCase(calculateInfoVo.getProCondition()) ? mainItem.getBigDecimal("buyamount") : mainItem.getBigDecimal("buyqty");
            param.setWholeAchieveScalar(conDecimal.multiply(multiple));
        }
        PromotionCalculateHelper.setAppointGiftMainInfo(param, mainItem, calculateInfoVo.getPolicyNo(), calculateInfoVo.getPolicyId(), PromStrategyEnums.appointGift);
        resultList.add(param);
        List<PromotionDetailParams> calculateResultList = PromotionCalculateHelper.calculateAppointGifyResult(calculateInfoVo.getGiftList(), multiple);
        if (CollectionUtils.isNotEmpty(calculateResultList)) {
            resultList.addAll(calculateResultList);
        }
        return resultList;
    }

    public static List<PromotionDetailParams> getTotalDiscountResultList(CalculateInfoVo calculateInfoVo) {
        DynamicObject mainItem = calculateInfoVo.getMainItem();
        BigDecimal totalDiscount = mainItem.getBigDecimal("totaldiscount");
        BigDecimal totalTaxAmount = calculateInfoVo.getParamList().stream().map(PromotionDetailParams::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalDeductAmount = totalTaxAmount.multiply(totalDiscount.multiply(new BigDecimal("0.01")));
        calculateInfoVo = "A".equalsIgnoreCase(calculateInfoVo.getLadderType()) ? WholeOrderCalculateHelper.getNoAllocationCalculateResult(calculateInfoVo, totalDeductAmount, totalDiscount, PromStrategyEnums.wholediscountRate) : WholeOrderCalculateHelper.getAllocationCalculateResult(calculateInfoVo, totalDeductAmount, totalDiscount, PromStrategyEnums.wholediscountRate);
        List paramList = calculateInfoVo.getParamList();
        for (PromotionDetailParams param : paramList) {
            param.setWholeDiscountRate(totalDiscount);
        }
        return paramList;
    }

    private static CalculateInfoVo getAllocationCalculateResult(CalculateInfoVo calculateInfoVo, BigDecimal totalDeductAmount, BigDecimal totalDiscount, PromStrategyEnums promStrategyEnums) {
        CalculateInfoVo calculateInfoVoResult = WholeOrderCalculateHelper.getTotalAmountAllocationResult(calculateInfoVo, totalDeductAmount, promStrategyEnums);
        BigDecimal totalAchieveScalar = PromotionCalculateHelper.getTotalAchieveScalar(calculateInfoVoResult.getMainItem(), calculateInfoVo.getMinMultiple(), calculateInfoVoResult.getProCondition());
        List paramList = calculateInfoVoResult.getParamList();
        for (PromotionDetailParams param : paramList) {
            PromotionCalculateHelper.setAppointGiftMainInfo(param, calculateInfoVo.getMainItem(), calculateInfoVo.getPolicyNo(), calculateInfoVo.getPolicyId(), promStrategyEnums);
            param.setWholeAchieveScalar(totalAchieveScalar);
            param.setWholeDiscountRate(totalDiscount);
        }
        return calculateInfoVoResult;
    }

    private static CalculateInfoVo getNoAllocationCalculateResult(CalculateInfoVo calculateInfoVo, BigDecimal totalDeductAmount, BigDecimal totalDiscount, PromStrategyEnums promStrategyEnums) {
        CalculateInfoVo calculateInfoVoResult = WholeOrderCalculateHelper.getTotalAmountAllocationResult(calculateInfoVo, totalDeductAmount, promStrategyEnums);
        List paramList = calculateInfoVoResult.getParamList();
        for (PromotionDetailParams param : paramList) {
            PromotionCalculateHelper.setAppointGiftMainInfo(param, calculateInfoVo.getMainItem(), calculateInfoVo.getPolicyNo(), calculateInfoVo.getPolicyId(), promStrategyEnums);
            param.setWholeAchieveScalar(calculateInfoVoResult.getTatalCompare());
            param.setWholeDiscountRate(totalDiscount);
        }
        return calculateInfoVoResult;
    }

    private static CalculateInfoVo getTotalAmountAllocationResult(CalculateInfoVo calculateInfoVo, BigDecimal totalDivideAmount, PromStrategyEnums promStrategyEnums) {
        CalculateInfoVo resultCalculateInfoVo = PromotionCalculateHelper.buildCalculateInfoVo(calculateInfoVo);
        List paramList = resultCalculateInfoVo.getParamList();
        int lastOneSeq = paramList.size() - 1;
        BigDecimal cumulativeAmount = BigDecimal.ZERO;
        for (int i = 0; i < paramList.size(); ++i) {
            PromotionDetailParams param = (PromotionDetailParams)paramList.get(i);
            PromotionCalculateHelper.setAppointGiftMainInfo(param, calculateInfoVo.getMainItem(), calculateInfoVo.getPolicyNo(), calculateInfoVo.getPolicyId(), promStrategyEnums);
            if (lastOneSeq == i) {
                param.setDeductAmount(totalDivideAmount.subtract(cumulativeAmount));
                continue;
            }
            BigDecimal scaleAmount = PromotionCalculateHelper.getAllocationDecimal(totalDivideAmount, calculateInfoVo.getTatalCompare(), param, calculateInfoVo.getProCondition(), calculateInfoVo.getPrecision());
            param.setDeductAmount(scaleAmount);
            cumulativeAmount = cumulativeAmount.add(scaleAmount);
        }
        return resultCalculateInfoVo;
    }

    public static List<PromotionDetailParams> getFixedDiscountResultList(CalculateInfoVo calculateInfoVo) {
        BigDecimal multiple = BigDecimal.ONE;
        if (calculateInfoVo.isFixedDisctCycle()) {
            multiple = calculateInfoVo.getMinMultiple();
        }
        BigDecimal fixedDiscountAmount = calculateInfoVo.getMainItem().getBigDecimal("fixeddisctamount").multiply(multiple);
        calculateInfoVo = WholeOrderCalculateHelper.getTotalAmountAllocationResult(calculateInfoVo, fixedDiscountAmount, PromStrategyEnums.fixedDiscountAmount);
        List paramList = calculateInfoVo.getParamList();
        BigDecimal totalAchieveScalar = calculateInfoVo.getTatalCompare();
        if (!"A".equalsIgnoreCase(calculateInfoVo.getLadderType())) {
            totalAchieveScalar = PromotionCalculateHelper.getTotalAchieveScalar(calculateInfoVo.getMainItem(), multiple, calculateInfoVo.getProCondition());
        }
        for (PromotionDetailParams param : paramList) {
            param.setTotalAmount(fixedDiscountAmount);
            param.setWholeAchieveScalar(totalAchieveScalar);
        }
        return paramList;
    }

    public static List<PromotionDetailParams> getUnitPriceDiscountResultList(CalculateInfoVo calculateInfoVo) {
        if (!PromotionTypeEnum.qty.getValue().equalsIgnoreCase(calculateInfoVo.getProCondition())) {
            return new ArrayList<PromotionDetailParams>(0);
        }
        DynamicObject mainItem = calculateInfoVo.getMainItem();
        List paramList = calculateInfoVo.getParamList();
        ArrayList<PromotionDetailParams> calculateList = new ArrayList<PromotionDetailParams>(paramList.size());
        BigDecimal deductAmount = BigDecimal.ZERO;
        BigDecimal achieveScalar = BigDecimal.ZERO;
        BigDecimal discountAmount = mainItem.getBigDecimal("pricedisctamt");
        if ("C".equalsIgnoreCase(calculateInfoVo.getLadderType())) {
            BigDecimal multiple = calculateInfoVo.isPerPriceCycle() ? calculateInfoVo.getMinMultiple() : BigDecimal.ONE;
            achieveScalar = mainItem.getBigDecimal("buyqty").multiply(multiple);
            BigDecimal addAchieveScalar = BigDecimal.ZERO;
            int lastOne = paramList.size();
            int i = 1;
            for (PromotionDetailParams param : paramList) {
                PromotionDetailParams paramResult = WholeOrderCalculateHelper.buildParamResult(param, calculateInfoVo, PromStrategyEnums.pricediscountAmount);
                if (lastOne == i) {
                    deductAmount = achieveScalar.subtract(addAchieveScalar).multiply(discountAmount).setScale(calculateInfoVo.getPrecision(), 6);
                    paramResult.setDeductAmount(deductAmount);
                } else {
                    BigDecimal singleDeductAmount = PromotionCalculateHelper.getAllocationDecimal(achieveScalar, calculateInfoVo.getTatalCompare(), paramResult, calculateInfoVo.getProCondition(), calculateInfoVo.getPrecision());
                    addAchieveScalar = addAchieveScalar.add(singleDeductAmount);
                    deductAmount = discountAmount.multiply(singleDeductAmount).setScale(calculateInfoVo.getPrecision(), 6);
                    paramResult.setDeductAmount(deductAmount);
                }
                paramResult.setPriceDiscountAmount(discountAmount);
                paramResult.setWholeAchieveScalar(achieveScalar);
                calculateList.add(paramResult);
                ++i;
            }
        } else {
            for (PromotionDetailParams param : paramList) {
                PromotionDetailParams paramResult = WholeOrderCalculateHelper.buildParamResult(param, calculateInfoVo, PromStrategyEnums.pricediscountAmount);
                paramResult.setPriceDiscountAmount(discountAmount);
                achieveScalar = param.getQty();
                deductAmount = achieveScalar.multiply(discountAmount).setScale(calculateInfoVo.getPrecision(), 6);
                paramResult.setDeductAmount(deductAmount);
                paramResult.setWholeAchieveScalar(calculateInfoVo.getTatalCompare());
                calculateList.add(paramResult);
            }
        }
        return calculateList;
    }

    private static PromotionDetailParams buildParamResult(PromotionDetailParams param, CalculateInfoVo calculateInfoVo, PromStrategyEnums promStrategyEnums) {
        PromotionDetailParams paramResult = (PromotionDetailParams)SerializationUtils.clone((Serializable)param);
        PromotionCalculateHelper.setAppointGiftMainInfo(paramResult, calculateInfoVo.getMainItem(), calculateInfoVo.getPolicyNo(), calculateInfoVo.getPolicyId(), promStrategyEnums);
        return paramResult;
    }
}

