/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.business.promotionitem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.pojo.PromotionItemVo;
import kd.occ.ocbase.common.pojo.PromtionItemParamVO;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocdpm.business.promotionitem.PromotionItemHelper;
import kd.occ.ocdpm.common.entity.PromotionDetailVo;
import kd.occ.ocdpm.common.enums.PromoteLinkEnum;
import kd.occ.ocdpm.common.enums.PromotionRowTypeEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class PromoteItemServiceHelper {
    public static List<PromotionItemVo> getMatchPromotionPolicyVOList(PromtionItemParamVO promtionItemParamVO) {
        List<DynamicObject> policyList = PromotionItemHelper.queryMatchPromotionPolicyList(promtionItemParamVO);
        List<PromotionItemVo> promotionItemVoList = PromoteItemServiceHelper.getMatchPromotionItemVoList(promtionItemParamVO, policyList);
        return PromoteItemServiceHelper.matchPromotionItemVoList(promtionItemParamVO, promotionItemVoList);
    }

    private static List<PromotionItemVo> getMatchPromotionItemVoList(PromtionItemParamVO promtionItemParamVO, List<DynamicObject> policyList) {
        boolean isOrderChannel = CollectionUtils.isNotEmpty((Collection)promtionItemParamVO.getOrderChannelIdList());
        ArrayList<Long> saleIdList = new ArrayList<Long>();
        ArrayList<Long> detailIdList = new ArrayList<Long>();
        String saleCol = String.join((CharSequence)".", "orderscopeentry", "channelclass");
        String detailCol = String.join((CharSequence)".", "entryentity", "itemclass");
        if (!isOrderChannel) {
            saleCol = String.join((CharSequence)".", "orderscopeentry", "customerclass");
            detailCol = String.join((CharSequence)".", "entryentity", "materialgroup");
        }
        long saleId = 0L;
        long detailId = 0L;
        for (DynamicObject policy : policyList) {
            saleId = policy.getLong(saleCol);
            if (saleId > 0L) {
                saleIdList.add(saleId);
            }
            if ((detailId = policy.getLong(detailCol)) <= 0L) continue;
            detailIdList.add(detailId);
        }
        List<PromotionItemVo> tempList = PromoteItemServiceHelper.buildPromotionItemVoList(promtionItemParamVO, policyList);
        if (isOrderChannel) {
            Map<Long, List<Long>> channelClassMap = PromoteItemServiceHelper.getChannelClassMap(saleIdList);
            Map<Long, List<Long>> itemClassMap = PromoteItemServiceHelper.getItemClassMap(detailIdList);
            for (PromotionItemVo itemVo : tempList) {
                List<Long> ids;
                if (itemVo.getItemClassId() > 0L && CollectionUtils.isNotEmpty(ids = itemClassMap.get(itemVo.getItemClassId()))) {
                    itemVo.setLinkedItemList(new ArrayList<Long>(ids));
                }
                if (itemVo.getOrderChannelClassId() <= 0L || !CollectionUtils.isNotEmpty(ids = channelClassMap.get(itemVo.getOrderChannelClassId()))) continue;
                itemVo.setLinkedChannelList(new ArrayList<Long>(ids));
            }
        } else {
            Map<Long, List<Long>> customerClassMap = PromoteItemServiceHelper.getCustomerClassMap(saleIdList);
            Map<Long, List<Long>> materialClassMap = PromoteItemServiceHelper.getLowerMaterialClassMap(detailIdList);
            for (PromotionItemVo itemVo : tempList) {
                List<Long> ids;
                if (itemVo.getMaterialClassId() > 0L && CollectionUtils.isNotEmpty(ids = materialClassMap.get(itemVo.getMaterialClassId()))) {
                    itemVo.setLinkedMaterialList(new ArrayList<Long>(ids));
                }
                if (itemVo.getCustomerClassId() <= 0L || !CollectionUtils.isNotEmpty(ids = customerClassMap.get(itemVo.getCustomerClassId()))) continue;
                itemVo.setLinkedCustomerList(new ArrayList<Long>(ids));
            }
        }
        return tempList;
    }

    private static Map<Long, List<Long>> getChannelClassMap(List<Long> idList) {
        QFilter filter = new QFilter("channelclass", "in", idList);
        Map channelClassMap = BusinessDataServiceHelper.loadFromCache((String)"ocdbd_channel_classes", (QFilter[])filter.toArray());
        if (channelClassMap == null || channelClassMap.size() == 0) {
            return new HashMap<Long, List<Long>>(0);
        }
        ArrayList channelClassList = new ArrayList(channelClassMap.values());
        HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>(channelClassList.size());
        for (DynamicObject channelClass : channelClassList) {
            List<Long> lowerList;
            long channelClassId = DynamicObjectUtils.getPkValue((DynamicObject)channelClass.getDynamicObject("channelclass"));
            ArrayList<Long> values = (ArrayList<Long>)map.get(channelClassId);
            if (CollectionUtils.isEmpty((Collection)values)) {
                values = new ArrayList<Long>(1);
            }
            if (CollectionUtils.isNotEmpty(lowerList = PromoteItemServiceHelper.getLowerChannelClasses(channelClass.getDynamicObject("channelclass")))) {
                values.addAll(lowerList);
            }
            map.put(channelClassId, values);
        }
        return map;
    }

    private static List<Long> getLowerChannelClasses(DynamicObject channel) {
        String number = DynamicObjectUtils.getString((DynamicObject)channel, (String)"number");
        if (StringUtils.isEmpty((String)number)) {
            return new ArrayList<Long>(0);
        }
        QFilter filter = new QFilter("longnumber", "like", (Object)String.join((CharSequence)".", number, "%"));
        DynamicObjectCollection channelClassList = QueryServiceHelper.query((String)"ocdbd_channel_class", (String)String.join((CharSequence)",", "level", "number", "longnumber", "id"), (QFilter[])filter.toArray());
        QFilter classFilter = new QFilter("channelclass", "in", channelClassList.stream().map(a -> a.getLong("id")).distinct().collect(Collectors.toList()));
        DynamicObjectCollection lowerChannelList = QueryServiceHelper.query((String)"ocdbd_channel_classes", (String)String.join((CharSequence)",", "channelclass", "channelid", "classstandard"), (QFilter[])classFilter.toArray());
        return lowerChannelList.stream().map(a -> a.getLong("channelid")).distinct().collect(Collectors.toList());
    }

    private static Map<Long, List<Long>> getCustomerClassMap(List<Long> cusClassList) {
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>(8);
        if (CollectionUtils.isEmpty(cusClassList)) {
            return result;
        }
        QFilter cusFilter = new QFilter("id", "in", cusClassList);
        DynamicObjectCollection cusList = QueryServiceHelper.query((String)"bd_customergroup", (String)String.join((CharSequence)",", "longnumber", "number", "parent", "level", "id"), (QFilter[])cusFilter.toArray());
        Map<Long, List<Long>> lowerClassMap = PromoteItemServiceHelper.getLowerCustomerClassMap(cusList);
        ArrayList<Long> customerClassList = new ArrayList<Long>(8);
        for (Map.Entry<Long, List<Long>> lowerClass : lowerClassMap.entrySet()) {
            customerClassList.add(lowerClass.getKey());
            customerClassList.addAll((Collection)lowerClass.getValue());
        }
        QFilter filter = new QFilter("group", "in", customerClassList);
        DynamicObjectCollection detailList = QueryServiceHelper.query((String)"bd_customergroupdetail", (String)"group,customer", (QFilter[])filter.toArray());
        Map<Long, List<DynamicObject>> detailMap = detailList.stream().collect(Collectors.groupingBy(a -> a.getLong("group")));
        for (Map.Entry<Long, List<Long>> lowerClass : lowerClassMap.entrySet()) {
            List<Long> lowerClassIdList = lowerClass.getValue();
            if (CollectionUtils.isEmpty(lowerClassIdList)) {
                lowerClassIdList = new ArrayList<Long>(1);
            }
            lowerClassIdList.add(lowerClass.getKey());
            ArrayList values = (ArrayList)result.get(lowerClass.getKey());
            if (CollectionUtils.isEmpty((Collection)values)) {
                values = new ArrayList(lowerClassIdList.size());
            }
            for (long classId : lowerClassIdList) {
                List<DynamicObject> linkedMaterialList = detailMap.get(classId);
                if (!CollectionUtils.isNotEmpty(linkedMaterialList)) continue;
                List idList = linkedMaterialList.stream().map(a -> a.getLong("customer")).collect(Collectors.toList());
                values.addAll(idList);
            }
            result.put(lowerClass.getKey(), values);
        }
        return result;
    }

    private static Map<Long, List<Long>> getLowerCustomerClassMap(DynamicObjectCollection upperCustomerClassList) {
        if (CollectionUtils.isEmpty((Collection)upperCustomerClassList)) {
            return new HashMap<Long, List<Long>>(0);
        }
        QFilter cusFilter = new QFilter("1", "!=", (Object)1);
        for (DynamicObject customer : upperCustomerClassList) {
            cusFilter.or(new QFilter("longnumber", "like", (Object)String.join((CharSequence)"!", customer.getString("longnumber"), "%")));
        }
        DynamicObjectCollection lowerClassList = QueryServiceHelper.query((String)"bd_customergroup", (String)String.join((CharSequence)",", "longnumber", "number", "level", "parent", "id"), (QFilter[])cusFilter.toArray());
        Collections.sort(lowerClassList, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                if (o1.getInt("level") < o2.getInt("level")) {
                    return 1;
                }
                if (o1.getInt("level") == o2.getInt("level")) {
                    return 0;
                }
                return -1;
            }
        });
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>(8);
        long parentId = 0L;
        for (DynamicObject classInfo : lowerClassList) {
            List lowerValues;
            ArrayList<Long> values;
            parentId = classInfo.getLong("parent");
            if (parentId == 0L) {
                parentId = classInfo.getLong("id");
            }
            if (CollectionUtils.isEmpty((Collection)(values = (ArrayList<Long>)result.get(parentId)))) {
                values = new ArrayList<Long>(1);
            }
            if (CollectionUtils.isNotEmpty((Collection)(lowerValues = (List)result.get(classInfo.getLong("id"))))) {
                values.addAll(lowerValues);
            }
            values.add(classInfo.getLong("id"));
            result.put(parentId, values);
        }
        return result;
    }

    private static Map<Long, List<Long>> getItemClassMap(List<Long> idList) {
        QFilter filter = new QFilter("goodsclasssid", "in", idList);
        Map classMap = BusinessDataServiceHelper.loadFromCache((String)"ocdbd_itemclassentry", (QFilter[])filter.toArray());
        if (classMap == null || classMap.size() == 0) {
            return new HashMap<Long, List<Long>>(0);
        }
        ArrayList classList = new ArrayList(classMap.values());
        HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>(classList.size());
        ArrayList<Long> values = null;
        long id = 0L;
        for (DynamicObject classDetail : classList) {
            id = DynamicObjectUtils.getPkValue((DynamicObject)classDetail.getDynamicObject("goodsclasssid"));
            values = (ArrayList<Long>)map.get(id);
            if (CollectionUtils.isEmpty((Collection)values)) {
                values = new ArrayList<Long>(1);
            }
            values.add(classDetail.getLong("itemid"));
            map.put(id, values);
        }
        return map;
    }

    private static Map<Long, List<Long>> getClassMapMaterial(Map<Long, List<Long>> lowerClassMap) {
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>(8);
        ArrayList<Long> materialClassList = new ArrayList<Long>(8);
        for (Map.Entry<Long, List<Long>> lowerClass : lowerClassMap.entrySet()) {
            materialClassList.add(lowerClass.getKey());
            materialClassList.addAll((Collection)lowerClass.getValue());
        }
        QFilter filter = new QFilter("group", "in", materialClassList);
        DynamicObjectCollection detailList = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)"group,material", (QFilter[])filter.toArray());
        Map<Long, List<DynamicObject>> detailMap = detailList.stream().collect(Collectors.groupingBy(a -> a.getLong("group")));
        for (Map.Entry<Long, List<Long>> lowerClass : lowerClassMap.entrySet()) {
            List<Long> lowerClassIdList = lowerClass.getValue();
            if (CollectionUtils.isEmpty(lowerClassIdList)) {
                lowerClassIdList = new ArrayList<Long>(1);
            }
            lowerClassIdList.add(lowerClass.getKey());
            ArrayList values = (ArrayList)result.get(lowerClass.getKey());
            if (CollectionUtils.isEmpty((Collection)values)) {
                values = new ArrayList(lowerClassIdList.size());
            }
            for (long classId : lowerClassIdList) {
                List<DynamicObject> linkedMaterialList = detailMap.get(classId);
                if (!CollectionUtils.isNotEmpty(linkedMaterialList)) continue;
                List idList = linkedMaterialList.stream().map(a -> a.getLong("material")).collect(Collectors.toList());
                values.addAll(idList);
            }
            result.put(lowerClass.getKey(), values);
        }
        return result;
    }

    private static Map<Long, List<Long>> getLowerMaterialClassMap(List<Long> classIdList) {
        QFilter classInfoFilter = new QFilter("id", "in", classIdList);
        DynamicObjectCollection classInfoList = QueryServiceHelper.query((String)"bd_materialgroup", (String)String.join((CharSequence)",", "longnumber", "id", "parent", "number"), (QFilter[])classInfoFilter.toArray());
        Map<Long, List<Long>> result = PromoteItemServiceHelper.getLowerMaterialClassByLongNumber(classInfoList);
        List classIds = classInfoList.stream().map(a -> a.getLong("id")).distinct().collect(Collectors.toList());
        Iterator<Map.Entry<Long, List<Long>>> it = result.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, List<Long>> entry = it.next();
            if (classIds.contains(entry.getKey())) continue;
            it.remove();
        }
        return PromoteItemServiceHelper.getClassMapMaterial(result);
    }

    private static Map<Long, List<Long>> getLowerMaterialClassByLongNumber(DynamicObjectCollection classInfoList) {
        if (CollectionUtils.isEmpty((Collection)classInfoList)) {
            return new HashMap<Long, List<Long>>(0);
        }
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>(8);
        DynamicObjectCollection classList = PromoteItemServiceHelper.queryMaterialClassListByLongNumber(classInfoList);
        long parentId = 0L;
        for (DynamicObject classInfo : classList) {
            List lowerValues;
            ArrayList<Long> values;
            parentId = classInfo.getLong("parent");
            if (parentId == 0L) {
                parentId = classInfo.getLong("id");
            }
            if (CollectionUtils.isEmpty((Collection)(values = (ArrayList<Long>)result.get(parentId)))) {
                values = new ArrayList<Long>(1);
            }
            if (CollectionUtils.isNotEmpty((Collection)(lowerValues = (List)result.get(classInfo.getLong("id"))))) {
                values.addAll(lowerValues);
            }
            values.add(classInfo.getLong("id"));
            result.put(parentId, values);
        }
        return result;
    }

    private static DynamicObjectCollection queryMaterialClassListByLongNumber(DynamicObjectCollection classInfoList) {
        QFilter filter = new QFilter("1", "!=", (Object)1);
        for (DynamicObject classInfo : classInfoList) {
            filter.or(new QFilter("longnumber", "like", (Object)String.join((CharSequence)"!", classInfo.getString("longnumber"), "%")));
            filter.or(new QFilter("number", "=", (Object)classInfo.getString("number")));
        }
        DynamicObjectCollection classList = QueryServiceHelper.query((String)"bd_materialgroup", (String)String.join((CharSequence)",", "level", "number", "longnumber", "id", "parent"), (QFilter[])filter.toArray());
        Collections.sort(classList, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                if (o1.getInt("level") < o2.getInt("level")) {
                    return 1;
                }
                if (o1.getInt("level") == o2.getInt("level")) {
                    return 0;
                }
                return -1;
            }
        });
        return classList;
    }

    private static List<PromotionItemVo> matchPromotionItemVoList(PromtionItemParamVO promtionItemParamVO, List<PromotionItemVo> promotionItemVoList) {
        ArrayList<PromotionItemVo> resultList = new ArrayList<PromotionItemVo>(8);
        List<Long> policyIdList = promotionItemVoList.stream().map(PromotionItemVo::getPolicyId).collect(Collectors.toList());
        policyIdList = policyIdList.stream().distinct().collect(Collectors.toList());
        List<PromotionDetailVo> promotionDetailVoList = PromoteItemServiceHelper.buildPromotionDetailVoList(policyIdList);
        Map<Long, String> lableMap = PromoteItemServiceHelper.queryPromotionLable();
        if (CollectionUtils.isNotEmpty(promotionDetailVoList)) {
            Map<Long, PromotionDetailVo> voMap = promotionDetailVoList.stream().collect(Collectors.toMap(PromotionDetailVo::getEntryId, a -> a, (k1, k2) -> k1));
            for (PromotionItemVo promotionItemVo : promotionItemVoList) {
                PromotionItemVo vo;
                PromotionDetailVo promotionDetailVo = voMap.get(promotionItemVo.getEntryId());
                if (promotionDetailVo == null || promotionDetailVo.getExceptionItemList().contains(String.format("%d.%d", promotionItemVo.getItemId(), promotionItemVo.getAuxptyId())) || promotionDetailVo.getExceptionMaterialList().contains(String.format("%d.%d", promotionItemVo.getMaterialId(), promotionItemVo.getAuxptyId()))) continue;
                promotionItemVo.setPromStrategyId(promotionDetailVo.getPtrategyIdList());
                ArrayList<String> lableList = new ArrayList<String>();
                for (Long id : promotionDetailVo.getPtrategyIdList()) {
                    String lable = lableMap.get(id);
                    if (StringUtils.isEmpty((String)lable) || lableList.contains(lable)) continue;
                    lableList.add(lable);
                }
                promotionItemVo.setLable(lableList);
                promotionItemVo.setPromLink(promotionDetailVo.getPromLink());
                promotionItemVo.setPromoteType(promotionDetailVo.getPromoteTypeId());
                if (CollectionUtils.isNotEmpty((Collection)promotionItemVo.getLinkedItemList())) {
                    for (Long linkedItemId : promotionItemVo.getLinkedItemList()) {
                        if (promotionDetailVo.getExceptionItemList().contains(String.format("%d.%d", linkedItemId, 0L))) continue;
                        vo = promotionItemVo.deepCopy(promotionItemVo);
                        vo.setLinkedItemList(null);
                        vo.setItemClassId(0L);
                        vo.setItemId(linkedItemId.longValue());
                        resultList.add(vo);
                    }
                    continue;
                }
                if (CollectionUtils.isNotEmpty((Collection)promotionItemVo.getLinkedMaterialList())) {
                    for (Long linkedMaterialId : promotionItemVo.getLinkedMaterialList()) {
                        if (promotionDetailVo.getExceptionMaterialList().contains(String.format("%d.%d", linkedMaterialId, 0L))) continue;
                        vo = promotionItemVo.deepCopy(promotionItemVo);
                        vo.setLinkedItemList(null);
                        vo.setMaterialClassId(0L);
                        vo.setMaterialId(linkedMaterialId.longValue());
                        resultList.add(vo);
                    }
                    continue;
                }
                resultList.add(promotionItemVo);
            }
        }
        return resultList;
    }

    private static List<PromotionDetailVo> buildPromotionDetailVoList(List<Long> policyIdList) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        filter.and(new QFilter("id", "in", policyIdList));
        Map policyMap = BusinessDataServiceHelper.loadFromCache((String)"ocdpm_promotepolicy", (String)String.join((CharSequence)",", "promotetype", "entryentity", "entryentity.id,entryentity.seq,entryentity.promotiongroupno,entryentity.ladderno,entryentity.rowtype,entryentity.pggroupno,entryentity.itemclass,entryentity.item,entryentity.materialgroup,entryentity.unit,entryentity.baseunit,entryentity.remark,entryentity.prostarttime,entryentity.proendtime,entryentity.procondition,entryentity.buyqty,entryentity.basebuyqty,entryentity.basegiftqty,entryentity.buyamount,entryentity.buymutiple,entryentity.minlimitqty,entryentity.minlimitamount,entryentity.ladderminbase,entryentity.laddermaxbase,entryentity.ladderminqty,entryentity.laddermaxqty,entryentity.ladderminamount,entryentity.laddermaxamount,entryentity.thisgiftqty,entryentity.iscycleaccount,entryentity.typeingroup,entryentity.thatgiftqty,entryentity.thatgiftexcprice,entryentity.isthatcycleaccount,entryentity.typebetgroup,entryentity.discounttate,entryentity.totaldiscount,entryentity.fixeddisctamount,entryentity.isfixeddisctcycle,entryentity.pricedisctamt,entryentity.isperpricecycle,entryentity.prounitprice,entryentity.ispropricecycle,entryentity.material,entryentity.auxpty,entryentity.minbuypiece,entryentity.prioritydetail,entryentity.prostrategy", "exceptionentry", "exceptionentry.id,exceptionentry.seq,exceptionentry.exceptionitem,exceptionentry.exceptionmaterial,exceptionentry.exceptionunit,exceptionentry.exceptionauxpty"), (QFilter[])filter.toArray());
        if (policyMap.isEmpty()) {
            return new ArrayList<PromotionDetailVo>(0);
        }
        ArrayList<PromotionDetailVo> voList = new ArrayList<PromotionDetailVo>(8);
        for (DynamicObject policy : policyMap.values()) {
            PromotionDetailVo vo = PromoteItemServiceHelper.buildPromotionDetailVo(policy);
            DynamicObjectCollection detailList = policy.getDynamicObjectCollection("entryentity");
            for (DynamicObject detailInfo : detailList) {
                if (!PromotionRowTypeEnum.mainRow.getValue().equalsIgnoreCase(detailInfo.getString("rowtype"))) continue;
                voList.add(PromoteItemServiceHelper.buildDetailInfoVOList(vo.deepCopy(vo), detailInfo));
            }
        }
        return voList;
    }

    private static PromotionDetailVo buildDetailInfoVOList(PromotionDetailVo vo, DynamicObject detailInfo) {
        DynamicObjectCollection prostrategyList = detailInfo.getDynamicObjectCollection("prostrategy");
        ArrayList<Long> strIdList = new ArrayList<Long>();
        for (DynamicObject promstrategy : prostrategyList) {
            strIdList.add(DynamicObjectUtils.getPkValue((DynamicObject)promstrategy.getDynamicObject(1)));
        }
        vo.setPtrategyIdList(strIdList);
        vo.setEntryId(DynamicObjectUtils.getPkValue((DynamicObject)detailInfo));
        return vo;
    }

    private static PromotionDetailVo buildPromotionDetailVo(DynamicObject policy) {
        PromotionDetailVo vo = new PromotionDetailVo();
        DynamicObject promoteType = policy.getDynamicObject("promotetype");
        vo.setPolicyId(DynamicObjectUtils.getPkValue((DynamicObject)policy));
        vo.setPromoteTypeId(DynamicObjectUtils.getPkValue((DynamicObject)promoteType, (String)"promobject"));
        vo.setPromLink(DynamicObjectUtils.getString((DynamicObject)promoteType, (String)"promlink"));
        if (PromoteLinkEnum.SCM.getValue().equalsIgnoreCase(promoteType.getString("promlink"))) {
            List exceptionMaterialList = policy.getDynamicObjectCollection("exceptionentry").stream().map(a -> PromoteItemServiceHelper.getExceptionKey(a.getDynamicObject("exceptionmaterial"), a.getDynamicObject("exceptionauxpty"))).collect(Collectors.toList());
            vo.setExceptionMaterialList(new ArrayList(exceptionMaterialList));
        } else {
            List exceptionItemList = policy.getDynamicObjectCollection("exceptionentry").stream().map(a -> PromoteItemServiceHelper.getExceptionKey(a.getDynamicObject("exceptionitem"), a.getDynamicObject("exceptionauxpty"))).collect(Collectors.toList());
            vo.setExceptionItemList(new ArrayList(exceptionItemList));
        }
        return vo;
    }

    private static String getExceptionKey(DynamicObject exceptionObject, DynamicObject auxpty) {
        return DynamicObjectUtils.getPkValue((DynamicObject)exceptionObject) + "." + DynamicObjectUtils.getPkValue((DynamicObject)auxpty);
    }

    private static List<PromotionItemVo> buildPromotionItemVoList(PromtionItemParamVO promtionItemParamVO, List<DynamicObject> policyList) {
        ArrayList<PromotionItemVo> promotionItemVoList = new ArrayList<PromotionItemVo>(8);
        if (CollectionUtils.isEmpty(policyList)) {
            return promotionItemVoList;
        }
        for (DynamicObject policy : policyList) {
            PromotionItemVo vo = new PromotionItemVo();
            vo.setEntryId(policy.getLong(String.join((CharSequence)".", "entryentity", "id")));
            vo.setPromoteType(policy.getLong("promotetype"));
            vo.setPolicyNumber(policy.getString("billno"));
            vo.setPolicyId(policy.getLong("id"));
            vo.setPolicyName(policy.getString("name"));
            vo.setLevel(policy.getLong(String.join((CharSequence)".", "entryentity", "prioritydetail")));
            vo.setDescribe(policy.getString("describe"));
            vo.setModifyTime(policy.getDate("modifytime"));
            vo.setOrderChannelId(policy.getLong(String.join((CharSequence)".", "orderscopeentry", "orderchannel")));
            vo.setOrderChannelClassId(policy.getLong(String.join((CharSequence)".", "orderscopeentry", "channelclass")));
            vo.setCustomerId(policy.getLong(String.join((CharSequence)".", "orderscopeentry", "customer")));
            vo.setCustomerClassId(policy.getLong(String.join((CharSequence)".", "orderscopeentry", "customerclass")));
            vo.setSalechannelId(policy.getLong(String.join((CharSequence)".", "salescopeentry", "salechannel")));
            vo.setSaleorgId(policy.getLong(String.join((CharSequence)".", "salescopeentry", "saleorg")));
            vo.setItemId(policy.getLong(String.join((CharSequence)".", "entryentity", "item")));
            vo.setItemClassId(policy.getLong(String.join((CharSequence)".", "entryentity", "itemclass")));
            vo.setMaterialId(policy.getLong(String.join((CharSequence)".", "entryentity", "material")));
            vo.setMaterialClassId(policy.getLong(String.join((CharSequence)".", "entryentity", "materialgroup")));
            vo.setGroupNoId(policy.getLong(String.join((CharSequence)".", "entryentity", "promotiongroupno")));
            vo.setAuxptyId(policy.getLong(String.join((CharSequence)".", "entryentity", "auxpty")));
            vo.setUnitId(policy.getLong(String.join((CharSequence)".", "entryentity", "unit")));
            ArrayList<Date> beginTimeList = new ArrayList<Date>(3);
            beginTimeList.add(policy.getDate("effectivedate"));
            Date date = policy.getDate(String.join((CharSequence)".", "entryentity", "prostarttime"));
            if (date != null) {
                beginTimeList.add(date);
            }
            if ((date = policy.getDate(String.join((CharSequence)".", "salescopeentry", "starttime"))) != null) {
                beginTimeList.add(date);
            }
            vo.setEffectiveDate((Date)Collections.max(beginTimeList));
            ArrayList<Date> endTimeList = new ArrayList<Date>(3);
            endTimeList.add(policy.getDate("expirationdate"));
            date = policy.getDate(String.join((CharSequence)".", "entryentity", "proendtime"));
            if (date != null) {
                endTimeList.add(date);
            }
            if ((date = policy.getDate(String.join((CharSequence)".", "salescopeentry", "endtime"))) != null) {
                endTimeList.add(date);
            }
            vo.setExpirationDate((Date)Collections.min(endTimeList));
            if (vo.getEffectiveDate().after(vo.getExpirationDate()) || promtionItemParamVO.getBeginTime() != null && vo.getExpirationDate() != null && vo.getExpirationDate().before(promtionItemParamVO.getBeginTime())) continue;
            promotionItemVoList.add(vo);
        }
        return promotionItemVoList;
    }

    private static Map<Long, String> queryPromotionLable() {
        HashMap<Long, String> lableMap = new HashMap<Long, String>(4);
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and(new QFilter("status", "=", (Object)"C"));
        Map queryLableMap = BusinessDataServiceHelper.loadFromCache((String)"ocdpm_promotionstrategy", (QFilter[])filter.toArray());
        if (!queryLableMap.isEmpty()) {
            for (Map.Entry map : queryLableMap.entrySet()) {
                DynamicObject promotionStrategy = (DynamicObject)map.getValue();
                lableMap.put(DynamicObjectUtils.getPkValue((DynamicObject)promotionStrategy), promotionStrategy.getString("lable"));
            }
        }
        return lableMap;
    }
}

