/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.business.promotionitem;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.pojo.PromtionItemParamVO;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class PromotionItemHelper {
    private static final long prodeployid = 1173168193141958656L;
    private static final String[] queryCol = new String[]{"id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,org,promotetype,currency,effectivedate,invaliduser,invalidtime,expirationdate,name,priority,describe", "entryentity.id,entryentity.seq,entryentity.promotiongroupno,entryentity.ladderno,entryentity.rowtype,entryentity.pggroupno,entryentity.itemclass,entryentity.item,entryentity.materialgroup,entryentity.unit,entryentity.baseunit,entryentity.remark,entryentity.prostarttime,entryentity.proendtime,entryentity.procondition,entryentity.buyqty,entryentity.basebuyqty,entryentity.basegiftqty,entryentity.buyamount,entryentity.buymutiple,entryentity.minlimitqty,entryentity.minlimitamount,entryentity.ladderminbase,entryentity.laddermaxbase,entryentity.ladderminqty,entryentity.laddermaxqty,entryentity.ladderminamount,entryentity.laddermaxamount,entryentity.thisgiftqty,entryentity.iscycleaccount,entryentity.typeingroup,entryentity.thatgiftqty,entryentity.thatgiftexcprice,entryentity.isthatcycleaccount,entryentity.typebetgroup,entryentity.discounttate,entryentity.totaldiscount,entryentity.fixeddisctamount,entryentity.isfixeddisctcycle,entryentity.pricedisctamt,entryentity.isperpricecycle,entryentity.prounitprice,entryentity.ispropricecycle,entryentity.material,entryentity.auxpty,entryentity.minbuypiece,entryentity.prioritydetail,entryentity.prostrategy", "exceptionentry.id,exceptionentry.seq,exceptionentry.exceptionitem,exceptionentry.exceptionmaterial,exceptionentry.exceptionunit,exceptionentry.exceptionauxpty", "salescopeentry.id,salescopeentry.seq,salescopeentry.salechannel,salescopeentry.starttime,salescopeentry.endtime,salescopeentry.saleorg", "orderscopeentry.id,orderscopeentry.seq,orderscopeentry.customer,orderscopeentry.customerclass,orderscopeentry.orderchannel,orderscopeentry.channelclass"};

    public static List<DynamicObject> queryMatchPromotionPolicyList(PromtionItemParamVO promtionItemParamVO) {
        QFilter filter = PromotionItemHelper.buildPromotionPolicyFilter(promtionItemParamVO);
        DynamicObjectCollection promotionPolicyList = QueryServiceHelper.query((String)"ocdpm_promotepolicy", (String)StringUtils.join((Object[])queryCol, (char)','), (QFilter[])filter.toArray(), (String)"billno");
        return promotionPolicyList;
    }

    private static QFilter buildPromotionPolicyFilter(PromtionItemParamVO promtionItemParamVO) {
        QFilter filters = PromotionItemHelper.buildHeadFilters(promtionItemParamVO.getBeginTime(), promtionItemParamVO.getEndTime(), promtionItemParamVO.getPromLink());
        QFilter orderFilter = PromotionItemHelper.buildOrderDetailFilter(promtionItemParamVO);
        filters.and(orderFilter);
        QFilter saleFilter = PromotionItemHelper.buildSaleDetailFilter(promtionItemParamVO);
        if (saleFilter != null) {
            filters.and(saleFilter);
        }
        return filters;
    }

    private static QFilter buildSaleDetailFilter(PromtionItemParamVO promtionItemParamVO) {
        return PromotionItemHelper.getSaleFilter(promtionItemParamVO.getSaleOrgIdList(), promtionItemParamVO.getSaleChannelIdList());
    }

    private static QFilter getSaleFilter(List<Long> saleOrgIdList, List<Long> saleChannelIdList) {
        boolean isSaleOrgEmpty = CollectionUtils.isEmpty(saleOrgIdList);
        boolean isSaleChannelEmpty = CollectionUtils.isEmpty(saleChannelIdList);
        if (!isSaleChannelEmpty && isSaleOrgEmpty) {
            return new QFilter("salescopeentry.salechannel", "in", saleChannelIdList);
        }
        if (isSaleChannelEmpty && !isSaleOrgEmpty) {
            return PromotionItemHelper.getOrgFilter(saleOrgIdList);
        }
        if (isSaleChannelEmpty && isSaleOrgEmpty) {
            QFilter filter = new QFilter("salescopeentry.salechannel", ">", (Object)0);
            return filter.or(PromotionItemHelper.getOrgFilter(saleOrgIdList));
        }
        QFilter filter = PromotionItemHelper.getOrgFilter(saleOrgIdList);
        filter.or(new QFilter("salescopeentry.salechannel", "in", saleChannelIdList));
        return filter;
    }

    private static QFilter getOrgFilter(List<Long> saleOrgIdList) {
        List<Long> settingOrgList = PromotionItemHelper.getOpenPromotionOrgList();
        if (CollectionUtils.isNotEmpty(saleOrgIdList)) {
            Sets.SetView orgSettings = Sets.intersection(new HashSet<Long>(settingOrgList), new HashSet<Long>(saleOrgIdList));
            return new QFilter("salescopeentry.saleorg", "in", (Object)orgSettings);
        }
        return new QFilter("salescopeentry.saleorg", "in", settingOrgList);
    }

    public static List<Long> getOpenPromotionOrgList() {
        DynamicObject proDeploy = BusinessDataServiceHelper.loadSingle((Object)1173168193141958656L, (String)"ocdpm_channeldeploy");
        if (proDeploy == null) {
            return new ArrayList<Long>(0);
        }
        DynamicObjectCollection entryentity = proDeploy.getDynamicObjectCollection("entryentity");
        ArrayList<Long> openList = new ArrayList<Long>(entryentity.size());
        for (DynamicObject entry : entryentity) {
            if (!entry.getBoolean("openpromotion")) continue;
            openList.add(DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)"orgid"));
        }
        return openList;
    }

    private static QFilter buildOrderDetailFilter(PromtionItemParamVO promtionItemParamVO) {
        if (CollectionUtils.isNotEmpty((Collection)promtionItemParamVO.getOrderChannelIdList())) {
            QFilter filters = new QFilter("orderscopeentry.orderchannel", "in", (Object)promtionItemParamVO.getOrderChannelIdList());
            Set<Long> classIds = PromotionItemHelper.getChannelClassIdList(promtionItemParamVO.getOrderChannelIdList());
            if (!CollectionUtils.isEmpty(classIds)) {
                filters.or(new QFilter("orderscopeentry.channelclass", "in", classIds));
            }
            return filters;
        }
        QFilter filters = new QFilter("orderscopeentry.customer", "in", (Object)promtionItemParamVO.getCustomIdList());
        Set<Long> cuClassifyIds = PromotionItemHelper.getCustomerGroupIdList(promtionItemParamVO.getCustomIdList());
        filters.or(new QFilter("orderscopeentry.customerclass", "in", cuClassifyIds));
        return filters;
    }

    private static QFilter buildHeadFilters(Date beginTime, Date endTime, List<String> promotionLinkList) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        filter.and(new QFilter("entryentity.rowtype", "=", (Object)"A"));
        if (CollectionUtils.isNotEmpty(promotionLinkList)) {
            List<Long> promotionTypeIds = PromotionItemHelper.getPromotionTypeIdsByPromotionLink(promotionLinkList);
            filter.and(new QFilter("promotetype", "in", promotionTypeIds));
        }
        if (beginTime != null && endTime != null) {
            filter.and("expirationdate", ">=", (Object)beginTime);
            filter.and("effectivedate", "<=", (Object)endTime);
        }
        return filter;
    }

    private static List<Long> getPromotionTypeIdsByPromotionLink(List<String> promotionLinkList) {
        QFilter filters = new QFilter("promlink", "in", promotionLinkList);
        DynamicObjectCollection proList = QueryServiceHelper.query((String)"ocdpm_promotiontype", (String)"id", (QFilter[])filters.toArray());
        ArrayList<Long> ids = new ArrayList<Long>(promotionLinkList.size());
        proList.forEach(m -> ids.add(DynamicObjectUtils.getPkValue((DynamicObject)m)));
        return ids;
    }

    private static List<String> getUpperCustomerGroupList(List<Long> customIdList) {
        QFilter filter = new QFilter("customer", "in", customIdList);
        Map customerMap = BusinessDataServiceHelper.loadFromCache((String)"bd_customergroupdetail", (String)"group,customer", (QFilter[])filter.toArray());
        HashSet<Object> groupIdSet = new HashSet<Object>(customerMap.size());
        if (!customerMap.isEmpty()) {
            for (DynamicObject cus : customerMap.values()) {
                groupIdSet.add(cus.get(String.join((CharSequence)".", "group", "id")));
            }
        }
        ArrayList<String> numberList = new ArrayList<String>(8);
        QFilter customerFilter = new QFilter("id", "in", groupIdSet);
        DynamicObjectCollection customerGroupList = QueryServiceHelper.query((String)"bd_customergroup", (String)"id,number,longnumber", (QFilter[])customerFilter.toArray());
        for (DynamicObject customerGroup : customerGroupList) {
            numberList.addAll(Arrays.asList(StringUtils.split((String)customerGroup.getString("longnumber"), (String)"!")));
        }
        return numberList;
    }

    private static Set<Long> getCustomerGroupIdList(List<Long> customIdList) {
        HashSet<Long> ids = new HashSet<Long>(8);
        List<String> numberList = PromotionItemHelper.getUpperCustomerGroupList(customIdList);
        QFilter numberFilter = new QFilter("number", "in", numberList);
        Map cusGroupMap = BusinessDataServiceHelper.loadFromCache((String)"bd_customergroup", (QFilter[])numberFilter.toArray());
        if (!cusGroupMap.isEmpty()) {
            for (DynamicObject customerGroup : cusGroupMap.values()) {
                long id = DynamicObjectUtils.getPkValue((DynamicObject)customerGroup);
                if (id <= 0L) continue;
                ids.add(id);
            }
        }
        return ids;
    }

    private static Set<Long> getChannelClassIdList(List<Long> orderChannelIdList) {
        QFilter numberFilter;
        Map classMap;
        HashSet<Long> ids = new HashSet<Long>(8);
        List<String> classNumberList = PromotionItemHelper.getChannelClassNumberList(orderChannelIdList);
        if (CollectionUtils.isNotEmpty(classNumberList) && !(classMap = BusinessDataServiceHelper.loadFromCache((String)"ocdbd_channel_class", (String)"id", (QFilter[])(numberFilter = new QFilter("number", "in", classNumberList)).toArray())).isEmpty()) {
            for (DynamicObject classInfo : classMap.values()) {
                long id = DynamicObjectUtils.getPkValue((DynamicObject)classInfo);
                if (id <= 0L) continue;
                ids.add(id);
            }
        }
        return ids;
    }

    private static List<String> getChannelClassNumberList(List<Long> orderChannelIdList) {
        ArrayList<String> numberList = new ArrayList<String>(8);
        QFilter filter = new QFilter("id", "in", orderChannelIdList);
        Map channelClassMap = BusinessDataServiceHelper.loadFromCache((String)"ocdbd_channel", (String)"id,channelclassentity,channelclassentity.id,channelclassentity.channelclass", (QFilter[])filter.toArray());
        if (!channelClassMap.isEmpty()) {
            ArrayList<Long> ids = new ArrayList<Long>(4);
            for (DynamicObject channelClass : channelClassMap.values()) {
                DynamicObjectCollection classEntry = channelClass.getDynamicObjectCollection("channelclassentity");
                for (DynamicObject va : classEntry) {
                    long classId = DynamicObjectUtils.getPkValue((DynamicObject)va, (String)"channelclass");
                    if (classId <= 0L) continue;
                    ids.add(classId);
                }
            }
            QFilter customerFilter = new QFilter("id", "in", ids);
            DynamicObjectCollection customerGroupList = QueryServiceHelper.query((String)"ocdbd_channel_class", (String)"id,number,longnumber", (QFilter[])customerFilter.toArray());
            for (DynamicObject customerGroup : customerGroupList) {
                numberList.addAll(Arrays.asList(StringUtils.split((String)customerGroup.getString("longnumber"), (String)"\\.")));
            }
        }
        return numberList;
    }
}

